/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import opennlp.tools.ml.model.Event;
import opennlp.tools.tokenize.DefaultTokenContextGenerator;
import opennlp.tools.tokenize.TokenContextGenerator;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.tokenize.lang.Factory;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class TokSpanEventStream
extends AbstractEventStream<TokenSample> {
    private TokenContextGenerator cg;
    private boolean skipAlphaNumerics;
    private final Pattern alphaNumeric;

    public TokSpanEventStream(ObjectStream<TokenSample> tokenSamples, boolean skipAlphaNumerics, Pattern alphaNumeric, TokenContextGenerator cg) {
        super(tokenSamples);
        this.alphaNumeric = alphaNumeric;
        this.skipAlphaNumerics = skipAlphaNumerics;
        this.cg = cg;
    }

    public TokSpanEventStream(ObjectStream<TokenSample> tokenSamples, boolean skipAlphaNumerics, TokenContextGenerator cg) {
        super(tokenSamples);
        Factory factory = new Factory();
        this.alphaNumeric = factory.getAlphanumeric(null);
        this.skipAlphaNumerics = skipAlphaNumerics;
        this.cg = cg;
    }

    public TokSpanEventStream(ObjectStream<TokenSample> tokenSamples, boolean skipAlphaNumerics) {
        this(tokenSamples, skipAlphaNumerics, new DefaultTokenContextGenerator());
    }

    @Override
    protected Iterator<Event> createEvents(TokenSample tokenSample) {
        ArrayList<Event> events = new ArrayList<Event>(50);
        Span[] tokens = tokenSample.getTokenSpans();
        String text = tokenSample.getText();
        if (tokens.length > 0) {
            int start = tokens[0].getStart();
            int end = tokens[tokens.length - 1].getEnd();
            String sent = text.substring(start, end);
            Span[] candTokens = WhitespaceTokenizer.INSTANCE.tokenizePos(sent);
            int firstTrainingToken = -1;
            int lastTrainingToken = -1;
            Span[] spanArray = candTokens;
            int n = spanArray.length;
            for (int i = 0; i < n; ++i) {
                int ti;
                Span candToken;
                Span cSpan = candToken = spanArray[i];
                String ctok = sent.substring(cSpan.getStart(), cSpan.getEnd());
                cSpan = new Span(cSpan.getStart() + start, cSpan.getEnd() + start);
                if (ctok.length() <= 1 || this.skipAlphaNumerics && this.alphaNumeric.matcher(ctok).matches()) continue;
                boolean foundTrainingTokens = false;
                for (ti = lastTrainingToken + 1; ti < tokens.length; ++ti) {
                    if (cSpan.contains(tokens[ti])) {
                        if (!foundTrainingTokens) {
                            firstTrainingToken = ti;
                            foundTrainingTokens = true;
                        }
                        lastTrainingToken = ti;
                        continue;
                    }
                    if (cSpan.getEnd() < tokens[ti].getEnd()) break;
                    if (tokens[ti].getEnd() < cSpan.getStart()) continue;
                    System.out.println("Bad training token: " + tokens[ti] + " cand: " + cSpan + " token=" + text.substring(tokens[ti].getStart(), tokens[ti].getEnd()));
                }
                if (!foundTrainingTokens) continue;
                for (ti = firstTrainingToken; ti <= lastTrainingToken; ++ti) {
                    Span tSpan = tokens[ti];
                    int cStart = cSpan.getStart();
                    for (int i2 = tSpan.getStart() + 1; i2 < tSpan.getEnd(); ++i2) {
                        String[] context = this.cg.getContext(ctok, i2 - cStart);
                        events.add(new Event("F", context));
                    }
                    if (tSpan.getEnd() == cSpan.getEnd()) continue;
                    String[] context = this.cg.getContext(ctok, tSpan.getEnd() - cStart);
                    events.add(new Event("T", context));
                }
            }
        }
        return events.iterator();
    }
}

