;;; -----------------------------------------------
;;;  PAM
;;; -----------------------------------------------

;(setq load-path (append (list "$pamdir"
;			      "$pamdir/elib")
;			load-path))
(autoload 'pam-analyze-file "pam-3" "Load Program Analysis Mode" t)
(autoload 'pam-sml-analyze-file "pam-3" "Load Program Analysis Mode" t)
(autoload 'pam-full-analyze-file "pam-3" "Load Program Analysis Mode" t)

;;; Set up PAM mode to run cqual

(autoload 'pam-analyze-file "pam-3" "Qualifier inference" t)
(autoload 'pam-analyze-file-common "pam-3" "Qualifier inference" t)

; Note:  -fflow-sensitive uses extra memory even if you don't use any
;        flow-sensitive qualifiers, so you should disable it if you're not
;        using it.  Also, if you have problems with the flow-sensitive 
;        support in this version of cqual, try version 0.98.
(setq pam-default-analysis '("gcqual"
			     "-fpam-mode"
			     "-fpoly"
;                             "-fflow-sensitive"
))

(fset 'cqual 'pam-analyze-file)

(require 'pam-faces)

;;; Custom PAM colors

;;; You can change the default colors here
(custom-set-faces
 '(pam-color-1 ((t (:foreground "olive drab" :underline t))) t)
 '(pam-color-2 ((t (:foreground "turquoise" :underline t))) t)
 '(pam-color-3 ((t (:foreground "greenyellow" :underline t))) t)
 '(pam-color-4 ((t (:foreground "aquamarine" :underline t))) t)
 '(pam-color-5 ((t (:foreground "purple" :underline t))) t)
 '(pam-color-6 ((t (:foreground "red" :underline t))) t)
 '(pam-color-7 ((t (:foreground "green" :underline t))) t)
 '(pam-color-8 ((t (:foreground "maroon" :underline t))) t)
 '(pam-color-mouse ((t (:foreground "white" :background "grey" :underline t))) t))

;;; Add new colors here

; Tainting qualifier colors
(pam-add-face pam-color-tainted ((t (:foreground "red" :underline t))))
(pam-add-face pam-color-untainted ((t (:foreground "green" :underline t))))

; Y2K qualifier colors
(pam-add-face pam-color-yyyy ((t (:foreground "greenyellow" :underline t))))
(pam-add-face pam-color-yy   ((t (:foreground "lightblue" :underline t))))
(pam-add-face pam-color-nonyear ((t (:foreground "mediumblue" :underline t))))
(pam-add-face pam-color-ww50 ((t (:foreground "red" :underline t))))
(pam-add-face pam-color-rcsdate ((t (:foreground "green" :underline t))))

; Locking qualifier colors
(pam-add-face pam-color-locked ((t (:foreground "red" :underline t))))
(pam-add-face pam-color-unlocked ((t (:foreground "green" :underline t))))
(pam-add-face pam-color-unknown ((t (:foreground "purple" :underline t))))
