/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.privilege;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesResponse;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestDeletePrivilegesAction
extends SecurityBaseRestHandler {
    public RestDeletePrivilegesAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.DELETE, "/_xpack/security/privilege/{application}/{privilege}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.DELETE, "/_security/privilege/{application}/{privilege}", (RestHandler)this);
    }

    public String getName() {
        return "xpack_security_delete_privilege_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String application = request.param("application");
        final String[] privileges = request.paramAsStringArray("privilege", null);
        String refresh = request.param("refresh");
        return channel -> ((DeletePrivilegesRequestBuilder)new SecurityClient((ElasticsearchClient)client).prepareDeletePrivileges(application, privileges).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<DeletePrivilegesResponse>(channel){

            public RestResponse buildResponse(DeletePrivilegesResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.startObject(application);
                for (String privilege : new HashSet<String>(Arrays.asList(privileges))) {
                    builder.field(privilege, Collections.singletonMap("found", response.found().contains(privilege)));
                }
                builder.endObject();
                builder.endObject();
                return new BytesRestResponse(response.found().isEmpty() ? RestStatus.NOT_FOUND : RestStatus.OK, builder);
            }
        });
    }
}

