/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.proto.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateUtils {
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final DateTimeFormatter UTC_DATE_FORMATTER = ISODateTimeFormat.dateOptionalTimeParser().withZoneUTC();
    public static final ZoneId UTC = ZoneId.of("Z");
    public static final String DATE_PARSE_FORMAT = "epoch_millis";
    private static final int DEFAULT_PRECISION_FOR_CURRENT_FUNCTIONS = 3;

    private DateUtils() {
    }

    public static ZonedDateTime asDateOnly(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC).toLocalDate().atStartOfDay(UTC);
    }

    public static ZonedDateTime asDateTime(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC);
    }

    public static ZonedDateTime asDateTime(long millis, ZoneId id) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), id);
    }

    public static ZonedDateTime asDateOnly(String dateFormat) {
        return DateUtils.asDateOnly(UTC_DATE_FORMATTER.parseDateTime(dateFormat));
    }

    public static ZonedDateTime asDateOnly(DateTime dateTime) {
        LocalDateTime ldt = LocalDateTime.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), 0, 0, 0, 0);
        return ZonedDateTime.ofStrict(ldt, ZoneOffset.ofTotalSeconds(dateTime.getZone().getOffset((ReadableInstant)dateTime) / 1000), org.elasticsearch.common.time.DateUtils.dateTimeZoneToZoneId((DateTimeZone)dateTime.getZone()));
    }

    public static ZonedDateTime asDateOnly(ZonedDateTime zdt) {
        return zdt.toLocalDate().atStartOfDay(zdt.getZone());
    }

    public static ZonedDateTime asDateTime(String dateFormat) {
        return DateUtils.asDateTime(UTC_DATE_FORMATTER.parseDateTime(dateFormat));
    }

    public static ZonedDateTime asDateTime(DateTime dateTime) {
        LocalDateTime ldt = LocalDateTime.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), dateTime.getSecondOfMinute(), dateTime.getMillisOfSecond() * 1000000);
        return ZonedDateTime.ofStrict(ldt, ZoneOffset.ofTotalSeconds(dateTime.getZone().getOffset((ReadableInstant)dateTime) / 1000), org.elasticsearch.common.time.DateUtils.dateTimeZoneToZoneId((DateTimeZone)dateTime.getZone()));
    }

    public static String toString(ZonedDateTime dateTime) {
        return StringUtils.toString((Object)dateTime);
    }

    public static String toDateString(ZonedDateTime date) {
        return date.format(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static long minDayInterval(long l) {
        if (l < 86400000L) {
            return 86400000L;
        }
        return l - l % 86400000L;
    }

    public static int getNanoPrecision(Expression precisionExpression, int nano) {
        int precision = 3;
        if (precisionExpression != null) {
            try {
                precision = Foldables.intValueOf(precisionExpression);
            }
            catch (Exception e) {
                throw new ParsingException(precisionExpression.source(), "invalid precision; " + e.getMessage(), new Object[0]);
            }
        }
        if (precision < 0 || precision > 9) {
            throw new ParsingException(precisionExpression.source(), "precision needs to be between [0-9], received [{}]", precisionExpression.sourceText());
        }
        nano -= nano % (int)Math.pow(10.0, 9 - precision);
        return nano;
    }
}

