/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.rest;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.XmppCapsStats;
import org.jitsi.utils.OrderedJsonObject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/debug")
public class Debug {
    @NotNull
    private final JicofoServices jicofoServices = Objects.requireNonNull(JicofoServices.getJicofoServicesSingleton(), "jicofoServices");

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public String getDebug(@DefaultValue(value="false") @QueryParam(value="full") boolean full) {
        return this.jicofoServices.getDebugState(full).toJSONString();
    }

    @GET
    @Path(value="conference/{confId}")
    @Produces(value={"application/json"})
    @NotNull
    public String confDebug(@PathParam(value="confId") String confId) {
        OrderedJsonObject confJson = this.jicofoServices.getConferenceDebugState(confId);
        return confJson.toJSONString();
    }

    @GET
    @Path(value="xmpp-caps")
    @Produces(value={"application/json"})
    @NotNull
    public String xmppCaps() {
        return XmppCapsStats.getStats().toJSONString();
    }

    @GET
    @Path(value="/conferences")
    @Produces(value={"application/json"})
    @NotNull
    public String conferences() {
        JSONArray conferencesJson = new JSONArray();
        for (JitsiMeetConference c : this.jicofoServices.getFocusManager().getAllConferences()) {
            conferencesJson.add((Object)c.getRoomName().toString());
        }
        return conferencesJson.toJSONString();
    }

    @GET
    @Path(value="/conferences-full")
    @Produces(value={"application/json"})
    @NotNull
    public String conferencesFull() {
        JSONObject conferencesJson = new JSONObject();
        for (JitsiMeetConference c : this.jicofoServices.getFocusManager().getAllConferences()) {
            conferencesJson.put((Object)c.getRoomName().toString(), (Object)c.getDebugState());
        }
        return conferencesJson.toJSONString();
    }
}

