/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.videobridge.cc.vp9.Vp9FrameProjection;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0097\u0001\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\u0006\u0010\u0013\u001a\u00020\r\u0012\u0006\u0010\u0014\u001a\u00020\r\u0012\u0006\u0010\u0015\u001a\u00020\r\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0017\u001a\u00020\u0005\u0012\u0006\u0010\u0018\u001a\u00020\r\u0012\u0006\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010<\u001a\u00020=2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u0000J\u000e\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0003J\u0010\u0010B\u001a\u00020\r2\u0006\u0010A\u001a\u00020CH\u0002J\u000e\u0010B\u001a\u00020\r2\u0006\u0010D\u001a\u00020\u0000J\u000e\u0010E\u001a\u00020=2\u0006\u0010A\u001a\u00020\u0003R\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\"R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\"\"\u0004\b%\u0010$R\u0011\u0010\u0013\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\"R\u0011\u0010&\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\"R\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001dR\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001d\"\u0004\b)\u0010*R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001dR\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\"R\u001e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\"R\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\"R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u001dR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001dR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\"\u00a8\u0006F"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "index", "", "(Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;I)V", "ssrc", "", "timestamp", "earliestKnownSequenceNumber", "latestKnownSequenceNumber", "seenStartOfFrame", "", "seenEndOfFrame", "seenMarker", "temporalLayer", "spatialLayer", "isUpperLevelReference", "isSwitchingUpPoint", "usesInterLayerDependency", "isInterPicturePredicted", "pictureId", "tl0PICIDX", "isKeyframe", "numSpatialLayers", "(JJIIZZZIIZZZZIIIZI)V", "<set-?>", "getEarliestKnownSequenceNumber", "()I", "effectiveSpatialLayer", "getEffectiveSpatialLayer", "getIndex", "isAccepted", "()Z", "setAccepted", "(Z)V", "setKeyframe", "isTL0", "getLatestKnownSequenceNumber", "getNumSpatialLayers", "setNumSpatialLayers", "(I)V", "getPictureId", "projection", "Lorg/jitsi/videobridge/cc/vp9/Vp9FrameProjection;", "getProjection", "()Lorg/jitsi/videobridge/cc/vp9/Vp9FrameProjection;", "setProjection", "(Lorg/jitsi/videobridge/cc/vp9/Vp9FrameProjection;)V", "getSeenEndOfFrame", "getSeenMarker", "getSeenStartOfFrame", "getSpatialLayer", "getSsrc", "()J", "getTemporalLayer", "getTimestamp", "getTl0PICIDX", "getUsesInterLayerDependency", "addPacket", "", "isImmediatelyAfter", "otherFrame", "matchesFrame", "pkt", "matchesSSRC", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "vp9Frame", "validateConsistency", "jitsi-videobridge"})
public final class Vp9Frame {
    private final long ssrc;
    private final long timestamp;
    private final int temporalLayer;
    private final int spatialLayer;
    private final boolean isUpperLevelReference;
    private final boolean isSwitchingUpPoint;
    private final boolean usesInterLayerDependency;
    private final boolean isInterPicturePredicted;
    private final int pictureId;
    private final int index;
    private final int tl0PICIDX;
    private boolean isKeyframe;
    private int numSpatialLayers;
    private int earliestKnownSequenceNumber;
    private int latestKnownSequenceNumber;
    private boolean seenStartOfFrame;
    private boolean seenEndOfFrame;
    private boolean seenMarker;
    @Nullable
    private Vp9FrameProjection projection;
    private boolean isAccepted;

    public Vp9Frame(long ssrc2, long timestamp, int earliestKnownSequenceNumber, int latestKnownSequenceNumber, boolean seenStartOfFrame, boolean seenEndOfFrame, boolean seenMarker, int temporalLayer, int spatialLayer, boolean isUpperLevelReference, boolean isSwitchingUpPoint, boolean usesInterLayerDependency, boolean isInterPicturePredicted, int pictureId, int index, int tl0PICIDX, boolean isKeyframe, int numSpatialLayers) {
        boolean bl;
        this.ssrc = ssrc2;
        this.timestamp = timestamp;
        this.temporalLayer = temporalLayer;
        this.spatialLayer = spatialLayer;
        this.isUpperLevelReference = isUpperLevelReference;
        this.isSwitchingUpPoint = isSwitchingUpPoint;
        this.usesInterLayerDependency = usesInterLayerDependency;
        this.isInterPicturePredicted = isInterPicturePredicted;
        this.pictureId = pictureId;
        this.index = index;
        this.tl0PICIDX = tl0PICIDX;
        this.isKeyframe = isKeyframe;
        this.numSpatialLayers = numSpatialLayers;
        this.earliestKnownSequenceNumber = earliestKnownSequenceNumber;
        this.latestKnownSequenceNumber = latestKnownSequenceNumber;
        this.seenStartOfFrame = seenStartOfFrame;
        this.seenEndOfFrame = seenEndOfFrame;
        this.seenMarker = seenMarker;
        boolean bl2 = bl = (this.index & Short.MAX_VALUE) == this.pictureId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final long getSsrc() {
        return this.ssrc;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getTemporalLayer() {
        return this.temporalLayer;
    }

    public final int getSpatialLayer() {
        return this.spatialLayer;
    }

    public final boolean isUpperLevelReference() {
        return this.isUpperLevelReference;
    }

    public final boolean isSwitchingUpPoint() {
        return this.isSwitchingUpPoint;
    }

    public final boolean getUsesInterLayerDependency() {
        return this.usesInterLayerDependency;
    }

    public final boolean isInterPicturePredicted() {
        return this.isInterPicturePredicted;
    }

    public final int getPictureId() {
        return this.pictureId;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getTl0PICIDX() {
        return this.tl0PICIDX;
    }

    public final boolean isKeyframe() {
        return this.isKeyframe;
    }

    public final void setKeyframe(boolean bl) {
        this.isKeyframe = bl;
    }

    public final int getNumSpatialLayers() {
        return this.numSpatialLayers;
    }

    public final void setNumSpatialLayers(int n) {
        this.numSpatialLayers = n;
    }

    public final int getEarliestKnownSequenceNumber() {
        return this.earliestKnownSequenceNumber;
    }

    public final int getLatestKnownSequenceNumber() {
        return this.latestKnownSequenceNumber;
    }

    public final boolean getSeenStartOfFrame() {
        return this.seenStartOfFrame;
    }

    public final boolean getSeenEndOfFrame() {
        return this.seenEndOfFrame;
    }

    public final boolean getSeenMarker() {
        return this.seenMarker;
    }

    @Nullable
    public final Vp9FrameProjection getProjection() {
        return this.projection;
    }

    public final void setProjection(@Nullable Vp9FrameProjection vp9FrameProjection) {
        this.projection = vp9FrameProjection;
    }

    public final boolean isAccepted() {
        return this.isAccepted;
    }

    public final void setAccepted(boolean bl) {
        this.isAccepted = bl;
    }

    public final int getEffectiveSpatialLayer() {
        return this.spatialLayer >= 0 ? this.spatialLayer : 0;
    }

    public Vp9Frame(@NotNull Vp9Packet packet, int index) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this(packet.getSsrc(), packet.getTimestamp(), packet.getSequenceNumber(), packet.getSequenceNumber(), packet.isStartOfFrame(), packet.isEndOfFrame(), packet.isMarked(), packet.getTemporalLayerIndex(), packet.getSpatialLayerIndex(), packet.isUpperLevelReference(), packet.isSwitchingUpPoint(), packet.getUsesInterLayerDependency(), packet.isInterPicturePredicted(), packet.getPictureId(), index, packet.getTL0PICIDX(), packet.isKeyframe(), packet.getScalabilityStructureNumSpatial());
    }

    public final void addPacket(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (!this.matchesFrame(packet)) {
            boolean bl = false;
            String string = "Non-matching packet added to frame";
            throw new IllegalArgumentException(string.toString());
        }
        int seq = packet.getSequenceNumber();
        if (RtpUtilsKt.isOlderThan(seq, this.earliestKnownSequenceNumber)) {
            this.earliestKnownSequenceNumber = seq;
        }
        if (RtpUtilsKt.isNewerThan(seq, this.latestKnownSequenceNumber)) {
            this.latestKnownSequenceNumber = seq;
        }
        if (packet.isStartOfFrame()) {
            this.seenStartOfFrame = true;
        }
        if (packet.isEndOfFrame()) {
            this.seenEndOfFrame = true;
        }
        if (packet.isMarked()) {
            this.seenMarker = true;
        }
        if (packet.getHasScalabilityStructure()) {
            this.numSpatialLayers = packet.getScalabilityStructureNumSpatial();
        }
    }

    public final boolean isTL0() {
        return this.temporalLayer <= 0;
    }

    public final boolean matchesSSRC(@NotNull Vp9Frame vp9Frame) {
        Intrinsics.checkNotNullParameter(vp9Frame, "vp9Frame");
        return this.ssrc == vp9Frame.ssrc;
    }

    private final boolean matchesSSRC(VideoRtpPacket pkt) {
        return this.ssrc == pkt.getSsrc();
    }

    public final boolean matchesFrame(@NotNull Vp9Packet pkt) {
        Intrinsics.checkNotNullParameter(pkt, "pkt");
        return this.matchesSSRC(pkt) && this.timestamp == pkt.getTimestamp() && this.spatialLayer == pkt.getSpatialLayerIndex();
    }

    public final void validateConsistency(@NotNull Vp9Packet pkt) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pkt, "pkt");
        if (this.temporalLayer == pkt.getTemporalLayerIndex() && this.tl0PICIDX == pkt.getTL0PICIDX() && this.pictureId == pkt.getPictureId() && this.isSwitchingUpPoint == pkt.isSwitchingUpPoint() && this.isUpperLevelReference == pkt.isUpperLevelReference() && this.usesInterLayerDependency == pkt.getUsesInterLayerDependency() && this.isInterPicturePredicted == pkt.isInterPicturePredicted()) {
            return;
        }
        StringBuilder $this$validateConsistency_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Vp9Packet $this$validateConsistency_u24lambda_u2d2_u24lambda_u2d1 = pkt;
        boolean bl2 = false;
        $this$validateConsistency_u24lambda_u2d2.append("Packet ssrc " + $this$validateConsistency_u24lambda_u2d2_u24lambda_u2d1.getSsrc() + ", seq " + $this$validateConsistency_u24lambda_u2d2_u24lambda_u2d1.getSequenceNumber() + ", picture id " + $this$validateConsistency_u24lambda_u2d2_u24lambda_u2d1.getPictureId() + ", timestamp " + $this$validateConsistency_u24lambda_u2d2_u24lambda_u2d1.getTimestamp() + " ");
        $this$validateConsistency_u24lambda_u2d2.append("is not consistent with frame " + this.ssrc + ", ");
        $this$validateConsistency_u24lambda_u2d2.append("seq " + this.earliestKnownSequenceNumber + "-" + this.latestKnownSequenceNumber + " ");
        $this$validateConsistency_u24lambda_u2d2.append("picture id " + this.pictureId + ", timestamp " + this.timestamp + ": ");
        boolean complained = false;
        if (this.temporalLayer != pkt.getTemporalLayerIndex()) {
            $this$validateConsistency_u24lambda_u2d2.append("packet temporal layer " + pkt.getTemporalLayerIndex() + " != frame temporal layer " + this.temporalLayer);
            complained = true;
        }
        if (this.tl0PICIDX != pkt.getTL0PICIDX()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d2.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d2.append("packet TL0PICIDX " + pkt.getTL0PICIDX() + " != frame TL0PICIDX " + this.tl0PICIDX);
            complained = true;
        }
        if (this.pictureId != pkt.getPictureId()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d2.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d2.append("packet PictureID " + pkt.getPictureId() + " != frame PictureID " + this.pictureId);
            complained = true;
        }
        if (this.isSwitchingUpPoint != pkt.isSwitchingUpPoint()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d2.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d2.append("packet switchingUpPoint " + pkt.isSwitchingUpPoint() + " != frame switchingUpPoint " + this.isSwitchingUpPoint);
            complained = true;
        }
        if (this.isUpperLevelReference != pkt.isUpperLevelReference()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d2.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d2.append("packet upperLevelReference " + pkt.isUpperLevelReference() + " != frame upperLevelReference " + this.isUpperLevelReference);
            complained = true;
        }
        if (this.usesInterLayerDependency != pkt.getUsesInterLayerDependency()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d2.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d2.append("packet usesInterLayerDepencency " + pkt.getUsesInterLayerDependency() + " != frame usesInterLayerDepencency " + this.usesInterLayerDependency);
            complained = true;
        }
        if (this.isInterPicturePredicted != pkt.isInterPicturePredicted()) {
            if (complained) {
                $this$validateConsistency_u24lambda_u2d2.append("; ");
            }
            $this$validateConsistency_u24lambda_u2d2.append("packet isInterPicturePredicted " + pkt.isInterPicturePredicted() + " != frame isInterPicturePredicted " + this.isInterPicturePredicted);
            complained = true;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        throw new RuntimeException(string2);
    }

    public final boolean isImmediatelyAfter(@NotNull Vp9Frame otherFrame) {
        boolean bl;
        Intrinsics.checkNotNullParameter(otherFrame, "otherFrame");
        int delta = VpxUtils.Companion.getExtendedPictureIdDelta(otherFrame.pictureId, this.pictureId);
        switch (delta) {
            case 0: {
                if (this.spatialLayer == otherFrame.spatialLayer + 1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (this.spatialLayer == 0 && otherFrame.spatialLayer == 2) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

