/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.websocket;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.websocket.ColibriWebSocketServlet;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J \u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/websocket/ColibriWebSocketService;", "", "webserverIsTls", "", "(Z)V", "baseUrl", "", "relayUrl", "getColibriRelayWebSocketUrl", "conferenceId", "relayId", "pwd", "getColibriWebSocketUrl", "endpointId", "registerServlet", "", "servletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "videobridge", "Lorg/jitsi/videobridge/Videobridge;", "Companion", "jitsi-videobridge"})
public final class ColibriWebSocketService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String baseUrl;
    @Nullable
    private final String relayUrl;
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default(Companion, null, null, 3, null);
    @NotNull
    private static final String COLIBRI_WS_ENDPOINT = "colibri-ws";
    @NotNull
    private static final String COLIBRI_RELAY_WS_ENDPOINT = "colibri-relay-ws";
    @NotNull
    public static final String COLIBRI_WS_PATH = "/colibri-ws/";
    @NotNull
    public static final String COLIBRI_RELAY_WS_PATH = "/colibri-relay-ws/";

    public ColibriWebSocketService(boolean webserverIsTls) {
        if (WebsocketServiceConfig.config.getEnabled()) {
            Boolean bl = WebsocketServiceConfig.config.getUseTls();
            boolean useTls2 = bl != null ? bl : webserverIsTls;
            String protocol = useTls2 ? "wss" : "ws";
            this.baseUrl = protocol + "://" + WebsocketServiceConfig.config.getDomain() + COLIBRI_WS_PATH + WebsocketServiceConfig.config.getServerId();
            this.relayUrl = RelayConfig.config.getEnabled() ? protocol + "://" + WebsocketServiceConfig.config.getRelayDomain() + COLIBRI_RELAY_WS_PATH + WebsocketServiceConfig.config.getServerId() : (String)null;
            logger.info("Base URL: " + this.baseUrl + " Relay URL: " + this.relayUrl);
        } else {
            logger.info("WebSockets are not enabled");
            this.baseUrl = null;
            this.relayUrl = null;
        }
    }

    @Nullable
    public final String getColibriWebSocketUrl(@NotNull String conferenceId, @NotNull String endpointId, @NotNull String pwd) {
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Intrinsics.checkNotNullParameter(pwd, "pwd");
        if (!WebsocketServiceConfig.config.getEnabled()) {
            return null;
        }
        return this.baseUrl + "/" + conferenceId + "/" + endpointId + "?pwd=" + pwd;
    }

    @Nullable
    public final String getColibriRelayWebSocketUrl(@NotNull String conferenceId, @NotNull String relayId, @NotNull String pwd) {
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        Intrinsics.checkNotNullParameter(pwd, "pwd");
        if (!WebsocketServiceConfig.config.getEnabled()) {
            return null;
        }
        return this.relayUrl + "/" + conferenceId + "/" + relayId + "?pwd=" + pwd;
    }

    public final void registerServlet(@NotNull ServletContextHandler servletContextHandler, @NotNull Videobridge videobridge) {
        Intrinsics.checkNotNullParameter(servletContextHandler, "servletContextHandler");
        Intrinsics.checkNotNullParameter(videobridge, "videobridge");
        if (WebsocketServiceConfig.config.getEnabled()) {
            ServletHolder servletHolder;
            logger.info("Registering servlet with baseUrl = " + this.baseUrl + ", relayUrl = " + this.relayUrl);
            ServletHolder $this$registerServlet_u24lambda_u2d0 = servletHolder = new ServletHolder();
            boolean bl = false;
            $this$registerServlet_u24lambda_u2d0.setServlet(new ColibriWebSocketServlet(WebsocketServiceConfig.config.getServerId(), videobridge));
            ServletHolder holder = servletHolder;
            servletContextHandler.addServlet(holder, "/colibri-ws/*");
            servletContextHandler.addServlet(holder, "/colibri-relay-ws/*");
            JettyWebSocketServletContainerInitializer.configure(servletContextHandler, null);
        } else {
            logger.info("Disabled, not registering servlet");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jitsi/videobridge/websocket/ColibriWebSocketService$Companion;", "", "()V", "COLIBRI_RELAY_WS_ENDPOINT", "", "COLIBRI_RELAY_WS_PATH", "COLIBRI_WS_ENDPOINT", "COLIBRI_WS_PATH", "logger", "Lorg/jitsi/utils/logging2/Logger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

