/*
 * Decompiled with CFR 0.152.
 */
package other.kafka;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import javax.imageio.ImageIO;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import other.kafka.ReplicationQuotasTestRig$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rv!B\u0001\u0003\u0011\u00039\u0011\u0001\u0007*fa2L7-\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e*jO*\u00111\u0001B\u0001\u0006W\u000647.\u0019\u0006\u0002\u000b\u0005)q\u000e\u001e5fe\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!\u0001\u0007*fa2L7-\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e*jON\u0011\u0011\u0002\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bMIA\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\f\n\u0005\u0004%IaF\u0001\u0004I&\u0014X#\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t11\u000b\u001e:j]\u001eDa!I\u0005!\u0002\u0013A\u0012\u0001\u00023je\u0002BqaI\u0005C\u0002\u0013\u0005A%A\u0001l+\u0005)\u0003CA\u0007'\u0013\t9cBA\u0002J]RDa!K\u0005!\u0002\u0013)\u0013AA6!\u0011\u0015Y\u0013\u0002\"\u0001-\u0003\u0011i\u0017-\u001b8\u0015\u00055\u0002\u0004CA\u0007/\u0013\tycB\u0001\u0003V]&$\b\"B\u0019+\u0001\u0004\u0011\u0014\u0001B1sON\u00042!D\u001a6\u0013\t!dBA\u0003BeJ\f\u0017\u0010\u0005\u00027{9\u0011qg\u000f\t\u0003q9i\u0011!\u000f\u0006\u0003u\u0019\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011qD\u0010\u0006\u0003y9AQ\u0001Q\u0005\u0005\u0002\u0005\u000b1A];o)\u0019i#)!\"\u0002Z\")1i\u0010a\u0001\t\u000611m\u001c8gS\u001e\u0004\"!\u0012$\u000e\u0003%1AaR\u0005A\u0011\niQ\t\u001f9fe&lWM\u001c;EK\u001a\u001cBA\u0012\u0007J\u0019B\u0011QBS\u0005\u0003\u0017:\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u000e\u001b&\u0011aJ\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t!\u001a\u0013)\u001a!C\u0001#\u0006!a.Y7f+\u0005)\u0004\u0002C*G\u0005#\u0005\u000b\u0011B\u001b\u0002\u000b9\fW.\u001a\u0011\t\u0011U3%Q3A\u0005\u0002\u0011\nqA\u0019:pW\u0016\u00148\u000f\u0003\u0005X\r\nE\t\u0015!\u0003&\u0003!\u0011'o\\6feN\u0004\u0003\u0002C-G\u0005+\u0007I\u0011\u0001\u0013\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0003\u0005\\\r\nE\t\u0015!\u0003&\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\t\u0011u3%Q3A\u0005\u0002y\u000b\u0001\u0002\u001e5s_R$H.Z\u000b\u0002?B\u0011Q\u0002Y\u0005\u0003C:\u0011A\u0001T8oO\"A1M\u0012B\tB\u0003%q,A\u0005uQJ|G\u000f\u001e7fA!AQM\u0012BK\u0002\u0013\u0005A%\u0001\tng\u001e\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\"AqM\u0012B\tB\u0003%Q%A\tng\u001e\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\u0002B\u0001\"\u001b$\u0003\u0016\u0004%\t\u0001J\u0001\b[N<7+\u001b>f\u0011!YgI!E!\u0002\u0013)\u0013\u0001C7tONK'0\u001a\u0011\t\u000bM1E\u0011A7\u0015\u000f\u0011sw\u000e]9sg\")\u0001\u000b\u001ca\u0001k!)Q\u000b\u001ca\u0001K!)\u0011\f\u001ca\u0001K!)Q\f\u001ca\u0001?\")Q\r\u001ca\u0001K!)\u0011\u000e\u001ca\u0001K!9QO\u0012b\u0001\n\u0003q\u0016A\u0006;be\u001e,GOQ=uKN\u0004VM\u001d\"s_.,'/\u0014\"\t\r]4\u0005\u0015!\u0003`\u0003]!\u0018M]4fi\nKH/Z:QKJ\u0014%o\\6fe6\u0013\u0005\u0005C\u0004z\r\u0006\u0005I\u0011\u0001>\u0002\t\r|\u0007/\u001f\u000b\t\tndXP`@\u0002\u0002!9\u0001\u000b\u001fI\u0001\u0002\u0004)\u0004bB+y!\u0003\u0005\r!\n\u0005\b3b\u0004\n\u00111\u0001&\u0011\u001di\u0006\u0010%AA\u0002}Cq!\u001a=\u0011\u0002\u0003\u0007Q\u0005C\u0004jqB\u0005\t\u0019A\u0013\t\u0013\u0005\u0015a)%A\u0005\u0002\u0005\u001d\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0013Q3!NA\u0006W\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\f\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0011\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0010\rF\u0005I\u0011AA\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\t+\u0007\u0015\nY\u0001C\u0005\u0002(\u0019\u000b\n\u0011\"\u0001\u0002\"\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA\u0016\rF\u0005I\u0011AA\u0017\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a\f+\u0007}\u000bY\u0001C\u0005\u00024\u0019\u000b\n\u0011\"\u0001\u0002\"\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0004\"CA\u001c\rF\u0005I\u0011AA\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIYB\u0001\"a\u000fG\u0003\u0003%\teF\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0011\u0005}b)!A\u0005\u0002\u0011\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"a\u0011G\u0003\u0003%\t!!\u0012\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qIA'!\ri\u0011\u0011J\u0005\u0004\u0003\u0017r!aA!os\"I\u0011qJA!\u0003\u0003\u0005\r!J\u0001\u0004q\u0012\n\u0004\"CA*\r\u0006\u0005I\u0011IA+\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA,!\u0019\tI&a\u0018\u0002H5\u0011\u00111\f\u0006\u0004\u0003;r\u0011AC2pY2,7\r^5p]&!\u0011\u0011MA.\u0005!IE/\u001a:bi>\u0014\b\"CA3\r\u0006\u0005I\u0011AA4\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA5\u0003_\u00022!DA6\u0013\r\tiG\u0004\u0002\b\u0005>|G.Z1o\u0011)\ty%a\u0019\u0002\u0002\u0003\u0007\u0011q\t\u0005\n\u0003g2\u0015\u0011!C!\u0003k\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002K!I\u0011\u0011\u0010$\u0002\u0002\u0013\u0005\u00131P\u0001\ti>\u001cFO]5oOR\t\u0001\u0004C\u0005\u0002\u0000\u0019\u000b\t\u0011\"\u0011\u0002\u0002\u00061Q-];bYN$B!!\u001b\u0002\u0004\"Q\u0011qJA?\u0003\u0003\u0005\r!a\u0012\t\u000f\u0005\u001du\b1\u0001\u0002\n\u00069!n\\;s]\u0006d\u0007cA#\u0002\f\u001a1\u0011QR\u0005\u0001\u0003\u001f\u0013qAS8ve:\fGnE\u0002\u0002\f2AqaEAF\t\u0003\t\u0019\n\u0006\u0002\u0002\n\"Q\u0011qSAF\u0005\u0004%I!!'\u0002\u00071|w-\u0006\u0002\u0002\u001cB!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"r\t!![8\n\t\u0005\u0015\u0016q\u0014\u0002\u0005\r&dW\rC\u0005\u0002*\u0006-\u0005\u0015!\u0003\u0002\u001c\u0006!An\\4!\u0011!\ti+a#\u0005\u0002\u0005=\u0016aD1qa\u0016tG\rV8K_V\u0014h.\u00197\u0015\u00075\n\t\f\u0003\u0004D\u0003W\u0003\r\u0001\u0012\u0005\t\u0003k\u000bY\t\"\u0001\u00028\u0006Y\u0011\r\u001d9f]\u0012\u001c\u0005.\u0019:u)\u0015i\u0013\u0011XA_\u0011\u001d\tY,a-A\u0002U\nA\u0001]1uQ\"A\u0011qXAZ\u0001\u0004\tI'A\u0003gSJ\u001cH\u000f\u0003\u0005\u0002D\u0006-E\u0011AAc\u0003\u0019AW-\u00193feR\tQ\u0006\u0003\u0005\u0002J\u0006-E\u0011AAc\u0003\u00191wn\u001c;fe\"A\u0011QZAF\t\u0003\ty-\u0001\u0004baB,g\u000e\u001a\u000b\u0004[\u0005E\u0007bBAj\u0003\u0017\u0004\r!N\u0001\b[\u0016\u001c8/Y4f\u0011!\tY,a#\u0005\u0002\u0005]G#A\u001b\t\u000f\u0005mw\b1\u0001\u0002j\u0005)B-[:qY\u0006L8\t[1siN|enU2sK\u0016tw!CAp\u0013\u0005\u0005\t\u0012AAq\u00035)\u0005\u0010]3sS6,g\u000e\u001e#fMB\u0019Q)a9\u0007\u0011\u001dK\u0011\u0011!E\u0001\u0003K\u001cR!a9\u0002h2\u00032\"!;\u0002pV*SeX\u0013&\t6\u0011\u00111\u001e\u0006\u0004\u0003[t\u0011a\u0002:v]RLW.Z\u0005\u0005\u0003c\fYOA\tBEN$(/Y2u\rVt7\r^5p]ZBqaEAr\t\u0003\t)\u0010\u0006\u0002\u0002b\"Q\u0011\u0011PAr\u0003\u0003%)%a\u001f\t\u0015\u0005m\u00181]A\u0001\n\u0003\u000bi0A\u0003baBd\u0017\u0010F\u0007E\u0003\u007f\u0014\tAa\u0001\u0003\u0006\t\u001d!\u0011\u0002\u0005\u0007!\u0006e\b\u0019A\u001b\t\rU\u000bI\u00101\u0001&\u0011\u0019I\u0016\u0011 a\u0001K!1Q,!?A\u0002}Ca!ZA}\u0001\u0004)\u0003BB5\u0002z\u0002\u0007Q\u0005\u0003\u0006\u0003\u000e\u0005\r\u0018\u0011!CA\u0005\u001f\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0012\tu\u0001#B\u0007\u0003\u0014\t]\u0011b\u0001B\u000b\u001d\t1q\n\u001d;j_:\u0004\u0012\"\u0004B\rk\u0015*s,J\u0013\n\u0007\tmaB\u0001\u0004UkBdWM\u000e\u0005\n\u0005?\u0011Y!!AA\u0002\u0011\u000b1\u0001\u001f\u00131\u0011)\u0011\u0019#a9\u0002\u0002\u0013%!QE\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003(A\u0019\u0011D!\u000b\n\u0007\t-\"D\u0001\u0004PE*,7\r\u001e\u0004\u0007\u0005_I\u0001A!\r\u0003\u0015\u0015C\b/\u001a:j[\u0016tGo\u0005\u0004\u0003.\tM\"\u0011\t\t\u0005\u0005k\u0011i$\u0004\u0002\u00038)!!\u0011\bB\u001e\u0003\tQ8NC\u0001\u0004\u0013\u0011\u0011yDa\u000e\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\u0011\u0011\u0019E!\u0013\u000e\u0005\t\u0015#\u0002\u0002B$\u0005w\tQ!\u001e;jYNLAAa\u0013\u0003F\t9Aj\\4hS:<\u0007bB\n\u0003.\u0011\u0005!q\n\u000b\u0003\u0005#\u00022!\u0012B\u0017\u0011%\u0011)F!\fC\u0002\u0013\u0005q#A\u0005u_BL7MT1nK\"A!\u0011\fB\u0017A\u0003%\u0001$\u0001\u0006u_BL7MT1nK\u0002B\u0011B!\u0018\u0003.\u0001\u0007I\u0011A\f\u0002\u001d\u0015D\b/\u001a:j[\u0016tGOT1nK\"Q!\u0011\rB\u0017\u0001\u0004%\tAa\u0019\u0002%\u0015D\b/\u001a:j[\u0016tGOT1nK~#S-\u001d\u000b\u0004[\t\u0015\u0004\"CA(\u0005?\n\t\u00111\u0001\u0019\u0011!\u0011IG!\f!B\u0013A\u0012aD3ya\u0016\u0014\u0018.\\3oi:\u000bW.\u001a\u0011\t\u0013\t5$Q\u0006b\u0001\n\u0003!\u0013a\u00039beRLG/[8o\u0013\u0012D\u0001B!\u001d\u0003.\u0001\u0006I!J\u0001\ra\u0006\u0014H/\u001b;j_:LE\r\t\u0005\u000b\u0005k\u0012i\u00031A\u0005\u0002\t]\u0014aB:feZ,'o]\u000b\u0003\u0005s\u0002b!!\u0017\u0003|\t}\u0014\u0002\u0002B?\u00037\u00121aU3r!\u0011\u0011\tIa\"\u000e\u0005\t\r%\u0002\u0002BC\u0005w\taa]3sm\u0016\u0014\u0018\u0002\u0002BE\u0005\u0007\u00131bS1gW\u0006\u001cVM\u001d<fe\"Q!Q\u0012B\u0017\u0001\u0004%\tAa$\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0004[\tE\u0005BCA(\u0005\u0017\u000b\t\u00111\u0001\u0003z!I!Q\u0013B\u0017A\u0003&!\u0011P\u0001\tg\u0016\u0014h/\u001a:tA!Q!\u0011\u0014B\u0017\u0005\u0004%\tAa'\u0002\u00171,\u0017\rZ3s%\u0006$Xm]\u000b\u0003\u0005;\u0003rAa(\u0003&\u0016\u0012I+\u0004\u0002\u0003\"*!!1UA.\u0003\u001diW\u000f^1cY\u0016LAAa*\u0003\"\n\u0019Q*\u00199\u0011\t5\u0019$1\u0016\t\u0004\u001b\t5\u0016b\u0001BX\u001d\t1Ai\\;cY\u0016D\u0011Ba-\u0003.\u0001\u0006IA!(\u0002\u00191,\u0017\rZ3s%\u0006$Xm\u001d\u0011\t\u0015\t]&Q\u0006b\u0001\n\u0003\u0011Y*A\u0007g_2dwn^3s%\u0006$Xm\u001d\u0005\n\u0005w\u0013i\u0003)A\u0005\u0005;\u000baBZ8mY><XM\u001d*bi\u0016\u001c\b\u0005\u0003\u0005\u0003@\n5B\u0011\u0001Ba\u00031\u0019H/\u0019:u\u0005J|7.\u001a:t)\ri#1\u0019\u0005\t\u0005\u000b\u0014i\f1\u0001\u0003H\u0006I!M]8lKJLEm\u001d\t\u0006\u00033\u0012Y(\n\u0005\t\u0005\u0017\u0014i\u0003\"\u0011\u0002F\u0006AA/Z1s\t><h\u000eC\u0004A\u0005[!\tAa4\u0015\u000f5\u0012\tNa5\u0003V\"11I!4A\u0002\u0011C\u0001\"a\"\u0003N\u0002\u0007\u0011\u0011\u0012\u0005\t\u00037\u0014i\r1\u0001\u0002j!A!\u0011\u001cB\u0017\t\u0003\u0011Y.A\fwC2LG-\u0019;f\u00032dwJ\u001a4tKR\u001cX*\u0019;dQR\u0019QF!8\t\r\r\u00139\u000e1\u0001E\u0011!\u0011\tO!\f\u0005\u0002\t\r\u0018!\u00037pO>+H\u000f];u)\u001di#Q\u001dBt\u0005_Daa\u0011Bp\u0001\u0004!\u0005\u0002\u0003Bu\u0005?\u0004\rAa;\u0002\u0011I,\u0007\u000f\\5dCN\u0004r!!\u0017\u0003n\u0016\u00129-\u0003\u0003\u0003(\u0006m\u0003\u0002\u0003By\u0005?\u0004\rAa=\u0002\u001b9,w/Q:tS\u001etW.\u001a8u!!\tIF!<\u0003v\n\u001d\u0007\u0003\u0002B|\u0007\u000fi!A!?\u000b\t\tm(Q`\u0001\u0007G>lWn\u001c8\u000b\u0007\r\u0011yP\u0003\u0003\u0004\u0002\r\r\u0011AB1qC\u000eDWM\u0003\u0002\u0004\u0006\u0005\u0019qN]4\n\t\r%!\u0011 \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\u0019iA!\f\u0005\u0002\u0005\u0015\u0017!H<bSR4uN\u001d*fCN\u001c\u0018n\u001a8nK:$Hk\\\"p[BdW\r^3\t\u0011\rE!Q\u0006C\u0001\u0007'\t1B]3oI\u0016\u00148\t[1siRIQf!\u0006\u0004\u001a\rm1Q\u0004\u0005\t\u0007/\u0019y\u00011\u0001\u0003\u001e\u0006!A-\u0019;b\u0011\u0019\u00016q\u0002a\u0001k!A\u0011qQB\b\u0001\u0004\tI\t\u0003\u0005\u0002\\\u000e=\u0001\u0019AA5\u0011!\u0019\tC!\f\u0005\u0002\r\r\u0012\u0001F7bs\n,G)[:qY\u0006LxJ\\*de\u0016,g\u000eF\u0003.\u0007K\u00199\u0003\u0003\u0005\u0002\\\u000e}\u0001\u0019AA5\u0011!\u0019Ica\bA\u0002\r-\u0012!B2iCJ$\b\u0003BB\u0017\u0007ki!aa\f\u000b\t\r%2\u0011\u0007\u0006\u0005\u0007g\u0019\u0019!A\u0003kMJ,W-\u0003\u0003\u00048\r=\"A\u0003&Ge\u0016,7\t[1si\"A11\bB\u0017\t\u0003\u0019i$A\u0006xe&$X\rV8GS2,GcB\u0017\u0004@\r\u000531\t\u0005\u0007!\u000ee\u0002\u0019A\u001b\t\u0011\u0005\u001d5\u0011\ba\u0001\u0003\u0013C\u0001b!\u000b\u0004:\u0001\u000711\u0006\u0005\t\u0007\u000f\u0012i\u0003\"\u0001\u0004J\u0005Y1M]3bi\u0016\u001c\u0005.\u0019:u)\u0019\u0019Yca\u0013\u0004N!1\u0001k!\u0012A\u0002UB\u0001ba\u0014\u0004F\u0001\u00071\u0011K\u0001\bI\u0006$\u0018m]3u!\u0011\u0019\u0019fa\u0017\u000e\u0005\rU#\u0002BB,\u00073\n!\u0001_=\u000b\t\r]1\u0011G\u0005\u0005\u0007;\u001a)F\u0001\nY3N+'/[3t\u0007>dG.Z2uS>t\u0007\u0002CB1\u0005[!\taa\u0019\u0002\u001d\u0005$G\rR1uCR{7\t[1siR!1\u0011KB3\u0011!\u00199ba\u0018A\u0002\tu\u0005\u0002CB5\u0005[!\taa\u001b\u0002\rI,7m\u001c:e)!\u0019iga\u001c\u0004t\r]\u0004#B\u0007\u0003\u0014\t%\u0006\u0002CB9\u0007O\u0002\rA!(\u0002\u000bI\fG/Z:\t\u000f\rU4q\ra\u0001K\u0005A!M]8lKJLE\r\u0003\u0005\u0004z\r\u001d\u0004\u0019\u0001BV\u0003-\u0019WO\u001d:f]R\u0014\u0016\r^3\t\u0011\ru$Q\u0006C\u0001\u0003\u000b\f\u0001\u0003\u001d:j]R\u0014\u0016\r^3NKR\u0014\u0018nY:\t\u0011\r\u0005%Q\u0006C\u0005\u0007\u0007\u000bA\"\\3bgV\u0014X\r\u001a*bi\u0016$bAa+\u0004\u0006\u000e%\u0005\u0002CBD\u0007\u007f\u0002\rAa \u0002\r\t\u0014xn[3s\u0011!\u0019Yia A\u0002\r5\u0015a\u0002:faRK\b/\u001a\t\u0005\u0005\u0003\u001by)\u0003\u0003\u0004\u0012\n\r%!C)v_R\fG+\u001f9f\u0011!\u0019)J!\f\u0005\u0002\r]\u0015\u0001\u00026t_:$2!NBM\u0011!\u0019Yja%A\u0002\ru\u0015!\u0002;pa&\u001c\u0007\u0003B\u0007\u0004 VJ1a!)\u000f\u0005)a$/\u001a9fCR,GM\u0010")
public final class ReplicationQuotasTestRig {
    public static void run(ExperimentDef experimentDef, Journal journal, boolean bl) {
        ReplicationQuotasTestRig$.MODULE$.run(experimentDef, journal, bl);
    }

    public static void main(String[] stringArray) {
        ReplicationQuotasTestRig$.MODULE$.main(stringArray);
    }

    public static int k() {
        return ReplicationQuotasTestRig$.MODULE$.k();
    }

    public static class Experiment
    extends ZooKeeperTestHarness {
        private final String topicName;
        private String experimentName = "unset";
        private final int partitionId;
        private Seq<KafkaServer> servers = null;
        private final scala.collection.mutable.Map<Object, double[]> leaderRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<Object, double[]> followerRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public String topicName() {
            return this.topicName;
        }

        public String experimentName() {
            return this.experimentName;
        }

        public void experimentName_$eq(String x$1) {
            this.experimentName = x$1;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public Seq<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(Seq<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public scala.collection.mutable.Map<Object, double[]> leaderRates() {
            return this.leaderRates;
        }

        public scala.collection.mutable.Map<Object, double[]> followerRates() {
            return this.followerRates;
        }

        public void startBrokers(Seq<Object> brokerIds) {
            Predef$.MODULE$.println((Object)"Starting Brokers");
            this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        }

        @Override
        public void tearDown() {
            TestUtils$.MODULE$.shutdownServers(this.servers());
            super.tearDown();
        }

        public void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
            this.experimentName_$eq(config.name());
            Range.Inclusive brokers = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 100 + config.brokers());
            IntRef count = IntRef.create((int)0);
            int shift = Math.round(config.brokers() / 2);
            scala.collection.immutable.Map replicas = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), config.partitions()).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)partition))), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Experiment.nextReplicaRoundRobin$1(config, count, shift)}))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.startBrokers((Seq<Object>)brokers);
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)replicas, this.servers());
            Predef$.MODULE$.println((Object)"Writing Data");
            String x$5 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
            int x$6 = 5;
            int x$7 = 0;
            long x$8 = TestUtils$.MODULE$.createNewProducer$default$3();
            long x$9 = TestUtils$.MODULE$.createNewProducer$default$4();
            long x$10 = TestUtils$.MODULE$.createNewProducer$default$6();
            long x$11 = TestUtils$.MODULE$.createNewProducer$default$7();
            SecurityProtocol x$12 = TestUtils$.MODULE$.createNewProducer$default$8();
            Option<File> x$13 = TestUtils$.MODULE$.createNewProducer$default$9();
            Option<Properties> x$14 = TestUtils$.MODULE$.createNewProducer$default$10();
            ByteArraySerializer x$15 = TestUtils$.MODULE$.createNewProducer$default$11();
            ByteArraySerializer x$16 = TestUtils$.MODULE$.createNewProducer$default$12();
            Option<Properties> x$17 = TestUtils$.MODULE$.createNewProducer$default$13();
            KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$5, x$7, x$8, x$9, x$6, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.msgsPerPartition()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.partitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> producer.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)partition)), null, (Object)new byte[config.msgSize()]))));
            Predef$.MODULE$.println((Object)"Starting Reassignment");
            Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)brokers, this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
            long start = System.currentTimeMillis();
            ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ZkUtils$.MODULE$.getReassignmentJson(newAssignment), new ReassignPartitionsCommand.Throttle(config.throttle(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
            this.waitForReassignmentToComplete();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reassignment took ", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((System.currentTimeMillis() - start) / 1000L))})));
            this.validateAllOffsetsMatch(config);
            journal.appendToJournal(config);
            this.renderChart(this.leaderRates(), "Leader", journal, displayChartsOnScreen);
            this.renderChart(this.followerRates(), "Follower", journal, displayChartsOnScreen);
            this.logOutput(config, (Map<Object, Seq<Object>>)replicas, (Map<TopicPartition, Seq<Object>>)newAssignment);
            Predef$.MODULE$.println((Object)("Output can be found here: " + journal.path()));
        }

        public void validateAllOffsetsMatch(ExperimentDef config) {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$validateAllOffsetsMatch$1(this, config, broker);
                return BoxedUnit.UNIT;
            });
        }

        public void logOutput(ExperimentDef config, Map<Object, Seq<Object>> replicas, Map<TopicPartition, Seq<Object>> newAssignment) {
            scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
            Predef$.MODULE$.println((Object)("The replicas are " + ((TraversableLike)replicas.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> "\n" + x$4, Seq$.MODULE$.canBuildFrom())));
            Predef$.MODULE$.println((Object)("This is the current replica assignment:\n" + actual.toSeq()));
            Predef$.MODULE$.println((Object)("proposed assignment is: \n" + newAssignment));
            Predef$.MODULE$.println((Object)("This is the assignment we ended up with" + actual));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numBrokers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokers())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.partitions())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttle: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)config.throttle())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numMessagesPerPartition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.msgsPerPartition())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msgSize: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.msgSize())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We will write ", "MB of data per broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)config.targetBytesPerBrokerMB())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Worst case duration is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(config.targetBytesPerBrokerMB() * 1000L * 1000L / config.throttle()))})));
        }

        public void waitForReassignmentToComplete() {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.printRateMetrics();
                return !this.zkClient().reassignPartitionsInProgress();
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReassignPartitionsZNode$.MODULE$.path()})), 3600000L, 1000L);
        }

        public void renderChart(scala.collection.mutable.Map<Object, double[]> data, String name, Journal journal, boolean displayChartsOnScreen) {
            XYSeriesCollection dataset = this.addDataToChart(data);
            JFreeChart chart = this.createChart(name, dataset);
            this.writeToFile(name, journal, chart);
            this.maybeDisplayOnScreen(displayChartsOnScreen, chart);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Chart generated for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }

        public void maybeDisplayOnScreen(boolean displayChartsOnScreen, JFreeChart chart) {
            block0: {
                if (!displayChartsOnScreen) break block0;
                ChartFrame frame = new ChartFrame(this.experimentName(), chart);
                frame.pack();
                frame.setVisible(true);
            }
        }

        public void writeToFile(String name, Journal journal, JFreeChart chart) {
            File file = new File(ReplicationQuotasTestRig$.MODULE$.other$kafka$ReplicationQuotasTestRig$$dir(), this.experimentName() + "-" + name + ".png");
            ImageIO.write((RenderedImage)chart.createBufferedImage(1000, 700), "png", file);
            journal.appendChart(file.getAbsolutePath(), name == "Leader");
        }

        /*
         * WARNING - void declaration
         */
        public JFreeChart createChart(String name, XYSeriesCollection dataset) {
            void var3_3;
            JFreeChart chart = ChartFactory.createXYLineChart((String)(this.experimentName() + " - " + name + " Throttling Performance"), (String)"Time (s)", (String)"Throttle Throughput (B/s)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public XYSeriesCollection addDataToChart(scala.collection.mutable.Map<Object, double[]> data) {
            void var2_2;
            XYSeriesCollection dataset = new XYSeriesCollection();
            data.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Experiment.$anonfun$addDataToChart$1(dataset, x0$1);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }

        public Option<double[]> record(scala.collection.mutable.Map<Object, double[]> rates, int brokerId, double currentRate) {
            double[] leaderRatesBroker = (double[])rates.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
            leaderRatesBroker = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(leaderRatesBroker)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{currentRate})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            return rates.put((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)leaderRatesBroker);
        }

        public void printRateMetrics() {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$printRateMetrics$1(this, broker);
                return BoxedUnit.UNIT;
            });
        }

        private double measuredRate(KafkaServer broker, QuotaType repType) {
            MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
            return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).contains((Object)metricName) ? ((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).value() : -1.0;
        }

        public String json(Seq<String> topic) {
            String topicStr = ((TraversableOnce)topic.map((Function1 & Serializable & scala.Serializable)t -> "{\"topic\": \"" + t + "\"}", Seq$.MODULE$.canBuildFrom())).mkString(",");
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"topics\": [", "],\"version\":1}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicStr}));
        }

        private static final int nextReplicaRoundRobin$1(ExperimentDef config$1, IntRef count$1, int shift$1) {
            ++count$1.elem;
            return 100 + (count$1.elem + shift$1) % config$1.brokers();
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$1(Experiment $this, ExperimentDef config$2, KafkaServer broker) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config$2.partitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
                boolean x$19;
                TopicPartition x$18;
                LogManager qual$1 = broker.getLogManager();
                long offset = BoxesRunTime.unboxToLong((Object)qual$1.getLog(x$18 = new TopicPartition($this.topicName(), partitionId), x$19 = qual$1.getLog$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.logEndOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
                if (offset >= 0L && offset != (long)config$2.msgsPerPartition()) {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Run failed as offsets did not match for partition ", " on broker ", ". Expected ", " but was ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)broker.config().brokerId()), BoxesRunTime.boxToInteger((int)config$2.msgsPerPartition()), BoxesRunTime.boxToLong((long)offset)})));
                }
            });
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$1(XYSeriesCollection dataset$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int broker = tuple2._1$mcI$sp();
            double[] values = (double[])tuple2._2();
            XYSeries series = new XYSeries((Comparable)((Object)("Broker:" + broker)));
            IntRef x = IntRef.create((int)0);
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)value -> {
                series.add((double)x$20.elem, value);
                ++x$20.elem;
            });
            dataset$1.addSeries(series);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$printRateMetrics$1(Experiment $this, KafkaServer broker) {
            block2: {
                double leaderRate = $this.measuredRate(broker, (QuotaType)QuotaType.LeaderReplication$.MODULE$);
                if (broker.config().brokerId() == 100) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "waiting... Leader rate on 101 is " + leaderRate);
                }
                $this.record($this.leaderRates(), broker.config().brokerId(), leaderRate);
                if (leaderRate > 0.0) {
                    $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader Rate on " + broker.config().brokerId() + " is " + leaderRate);
                }
                double followerRate = $this.measuredRate(broker, (QuotaType)QuotaType.FollowerReplication$.MODULE$);
                $this.record($this.followerRates(), broker.config().brokerId(), followerRate);
                if (!(followerRate > 0.0)) break block2;
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Follower Rate on " + broker.config().brokerId() + " is " + followerRate);
            }
        }

        public Experiment() {
            this.topicName = "my-topic";
            this.partitionId = 0;
        }
    }

    public static class ExperimentDef
    implements Product,
    scala.Serializable {
        private final String name;
        private final int brokers;
        private final int partitions;
        private final long throttle;
        private final int msgsPerPartition;
        private final int msgSize;
        private final long targetBytesPerBrokerMB;

        public String name() {
            return this.name;
        }

        public int brokers() {
            return this.brokers;
        }

        public int partitions() {
            return this.partitions;
        }

        public long throttle() {
            return this.throttle;
        }

        public int msgsPerPartition() {
            return this.msgsPerPartition;
        }

        public int msgSize() {
            return this.msgSize;
        }

        public long targetBytesPerBrokerMB() {
            return this.targetBytesPerBrokerMB;
        }

        public ExperimentDef copy(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            return new ExperimentDef(name, brokers, partitions, throttle, msgsPerPartition, msgSize);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.brokers();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public long copy$default$4() {
            return this.throttle();
        }

        public int copy$default$5() {
            return this.msgsPerPartition();
        }

        public int copy$default$6() {
            return this.msgSize();
        }

        public String productPrefix() {
            return "ExperimentDef";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.name();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.brokers());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this.partitions());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.throttle());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.msgsPerPartition());
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this.msgSize());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExperimentDef;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.brokers());
            n = Statics.mix((int)n, (int)this.partitions());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.throttle()));
            n = Statics.mix((int)n, (int)this.msgsPerPartition());
            n = Statics.mix((int)n, (int)this.msgSize());
            return Statics.finalizeHash((int)n, (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExperimentDef)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExperimentDef experimentDef = (ExperimentDef)x$1;
            String string = this.name();
            String string2 = experimentDef.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.brokers() != experimentDef.brokers()) return false;
            if (this.partitions() != experimentDef.partitions()) return false;
            if (this.throttle() != experimentDef.throttle()) return false;
            if (this.msgsPerPartition() != experimentDef.msgsPerPartition()) return false;
            if (this.msgSize() != experimentDef.msgSize()) return false;
            if (!experimentDef.canEqual(this)) return false;
            return true;
        }

        public ExperimentDef(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            this.name = name;
            this.brokers = brokers;
            this.partitions = partitions;
            this.throttle = throttle;
            this.msgsPerPartition = msgsPerPartition;
            this.msgSize = msgSize;
            Product.$init$((Product)this);
            this.targetBytesPerBrokerMB = (long)msgsPerPartition * (long)msgSize * (long)partitions / (long)brokers / 1000000L;
        }
    }

    public static class Journal {
        private final File log = new File(ReplicationQuotasTestRig$.MODULE$.other$kafka$ReplicationQuotasTestRig$$dir(), "Log.html");

        private File log() {
            return this.log;
        }

        public void appendToJournal(ExperimentDef config) {
            double arg$macro$1 = config.throttle();
            double arg$macro$2 = config.msgsPerPartition();
            double arg$macro$3 = config.msgSize();
            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\n<h3>", "</h3>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.name()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<p>- BrokerCount: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokers())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<p>- PartitionCount: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.partitions())})) + new StringOps("<p>- Throttle: %,.0f MB/s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)})) + new StringOps("<p>- MsgCount: %,.0f ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$2)})) + new StringOps("<p>- MsgSize: %,.0f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<p>- TargetBytesPerBrokerMB: ", "<p>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)config.targetBytesPerBrokerMB())}));
            this.append(message);
        }

        public void appendChart(String path, boolean first) {
            StringBuilder message = new StringBuilder();
            Object object = first ? message.append("<p><p>") : BoxedUnit.UNIT;
            message.append("<img src=\"" + path + "\" alt=\"Chart\" style=\"width:600px;height:400px;align=\"middle\"\">");
            Object object2 = !first ? message.append("<p><p>") : BoxedUnit.UNIT;
            this.append(message.toString());
        }

        public void header() {
            this.append("<html><head><h1>Replication Quotas Test Rig</h1></head><body>");
        }

        public void footer() {
            this.append("</body></html>");
        }

        public void append(String message) {
            FileOutputStream stream = new FileOutputStream(this.log(), true);
            new PrintWriter(null, message, stream){
                {
                    this.append(message$1);
                    this.close();
                }
            };
        }

        public String path() {
            return this.log().getAbsolutePath();
        }

        public Journal() {
            this.header();
        }
    }
}

