/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;

class KStreamFlatMapValues<K, V, V1>
implements ProcessorSupplier<K, V> {
    private final ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends V1>> mapper;

    KStreamFlatMapValues(ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends V1>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamFlatMapValuesProcessor();
    }

    private class KStreamFlatMapValuesProcessor
    extends AbstractProcessor<K, V> {
        private KStreamFlatMapValuesProcessor() {
        }

        @Override
        public void process(K key, V value) {
            Iterable newValues = (Iterable)KStreamFlatMapValues.this.mapper.apply(key, value);
            for (Object v : newValues) {
                this.context().forward(key, v);
            }
        }
    }
}

