/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryCache;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.RepositoryInfo;
import org.opensolaris.opengrok.history.TagEntry;
import org.opensolaris.opengrok.util.Executor;

public abstract class Repository
extends RepositoryInfo {
    protected String cmd;
    protected TreeSet<TagEntry> tagList = null;

    abstract boolean fileHasHistory(File var1);

    abstract boolean hasHistoryForDirectories();

    abstract History getHistory(File var1) throws HistoryException;

    History getHistory(File file, String sinceRevision) throws HistoryException {
        if (sinceRevision != null) {
            Logger logger = OpenGrokLogger.getLogger();
            logger.log(Level.WARNING, "Incremental history retrieval is not implemented for {0}.", this.getClass().getSimpleName());
            logger.log(Level.WARNING, "Falling back to slower full history retrieval.");
        }
        History history = this.getHistory(file);
        if (sinceRevision == null) {
            return history;
        }
        ArrayList<HistoryEntry> partial = new ArrayList<HistoryEntry>();
        for (HistoryEntry entry : history.getHistoryEntries()) {
            partial.add(entry);
            if (!sinceRevision.equals(entry.getRevision())) continue;
            break;
        }
        this.removeAndVerifyOldestChangeset(partial, sinceRevision);
        history.setHistoryEntries(partial);
        return history;
    }

    void removeAndVerifyOldestChangeset(List<HistoryEntry> entries, String revision) throws HistoryException {
        HistoryEntry entry;
        HistoryEntry historyEntry = entry = entries.isEmpty() ? null : entries.remove(entries.size() - 1);
        if (entry == null || !revision.equals(entry.getRevision())) {
            throw new HistoryException("Cached revision '" + revision + "' not found in the repository " + this.getDirectoryName());
        }
    }

    abstract InputStream getHistoryGet(String var1, String var2, String var3);

    abstract boolean fileHasAnnotation(File var1);

    boolean hasFileBasedTags() {
        return false;
    }

    TreeSet<TagEntry> getTagList() {
        return this.tagList;
    }

    void assignTagsInHistory(History hist) throws HistoryException {
        if (hist == null) {
            return;
        }
        if (this.getTagList() == null) {
            throw new HistoryException("Tag list was not created before assigning tags to changesets!");
        }
        Iterator<TagEntry> it = this.getTagList().descendingIterator();
        TagEntry lastTagEntry = null;
        block0: for (HistoryEntry ent : hist.getHistoryEntries()) {
            while (lastTagEntry != null || it.hasNext()) {
                if (lastTagEntry == null) {
                    lastTagEntry = it.next();
                }
                if (lastTagEntry.compareTo(ent) < 0) continue block0;
                if (ent.getTags() == null) {
                    ent.setTags(lastTagEntry.getTags());
                } else {
                    ent.setTags(ent.getTags() + ", " + lastTagEntry.getTags());
                }
                if (it.hasNext()) {
                    lastTagEntry = it.next();
                    continue;
                }
                lastTagEntry = null;
            }
        }
    }

    protected void buildTagList(File directory) {
        this.tagList = null;
    }

    abstract Annotation annotate(File var1, String var2) throws IOException;

    protected String getRevisionForAnnotate(String history_revision) {
        return history_revision;
    }

    final void createCache(HistoryCache cache, String sinceRevision) throws HistoryException {
        RuntimeEnvironment env;
        History history;
        if (!this.isWorking()) {
            return;
        }
        if (!this.hasHistoryForDirectories()) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Skipping creation of history cache for {0}, since retrieval of history for directories is not implemented for this repository type.", this.getDirectoryName());
            return;
        }
        File directory = new File(this.getDirectoryName());
        try {
            history = this.getHistory(directory, sinceRevision);
        }
        catch (HistoryException he) {
            if (sinceRevision == null) {
                throw he;
            }
            OpenGrokLogger.getLogger().log(Level.INFO, "Failed to get partial history. Attempting to recreate the history cache from scratch.", he);
            history = null;
        }
        if (sinceRevision != null && history == null) {
            history = this.getHistory(directory);
            cache.clear(this);
        }
        if ((env = RuntimeEnvironment.getInstance()).isTagsEnabled() && this.hasFileBasedTags()) {
            this.buildTagList(new File(this.directoryName));
        }
        if (history != null) {
            cache.store(history, this);
        }
    }

    abstract void update() throws IOException;

    abstract boolean isRepositoryFor(File var1);

    boolean supportsSubRepositories() {
        return false;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat(this.datePattern, Locale.US);
    }

    static Boolean checkCmd(String ... args) {
        Executor exec = new Executor(args);
        return exec.exec(false) == 0;
    }

    protected String ensureCommand(String propertyKey, String fallbackCommand) {
        if (this.cmd != null) {
            return this.cmd;
        }
        this.cmd = RuntimeEnvironment.getInstance().getRepoCmd(this.getClass().getCanonicalName());
        if (this.cmd == null) {
            this.cmd = System.getProperty(propertyKey, fallbackCommand);
            RuntimeEnvironment.getInstance().setRepoCmd(this.getClass().getCanonicalName(), this.cmd);
        }
        return this.cmd;
    }
}

