/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkEditDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myInvokeField;
    private JTextField myAliasField;
    private JBCheckBox myEnabledCheckBox;
    private JRadioButton myProjectVisibilityRadioButton;
    private JRadioButton myGlobalVisibilityRadioButton;
    private final FrameworkDataService.FrameworkFileData myFileData;

    protected FrameworkEditDialog(@NotNull Component parent, @NotNull FrameworkDataService.FrameworkFileData fileData) {
        if (parent == null) {
            FrameworkEditDialog.$$$reportNull$$$0(0);
        }
        if (fileData == null) {
            FrameworkEditDialog.$$$reportNull$$$0(1);
        }
        super(parent, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(FrameworkBundle.message("framework.edit.dialog.title.edit.tool", objectArray));
        this.myFileData = fileData;
        FrameworkConfigurationDescription framework = fileData.getFramework();
        this.myInvokeField.setText(framework.getInvokeText());
        Project project = FrameworkUtils.getProject(parent);
        this.myInvokeField.addBrowseFolderListener(FrameworkBundle.message("framework.settings.table.tool.path.header", new Object[0]), FrameworkBundle.message("framework.choose.path.to.executable", new Object[0]), project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        this.myAliasField.setText(framework.getAlias());
        this.myEnabledCheckBox.setSelected(framework.isEnabled());
        if (fileData.isProjectVisibility()) {
            this.myProjectVisibilityRadioButton.setSelected(true);
        } else {
            this.myGlobalVisibilityRadioButton.setSelected(true);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.myInvokeField.getText())) {
            return new ValidationInfo(FrameworkBundle.message("framework.0.not.provided", FrameworkBundle.message("framework.settings.table.tool.path.header", new Object[0])), (JComponent)this.myInvokeField);
        }
        if (StringUtil.isEmpty((String)this.myAliasField.getText())) {
            return new ValidationInfo(FrameworkBundle.message("framework.0.not.provided", FrameworkBundle.message("framework.settings.table.alias.header", new Object[0])), (JComponent)this.myAliasField);
        }
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        FrameworkConfigurationDescription framework = this.myFileData.getFramework();
        framework.setAlias(this.myAliasField.getText());
        framework.setInvokeText(this.myInvokeField.getText());
        framework.setEnabled(this.myEnabledCheckBox.isSelected());
        this.myFileData.setProjectVisibility(this.myProjectVisibilityRadioButton.isSelected());
        super.doOKAction();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "FrameworkEditDialogDimensionKey";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileData";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/framework/ui/FrameworkEditDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.custom.framework.dialog.tool.path"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInvokeField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.custom.framework.dialog.command.alias"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAliasField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEnabledCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Enabled");
        jBCheckBox.setMnemonic('E');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Visibility:");
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectVisibilityRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("current project");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jRadioButton2, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGlobalVisibilityRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("global");
        jRadioButton.setMnemonic('B');
        jRadioButton.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jRadioButton, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

