/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.Dbms;
import com.intellij.database.actions.BasicElementAction;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0010H\u0014J\u001c\u0010\u0012\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0010H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/actions/HideSchemasAction;", "Lcom/intellij/database/actions/BasicElementAction;", "Lcom/intellij/database/model/basic/BasicNamespace;", "()V", "cast", "node", "Lcom/intellij/database/model/basic/BasicNode;", "check", "", "doIt", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selection", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicModel;", "enabled", "intellij.database.impl"})
public final class HideSchemasAction
extends BasicElementAction<BasicNamespace> {
    @Override
    @Nullable
    protected BasicNamespace cast(@Nullable BasicNode node) {
        BasicNode basicNode = node;
        if (!(basicNode instanceof BasicNamespace)) {
            basicNode = null;
        }
        return (BasicNamespace)basicNode;
    }

    @Override
    protected boolean check(@NotNull BasicNamespace node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return node.isVisible();
    }

    @Override
    protected boolean enabled(@NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkParameterIsNotNull(selection, (String)"selection");
        Iterator iterator = selection.values().iterator();
        while (iterator.hasNext()) {
            BasicNamespace element2;
            BasicNamespace basicNamespace = element2 = (BasicNamespace)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicNamespace, (String)"element");
            if (!Intrinsics.areEqual((Object)basicNamespace.getKind(), (Object)ObjectKind.DATABASE) || !element2.isCurrent()) continue;
            BasicModel basicModel = element2.getModel();
            if (!Intrinsics.areEqual((Object)(basicModel != null ? basicModel.getDbms() : null), (Object)Dbms.POSTGRES)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doIt(@NotNull AnActionEvent e, @NotNull Project project, @NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(selection, (String)"selection");
        DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dataSourceStorage), (String)"DataSourceStorage.getProjectStorage(project)");
        for (LocalDataSource dataSource : dataSourceStorage.getDataSources()) {
            DasModel model;
            if (!(dataSource instanceof LocalDataSource)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataSource.getModel(), (String)"dataSource.model");
            if (!(model instanceof BasicModel) || !selection.containsKey((Object)model)) continue;
            DataSourceUiUtil.setNamespacesVisible(project, dataSource, selection.get((Object)model), false);
            DataSourceSyncManager.getInstance().introspectionScopeChanged(project, dataSource);
        }
    }
}

