/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers;

import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableIndexColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> {
    public static final Pattern COLUMN_SPLITTER_PATTERN = Pattern.compile("\\s*,\\s*");
    private final DatabaseMetaDataWrapper.TableIndexColumn myTemplate;
    private final DatabaseMetaDataWrapper.Table myTable;
    private String[] mySubColumns;
    private int mySubIdx;

    public TableIndexColumnIt(@Nullable ResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (table == null) {
            TableIndexColumnIt.$$$reportNull$$$0(0);
        }
        super(rs);
        this.mySubIdx = -1;
        this.myTable = table;
        this.myTemplate = this.createStorage();
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableIndexColumn createStorage() {
        DatabaseMetaDataWrapper.TableIndexColumn tableIndexColumn = new DatabaseMetaDataWrapper.TableIndexColumn(new DatabaseMetaDataWrapper.TableIndex(this.myTable, ""));
        if (tableIndexColumn == null) {
            TableIndexColumnIt.$$$reportNull$$$0(1);
        }
        return tableIndexColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableIndexColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableIndexColumn res2 = (DatabaseMetaDataWrapper.TableIndexColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            res2.index.type = this.myRs.getShort("TYPE", 7);
            if (res2.index.type == 0) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.myTable.schema.schema);
            if (!Comparing.equal((String)schema, (String)this.myTable.schema.schema) || !Comparing.equal((String)table, (String)this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            res2.index.nonUnique = this.myRs.getBoolean("NON_UNIQUE", 4);
            res2.index.name = this.myRs.getString("INDEX_NAME", 6);
            String ascOrDesc = this.myRs.getString("ASC_OR_DESC", 10);
            res2.sorting = "a".equalsIgnoreCase(ascOrDesc) ? DasIndex.Sorting.ASCENDING : ("d".equalsIgnoreCase(ascOrDesc) ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.NONE);
            res2.index.qualifier = this.myRs.getString("INDEX_QUALIFIER", 5);
            res2.position = this.myRs.getShort("ORDINAL_POSITION", 8);
            res2.name = this.myRs.getString("COLUMN_NAME", 9);
            String[] columnNames = COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)res2.name), 0);
            if (columnNames.length > 1) {
                for (int i2 = 0; i2 < columnNames.length; ++i2) {
                    columnNames[i2] = StringUtil.unquoteString((String)columnNames[i2]);
                }
                this.myTemplate.assign(res2);
                this.mySubColumns = columnNames;
                this.mySubIdx = 0;
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            if (!StringUtil.isEmpty((String)res2.name)) {
                res2.name = StringUtil.unquoteString((String)res2.name);
            }
        }
        catch (SQLException e) {
            this.onError(res2, e);
            return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
        }
        return res2;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableIndexColumn nextImpl() {
        if (this.mySubIdx != -1 && this.mySubColumns != null) {
            DatabaseMetaDataWrapper.TableIndexColumn res2 = (DatabaseMetaDataWrapper.TableIndexColumn)this.getStorageToFill();
            res2.assign(this.myTemplate);
            res2.name = this.mySubColumns[this.mySubIdx];
            ++this.mySubIdx;
            if (this.mySubIdx >= this.mySubColumns.length) {
                this.mySubIdx = -1;
                this.mySubColumns = null;
            }
            return res2;
        }
        return (DatabaseMetaDataWrapper.TableIndexColumn)super.nextImpl();
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableIndexColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.index.table.schema.database, cur.index.table.schema.schema, cur.index.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableIndexColumnIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableIndexColumnIt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn, DatabaseMetaDataWrapper.TableIndexColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> it) {
            final String indexName = ((DatabaseMetaDataWrapper.TableIndexColumn)it.current()).index.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableIndexColumn item) {
                    return Comparing.equal((String)indexName, (String)item.index.name);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.TableIndex getItem(ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> it) {
            return ((DatabaseMetaDataWrapper.TableIndexColumn)it.current()).index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableIndexColumnIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbcMetadataWrappers/TableIndexColumnIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

