/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlConditionDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.impl.JdbcProcedureCallImpl;
import com.intellij.sql.psi.impl.SqlAlterDomainStatementImpl;
import com.intellij.sql.psi.impl.SqlAlterInstructionImpl;
import com.intellij.sql.psi.impl.SqlAlterStatementImpl;
import com.intellij.sql.psi.impl.SqlAlterTableStatementImpl;
import com.intellij.sql.psi.impl.SqlAlterTriggerStatementImpl;
import com.intellij.sql.psi.impl.SqlAsExpressionImpl;
import com.intellij.sql.psi.impl.SqlAuthorizationIdentifierImpl;
import com.intellij.sql.psi.impl.SqlBetweenExpressionImpl;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlBreakStatementImpl;
import com.intellij.sql.psi.impl.SqlCaseExpressionImpl;
import com.intellij.sql.psi.impl.SqlCaseStatementImpl;
import com.intellij.sql.psi.impl.SqlClauseImpl;
import com.intellij.sql.psi.impl.SqlCollateClauseImpl;
import com.intellij.sql.psi.impl.SqlCollectionTypeDefinitionImpl;
import com.intellij.sql.psi.impl.SqlCollectionTypeElementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionInTypeImpl;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlConditionErrorSpec;
import com.intellij.sql.psi.impl.SqlConstraintDefinitionImpl;
import com.intellij.sql.psi.impl.SqlConstraintStubbedDefinitionImpl;
import com.intellij.sql.psi.impl.SqlContinueStatementImpl;
import com.intellij.sql.psi.impl.SqlCorrespondingClauseImpl;
import com.intellij.sql.psi.impl.SqlCreateAssertionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateCatalogStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateCharacterSetStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateCollationStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateDomainStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateIndexStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateMatViewStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateOperatorStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateProcedureStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateRoleStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateSchemaStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateSequenceStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateSynonymStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTableStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTablespaceStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTranslationStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateUserStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateViewStatementImpl;
import com.intellij.sql.psi.impl.SqlCursorDefinitionImpl;
import com.intellij.sql.psi.impl.SqlDeclareConditionHandlerStatementImpl;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlDeclareVariableStatementImpl;
import com.intellij.sql.psi.impl.SqlDefinitionHolderStatementImpl;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlDeleteDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlDeleteStatementImpl;
import com.intellij.sql.psi.impl.SqlDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.impl.SqlElseClauseImpl;
import com.intellij.sql.psi.impl.SqlElseIfClauseImpl;
import com.intellij.sql.psi.impl.SqlErrorCodeSpec;
import com.intellij.sql.psi.impl.SqlExceptionClauseImpl;
import com.intellij.sql.psi.impl.SqlExceptionWhenClauseImpl;
import com.intellij.sql.psi.impl.SqlExplainStatementImpl;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlExpressionListImpl;
import com.intellij.sql.psi.impl.SqlForLoopStatementImpl;
import com.intellij.sql.psi.impl.SqlForeignKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlFromClauseImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlGotoStatementImpl;
import com.intellij.sql.psi.impl.SqlGrantStatementImpl;
import com.intellij.sql.psi.impl.SqlGroupByClauseImpl;
import com.intellij.sql.psi.impl.SqlHavingClauseImpl;
import com.intellij.sql.psi.impl.SqlIdentifierImpl;
import com.intellij.sql.psi.impl.SqlIfStatementImpl;
import com.intellij.sql.psi.impl.SqlIndexDefinitionImpl;
import com.intellij.sql.psi.impl.SqlInsertDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlInsertStatementImpl;
import com.intellij.sql.psi.impl.SqlIntersectExpressionImpl;
import com.intellij.sql.psi.impl.SqlIntervalLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlJoinConditionClauseImpl;
import com.intellij.sql.psi.impl.SqlJoinExpressionImpl;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlLikeTableClauseImpl;
import com.intellij.sql.psi.impl.SqlLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlLoopStatementImpl;
import com.intellij.sql.psi.impl.SqlMergeStatementImpl;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlNullStatementImpl;
import com.intellij.sql.psi.impl.SqlObjectAttributeDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlOrderByClauseImpl;
import com.intellij.sql.psi.impl.SqlParameterDefinitionImpl;
import com.intellij.sql.psi.impl.SqlParameterImpl;
import com.intellij.sql.psi.impl.SqlParameterListImpl;
import com.intellij.sql.psi.impl.SqlParenthesizedExpressionImpl;
import com.intellij.sql.psi.impl.SqlPartitionByClauseImpl;
import com.intellij.sql.psi.impl.SqlPartitionDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPathLiteral;
import com.intellij.sql.psi.impl.SqlPivotedQueryExpressionImpl;
import com.intellij.sql.psi.impl.SqlPrimaryKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlQueryExpressionImpl;
import com.intellij.sql.psi.impl.SqlRaiseStatementImpl;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlReferenceListImpl;
import com.intellij.sql.psi.impl.SqlRenameToClauseImpl;
import com.intellij.sql.psi.impl.SqlRepeatLoopStatementImpl;
import com.intellij.sql.psi.impl.SqlReturnStatementImpl;
import com.intellij.sql.psi.impl.SqlReturningClauseImpl;
import com.intellij.sql.psi.impl.SqlReturningExpressionImpl;
import com.intellij.sql.psi.impl.SqlReturnsClauseImpl;
import com.intellij.sql.psi.impl.SqlRevokeStatementImpl;
import com.intellij.sql.psi.impl.SqlSelectClauseImpl;
import com.intellij.sql.psi.impl.SqlSelectIntoClauseImpl;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlSelectOptionImpl;
import com.intellij.sql.psi.impl.SqlSelectStatementImpl;
import com.intellij.sql.psi.impl.SqlSetAssignmentImpl;
import com.intellij.sql.psi.impl.SqlSetClauseImpl;
import com.intellij.sql.psi.impl.SqlSetStatementImpl;
import com.intellij.sql.psi.impl.SqlSignalStatement;
import com.intellij.sql.psi.impl.SqlSpecialErrorSpec;
import com.intellij.sql.psi.impl.SqlStatementImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralConcatenationImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableColumnsListImpl;
import com.intellij.sql.psi.impl.SqlTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlThenClauseImpl;
import com.intellij.sql.psi.impl.SqlTimeAndDateLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlTruncateTableStatementImpl;
import com.intellij.sql.psi.impl.SqlTypeCastExpressionImpl;
import com.intellij.sql.psi.impl.SqlTypeDefinitionImpl;
import com.intellij.sql.psi.impl.SqlTypeElementImpl;
import com.intellij.sql.psi.impl.SqlUnaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlUnionExpressionImpl;
import com.intellij.sql.psi.impl.SqlUniqueKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlUnpivotedQueryExpressionImpl;
import com.intellij.sql.psi.impl.SqlUpdatabilityClauseImpl;
import com.intellij.sql.psi.impl.SqlUpdateStatementImpl;
import com.intellij.sql.psi.impl.SqlUseDatabaseStatementImpl;
import com.intellij.sql.psi.impl.SqlUsingClauseImpl;
import com.intellij.sql.psi.impl.SqlValuesExpressionImpl;
import com.intellij.sql.psi.impl.SqlVariableDefinitionImpl;
import com.intellij.sql.psi.impl.SqlWhenClauseImpl;
import com.intellij.sql.psi.impl.SqlWhenThenClauseImpl;
import com.intellij.sql.psi.impl.SqlWhereClauseImpl;
import com.intellij.sql.psi.impl.SqlWhileLoopStatementImpl;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.sql.psi.impl.SqlWithClauseImpl;
import com.intellij.sql.psi.impl.SqlWithQueryExpressionImpl;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlElementFactory
implements SqlElementTypes {
    protected Info getStaticInfo() {
        throw new UnsupportedOperationException();
    }

    public PsiElement createCompositeElement(ASTNode node) {
        IElementType type = node.getElementType();
        Constructor constructor = this.getStaticInfo().map.get(type);
        if (constructor == null) {
            throw new AssertionError((Object)(this.getClass().getSimpleName() + ": node type: " + type + " text: " + node.getText()));
        }
        try {
            return (PsiElement)constructor.newInstance(node);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            ExceptionUtil.rethrowUnchecked((Throwable)target);
            throw new AssertionError((Object)target);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T extends PsiElement> T createCompositeElement(StubElement<T> stub) {
        IStubElementType stubType = stub.getStubType();
        Constructor constructor = this.getStaticInfo().map2.get(stubType);
        if (constructor == null) {
            throw new AssertionError((Object)(this.getClass().getSimpleName() + ": unknown stub type: " + stubType));
        }
        try {
            return (T)((PsiElement)constructor.newInstance(stub));
        }
        catch (Exception e) {
            throw new AssertionError(constructor.toGenericString() + " <- " + stub.getClass().getSimpleName(), e);
        }
    }

    @Nullable
    public CompositePsiElement createElementNode(@NotNull IElementType type) {
        Constructor constructor;
        if (type == null) {
            SqlElementFactory.$$$reportNull$$$0(0);
        }
        if ((constructor = this.getStaticInfo().map3.get(type)) == null) {
            if (type instanceof SqlReferenceElementType) {
                return new SqlReferenceExpressionImpl(type);
            }
            if (type instanceof IsExternal && !(type instanceof IStubElementType)) {
                return new SqlCompositeElementImpl.External(type);
            }
            return null;
        }
        try {
            return (CompositePsiElement)constructor.newInstance(type);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public Map<String, String> getReplacements() {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (Map map : Arrays.asList(this.getStaticInfo().map, this.getStaticInfo().map3)) {
            for (IElementType type : map.keySet()) {
                result2.put(type.toString(), ((Constructor)map.get(type)).getDeclaringClass().getSimpleName());
            }
        }
        return result2;
    }

    public JBIterable<Pair<IElementType, Class<?>>> getClasses() {
        return JBIterable.from(this.getStaticInfo().map3.entrySet()).transform(e -> Pair.create(e.getKey(), ((Constructor)e.getValue()).getDeclaringClass()));
    }

    public static void getDefaultRegistrations(@NotNull Info info) {
        if (info == null) {
            SqlElementFactory.$$$reportNull$$$0(1);
        }
        SqlElementFactory.registerImplementation(info, (IElementType)JDBC_PROCEDURE_CALL, JdbcProcedureCallImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)ODBC_FUNCTION_CALL, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)ODBC_ESCAPE, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)ODBC_DATE, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)ODBC_TIME, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)ODBC_TIMESTAMP, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)ODBC_GENERIC, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_BOOLEAN_LITERAL, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_NUMERIC_LITERAL, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SPECIAL_LITERAL, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_IDENTIFIER, SqlIdentifierImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_UPDATABILITY_CLAUSE, SqlUpdatabilityClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_LIKE_TABLE_CLAUSE, SqlLikeTableClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_AS_QUERY_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ORDER_BY_CLAUSE, SqlOrderByClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SET_CLAUSE, SqlSetClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CORRESPONDING_CLAUSE, SqlCorrespondingClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TABLE_EXPRESSION, SqlTableExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_UNION_EXPRESSION, SqlUnionExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_INTERSECT_EXPRESSION, SqlIntersectExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_JOIN_EXPRESSION, SqlJoinExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARENTHESIZED_EXPRESSION, SqlParenthesizedExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARENTHESIZED_JOIN_EXPRESSION, SqlParenthesizedExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARENTHESIZED_QUERY_EXPRESSION, SqlParenthesizedExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_EXPLICIT_TABLE_EXPRESSION, SqlExplicitTableExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_VALUES_EXPRESSION, SqlValuesExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_AS_EXPRESSION, SqlAsExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TYPE_CAST_EXPRESSION, SqlTypeCastExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CASE_EXPRESSION, SqlCaseExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_WHEN_CLAUSE, SqlWhenClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_THEN_CLAUSE, SqlThenClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CASE_WHEN_THEN_CLAUSE, SqlWhenThenClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ELSE_CLAUSE, SqlElseClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ELSEIF_CLAUSE, SqlElseIfClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_EXCEPTION_CLAUSE, SqlExceptionClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_EXCEPTION_WHEN_CLAUSE, SqlExceptionWhenClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARAMETER_REFERENCE, SqlParameterImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CONDITION_REFERENCE, SqlConditionErrorSpec.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_REFERENCE_LIST, SqlReferenceListImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_EXPRESSION_LIST, SqlExpressionListImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TABLE_COLUMNS_LIST, SqlTableColumnsListImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLUMN_ALIAS_LIST, SqlColumnAliasListImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TYPED_COLUMN_ALIAS_LIST, SqlColumnAliasListImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_QUERY_EXPRESSION, SqlQueryExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_WITH_QUERY_EXPRESSION, SqlWithQueryExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SELECT_CLAUSE, SqlSelectClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_QUERY_FLATTEN_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SELECT_INTO_CLAUSE, SqlSelectIntoClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SELECT_INTO_NEW_TABLE_CLAUSE, SqlSelectIntoNewTableClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SELECT_OPTION, SqlSelectOptionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_FROM_CLAUSE, SqlFromClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_WHERE_CLAUSE, SqlWhereClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_HAVING_CLAUSE, SqlHavingClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_GROUP_BY_CLAUSE, SqlGroupByClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_WITH_CLAUSE, SqlWithClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_IF_EXISTS_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TYPE_SUFFIX, SqlCompositeElementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TYPE_ELEMENT, SqlTypeElementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TABLE_TYPE_ELEMENT, SqlTypeElementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TYPE_ELEMENT_EXT, SqlTypeElementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLLECTION_TYPE_ELEMENT, SqlCollectionTypeElementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_BINARY_EXPRESSION, SqlBinaryExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_UNARY_EXPRESSION, SqlUnaryExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_BETWEEN_EXPRESSION, SqlBetweenExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_FUNCTION_CALL, SqlFunctionCallExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TABLE_PROCEDURE_CALL_EXPRESSION, SqlFunctionCallTableExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TIME_LITERAL, SqlTimeAndDateLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DATE_LITERAL, SqlTimeAndDateLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TIMESTAMP_LITERAL, SqlTimeAndDateLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_STRING_LITERAL, SqlStringLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_STRING_LITERAL_CONCATENATION, SqlStringLiteralConcatenationImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_INTERVAL_LITERAL, SqlIntervalLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ARRAY_LITERAL, SqlLiteralExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DELETE_DML_INSTRUCTION, SqlDeleteDmlInstructionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SELECT_STATEMENT, SqlSelectStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_INSERT_STATEMENT, SqlInsertStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DELETE_STATEMENT, SqlDeleteStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_UPDATE_STATEMENT, SqlUpdateStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_MERGE_STATEMENT, SqlMergeStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SET_STATEMENT, SqlSetStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_CATALOG_STATEMENT, SqlCreateCatalogStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_SCHEMA_STATEMENT, SqlCreateSchemaStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_EXTERNAL_SCHEMA_STATEMENT, SqlCreateSchemaStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_TABLE_STATEMENT, SqlCreateTableStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_VIEW_STATEMENT, SqlCreateViewStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_MATERIALIZED_VIEW_STATEMENT, SqlCreateMatViewStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_CHARACTER_SET_STATEMENT, SqlCreateCharacterSetStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_DOMAIN_STATEMENT, SqlCreateDomainStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_COLLATION_STATEMENT, SqlCreateCollationStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_TRANSLATION_STATEMENT, SqlCreateTranslationStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_ASSERTION_STATEMENT, SqlCreateAssertionStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_ROLE_STATEMENT, SqlCreateRoleStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_SYNONYM_STATEMENT, SqlCreateSynonymStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_SEQUENCE_STATEMENT, SqlCreateSequenceStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_PREPARED_STATEMENT, SqlCreateStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DML_INSTRUCTION, SqlDmlInstructionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_UPDATE_DML_INSTRUCTION, SqlDmlInstructionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_MERGE_DML_INSTRUCTION, SqlDmlInstructionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DELETE_DML_INSTRUCTION, SqlDeleteDmlInstructionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_INSERT_DML_INSTRUCTION, SqlInsertDmlInstructionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_RETURNING_CLAUSE, SqlReturningClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLLATE_CLAUSE, SqlCollateClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ON_TARGET_CLAUSE, SqlOnTargetClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_RENAME_TO_CLAUSE, SqlRenameToClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_RETURNING_EXPRESSION, SqlReturningExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_LOCK_TABLE_STATEMENT, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SET_ASSIGNMENT, SqlSetAssignmentImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_GENERIC_DROP_STATEMENT, SqlDropStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_STATEMENT, SqlCreateStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_STATEMENT, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_START_TRANSACTION_STATEMENT, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COMMIT_STATEMENT, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ROLLBACK_STATEMENT, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TRIGGER_TIME_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TRIGGER_EVENT_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TRIGGER_GRANULARITY_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COMMENT_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_HINT_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ANALYTIC_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_EXPRESSION, SqlExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_GENERIC_DEFINITION, SqlDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_GENERIC_SETTINGS_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ENGINE_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_WINDOW_CLAUSE, SqlWindowClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARTITION_BY_CLAUSE, SqlPartitionByClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_GENERIC_ELEMENT, SqlCompositeElementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_BLOCK_STATEMENT, SqlBlockStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLUMN_DEFINITION, SqlColumnDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLUMN_DEFINITION_IN_TYPE, SqlColumnDefinitionInTypeImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLUMN_ALIAS_DEFINITION, SqlColumnAliasDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CHECK_CONSTRAINT_DEFINITION, SqlConstraintStubbedDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_UNIQUE_CONSTRAINT_DEFINITION, SqlUniqueKeyDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CONSTRAINT_DEFINITION, SqlConstraintDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_NOT_NULL_CONSTRAINT_DEFINITION, SqlConstraintDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_NULLABLE_CONSTRAINT_DEFINITION, SqlConstraintDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_FOREIGN_KEY_DEFINITION, SqlForeignKeyDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_FOREIGN_KEY_CASCADE_OPTION, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_FOREIGN_KEY_REFERENCES_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PRIMARY_KEY_DEFINITION, SqlPrimaryKeyDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DEFAULT_CONSTRAINT_DEFINITION, SqlConstraintStubbedDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLLATE_CONSTRAINT_DEFINITION, SqlConstraintDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLUMN_GENERATED_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CONSTRAINT_CHARACTERISTIC_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_REFERENCING_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_XML_COLUMNS_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_XML_NAMESPACES_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_JSON_COLUMNS_CLAUSE, SqlClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_DOMAIN_STATEMENT, SqlAlterDomainStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_SCHEMA_STATEMENT, SqlAlterStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_TABLE_STATEMENT, SqlAlterTableStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_GRANT_STATEMENT, SqlGrantStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_REVOKE_STATEMENT, SqlRevokeStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_INSTRUCTION, SqlAlterInstructionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_JOIN_CONDITION_CLAUSE, SqlJoinConditionClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_USING_CLAUSE, SqlUsingClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_AUTHORIZATION_IDENTIFIER, SqlAuthorizationIdentifierImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_TRIGGER_STATEMENT, SqlAlterTriggerStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_INDEX_STATEMENT, SqlAlterStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_VIEW_STATEMENT, SqlAlterStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_SEQUENCE_STATEMENT, SqlAlterStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_STATEMENT, SqlAlterStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COMMENT_STATEMENT, SqlCommentStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARAMETER_LIST, SqlParameterListImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARAMETER_DEFINITION, SqlParameterDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_NAMED_PARAMETER_VALUE, SqlNamedParameterValueExpression.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TABLE_PARTITIONS_CLAUSE, SqlCompositeElementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PARTITION_DEFINITION, SqlPartitionDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_INDEX_DEFINITION, SqlIndexDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_INDEX_STATEMENT, SqlCreateIndexStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_PROCEDURE_STATEMENT, SqlCreateProcedureStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_OPERATOR_STATEMENT, SqlCreateOperatorStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_FUNCTION_STATEMENT, SqlCreateFunctionStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_TRIGGER_STATEMENT, SqlCreateTriggerStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_TABLESPACE_STATEMENT, SqlCreateTablespaceStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CREATE_USER_STATEMENT, SqlCreateUserStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_RETURNS_CLAUSE, SqlReturnsClauseImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ALTER_TABLESPACE_STATEMENT, SqlAlterStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PIVOTED_QUERY_EXPRESSION, SqlPivotedQueryExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PIVOT_COLUMN_DEFINITION, SqlPivotedQueryExpressionImpl.SqlPivotColumnDefinition.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_UNPIVOTED_QUERY_EXPRESSION, SqlUnpivotedQueryExpressionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_NAMED_QUERY_DEFINITION, SqlNamedQueryDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_NULL_STATEMENT, SqlNullStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DECLARE_STATEMENT, SqlDeclareStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DECLARE_VARIABLE_STATEMENT, SqlDeclareVariableStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DECLARE_HANDLER_STATEMENT, SqlDeclareConditionHandlerStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_VARIABLE_DEFINITION, SqlVariableDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ATTRIBUTE_DEFINITION, SqlObjectAttributeDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CURSOR_DEFINITION, SqlCursorDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_LABEL_DEFINITION, SqlLabelDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TYPE_DEFINITION, SqlTypeDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_COLLECTION_TYPE_DEFINITION, SqlCollectionTypeDefinitionImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CONDITION_DEFINITION, SqlConditionDefinition.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_IF_STATEMENT, SqlIfStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CASE_STATEMENT, SqlCaseStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_LOOP_STATEMENT, SqlLoopStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_WHILE_LOOP_STATEMENT, SqlWhileLoopStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_REPEAT_LOOP_STATEMENT, SqlRepeatLoopStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_FOR_LOOP_STATEMENT, SqlForLoopStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_GOTO_STATEMENT, SqlGotoStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_EXIT_STATEMENT, SqlBreakStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CONTINUE_STATEMENT, SqlContinueStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_RETURN_STATEMENT, SqlReturnStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SIGNAL_STATEMENT, SqlSignalStatement.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_RESIGNAL_STATEMENT, SqlSignalStatement.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_RAISE_STATEMENT, SqlRaiseStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_THROW_STATEMENT, SqlRaiseStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_USE_SCHEMA_STATEMENT, SqlUseDatabaseStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_USE_CATALOG_STATEMENT, SqlUseDatabaseStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_ERROR_CODE_SPEC, SqlErrorCodeSpec.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_SPECIAL_ERROR_SPEC, SqlSpecialErrorSpec.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_CONDITION_ERROR_SPEC, SqlConditionErrorSpec.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_EXPLAIN_STATEMENT, SqlExplainStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_DEFINITION_HOLDER_STATEMENT, SqlDefinitionHolderStatementImpl.class);
        SqlElementFactory.registerImplementation(info, SQL_EVALUABLE_EXPRESSION, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_OPERATOR_SIGNATURE, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_FUNCTION_SIGNATURE, SqlStatementImpl.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_PATH_LITERAL, SqlPathLiteral.class);
        SqlElementFactory.registerImplementation(info, (IElementType)SQL_TRUNCATE_TABLE_STATEMENT, SqlTruncateTableStatementImpl.class);
    }

    public static void registerImplementation(Info info, IElementType type, Class<? extends PsiElement> clazz) {
        try {
            if (type instanceof IStubElementType) {
                info.map.put(type, clazz.getConstructor(ASTNode.class));
                boolean found = false;
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    Class<?>[] args2 = constructor.getParameterTypes();
                    if (args2.length != 1 || !StubElement.class.isAssignableFrom(args2[0])) continue;
                    info.map2.put(type, constructor);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new AssertionError((Object)("Stub constructor not found in " + clazz.getName()));
                }
            } else if (CompositePsiElement.class.isAssignableFrom(clazz)) {
                boolean found = false;
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    Class<?>[] args3 = constructor.getParameterTypes();
                    if (args3.length != 1 || !IElementType.class.isAssignableFrom(args3[0])) continue;
                    info.map3.put(type, constructor);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new AssertionError((Object)("Stub constructor not found in " + clazz.getName()));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    protected static IElementType getCompositeType(String name, String prefix) {
        IElementType existingType = SqlTokenRegistry.findCompositeType((String)name);
        if (existingType != null) {
            IElementType iElementType = existingType;
            if (iElementType == null) {
                SqlElementFactory.$$$reportNull$$$0(2);
            }
            return iElementType;
        }
        IElementType type = SqlElementFactory.findBaseSqlType(name.substring(prefix.length()));
        if (type != null) {
            IElementType iElementType = type;
            if (iElementType == null) {
                SqlElementFactory.$$$reportNull$$$0(3);
            }
            return iElementType;
        }
        SqlCompositeElementType sqlCompositeElementType = SqlTokenRegistry.getCompositeType((String)name);
        if (sqlCompositeElementType == null) {
            SqlElementFactory.$$$reportNull$$$0(4);
        }
        return sqlCompositeElementType;
    }

    @Nullable
    protected static IElementType findBaseSqlType(@NotNull String noPrefix) {
        IElementType type;
        if (noPrefix == null) {
            SqlElementFactory.$$$reportNull$$$0(5);
        }
        if ((type = SqlTokenRegistry.findCompositeType((String)("SQL_" + noPrefix))) != null) {
            return type;
        }
        if (noPrefix.endsWith("_STATEMENT")) {
            if (noPrefix.startsWith("ALTER_")) {
                return SQL_ALTER_STATEMENT;
            }
            if (noPrefix.startsWith("CREATE_")) {
                return SQL_CREATE_STATEMENT;
            }
            if (noPrefix.startsWith("DECLARE_")) {
                return SQL_DECLARE_STATEMENT;
            }
            if (noPrefix.startsWith("DROP_")) {
                return SQL_GENERIC_DROP_STATEMENT;
            }
            if (noPrefix.endsWith("_LOOP_STATEMENT")) {
                return SQL_LOOP_STATEMENT;
            }
            return SQL_STATEMENT;
        }
        if (noPrefix.endsWith("_FROM_CLAUSE")) {
            return SQL_FROM_CLAUSE;
        }
        if (noPrefix.endsWith("_CLAUSE")) {
            if (noPrefix.startsWith("ANALYTIC_")) {
                return SQL_ANALYTIC_CLAUSE;
            }
            return SQL_CLAUSE;
        }
        if (noPrefix.endsWith("_SELECT_OPTION")) {
            return SQL_SELECT_OPTION;
        }
        if (noPrefix.endsWith("_OPTION")) {
            return SQL_GENERIC_SETTINGS_CLAUSE;
        }
        if (noPrefix.endsWith("_ALIAS_DEFINITION")) {
            return SQL_AS_EXPRESSION;
        }
        if (noPrefix.endsWith("_DEFINITION")) {
            IElementType t;
            if (noPrefix.startsWith("COLUMN_") && (noPrefix.contains("KEY") || noPrefix.contains("CONSTRAINT")) && (t = SqlTokenRegistry.findCompositeType((String)("SQL_" + noPrefix.substring("COLUMN_".length())))) != null) {
                return t;
            }
            if (noPrefix.endsWith("_CONSTRAINT_DEFINITION")) {
                return SQL_CONSTRAINT_DEFINITION;
            }
            return SQL_GENERIC_DEFINITION;
        }
        if (noPrefix.startsWith("PARENTHESIZED") && noPrefix.endsWith("EXPRESSION")) {
            return SQL_PARENTHESIZED_EXPRESSION;
        }
        if (noPrefix.endsWith("_QUERY_EXPRESSION")) {
            return SQL_QUERY_EXPRESSION;
        }
        return null;
    }

    static {
        SqlTokenRegistry.ensureInterfacesAreInitializedInOrder(SqlElementFactory.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/base/SqlElementFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/base/SqlElementFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createElementNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRegistrations";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBaseSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Info {
        final Map<IElementType, Constructor> map = ContainerUtil.newTroveMap();
        final Map<IElementType, Constructor> map2 = ContainerUtil.newTroveMap();
        final Map<IElementType, Constructor> map3 = ContainerUtil.newTroveMap();
    }
}

