/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.validation.XsltValidator;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedElementInspection
extends XsltInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unused Variable/Parameter" == null) {
            UnusedElementInspection.$$$reportNull$$$0(0);
        }
        return "Unused Variable/Parameter";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("XsltUnusedDeclaration" == null) {
            UnusedElementInspection.$$$reportNull$$$0(1);
        }
        return "XsltUnusedDeclaration";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnusedElementInspection.$$$reportNull$$$0(2);
        }
        if (!(holder.getFile() instanceof XmlFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UnusedElementInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            UnusedElementInspection.$$$reportNull$$$0(4);
        }
        return myVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitor
    extends XmlElementVisitor {
        private final ProblemsHolder myHolder;

        MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (!XsltSupport.isVariableOrParamName(attribute)) {
                return;
            }
            XmlTag tag = attribute.getParent();
            if (XsltSupport.isTopLevelElement(tag)) {
                return;
            }
            XsltVariable variable = XsltElementFactory.getInstance().wrapElement(tag, XsltVariable.class);
            String name = variable.getName();
            if (name == null || name.length() == 0) {
                return;
            }
            XsltValidator.checkUnusedVariable(variable, this.myHolder);
        }
    }
}

