/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Dbms
implements Comparable<Dbms> {
    private static final ConcurrentMap<String, Dbms> ourValues = ContainerUtil.newConcurrentMap();
    public static final Dbms UNKNOWN = Dbms.create("UNKNOWN");
    public static final Dbms ORACLE = Dbms.create("Oracle");
    public static final Dbms MEMSQL = Dbms.create("MemSQL");
    public static final Dbms MARIADB = Dbms.create("MariaDB");
    public static final Dbms MYSQL = Dbms.create("MySQL");
    public static final Dbms POSTGRES = Dbms.create("POSTGRES", "PostgreSQL");
    public static final Dbms REDSHIFT = Dbms.create("REDSHIFT", "Amazon Redshift");
    public static final Dbms MSSQL = Dbms.create("MSSQL", "Microsoft SQL Server");
    public static final Dbms AZURE = Dbms.create("AZURE", "Azure SQL Database");
    public static final Dbms SYBASE = Dbms.create("SYBASE", "Sybase ASE");
    public static final Dbms DB2 = Dbms.create("DB2", "IBM Db2 LUW");
    public static final Dbms SQLITE = Dbms.create("SQLite");
    public static final Dbms HSQL = Dbms.create("HSQLDB");
    public static final Dbms H2 = Dbms.create("H2");
    public static final Dbms DERBY = Dbms.create("DERBY", "Apache Derby");
    public static final Dbms EXASOL = Dbms.create("Exasol");
    public static final Dbms CLICKHOUSE = Dbms.create("ClickHouse");
    public static final Dbms CASSANDRA = Dbms.create("CASSANDRA", "Apache Cassandra");
    public static final Dbms VERTICA = Dbms.create("Vertica");
    public static final Dbms GREENPLUM = Dbms.create("Greenplum");
    public static final Dbms HANA = Dbms.create("HANA");
    public static final Dbms FIREBIRD = Dbms.create("Firebird");
    public static final Dbms PRESTO = Dbms.create("Presto");
    public static final Dbms INFORMIX = Dbms.create("Informix");
    public static final Dbms IMPALA = Dbms.create("Impala");
    public static final Dbms NETEZZA = Dbms.create("Netezza");
    public static final Dbms PHOENIX = Dbms.create("Phoenix");
    public static final Dbms HIVE = Dbms.create("Hive");
    public static final Dbms SPARK = Dbms.create("SPARK", "Spark SQL");
    public static final Dbms SNOWFLAKE = Dbms.create("Snowflake");
    public static final Dbms INGRES = Dbms.create("Ingres");
    public static final Dbms TERADATA = Dbms.create("Teradata");
    public static final Dbms OPENEDGE = Dbms.create("OpenEdge");
    public static final Dbms TIBERO = Dbms.create("Tibero");
    public static final Dbms FILEMAKER = Dbms.create("FileMaker");
    public static final Dbms FRONTBASE = Dbms.create("FrontBase");
    public static final Dbms MONGO = Dbms.create("Mongo", "MongoDB");
    private final String myName;
    private final String myDisplayName;

    @NotNull
    public static Dbms create(@NotNull String displayName) {
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(0);
        }
        Dbms dbms = Dbms.create(displayName, displayName);
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public static Dbms create(@NotNull String name, @NotNull String displayName) {
        Dbms existing;
        if (name == null) {
            Dbms.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(3);
        }
        if ((existing = (Dbms)ourValues.get(name = StringUtil.toUpperCase((String)name))) != null) {
            Dbms dbms = existing;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(4);
            }
            return dbms;
        }
        Dbms dbms = (Dbms)ConcurrencyUtil.cacheOrGet(ourValues, (Object)name, (Object)new Dbms(name, displayName));
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(5);
        }
        return dbms;
    }

    private Dbms(@NotNull String name, @NotNull String displayName) {
        if (name == null) {
            Dbms.$$$reportNull$$$0(6);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(7);
        }
        this.myName = name;
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOracle() {
        return this == ORACLE;
    }

    public boolean isMysql() {
        return this == MYSQL || this == MARIADB || this == MEMSQL;
    }

    public boolean isPostgres() {
        return this == POSTGRES || this == REDSHIFT;
    }

    public boolean isRedshift() {
        return this == REDSHIFT;
    }

    public boolean isVertica() {
        return this == VERTICA;
    }

    public boolean isMicrosoft() {
        return this == MSSQL || this == AZURE;
    }

    public boolean isSybase() {
        return this == SYBASE;
    }

    public boolean isDb2() {
        return this == DB2;
    }

    public boolean isHsqldb() {
        return this == HSQL;
    }

    public boolean isH2() {
        return this == H2;
    }

    public boolean isDerby() {
        return this == DERBY;
    }

    public boolean isSqlite() {
        return this == SQLITE;
    }

    public boolean isTransactSql() {
        return this.isMicrosoft() || this.isSybase();
    }

    public boolean isExasol() {
        return this == EXASOL;
    }

    public boolean isClickHouse() {
        return this == CLICKHOUSE;
    }

    public boolean isCassandra() {
        return this == CASSANDRA;
    }

    @NotNull
    public static Dbms forDataSource(@NotNull DasDataSource o) {
        if (o == null) {
            Dbms.$$$reportNull$$$0(10);
        }
        NameVersion p = o.getDatabaseVersion();
        Dbms result = Dbms.fromString(p.version);
        if (result == UNKNOWN) {
            result = Dbms.fromString(p.name);
        }
        if (result == UNKNOWN && o instanceof RawConnectionConfig) {
            result = Dbms.forConnection((RawConnectionConfig)((Object)o));
        }
        if (result == POSTGRES) {
            Version version;
            Version version2 = version = p.version != null && p.version.contains("8") ? Version.parseVersion((String)p.version) : null;
            if (version != null && version.major == 8 && version.bugfix == 2) {
                result = REDSHIFT;
            }
        }
        Dbms dbms = result;
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(11);
        }
        return dbms;
    }

    @NotNull
    public static Dbms forConnection(@Nullable RawConnectionConfig o) {
        if (o == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(12);
            }
            return dbms;
        }
        Dbms result = Dbms.fromString(o.getUrl());
        if (result != UNKNOWN) {
            Dbms dbms = result;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(13);
            }
            return dbms;
        }
        Dbms dbms = Dbms.fromString(o.getDriverClass());
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(14);
        }
        return dbms;
    }

    @NotNull
    public static Dbms fromString(@Nullable String text) {
        if (text == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(15);
            }
            return dbms;
        }
        String pattern = "(?i).*\\b(?:%s).*";
        for (Dbms family : ourValues.values()) {
            if (!text.matches(String.format(pattern, family.getName()))) continue;
            Dbms dbms = family;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(16);
            }
            return dbms;
        }
        if (text.matches(String.format(pattern, "hsql"))) {
            Dbms dbms = HSQL;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(17);
            }
            return dbms;
        }
        if (text.matches(String.format(pattern, "microsoft|sqlserver"))) {
            Dbms dbms = MSSQL;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(18);
            }
            return dbms;
        }
        if (text.matches(String.format(pattern, "adaptive server")) || StringUtil.startsWithIgnoreCase((String)text, (String)"ase")) {
            Dbms dbms = SYBASE;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(19);
            }
            return dbms;
        }
        if (text.startsWith("ids")) {
            Dbms dbms = INFORMIX;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(20);
            }
            return dbms;
        }
        if (text.matches(String.format(pattern, "exa"))) {
            Dbms dbms = EXASOL;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(21);
            }
            return dbms;
        }
        Dbms dbms = UNKNOWN;
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(22);
        }
        return dbms;
    }

    @Nullable
    public static Dbms byName(@NotNull String name) {
        if (name == null) {
            Dbms.$$$reportNull$$$0(23);
        }
        return (Dbms)ourValues.get(name);
    }

    public static Collection<Dbms> allValues() {
        return ourValues.values();
    }

    @Override
    public int compareTo(@NotNull Dbms o) {
        if (o == null) {
            Dbms.$$$reportNull$$$0(24);
        }
        return Comparing.compare((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/Dbms";
                break;
            }
            case 2: 
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/Dbms";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "forDataSource";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forConnection";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forDataSource";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

