/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.remote.RemoteFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.config.commandLine.PhpLocalCommandLinePathProcessor;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.remote.debug.PhpRemoteSshDebugStrategy;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpRemoteCommandLinePathProcessor
extends PhpLocalCommandLinePathProcessor {
    private final String myInterpreterId;
    private final PhpRemoteSdkAdditionalData mySdkAdditionalData;
    private final PathMappingSettings myMappingSettings;

    public PhpRemoteCommandLinePathProcessor(@NotNull String interpreterId, @NotNull PhpRemoteSdkAdditionalData data, @NotNull PathMappingSettings mappingSettings) {
        if (interpreterId == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(1);
        }
        if (mappingSettings == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(2);
        }
        this.myInterpreterId = interpreterId;
        this.mySdkAdditionalData = data;
        this.myMappingSettings = mappingSettings;
    }

    @NotNull
    public String process(@NotNull String localPath) {
        String remotePath;
        boolean isWin;
        if (localPath == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(3);
        }
        String string = (isWin = RemoteFile.isWindowsPath((String)(remotePath = this.myMappingSettings.convertToRemote(super.process(localPath))))) ? FileUtilRt.toSystemDependentName((String)remotePath, (char)'\\') : FileUtil.toSystemIndependentName((String)remotePath);
        if (string == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean canProcess(@NotNull String localPath) {
        if (localPath == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(5);
        }
        return super.canProcess(localPath) && this.myMappingSettings.canReplaceLocal(localPath);
    }

    @NotNull
    public PhpDebugStrategy createDebugStrategy(@NotNull Project project) {
        if (project == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(6);
        }
        PhpRemoteSshDebugStrategy phpRemoteSshDebugStrategy = new PhpRemoteSshDebugStrategy(project, this.myInterpreterId, this.mySdkAdditionalData, this.myMappingSettings.getPathMappings());
        if (phpRemoteSshDebugStrategy == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(7);
        }
        return phpRemoteSshDebugStrategy;
    }

    @NotNull
    public PhpPathMapper createPathMapper(@NotNull Project project) {
        if (project == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(8);
        }
        PhpPathMapper phpPathMapper = PhpPathMapper.create((List)this.myMappingSettings.getPathMappings());
        if (phpPathMapper == null) {
            PhpRemoteCommandLinePathProcessor.$$$reportNull$$$0(9);
        }
        return phpPathMapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpRemoteCommandLinePathProcessor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteCommandLinePathProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugStrategy";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDebugStrategy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPathMapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

