/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class NodeAsdfUtil {
    public static final String SHIMS = "shims";
    public static final String INSTALLS_NODEJS = "installs/nodejs";
    private static final String ASDF_DIR_SYSTEM_INDEPENDENT = NodeAsdfUtil.findAsdfDirSystemIndependentPath();
    private static final String SHIMS_DIR_SYSTEM_INDEPENDENT = StringUtil.trimEnd((String)ASDF_DIR_SYSTEM_INDEPENDENT, (char)'/') + "/" + "shims" + "/";

    private NodeAsdfUtil() {
    }

    @NotNull
    private static String findAsdfDirSystemIndependentPath() {
        String asdfDirPath = EnvironmentUtil.getValue((String)"ASDF_DIR");
        if (asdfDirPath != null && FileUtil.isAbsolutePlatformIndependent((String)asdfDirPath)) {
            String string = FileUtil.toSystemIndependentName((String)asdfDirPath);
            if (string == null) {
                NodeAsdfUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = FileUtil.toSystemIndependentName((String)(SystemProperties.getUserHome() + "/.asdf"));
        if (string == null) {
            NodeAsdfUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getAsdfDirSystemIndependentPath() {
        String string = ASDF_DIR_SYSTEM_INDEPENDENT;
        if (string == null) {
            NodeAsdfUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    static boolean isShimsNode(@NotNull NodeJsLocalInterpreter interpreter) {
        String path;
        if (interpreter == null) {
            NodeAsdfUtil.$$$reportNull$$$0(3);
        }
        if ((path = interpreter.getInterpreterSystemIndependentPath()).startsWith(SHIMS_DIR_SYSTEM_INDEPENDENT)) {
            return !StringUtil.contains((CharSequence)path, (int)SHIMS_DIR_SYSTEM_INDEPENDENT.length(), (int)path.length(), (char)'/');
        }
        return false;
    }

    @Nullable
    public static NodeJsLocalInterpreter resolveShimsNode(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            NodeAsdfUtil.$$$reportNull$$$0(4);
        }
        Promise<SemVer> promise = interpreter.provideCachedVersionOrFetch();
        try {
            File file2;
            SemVer version = (SemVer)promise.blockingGet(2, TimeUnit.SECONDS);
            if (version != null && (file2 = new File(NodeAsdfUtil.getAsdfDirSystemIndependentPath(), "installs/nodejs/" + version.getRawVersion() + "/bin/" + NodeJsLocalInterpreterUtil.NODE_INTERPRETER_BASE_NAME)).isFile() && file2.canExecute()) {
                return new NodeJsLocalInterpreter(file2.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeAsdfUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAsdfDirSystemIndependentPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsdfDirSystemIndependentPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeAsdfUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isShimsNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveShimsNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

