/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelectorBase;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.surroundWith.JSWithIfSurrounder;
import com.intellij.lang.javascript.template.postfix.JSTemplateExpressionCondition;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.utils.BoolUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPostfixTemplateUtils {
    @NotNull
    private static final Map<String, JSTemplateExpressionCondition.Factory> ourConditionFactories = ContainerUtil.newHashMap((Pair)Pair.create((Object)"nonVoid", () -> new JSTemplateExpressionCondition.NonVoidCondition()), (Pair[])new Pair[]{Pair.create((Object)"arrayType", () -> new JSTemplateExpressionCondition.ArrayCondition())});
    public static final Condition<PsiElement> DEFAULT_FILTER = new Condition<PsiElement>(){
        private final Class[] FILTER_TYPES = new Class[]{TypeScriptImportStatement.class, ES6ImportDeclaration.class, TypeScriptEntityName.class, TypeScriptType.class, JSReferenceListMember.class, JSReferenceList.class, ES6ExportDeclaration.class};
        private final Class[] STOP_TYPES = (Class[])ArrayUtil.append((Object[])this.FILTER_TYPES, JSStatement.class);

        public boolean value(PsiElement element) {
            if (!JSPostfixTemplateUtils.isAcceptableDialect(element)) {
                return false;
            }
            if (element.getParent() instanceof JSProperty) {
                return false;
            }
            PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])this.STOP_TYPES);
            if (parent == null) {
                return true;
            }
            for (Class aClass : this.FILTER_TYPES) {
                if (!aClass.isInstance(parent)) continue;
                return false;
            }
            return true;
        }
    };
    public static final Condition<PsiElement> NON_LITERAL_CONDITION = element -> {
        boolean isIncorrect = element instanceof JSLiteralExpression || element instanceof JSSuperExpression || element instanceof TypeScriptEntityName;
        return !isIncorrect;
    };
    public static final Condition<PsiElement> DEFAULT_AND_NON_LITERAL_CONDITION = Conditions.and(DEFAULT_FILTER, NON_LITERAL_CONDITION);
    public static final Condition<PsiElement> TYPESCRIPT_CONDITION = el -> DialectDetector.isTypeScript(el);
    @NotNull
    public static final PostfixTemplatePsiInfo JS_PSI_INFO = new PostfixTemplatePsiInfo(){

        @NotNull
        public PsiElement createExpression(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
            if (context == null) {
                5.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                5.$$$reportNull$$$0(1);
            }
            if (suffix == null) {
                5.$$$reportNull$$$0(2);
            }
            PsiElement psiElement = JSPostfixTemplateUtils.createExpression(context, prefix, suffix);
            if (psiElement == null) {
                5.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        @NotNull
        public PsiElement getNegatedExpression(@NotNull PsiElement element) {
            if (element == null) {
                5.$$$reportNull$$$0(4);
            }
            String negatedExpressionText = BoolUtils.getNegatedExpressionText((JSExpression)element);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)element.getProject());
            ASTNode node = JSChangeUtil.createExpressionWithContext(negatedExpressionText, element);
            assert (node != null);
            PsiElement psiElement = codeStyleManager.reformat(node.getPsi());
            if (psiElement == null) {
                5.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$5";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$5";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNegatedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createExpression";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getNegatedExpression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public static String endTemplate(PsiElement element) {
        return JSCodeStyleSettings.getSemicolon((PsiElement)element.getContainingFile()) + "$END$";
    }

    public static PostfixTemplateExpressionSelector selectorTopmost() {
        return JSPostfixTemplateUtils.selectorTopmost(DEFAULT_FILTER);
    }

    public static PostfixTemplateExpressionSelector selectNotLiteralExpressionsWithCurrentOffset() {
        return JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset(DEFAULT_AND_NON_LITERAL_CONDITION);
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset() {
        return JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset(DEFAULT_FILTER);
    }

    public static PostfixTemplateExpressionSelector selectorWithFeature(final @NotNull PostfixTemplateExpressionSelector parent, final @NotNull JSLanguageFeature feature, final @Nullable Condition<? super PsiElement> placeAdditionalCondition) {
        if (parent == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(0);
        }
        if (feature == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(1);
        }
        return new PostfixTemplateExpressionSelector(){

            public boolean hasExpression(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
                VirtualFile virtualFile;
                JSLanguageDialect dialect;
                PsiFile file2;
                DialectOptionHolder holder;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (copyDocument == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((holder = DialectDetector.dialectOfElement((PsiElement)context.getContainingFile().getOriginalFile())) == null && (file2 = context.getContainingFile()) != null && (dialect = DialectDetector.getLanguageDialect(virtualFile = file2.getViewProvider().getVirtualFile(), context.getProject())) != null) {
                    holder = dialect.getOptionHolder();
                }
                return holder != null && holder.hasFeature(feature) && (placeAdditionalCondition == null || placeAdditionalCondition.value((Object)context)) && parent.hasExpression(context, copyDocument, newOffset);
            }

            @NotNull
            public List<PsiElement> getExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(3);
                }
                List list = parent.getExpressions(context, document, offset);
                if (list == null) {
                    2.$$$reportNull$$$0(4);
                }
                return list;
            }

            @NotNull
            public Function<PsiElement, String> getRenderer() {
                Function function = parent.getRenderer();
                if (function == null) {
                    2.$$$reportNull$$$0(5);
                }
                return function;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "copyDocument";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExpressions";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "hasExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getExpressions";
                        break;
                    }
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static PostfixTemplateExpressionSelector selectorTopmost(Condition<PsiElement> expressionsFilter) {
        return new PostfixTemplateExpressionSelectorBase(expressionsFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!JSPostfixTemplateUtils.isAcceptableDialect(context)) {
                    return ContainerUtil.emptyList();
                }
                JSExpressionStatement exprStatement = (JSExpressionStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSExpressionStatement.class});
                JSExpression statement = exprStatement != null ? (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)exprStatement, JSExpression.class) : null;
                return ContainerUtil.createMaybeSingletonList((Object)statement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$3";
                objectArray[2] = "getNonFilteredExpressions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isAcceptableDialect(@NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (context == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(2);
        }
        return (holder = DialectDetector.dialectOfElement(context)) != null && !holder.isCoffeeScript && holder != DialectOptionHolder.JS_IN_JADE && holder != DialectOptionHolder.OTHER;
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset(Condition<PsiElement> additionalExpressionsFilter) {
        return new PostfixTemplateExpressionSelectorBase(additionalExpressionsFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int newOffset) {
                if (context == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!DEFAULT_FILTER.value((Object)context)) {
                    return ContainerUtil.emptyList();
                }
                List<Pair<JSExpression, TextRange>> expressionsInRange = JSIntroducedExpressionUtil.findExpressionsInRange(context.getContainingFile(), newOffset, newOffset);
                ArrayList result2 = ContainerUtil.newArrayList();
                if (expressionsInRange == null) {
                    return result2;
                }
                for (Pair<JSExpression, TextRange> pair : expressionsInRange) {
                    result2.add(pair.getFirst());
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4";
                objectArray[2] = "getNonFilteredExpressions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static Surrounder createIfSurrounder() {
        JSWithIfSurrounder jSWithIfSurrounder = new JSWithIfSurrounder(){

            @Override
            protected boolean willWrapExpression() {
                return false;
            }
        };
        if (jSWithIfSurrounder == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(3);
        }
        return jSWithIfSurrounder;
    }

    @NotNull
    public static PsiElement createExpression(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
        if (context == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(5);
        }
        if (suffix == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(6);
        }
        ASTNode node = JSChangeUtil.createExpressionWithContext(prefix + context.getText() + suffix, context);
        assert (node != null);
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @NotNull
    public static PostfixTemplateExpressionCondition<JSExpression> createCondition(@NotNull Element element) {
        if (element == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(8);
        }
        String id = element.getAttributeValue("id");
        JSTemplateExpressionCondition.Factory factory = ourConditionFactories.get(id);
        JSTemplateExpressionCondition jSTemplateExpressionCondition = factory.create();
        if (jSTemplateExpressionCondition == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(9);
        }
        return jSTemplateExpressionCondition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfSurrounder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectorWithFeature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableDialect";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

