/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.google.common.collect.Lists;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.ManagePackagesDialog;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.intellij.webcore.packaging.RepoPackage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPackagesPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InstalledPackagesPanel.class);
    private static final String LOADING_PACKAGES_LIST_TITLE = "Loading Packages List";
    private final AnActionButton myUpgradeButton;
    protected final AnActionButton myInstallButton;
    private final AnActionButton myUninstallButton;
    protected final JBTable myPackagesTable;
    private final DefaultTableModel myPackagesTableModel;
    protected volatile PackageManagementService myPackageManagementService;
    protected final Project myProject;
    protected final PackagesNotificationPanel myNotificationArea;
    private final Set<String> myCurrentlyInstalling;
    private final Map<InstalledPackage, String> myWaitingToUpgrade;

    public InstalledPackagesPanel(@NotNull Project project, @NotNull PackagesNotificationPanel area) {
        if (project == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(0);
        }
        if (area == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myCurrentlyInstalling = ContainerUtil.newHashSet();
        this.myWaitingToUpgrade = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myNotificationArea = area;
        this.myPackagesTableModel = new DefaultTableModel(new String[]{"Package", "Version", "Latest version"}, 0){

            @Override
            public boolean isCellEditable(int i, int i1) {
                return false;
            }
        };
        final MyTableCellRenderer tableCellRenderer = new MyTableCellRenderer();
        this.myPackagesTable = new JBTable(this.myPackagesTableModel){

            public TableCellRenderer getCellRenderer(int row2, int column) {
                return tableCellRenderer;
            }
        };
        this.myPackagesTable.setPreferredScrollableViewportSize(null);
        this.myPackagesTable.setStriped(true);
        this.myPackagesTable.getTableHeader().setReorderingAllowed(false);
        new TableSpeedSearch((JTable)this.myPackagesTable);
        this.myUpgradeButton = new AnActionButton("Upgrade", IconUtil.getMoveUpIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                InstalledPackagesPanel.this.upgradeAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$3", "actionPerformed"));
            }
        };
        this.myInstallButton = new DumbAwareActionButton("Install", IconUtil.getAddIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (InstalledPackagesPanel.this.myPackageManagementService != null) {
                    ManagePackagesDialog dialog2 = InstalledPackagesPanel.this.createManagePackagesDialog();
                    dialog2.show();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$4", "actionPerformed"));
            }
        };
        this.myInstallButton.setShortcut(CommonShortcuts.getNew());
        this.myUninstallButton = new AnActionButton("Uninstall", IconUtil.getRemoveIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                InstalledPackagesPanel.this.uninstallAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$5", "actionPerformed"));
            }
        };
        this.myUninstallButton.setShortcut(CommonShortcuts.getDelete());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myPackagesTable).disableUpDownActions().disableAddAction().disableRemoveAction().addExtraAction(this.myInstallButton).addExtraAction(this.myUninstallButton).addExtraAction(this.myUpgradeButton);
        decorator.addExtraActions(this.getExtraActions());
        this.add(decorator.createPanel());
        this.myInstallButton.setEnabled(false);
        this.myUninstallButton.setEnabled(false);
        this.myUpgradeButton.setEnabled(false);
        this.myPackagesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                InstalledPackagesPanel.this.updateUninstallUpgrade();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (InstalledPackagesPanel.this.myPackageManagementService != null && InstalledPackagesPanel.this.myInstallButton.isEnabled()) {
                    Object pkg;
                    ManagePackagesDialog dialog2 = InstalledPackagesPanel.this.createManagePackagesDialog();
                    Point p = e.getPoint();
                    int row2 = InstalledPackagesPanel.this.myPackagesTable.rowAtPoint(p);
                    int column = InstalledPackagesPanel.this.myPackagesTable.columnAtPoint(p);
                    if (row2 >= 0 && column >= 0 && (pkg = InstalledPackagesPanel.this.myPackagesTable.getValueAt(row2, 0)) instanceof InstalledPackage) {
                        dialog2.selectPackage((InstalledPackage)pkg);
                    }
                    dialog2.show();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myPackagesTable);
    }

    protected AnActionButton[] getExtraActions() {
        return new AnActionButton[0];
    }

    @NotNull
    protected ManagePackagesDialog createManagePackagesDialog() {
        ManagePackagesDialog managePackagesDialog = new ManagePackagesDialog(this.myProject, this.myPackageManagementService, new PackageManagementService.Listener(){

            @Override
            public void operationStarted(String packageName) {
                InstalledPackagesPanel.this.myNotificationArea.hide();
                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
            }

            @Override
            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                InstalledPackagesPanel.this.myNotificationArea.showResult(packageName, errorDescription);
                InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                InstalledPackagesPanel.this.doUpdatePackages(InstalledPackagesPanel.this.myPackageManagementService);
            }
        });
        if (managePackagesDialog == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(2);
        }
        return managePackagesDialog;
    }

    private void upgradeAction() {
        int[] rows = this.myPackagesTable.getSelectedRows();
        if (this.myPackageManagementService != null) {
            HashSet<String> upgradedPackages = new HashSet<String>();
            Set<String> packagesShouldBePostponed = this.getPackagesToPostpone();
            for (int row2 : rows) {
                Object packageObj = this.myPackagesTableModel.getValueAt(row2, 0);
                if (!(packageObj instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)packageObj;
                String packageName = pkg.getName();
                String currentVersion = pkg.getVersion();
                String availableVersion = (String)this.myPackagesTableModel.getValueAt(row2, 2);
                if (packagesShouldBePostponed.contains(packageName)) {
                    this.myWaitingToUpgrade.put(pkg, availableVersion);
                    continue;
                }
                if (!this.isUpdateAvailable(currentVersion, availableVersion)) continue;
                this.upgradePackage(pkg, availableVersion);
                upgradedPackages.add(packageName);
            }
            if (this.myCurrentlyInstalling.isEmpty() && upgradedPackages.isEmpty() && !this.myWaitingToUpgrade.isEmpty()) {
                this.upgradePostponedPackages();
            }
        }
    }

    private void upgradePostponedPackages() {
        Iterator<Map.Entry<InstalledPackage, String>> iterator = this.myWaitingToUpgrade.entrySet().iterator();
        Map.Entry<InstalledPackage, String> toUpgrade = iterator.next();
        iterator.remove();
        this.upgradePackage(toUpgrade.getKey(), toUpgrade.getValue());
    }

    protected Set<String> getPackagesToPostpone() {
        return Collections.emptySet();
    }

    private void upgradePackage(final @NotNull InstalledPackage pkg, final @Nullable String toVersion) {
        if (pkg == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(3);
        }
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        this.myPackageManagementService.fetchPackageVersions(pkg.getName(), new CatchingConsumer<List<String>, Exception>(){

            public void consume(List<String> releases) {
                if (!releases.isEmpty() && !InstalledPackagesPanel.this.isUpdateAvailable(pkg.getVersion(), releases.get(0))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (pkg == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    final ModalityState modalityState = ModalityState.current();
                    PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                        @Override
                        public void operationStarted(String packageName) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                                InstalledPackagesPanel.this.myCurrentlyInstalling.add(packageName);
                            }, modalityState);
                        }

                        @Override
                        public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                                InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                                InstalledPackagesPanel.this.myCurrentlyInstalling.remove(packageName);
                                if (errorDescription == null) {
                                    InstalledPackagesPanel.this.myNotificationArea.showSuccess("Package " + packageName + " successfully upgraded");
                                } else {
                                    InstalledPackagesPanel.this.myNotificationArea.showError("Upgrade packages failed. <a href=\"xxx\">Details...</a>", "Upgrade Packages Failed", errorDescription);
                                }
                                if (InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty() && !InstalledPackagesPanel.this.myWaitingToUpgrade.isEmpty()) {
                                    InstalledPackagesPanel.this.upgradePostponedPackages();
                                }
                            }, modalityState);
                        }
                    };
                    PackageManagementServiceEx serviceEx = InstalledPackagesPanel.this.getServiceEx();
                    if (serviceEx != null) {
                        serviceEx.updatePackage(pkg, toVersion, listener2);
                    } else {
                        InstalledPackagesPanel.this.myPackageManagementService.installPackage(new RepoPackage(pkg.getName(), null), null, true, null, listener2, false);
                    }
                    InstalledPackagesPanel.this.myUpgradeButton.setEnabled(false);
                }, ModalityState.any());
            }

            public void consume(Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)"Error occurred. Please, check your internet connection.", (String)"Upgrade Package Failed."), ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/webcore/packaging/InstalledPackagesPanel$9", "lambda$consume$0"));
            }
        });
    }

    @Nullable
    private PackageManagementServiceEx getServiceEx() {
        return (PackageManagementServiceEx)ObjectUtils.tryCast((Object)this.myPackageManagementService, PackageManagementServiceEx.class);
    }

    private void updateUninstallUpgrade() {
        int[] selected = this.myPackagesTable.getSelectedRows();
        boolean upgradeAvailable = false;
        boolean canUninstall = selected.length != 0;
        boolean canInstall = this.installEnabled();
        boolean canUpgrade = true;
        if (this.myPackageManagementService != null && selected.length != 0) {
            for (int i = 0; i != selected.length; ++i) {
                Object value;
                int index = selected[i];
                if (index >= this.myPackagesTable.getRowCount() || !((value = this.myPackagesTable.getValueAt(index, 0)) instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)value;
                if (!this.canUninstallPackage(pkg)) {
                    canUninstall = false;
                }
                canInstall = this.canInstallPackage(pkg);
                if (!this.canUpgradePackage(pkg)) {
                    canUpgrade = false;
                }
                String pyPackageName = pkg.getName();
                String availableVersion = (String)this.myPackagesTable.getValueAt(index, 2);
                if (!upgradeAvailable) {
                    boolean bl = upgradeAvailable = this.isUpdateAvailable(pkg.getVersion(), availableVersion) && !this.myCurrentlyInstalling.contains(pyPackageName);
                }
                if (!canUninstall && !canUpgrade) break;
            }
        }
        this.myUninstallButton.setEnabled(canUninstall);
        this.myInstallButton.setEnabled(canInstall);
        this.myUpgradeButton.setEnabled(upgradeAvailable && canUpgrade);
    }

    protected boolean canUninstallPackage(InstalledPackage pyPackage) {
        return true;
    }

    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected boolean installEnabled() {
        return true;
    }

    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        return true;
    }

    private void uninstallAction() {
        List<InstalledPackage> packages = this.getSelectedPackages();
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        if (selPackageManagementService != null) {
            final ModalityState modalityState = ModalityState.current();
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                @Override
                public void operationStarted(String packageName) {
                    ApplicationManager.getApplication().invokeLater(() -> InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true), modalityState);
                }

                @Override
                public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                        InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                        InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                        if (errorDescription == null) {
                            if (packageName != null) {
                                InstalledPackagesPanel.this.myNotificationArea.showSuccess("Package '" + packageName + "' successfully uninstalled");
                            } else {
                                InstalledPackagesPanel.this.myNotificationArea.showSuccess("Packages successfully uninstalled");
                            }
                        } else {
                            InstalledPackagesPanel.this.myNotificationArea.showError("Uninstall packages failed. <a href=\"xxx\">Details...</a>", "Uninstall Packages Failed", errorDescription);
                        }
                    }, modalityState);
                }
            };
            this.myPackageManagementService.uninstallPackages(packages, listener2);
        }
    }

    @NotNull
    private List<InstalledPackage> getSelectedPackages() {
        int[] rows;
        ArrayList<InstalledPackage> results = new ArrayList<InstalledPackage>();
        for (int row2 : rows = this.myPackagesTable.getSelectedRows()) {
            Object packageName = this.myPackagesTableModel.getValueAt(row2, 0);
            if (!(packageName instanceof InstalledPackage)) continue;
            results.add((InstalledPackage)packageName);
        }
        ArrayList<InstalledPackage> arrayList = results;
        if (arrayList == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void updatePackages(@Nullable PackageManagementService packageManagementService) {
        this.myPackageManagementService = packageManagementService;
        this.myPackagesTable.clearSelection();
        this.myPackagesTableModel.getDataVector().clear();
        this.myPackagesTableModel.fireTableDataChanged();
        if (packageManagementService != null) {
            this.doUpdatePackages(packageManagementService);
        }
    }

    private void onUpdateStarted() {
        this.myPackagesTable.setPaintBusy(true);
        this.myPackagesTable.getEmptyText().setText("Loading...");
    }

    private void onUpdateFinished() {
        this.myPackagesTable.setPaintBusy(false);
        this.myPackagesTable.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        this.updateUninstallUpgrade();
        ActivityTracker.getInstance().inc();
    }

    public void doUpdatePackages(final @NotNull PackageManagementService packageManagementService) {
        if (packageManagementService == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(6);
        }
        this.onUpdateStarted();
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.myProject, LOADING_PACKAGES_LIST_TITLE, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    11.$$$reportNull$$$0(0);
                }
                Collection<Object> packages = Lists.newArrayList();
                try {
                    packages = packageManagementService.getInstalledPackages();
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage());
                }
                finally {
                    Collection<Object> finalPackages = packages;
                    Map cache = InstalledPackagesPanel.this.buildNameToPackageMap(packageManagementService.getAllPackagesCached());
                    boolean shouldFetchLatestVersionsForOnlyInstalledPackages = InstalledPackagesPanel.this.shouldFetchLatestVersionsForOnlyInstalledPackages();
                    if (cache.isEmpty() && !shouldFetchLatestVersionsForOnlyInstalledPackages) {
                        InstalledPackagesPanel.this.refreshLatestVersions(packageManagementService);
                    }
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (packageManagementService == null) {
                            11.$$$reportNull$$$0(1);
                        }
                        if (packageManagementService == InstalledPackagesPanel.this.myPackageManagementService) {
                            InstalledPackagesPanel.this.myPackagesTableModel.getDataVector().clear();
                            for (InstalledPackage pkg : finalPackages) {
                                RepoPackage repoPackage = (RepoPackage)cache.get(pkg.getName());
                                String version = repoPackage != null ? repoPackage.getLatestVersion() : null;
                                InstalledPackagesPanel.this.myPackagesTableModel.addRow(new Object[]{pkg, pkg.getVersion(), version == null ? "" : version});
                            }
                            if (!cache.isEmpty()) {
                                InstalledPackagesPanel.this.onUpdateFinished();
                            }
                            if (shouldFetchLatestVersionsForOnlyInstalledPackages) {
                                InstalledPackagesPanel.this.setLatestVersionsForInstalledPackages();
                            }
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "packageManagementService";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/webcore/packaging/InstalledPackagesPanel$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private InstalledPackage getInstalledPackageAt(int index) {
        return (InstalledPackage)this.myPackagesTableModel.getValueAt(index, 0);
    }

    private void setLatestVersionsForInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx == null) {
            return;
        }
        int packageCount = this.myPackagesTableModel.getRowCount();
        if (packageCount == 0) {
            this.onUpdateFinished();
        }
        final AtomicInteger inProgressPackageCount = new AtomicInteger(packageCount);
        int i = 0;
        while (i < packageCount) {
            final int finalIndex = i++;
            final InstalledPackage pkg = this.getInstalledPackageAt(finalIndex);
            serviceEx.fetchLatestVersion(pkg, new CatchingConsumer<String, Exception>(){

                private void decrement() {
                    if (inProgressPackageCount.decrementAndGet() == 0) {
                        InstalledPackagesPanel.this.onUpdateFinished();
                    }
                }

                public void consume(Exception e) {
                    UIUtil.invokeLaterIfNeeded(() -> this.decrement());
                    LOG.warn("Cannot fetch the latest version of the installed package " + pkg, (Throwable)e);
                }

                public void consume(@Nullable String latestVersion) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        InstalledPackage p;
                        if (finalIndex < InstalledPackagesPanel.this.myPackagesTableModel.getRowCount() && pkg == (p = InstalledPackagesPanel.this.getInstalledPackageAt(finalIndex))) {
                            InstalledPackagesPanel.this.myPackagesTableModel.setValueAt(latestVersion, finalIndex, 2);
                        }
                        this.decrement();
                    });
                }
            });
        }
    }

    private boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx != null) {
            return serviceEx.shouldFetchLatestVersionsForOnlyInstalledPackages();
        }
        return false;
    }

    private boolean isUpdateAvailable(@Nullable String currentVersion, @Nullable String availableVersion) {
        if (availableVersion == null) {
            return false;
        }
        if (currentVersion == null) {
            return true;
        }
        PackageManagementService service2 = this.myPackageManagementService;
        if (service2 != null) {
            return service2.compareVersions(currentVersion, availableVersion) < 0;
        }
        return PackageVersionComparator.VERSION_COMPARATOR.compare(currentVersion, availableVersion) < 0;
    }

    private void refreshLatestVersions(@NotNull PackageManagementService packageManagementService) {
        if (packageManagementService == null) {
            InstalledPackagesPanel.$$$reportNull$$$0(7);
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (packageManagementService == null) {
                InstalledPackagesPanel.$$$reportNull$$$0(8);
            }
            if (packageManagementService == this.myPackageManagementService) {
                try {
                    List<RepoPackage> packages = packageManagementService.reloadAllPackages();
                    Map<String, RepoPackage> packageMap = this.buildNameToPackageMap(packages);
                    application.invokeLater(() -> {
                        for (int i = 0; i != this.myPackagesTableModel.getRowCount(); ++i) {
                            InstalledPackage pyPackage = (InstalledPackage)this.myPackagesTableModel.getValueAt(i, 0);
                            RepoPackage repoPackage = (RepoPackage)packageMap.get(pyPackage.getName());
                            this.myPackagesTableModel.setValueAt(repoPackage == null ? null : repoPackage.getLatestVersion(), i, 2);
                        }
                        this.myPackagesTable.setPaintBusy(false);
                    }, ModalityState.stateForComponent((Component)this.myPackagesTable));
                }
                catch (IOException ignored) {
                    LOG.warn("Cannot refresh the list of available packages with their latest versions", (Throwable)ignored);
                    this.myPackagesTable.setPaintBusy(false);
                }
            }
        });
    }

    private Map<String, RepoPackage> buildNameToPackageMap(List<RepoPackage> packages) {
        try {
            return InstalledPackagesPanel.doBuildNameToPackageMap(packages);
        }
        catch (Exception e) {
            PackageManagementService service2 = this.myPackageManagementService;
            LOG.error("Failure in " + this.getClass().getName() + ", service: " + (service2 != null ? service2.getClass().getName() : null), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static Map<String, RepoPackage> doBuildNameToPackageMap(List<RepoPackage> packages) {
        HashMap<String, RepoPackage> packageMap = new HashMap<String, RepoPackage>();
        for (RepoPackage aPackage : packages) {
            packageMap.put(aPackage.getName(), aPackage);
        }
        return packageMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/packaging/InstalledPackagesPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagementService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/packaging/InstalledPackagesPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createManagePackagesDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "upgradePackage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canInstallPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doUpdatePackages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshLatestVersions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshLatestVersions$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
            String version = (String)table.getValueAt(row2, 1);
            String availableVersion = (String)table.getValueAt(row2, 2);
            boolean update = column == 2 && StringUtil.isNotEmpty((String)availableVersion) && InstalledPackagesPanel.this.isUpdateAvailable(version, availableVersion);
            cell.setIcon(update ? IconUtil.getMoveUpIcon() : null);
            Object pyPackage = table.getValueAt(row2, 0);
            if (pyPackage instanceof InstalledPackage) {
                cell.setToolTipText(((InstalledPackage)pyPackage).getTooltipText());
            }
            return cell;
        }
    }
}

