/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.ComposerUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerJsonForm {
    private JPanel myConfigPanel;
    private TextFieldWithBrowseButton myConfigPathTextField;
    private JBCheckBox myAddPackagesAsLibrariesCheckBox;
    private JBCheckBox mySyncComposerConfigCheckBox;
    private JBLabel myUserSettingsStateLabel;
    private ActionLink myOpenJsonLink;
    private final boolean isVisible;
    private Project myProject;
    private static final String OVERWRITTEN = PhpBundle.message("action.detect.user.settings.state.overwritten", new Object[0]);
    private static final String SUPPORTED = PhpBundle.message("action.detect.user.settings.state.supported", new Object[0]);

    public ComposerJsonForm(@NotNull Project project, boolean visible) {
        if (project == null) {
            ComposerJsonForm.$$$reportNull$$$0(0);
        }
        this.isVisible = visible;
        this.$$$setupUI$$$();
        if (!this.isVisible) {
            this.myConfigPanel.setVisible(false);
            return;
        }
        this.myProject = project;
        this.myUserSettingsStateLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        FileChooserDescriptor singleFileDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myConfigPathTextField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(PhpBundle.message("framework.composer.path.dialog.path.to.composer.json", new Object[0]), PhpBundle.message("framework.composer.path.dialog.specify.composer.json", new Object[0]), (ComponentWithBrowseButton)this.myConfigPathTextField, null, singleFileDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = ComposerJsonForm.this.myConfigPathTextField.getText();
                if (StringUtil.isEmpty((String)text) && (file = ComposerUtils.findFileInProject(ComposerJsonForm.this.myConfigPanel, "composer.json")) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        this.myConfigPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComposerJsonForm.this.configPathUpdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerJsonForm$2", "textChanged"));
            }
        });
    }

    private void configPathUpdated() {
        boolean enabled = !StringUtil.isEmptyOrSpaces((String)this.myConfigPathTextField.getText());
        this.myAddPackagesAsLibrariesCheckBox.setEnabled(enabled);
        this.mySyncComposerConfigCheckBox.setEnabled(enabled);
        this.myUserSettingsStateLabel.setEnabled(enabled);
        this.myOpenJsonLink.setEnabled(ComposerJsonForm.validateComposerJsonPath(this.myConfigPathTextField) == null);
    }

    boolean isModified(@NotNull ComposerDataService service) {
        boolean oldSelected;
        if (service == null) {
            ComposerJsonForm.$$$reportNull$$$0(1);
        }
        if (!this.isVisible) {
            return false;
        }
        String oldConfigPath = StringUtil.nullize((String)service.getConfigPath());
        String newConfigPath = StringUtil.nullize((String)this.myConfigPathTextField.getText());
        if (!(oldConfigPath != null ? oldConfigPath.equals(newConfigPath) : newConfigPath == null)) {
            return true;
        }
        boolean bl = oldSelected = service.getSynchronizationState() != ComposerDataService.SynchronizationState.DONT_SYNCHRONIZE;
        if (this.mySyncComposerConfigCheckBox.isSelected() != oldSelected) {
            return true;
        }
        return this.myAddPackagesAsLibrariesCheckBox.isSelected() != service.isUpdateLibrary();
    }

    void apply(@NotNull ComposerDataService service) {
        if (service == null) {
            ComposerJsonForm.$$$reportNull$$$0(2);
        }
        if (!this.isVisible) {
            return;
        }
        service.setConfigPathAndLibraryUpdateStatus(StringUtil.nullize((String)this.myConfigPathTextField.getText()), this.myAddPackagesAsLibrariesCheckBox.isSelected());
        if (!this.mySyncComposerConfigCheckBox.isSelected()) {
            service.setSynchronizationState(ComposerDataService.SynchronizationState.DONT_SYNCHRONIZE);
        } else {
            service.setSynchronizationState(ComposerDataService.SynchronizationState.SYNCHRONIZE);
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    void reset(@NotNull ComposerDataService service) {
        if (service == null) {
            ComposerJsonForm.$$$reportNull$$$0(3);
        }
        if (!this.isVisible) {
            return;
        }
        this.myConfigPathTextField.setText(StringUtil.nullize((String)service.getConfigPath()));
        this.configPathUpdated();
        this.myAddPackagesAsLibrariesCheckBox.setSelected(service.isUpdateLibrary());
        this.mySyncComposerConfigCheckBox.setSelected(service.getSynchronizationState() == ComposerDataService.SynchronizationState.SYNCHRONIZE || service.getSynchronizationState() == ComposerDataService.SynchronizationState.NOT_INITIALIZED && ComposerSettingSyncConfigClient.isDefaultAllSettings(this.myProject, service.getConfigPath()));
        boolean defaultSettingsOrInitialized = ComposerSettingSyncConfigClient.isDefaultAllSettings(this.myProject, service.getConfigPath()) || service.getSynchronizationState() != ComposerDataService.SynchronizationState.NOT_INITIALIZED;
        this.myUserSettingsStateLabel.setText(defaultSettingsOrInitialized ? SUPPORTED : OVERWRITTEN);
        if (!defaultSettingsOrInitialized) {
            this.myUserSettingsStateLabel.setIcon(UIUtil.getBalloonWarningIcon());
        }
    }

    void setChangeListener(@NotNull DocumentAdapter documentAdapter) {
        if (documentAdapter == null) {
            ComposerJsonForm.$$$reportNull$$$0(4);
        }
        if (!this.isVisible) {
            return;
        }
        this.myConfigPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)documentAdapter);
    }

    @Nullable
    ValidationInfo validate() {
        if (!this.isVisible) {
            return null;
        }
        return ComposerJsonForm.validateComposerJsonPath(this.myConfigPathTextField);
    }

    private void createUIComponents() {
        this.myOpenJsonLink = new ActionLink(PhpBundle.message("action.detect.composer.json.open", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (ComposerJsonForm.this.myOpenJsonLink.isEnabled()) {
                    String path = ComposerJsonForm.this.myConfigPathTextField.getText();
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file == null) {
                        String title = PhpBundle.message("action.detect.composer.json.not.found.title", new Object[0]);
                        String message = PhpBundle.message("action.detect.composer.json.not.found", path);
                        Messages.showMessageDialog((Project)ComposerJsonForm.this.myProject, (String)message, (String)title, (Icon)Messages.getWarningIcon());
                        return;
                    }
                    FileEditorManager fileManager = FileEditorManager.getInstance((Project)ComposerJsonForm.this.myProject);
                    if (fileManager != null) {
                        fileManager.openFile(file, true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerJsonForm$3", "actionPerformed"));
            }
        });
        this.myOpenJsonLink.setPaintUnderline(false);
    }

    private static ValidationInfo validateComposerJsonPath(TextFieldWithBrowseButton textFieldWithBrowseButton) {
        String path = textFieldWithBrowseButton.getText();
        JComponent component = textFieldWithBrowseButton.getChildComponent();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.form.empty.path.to.composer.json", new Object[0]), component);
        }
        File file = new File(path);
        if (!file.exists()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.file.0.is.not.found", path), component);
        }
        if (file.isDirectory()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.validation.0.is.a.directory", path), component);
        }
        if (!"composer.json".equals(file.getName())) {
            return new ValidationInfo(PhpBundle.message("framework.composer.selected.file.is.not.composer.json", new Object[0]), component);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentAdapter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/ComposerJsonForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setChangeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myConfigPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.mySyncComposerConfigCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setContentAreaFilled(true);
        jBCheckBox2.setText("Synchronize IDE Settings with composer.json");
        jBCheckBox2.setMnemonic('S');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.myUserSettingsStateLabel = jBLabel = new JBLabel();
        jBLabel.setText("The settings (Php Language Level, Directories) may be updated");
        jBLabel.setVisible(true);
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        this.myAddPackagesAsLibrariesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Add packages as libraries");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(7, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Path to composer.json:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jLabel, "West");
        this.myConfigPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, "Center");
        ActionLink actionLink = this.myOpenJsonLink;
        jPanel2.add((Component)actionLink, "East");
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigPanel;
    }
}

