/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.log;

import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigurable;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogConsoleViewInterface;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.actions.log.lang.highlighter.ComposerLogHighlighter;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorConfigurableList;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorValidationInspection;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfigurableList;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerValidationInspection;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfigurableList;
import com.jetbrains.php.tools.quality.phpcs.PhpCSValidationInspection;
import com.jetbrains.php.ui.PhpSingleConfigurableEditor;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerLogMessageBuilder {
    private static final Logger LOG = Logger.getInstance(ComposerLogMessageBuilder.class);
    private final ComposerLogService.MessageId myId;
    private ComposerLogConsoleViewInterface myConsole;
    @Nullable
    private final ModalityState myModalityState;

    ComposerLogMessageBuilder(@NotNull ComposerLogService.MessageId id, @Nullable Settings settings, @NotNull ComposerLogConsoleViewInterface console, @Nullable ModalityState modalityState) {
        if (id == null) {
            ComposerLogMessageBuilder.$$$reportNull$$$0(0);
        }
        if (console == null) {
            ComposerLogMessageBuilder.$$$reportNull$$$0(1);
        }
        this.myId = id;
        this.myConsole = console;
        this.myModalityState = modalityState;
        this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.ID, this.myId.getTextPart(), ComposerLogHighlighter.DEFAULT_CONTENT_TYPE, this.myModalityState);
        if (settings != null) {
            this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.ID, " \u2006", ComposerLogHighlighter.DEFAULT_CONTENT_TYPE, this.myModalityState);
            this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.ID, settings.myId, ComposerLogHighlighter.DEFAULT_CONTENT_TYPE, this.myModalityState);
        }
    }

    public ComposerLogMessageBuilder printCommand(@NotNull String command, @Nullable ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> executorGenerator, @Nullable Project project) {
        if (command == null) {
            ComposerLogMessageBuilder.$$$reportNull$$$0(2);
        }
        this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.COMMAND, command, ComposerLogHighlighter.SUCCESSFUL_COMMAND_CONTENT_TYPE, this.myModalityState);
        if (executorGenerator != null && project != null) {
            ComposerLogService.getInstance(project).putRerunData(this.myId, executorGenerator);
        }
        return this;
    }

    public void printOutputPart(String text, Key outputType) {
        ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
        this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.OUTPUT, text, consoleViewType, this.myModalityState);
    }

    public void printSummary(String text) {
        this.printSummary(text, true, false, null, null);
    }

    public void printSummary(String text, boolean success, boolean showInEventLog, NotificationType notificationType, Project project) {
        this.printSummary(new SummaryMessage(text), success, showInEventLog, notificationType, project);
    }

    public void printSummary(SummaryMessage text, boolean success, boolean showInEventLog, NotificationType notificationType, final Project project) {
        text.printToConsole(this.myConsole, success, project, this.myModalityState);
        if (showInEventLog && (notificationType == NotificationType.ERROR || !this.myConsole.isShown())) {
            LOG.assertTrue(project != null);
            if (notificationType == null) {
                notificationType = NotificationType.INFORMATION;
            }
            DumbAwareAction logAction = new DumbAwareAction("Show in log"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ComposerLogService.getInstance(project).getConsoleView().show(ComposerLogMessageBuilder.this.myId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$1", "actionPerformed"));
                }
            };
            Notification notification2 = new Notification(ComposerUtils.COMPOSER_GROUP_DISPLAY_ID, PhpBundle.message("framework.composer", new Object[0]), text.forNotification(), notificationType);
            notification2.addAction((AnAction)logAction);
            Notifications.Bus.notify((Notification)notification2, (Project)project);
        }
        this.myConsole.scrollToEnd();
        this.detach();
    }

    public void detach() {
        this.myConsole.detach();
        this.myConsole = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "printCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SummaryMessage {
        private final List<Pair<String, VirtualFile>> myElements = new ArrayList<Pair<String, VirtualFile>>();

        public SummaryMessage() {
        }

        public SummaryMessage(String text) {
            this.appendText(text);
        }

        public SummaryMessage appendText(String text) {
            this.myElements.add((Pair<String, VirtualFile>)Pair.create((Object)text, null));
            return this;
        }

        public SummaryMessage appendLink(VirtualFile file, Project project) {
            String presentablePath = ComposerUtils.getPresentablePath(file, project);
            this.myElements.add((Pair<String, VirtualFile>)Pair.create((Object)presentablePath, (Object)file));
            return this;
        }

        public void printToConsole(ComposerLogConsoleViewInterface console, boolean success, Project project, ModalityState modalityState) {
            ComposerLogConsoleViewInterface.MessagePart messagePart = success ? ComposerLogConsoleViewInterface.MessagePart.SUCCESS_SUMMARY : ComposerLogConsoleViewInterface.MessagePart.FAILURE_SUMMARY;
            ConsoleViewContentType consoleViewType = success ? ComposerLogHighlighter.SUCCESSFUL_SUMMARY_TEXT_CONTENT_TYPE : ComposerLogHighlighter.FAILED_SUMMARY_TEXT_CONTENT_TYPE;
            for (Pair<String, VirtualFile> pair : this.myElements) {
                if (pair.second == null) {
                    console.print(messagePart, (String)pair.first, consoleViewType, modalityState);
                    continue;
                }
                OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(new OpenFileDescriptor(project, (VirtualFile)pair.second));
                console.printHyperlink(messagePart, (String)pair.first, info, modalityState);
            }
        }

        public String forNotification() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Pair<String, VirtualFile> pair : this.myElements) {
                stringBuilder.append((String)pair.first);
            }
            return stringBuilder.toString();
        }
    }

    public static enum Settings {
        COMPOSER("\u2000"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                new PhpSingleConfigurableEditor(project, (Configurable)new ComposerConfigurable(project, false)).showAndGet();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$1", "show"));
            }
        }
        ,
        PHP("\u2001"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpProjectConfigurable.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$2", "show"));
            }
        }
        ,
        DIRECTORIES("\u2002"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, "Directories");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$3", "show"));
            }
        }
        ,
        TEST_FRAMEWORKS("\u2003"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable(project, (Configurable)new PhpTestFrameworksConfigurable(project));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$4", "show"));
            }
        }
        ,
        CODE_SNIFFER("\u2004"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable(project, (Configurable)new PhpCSConfigurableList(project, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$5", "show"));
            }
        }
        ,
        MESS_DETECTOR("\u2005"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    6.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable(project, (Configurable)new MessDetectorConfigurableList(project, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$6", "show"));
            }
        }
        ,
        CODE_SNIFFER_INSPECTION("\u2006"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    7.$$$reportNull$$$0(0);
                }
                EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile(), (String)new PhpCSValidationInspection().getShortName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$7", "show"));
            }
        }
        ,
        MESS_DETECTOR_INSPECTION("\u2007"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    8.$$$reportNull$$$0(0);
                }
                EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile(), (String)new MessDetectorValidationInspection().getShortName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$8", "show"));
            }
        }
        ,
        CS_FIXER("\u2008"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    9.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable(project, (Configurable)new PhpCSFixerConfigurableList(project, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$9", "show"));
            }
        }
        ,
        CS_FIXER_INSPECTION("\u2009"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    10.$$$reportNull$$$0(0);
                }
                EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile(), (String)new PhpCSFixerValidationInspection().getShortName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$10", "show"));
            }
        };

        private final String myId;

        private Settings(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }

        public abstract void show(@NotNull Project var1);

        @Nullable
        public static Settings findById(String id) {
            if (id == null) {
                return null;
            }
            for (Settings settings : Settings.values()) {
                if (!settings.getId().equals(id)) continue;
                return settings;
            }
            return null;
        }
    }
}

