/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpDebugExternalConnectionHandler;
import com.jetbrains.php.debug.connection.PhpDebugPathExtractor;
import com.jetbrains.php.debug.connection.PhpListeningProjectsProvider;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.util.connection.ConnectionHandler;
import com.jetbrains.php.util.connection.ServerConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public abstract class PhpDebugServer<C extends PhpDebugConnection>
extends ServerConnection
implements PhpListeningProjectsProvider {
    private final Map<String, ConnectionHandler<C>> myIdHandlerMap = new HashMap<String, ConnectionHandler<C>>();
    private final Map<String, Boolean> myIdPermanentMap = new HashMap<String, Boolean>();
    private final List<PhpDebugExternalConnectionsAccepter> myConnectionListeners = new ArrayList<PhpDebugExternalConnectionsAccepter>();
    private final Random sessionNumberGenerator = new Random();
    private final Object myLock = new Object();
    private volatile int myConnected = 0;
    public static final int MAX_CONNECTED_COUNT = 50;

    protected PhpDebugServer() {
    }

    @Override
    protected void handle(@NotNull Socket socket) throws IOException {
        if (socket == null) {
            PhpDebugServer.$$$reportNull$$$0(0);
        }
        this.handle(socket.getInputStream(), socket.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handle(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            PhpDebugServer.$$$reportNull$$$0(1);
        }
        if (outputStream == null) {
            PhpDebugServer.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnected >= 50) {
                this.logEvent("too many connected connections");
                return;
            }
            ++this.myConnected;
        }
        PhpDebugConnection connection = null;
        try {
            ConnectionHandler<PhpDebugConnection> handler;
            connection = (PhpDebugConnection)this.createConnection(inputStream, outputStream);
            Disposer.register((Disposable)ApplicationManager.getApplication(), connection);
            connection.init();
            String sessionId = connection.getSessionId();
            Object object2 = this.myLock;
            synchronized (object2) {
                handler = this.myIdHandlerMap.get(sessionId);
                if (handler != null) {
                    Boolean isPermanent = this.myIdPermanentMap.get(sessionId);
                    assert (isPermanent != null);
                    if (!isPermanent.booleanValue()) {
                        this.unregisterSessionHandler(sessionId);
                    }
                }
            }
            if (handler != null) {
                handler.handle(connection);
            } else {
                int size;
                Object object3 = this.myLock;
                synchronized (object3) {
                    size = this.myConnectionListeners.size();
                }
                if (size != 0) {
                    this.createExternalConnectionHandler(connection);
                } else {
                    connection.startDetach();
                }
            }
            connection.connect();
        }
        finally {
            Object object4 = this.myLock;
            synchronized (object4) {
                --this.myConnected;
            }
            if (connection != null) {
                Disposer.dispose((Disposable)connection);
            }
        }
    }

    @Override
    @NotNull
    public List<Project> getListeningProjects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        List<PhpDebugExternalConnectionsAccepter> connectionListeners = this.getConnectionListeners();
        for (PhpDebugExternalConnectionsAccepter connectionListener : connectionListeners) {
            if (!connectionListener.isStarted()) continue;
            projects.add(connectionListener.getProject());
        }
        ArrayList<Project> arrayList = projects;
        if (arrayList == null) {
            PhpDebugServer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<PhpDebugExternalConnectionsAccepter> getConnectionListeners() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<PhpDebugExternalConnectionsAccepter> arrayList = new ArrayList<PhpDebugExternalConnectionsAccepter>(this.myConnectionListeners);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        PhpDebugServer.$$$reportNull$$$0(4);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String registerSessionHandler(boolean permanent, @NotNull ConnectionHandler<C> handler) throws ExecutionException {
        if (handler == null) {
            PhpDebugServer.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        int sessionId = this.generateSessionId();
        while (true) {
            if (!this.myIdHandlerMap.keySet().contains(String.valueOf(sessionId))) {
                String sessionIdStr = String.valueOf(sessionId);
                this.registerSessionHandler(sessionIdStr, permanent, handler);
                String string = sessionIdStr;
                // MONITOREXIT : object
                if (string != null) return string;
                PhpDebugServer.$$$reportNull$$$0(6);
                return string;
            }
            sessionId = this.generateSessionId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSessionHandler(@NotNull String sessionId, boolean permanent, @NotNull ConnectionHandler<C> handler) throws ExecutionException {
        if (sessionId == null) {
            PhpDebugServer.$$$reportNull$$$0(7);
        }
        if (handler == null) {
            PhpDebugServer.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            switch (this.getStatus()) {
                case STOPPED: {
                    throw new ExecutionException("Cannot register handler");
                }
                case STARTED: {
                    if (this.myIdHandlerMap.keySet().contains(sessionId)) {
                        throw new ExecutionException("Handler with the same session id is already registered");
                    }
                    this.myIdHandlerMap.put(sessionId, handler);
                    this.myIdPermanentMap.put(sessionId, permanent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSessionHandler(@NotNull String sessionId) {
        if (sessionId == null) {
            PhpDebugServer.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myIdPermanentMap.remove(sessionId);
            this.myIdHandlerMap.remove(sessionId);
            this.tryStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalConnectionListener(@NotNull PhpDebugExternalConnectionsAccepter connectionsListener) throws ExecutionException {
        if (connectionsListener == null) {
            PhpDebugServer.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            switch (this.getStatus()) {
                case STARTED: {
                    this.myConnectionListeners.add(connectionsListener);
                    break;
                }
                case STOPPED: {
                    throw new ExecutionException("Cannot register handler");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterExternalConnectionListener(@NotNull PhpDebugExternalConnectionsAccepter connectionsListener) {
        boolean remove;
        if (connectionsListener == null) {
            PhpDebugServer.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            remove = this.myConnectionListeners.remove(connectionsListener);
            this.tryStop();
        }
        return remove;
    }

    private void tryStop() {
        if (this.myIdHandlerMap.size() == 0 && this.myConnectionListeners.size() == 0) {
            this.stopListening();
        }
    }

    protected abstract C createConnection(@NotNull InputStream var1, @NotNull OutputStream var2);

    protected abstract PhpDebugExternalConnectionHandler<C> createExternalConnectionHandler(@NotNull C var1);

    @NotNull
    public abstract PhpDebugPathExtractor createPathFromUrlExtractor();

    private int generateSessionId() {
        return 10000 + this.sessionNumberGenerator.nextInt(10000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugServer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionsListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugServer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeningProjects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionListeners";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "registerSessionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerSessionHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSessionHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerExternalConnectionListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExternalConnectionListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

