/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hierarchy.method;

import com.intellij.icons.AllIcons;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.jetbrains.php.hierarchy.PhpHierarchyUtils;
import com.jetbrains.php.hierarchy.method.PhpMethodHierarchyTreeStructure;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class PhpMethodHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private Icon myRawIcon;
    private Icon myStateIcon;
    private PhpMethodHierarchyTreeStructure myTreeStructure;

    public PhpMethodHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, PhpClass aClass, boolean isBase, PhpMethodHierarchyTreeStructure treeStructure) {
        super(project, (NodeDescriptor)parentDescriptor, (PsiElement)aClass, isBase);
        this.myTreeStructure = treeStructure;
    }

    public final void setTreeStructure(PhpMethodHierarchyTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
    }

    private Method getMethod(PhpClass aClass, boolean checkBases) {
        return PhpHierarchyUtils.findBaseMethodInClass(this.myTreeStructure.getBaseMethod(), aClass, checkBases);
    }

    public final PhpClass getPhpClass() {
        return (PhpClass)this.getPsiElement();
    }

    public final PsiElement getTargetElement() {
        PhpClass aClass = this.getPhpClass();
        if (aClass == null || !aClass.isValid()) {
            return null;
        }
        Method method = this.getMethod(aClass, false);
        if (method != null) {
            return method;
        }
        return aClass;
    }

    public final boolean update() {
        LayeredIcon icon;
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PhpClass jsClass = this.getPhpClass();
        if (jsClass == null) {
            return this.invalidElement();
        }
        Icon newRawIcon = jsClass.getIcon(flags);
        Icon newStateIcon = this.calculateState(jsClass);
        changes = true;
        this.myRawIcon = newRawIcon;
        this.myStateIcon = newStateIcon;
        Icon newIcon = this.myRawIcon;
        if (this.myIsBase) {
            icon = new LayeredIcon(2);
            icon.setIcon(newIcon, 0);
            icon.setIcon(AllIcons.Actions.Forward, 1, -AllIcons.Actions.Forward.getIconWidth() / 2, 0);
            newIcon = icon;
        }
        if (this.myStateIcon != null) {
            icon = new RowIcon(2);
            icon.setIcon(this.myStateIcon, 0);
            icon.setIcon(newIcon, 1);
            newIcon = icon;
        }
        this.setIcon(newIcon);
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(jsClass.getName(), classNameAttributes);
        String fileName = PhpHierarchyUtils.getFileNameContainingElement((PsiElement)jsClass);
        this.myHighlightedText.getEnding().addText(" (" + fileName + ")", UsageTreeColorsScheme.getInstance().getScheme().getAttributes(UsageTreeColors.NUMBER_OF_USAGES));
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return true;
    }

    @Nullable
    private Icon calculateState(PhpClass jsClass) {
        boolean hasBaseImplementation;
        if (jsClass.isInterface()) {
            return null;
        }
        Method method = this.getMethod(jsClass, false);
        if (method != null) {
            if (method.isAbstract()) {
                return null;
            }
            return AllIcons.Hierarchy.MethodDefined;
        }
        if (this.myTreeStructure.isSuperClassForBaseClass(jsClass)) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        Method baseClassMethod = this.getMethod(jsClass, true);
        boolean bl = hasBaseImplementation = baseClassMethod != null && !baseClassMethod.getModifier().isAbstract();
        if (hasBaseImplementation) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        return AllIcons.Hierarchy.ShouldDefineMethod;
    }
}

