/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInitializeFieldsIntention
extends PsiElementBaseIntentionAction {
    public static final String DIALOG_TITLE = "Select Fields to Initialize";
    public static final String NAME = "Initialize fields";

    @NotNull
    public String getText() {
        if (NAME == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @NotNull
    public String getFamilyName() {
        if (NAME == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(1);
        }
        return NAME;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(3);
        }
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        Collection<Parameter> parameters = PhpInitializeFieldsIntention.getUnsavedParameters(element);
        if (containingClass != null && parameters != null) {
            Object selected;
            Object selectedElements = new ArrayList<PhpNamedElementNode>();
            for (Parameter parameter : parameters) {
                if (!StringUtil.isNotEmpty((String)parameter.getName())) continue;
                selectedElements.add(new PhpNamedElementNode((PhpNamedElement)parameter));
            }
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                MemberChooser<PhpNamedElementNode> chooser = new MemberChooser<PhpNamedElementNode>(selectedElements.toArray(new PhpNamedElementNode[0]), false, true, project){
                    private MemberChooser.ShowContainersAction myShowContainersAction;
                    {
                        this.setTitle(PhpInitializeFieldsIntention.DIALOG_TITLE);
                        this.setCopyJavadocVisible(false);
                    }

                    protected void fillToolbarActions(DefaultActionGroup group) {
                        super.fillToolbarActions(group);
                        this.setShowClasses(true);
                        group.remove((AnAction)this.myShowContainersAction);
                    }

                    protected MemberChooser.ShowContainersAction getShowContainersAction() {
                        this.myShowContainersAction = super.getShowContainersAction();
                        return this.myShowContainersAction;
                    }

                    public void dispose() {
                        super.dispose();
                        this.myShowContainersAction = null;
                    }
                };
                chooser.show();
                if (chooser.getExitCode() != 0) {
                    return;
                }
                selected = chooser.getSelectedElements();
                selectedElements = selected == null ? Collections.emptyList() : selected;
            }
            ArrayList<Parameter> toInitialize = new ArrayList<Parameter>();
            selected = selectedElements.iterator();
            while (selected.hasNext()) {
                PhpNamedElementNode selectedElement = (PhpNamedElementNode)((Object)selected.next());
                PsiElement parameter = selectedElement.getPsiElement();
                if (!(parameter instanceof Parameter)) continue;
                toInitialize.add((Parameter)parameter);
            }
            PsiFile file = containingClass.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
            String visibilityModifier = phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY.toString();
            ApplicationManager.getApplication().runWriteAction(() -> PhpRefactoringUtil.initializeFieldsByParameters(containingClass, toInitialize, visibilityModifier));
        }
    }

    @Nullable
    private static Method getConstructor(@NotNull PsiElement element) {
        PhpClass containingClass;
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(4);
        }
        return (containingClass = (PhpClass)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) == null ? null : containingClass.getConstructor();
    }

    @Nullable
    private static Collection<Parameter> getUnsavedParameters(@NotNull PsiElement element) {
        Method constructor;
        Parameter[] parameters;
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(5);
        }
        Parameter[] parameterArray = parameters = (constructor = PhpInitializeFieldsIntention.getConstructor(element)) == null ? null : constructor.getParameters();
        if (constructor == null || parameters.length == 0) {
            return null;
        }
        THashSet savedParameters = new THashSet();
        constructor.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Set)savedParameters){
            final /* synthetic */ Set val$savedParameters;
            {
                this.val$savedParameters = set;
            }

            public void visitElement(PsiElement element) {
                if (element instanceof AssignmentExpression) {
                    this.visitPhpAssignmentExpression((AssignmentExpression)element);
                } else {
                    super.visitElement(element);
                }
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement value = assignmentExpression.getValue();
                if (value instanceof Variable && assignmentExpression.getVariable() instanceof FieldReference) {
                    this.val$savedParameters.add(((Variable)value).getNameCS());
                }
            }
        });
        ArrayList<Parameter> unsavedParameters = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            if (savedParameters.contains(parameter.getNameCS())) continue;
            unsavedParameters.add(parameter);
        }
        return unsavedParameters;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile file;
        if (project == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(7);
        }
        if (!((file = element.getContainingFile()) instanceof PhpFile)) {
            return false;
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        if (!PhpInitializeFieldsIntention.isInvokedOnConstructor(element)) {
            return false;
        }
        Method constructor = (Method)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Method.INSTANCEOF);
        Object groupStatement = PhpPsiUtil.getChildByCondition((PsiElement)constructor, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement == null) {
            return false;
        }
        Collection<Parameter> parameters = PhpInitializeFieldsIntention.getUnsavedParameters(element);
        return parameters != null && !parameters.isEmpty();
    }

    private static boolean isInvokedOnConstructor(@NotNull PsiElement element) {
        Object parameters;
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(8);
        }
        if ((parameters = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)ParameterList.INSTANCEOF)) != null) {
            return PhpRefactoringUtil.isElementConstructor(parameters.getParent());
        }
        PsiElement parent = element.getParent();
        if (PhpRefactoringUtil.isElementConstructor(parent)) {
            return ((Function)parent).getNameIdentifier() == element || PhpPsiUtil.isOfType(element, PhpTokenTypes.kwFUNCTION) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN);
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInitializeFieldsIntention";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInitializeFieldsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInvokedOnConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

