/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.validation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import gnu.trove.THashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterValidator {
    @Nullable
    public static ValidationInfo validate(@NotNull Project project, @NotNull List<? extends PhpParameterTemplate> templates) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(0);
        }
        if (templates == null) {
            PhpParameterValidator.$$$reportNull$$$0(1);
        }
        THashSet parameterNames = new THashSet();
        boolean initializedParameters = false;
        boolean variadicParameters = false;
        for (PhpParameterTemplate phpParameterTemplate : templates) {
            String initializer;
            String parameterText = phpParameterTemplate.getParameterPreviewText();
            Parameter parameter = PhpParameterValidator.constructParameter(project, parameterText);
            if (parameter == null) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation", parameterText);
            }
            String name = parameter.getName();
            if (PhpLangUtil.isSuperGlobal(name) || PhpLangUtil.isThisReference(name)) {
                return PhpParameterValidator.newValidation("refactoring.parameter.reserved.name", name);
            }
            String typeDeclarationString = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
            ValidationInfo simpleValidation = PhpParameterValidator.simpleValidation(project, parameter, parameterText, typeDeclarationString, initializer = PhpParameterValidator.getInitializer(parameter), phpParameterTemplate.getDefaultValue());
            if (simpleValidation != null) {
                return simpleValidation;
            }
            if (!parameterNames.add(name)) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.duplicate.parameter", name);
            }
            String defaultValue = StringUtil.notNullize((String)phpParameterTemplate.getDefaultValue());
            if (StringUtil.isNotEmpty((String)initializer)) {
                initializedParameters = true;
                if (StringUtil.isNotEmpty((String)typeDeclarationString) && !PhpParameterValidator.isArray(parameter.getDeclaredType()) && !"null".equalsIgnoreCase(initializer) && !PhpStrictTypeCheckingInspection.isScalar(parameter.getDeclaredType())) {
                    return PhpParameterValidator.newValidation("refactoring.parameter.validation.initializer.type", new Object[0]);
                }
                if (phpParameterTemplate.isVariadic()) {
                    return PhpParameterValidator.newValidation("refactoring.parameter.validation.variadic.can.have.default.value", new Object[0]);
                }
            } else if (initializedParameters && !phpParameterTemplate.isVariadic()) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.initializer.last", new Object[0]);
            }
            if (variadicParameters) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.variadic.last", new Object[0]);
            }
            if (phpParameterTemplate.isVariadic()) {
                variadicParameters = true;
            }
            if (phpParameterTemplate.shouldBeInitialized() && StringUtil.isEmpty((String)defaultValue) && StringUtil.isEmpty((String)initializer)) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation.no.default.value", parameterText);
            }
            if (!parameter.isPassByRef() || PhpParameterValidator.canBePassByRef(project, defaultValue)) continue;
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.pass.by.reference", new Object[0]);
        }
        return null;
    }

    private static boolean isArray(PhpType type) {
        int size = type.getTypes().size();
        return PhpType.intersects((PhpType)type, (PhpType)PhpType.ARRAY) && (size == 1 || size == 2 && PhpType.intersects((PhpType)PhpType.NULL, (PhpType)type));
    }

    private static boolean canBePassByRef(@NotNull Project project, @Nullable String expression) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(2);
        }
        if (StringUtil.isNotEmpty((String)expression)) {
            assert (expression != null);
            Variable variable = PhpPsiElementFactory.createFirstFromText(project, Variable.class, expression);
            return variable != null && expression.trim().equals(variable.getText().trim());
        }
        return true;
    }

    @Nullable
    public static ValidationInfo validateAndCommit(@NotNull Project project, @NotNull List<? extends PhpParameterTemplate> templates) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(3);
        }
        if (templates == null) {
            PhpParameterValidator.$$$reportNull$$$0(4);
        }
        for (PhpParameterTemplate phpParameterTemplate : templates) {
            String initializer;
            String parameterText = phpParameterTemplate.getParameterPreviewText();
            Parameter parameter = PhpParameterValidator.constructParameter(project, parameterText);
            if (parameter == null) {
                return PhpParameterValidator.newValidation("refactoring.parameter.validation", parameterText);
            }
            String type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
            ValidationInfo simpleValidation = PhpParameterValidator.simpleValidation(project, parameter, parameterText, type, initializer = PhpParameterValidator.getInitializer(parameter), phpParameterTemplate.getDefaultValue());
            if (simpleValidation != null) {
                return simpleValidation;
            }
            phpParameterTemplate.updateParameter(parameter);
        }
        return null;
    }

    @Nullable
    private static ValidationInfo simpleValidation(@NotNull Project project, @NotNull Parameter newParameter, @NotNull String parameterText, @NotNull String type, @NotNull String initializer, @Nullable String defaultValue) {
        Method method;
        PhpReturnType element;
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(5);
        }
        if (newParameter == null) {
            PhpParameterValidator.$$$reportNull$$$0(6);
        }
        if (parameterText == null) {
            PhpParameterValidator.$$$reportNull$$$0(7);
        }
        if (type == null) {
            PhpParameterValidator.$$$reportNull$$$0(8);
        }
        if (initializer == null) {
            PhpParameterValidator.$$$reportNull$$$0(9);
        }
        if (!newParameter.getText().equals(parameterText)) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation", parameterText);
        }
        String name = newParameter.getName();
        if (!PhpNameUtil.isValidParameterName(name)) {
            return PhpParameterValidator.newValidation("validation.invalid.identifier", name);
        }
        if (StringUtil.isNotEmpty((String)type) && !PhpParameterValidator.isPrimitiveParameterType(type) && (element = (method = PhpPsiElementFactory.createPhpPsiFromText(project, Method.class, "class A {function f(): " + type + " {}}")).getReturnType()) == null) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.type", type);
        }
        if (!PhpParameterValidator.validateExpression(project, initializer, false)) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.initializer", initializer);
        }
        if (!PhpParameterValidator.validateExpression(project, defaultValue, newParameter.isVariadic())) {
            return PhpParameterValidator.newValidation("refactoring.parameter.validation.default.value", defaultValue);
        }
        return null;
    }

    private static boolean isPrimitiveParameterType(@NotNull String type) {
        String fqn;
        if (type == null) {
            PhpParameterValidator.$$$reportNull$$$0(10);
        }
        return PhpType.isArray((String)(fqn = PhpLangUtil.toFQN(type))) || "\\callable".equals(fqn);
    }

    private static boolean validateExpression(@NotNull Project project, @Nullable String expression, boolean canBeExpressionList) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)expression)) {
            if (canBeExpressionList) {
                List expressionElements = StringUtil.split((String)expression, (String)",");
                for (String expressionElement : expressionElements) {
                    boolean isValid = PhpParameterValidator.validateExpressionElement(project, expressionElement);
                    if (isValid) continue;
                    return false;
                }
            } else {
                return PhpParameterValidator.validateExpressionElement(project, expression);
            }
        }
        return true;
    }

    private static boolean validateExpressionElement(@NotNull Project project, @NotNull String expression) {
        PhpExpression element;
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(12);
        }
        if (expression == null) {
            PhpParameterValidator.$$$reportNull$$$0(13);
        }
        return (element = PhpPsiElementFactory.createFirstFromText(project, PhpExpression.class, expression)) != null && expression.trim().equals(element.getText().trim());
    }

    private static ValidationInfo newValidation(@NotNull String messagePath, Object ... parameters) {
        if (messagePath == null) {
            PhpParameterValidator.$$$reportNull$$$0(14);
        }
        return new ValidationInfo(PhpBundle.message(messagePath, parameters));
    }

    @Nullable
    private static Parameter constructParameter(@NotNull Project project, @NotNull String parameter) {
        if (project == null) {
            PhpParameterValidator.$$$reportNull$$$0(15);
        }
        if (parameter == null) {
            PhpParameterValidator.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)parameter)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("function foo(");
        builder.append(parameter);
        builder.append("){}");
        return PhpPsiElementFactory.createFromText(project, Parameter.class, builder.toString());
    }

    @NotNull
    private static String getInitializer(@NotNull Parameter parameter) {
        PsiElement defaultValue;
        if (parameter == null) {
            PhpParameterValidator.$$$reportNull$$$0(17);
        }
        String string = (defaultValue = parameter.getDefaultValue()) == null ? "" : defaultValue.getText();
        if (string == null) {
            PhpParameterValidator.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterText";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/validation/PhpParameterValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/validation/PhpParameterValidator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBePassByRef";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateAndCommit";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "simpleValidation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveParameterType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateExpressionElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newValidation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "constructParameter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

