/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.run;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRefactoringListenerRunConfiguration;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationEditor;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerConfigurationEditor;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettingsValidator;
import com.jetbrains.php.util.PhpConfigurationUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestRunConfiguration
extends PhpRefactoringListenerRunConfiguration<PhpTestRunConfigurationSettings>
implements LocatableConfiguration,
SMRunnerConsolePropertiesProvider {
    private final PhpTestFrameworkType myFrameworkType;
    private final Runnable myShowSettingsRunnable;
    private final PhpTestRunnerSettingsValidator myValidator;
    private final PhpTestRunConfigurationHandler myHandler;
    private final PhpTestFrameworkVersionDetector myVersionDetector;

    protected PhpTestRunConfiguration(Project project, ConfigurationFactory factory, String name, @NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestRunnerSettingsValidator validator, @NotNull PhpTestRunConfigurationHandler handler) {
        if (frameworkType == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (validator == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(2);
        }
        this(project, factory, name, frameworkType, validator, handler, null);
    }

    protected PhpTestRunConfiguration(Project project, ConfigurationFactory factory, String name, @NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestRunnerSettingsValidator validator, @NotNull PhpTestRunConfigurationHandler handler, @Nullable PhpTestFrameworkVersionDetector versionDetector) {
        if (frameworkType == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(3);
        }
        if (validator == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(4);
        }
        if (handler == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(5);
        }
        super(project, factory, name);
        this.myFrameworkType = frameworkType;
        this.myValidator = validator;
        this.myHandler = handler;
        this.myVersionDetector = versionDetector;
        this.myShowSettingsRunnable = PhpTestFrameworksConfigurable.createFix(project, this.myFrameworkType);
    }

    @NotNull
    public String getFrameworkName() {
        String string = this.myFrameworkType.getDisplayName();
        if (string == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected PhpTestRunConfigurationSettings createSettings() {
        PhpTestRunConfigurationSettings phpTestRunConfigurationSettings = new PhpTestRunConfigurationSettings();
        if (phpTestRunConfigurationSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(7);
        }
        return phpTestRunConfigurationSettings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhpTestRunConfigurationEditor phpTestRunConfigurationEditor = this.getConfigurationEditor(ContainerUtil.newEnumMap(PhpTestRunnerSettings.Scope.class));
        if (phpTestRunConfigurationEditor == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(8);
        }
        return phpTestRunConfigurationEditor;
    }

    @NotNull
    protected PhpTestRunConfigurationEditor getConfigurationEditor(@NotNull Map<PhpTestRunnerSettings.Scope, String> scopes) {
        if (scopes == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(9);
        }
        PhpTestRunConfigurationEditor phpTestRunConfigurationEditor = new PhpTestRunConfigurationEditor(this.getProject(), this.myShowSettingsRunnable, scopes, (Function<? super PhpTestRunnerConfigurationEditor, ? extends TextFieldCompletionProvider>)((Function)this::createMethodFieldCompletionProvider));
        if (phpTestRunConfigurationEditor == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(10);
        }
        return phpTestRunConfigurationEditor;
    }

    @NotNull
    protected abstract TextFieldCompletionProvider createMethodFieldCompletionProvider(@NotNull PhpTestRunnerConfigurationEditor var1);

    public void checkConfiguration() throws RuntimeConfigurationException {
        Project project = this.getProject();
        PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)this.getSettings();
        PhpRunUtil.checkCommandLineSettings(project, settings.getCommandLineSettings());
        PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
        assert (interpreter != null);
        PhpTestFrameworkConfiguration configuration = PhpTestFrameworkSettingsManager.getInstance(project).getConfigByInterpreter(this.myFrameworkType, interpreter);
        if (configuration == null) {
            String target = interpreter.isRemote() ? "'" + interpreter.getName() + "' interpreter" : "local machine";
            String message = PhpBundle.message("php.test.framework.settings.is.not.provided.or.empty", this.getFrameworkName(), target);
            throw new RuntimeConfigurationError(message, this.myShowSettingsRunnable);
        }
        VirtualFile workingDirectory = PhpRunUtil.findDirectory(this.getWorkingDirectory(project, settings, configuration));
        if (workingDirectory == null) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Working directory"));
        }
        switch (testRunnerSettings.getScope()) {
            case Type: {
                String typeError = this.myValidator.isTypeValid(testRunnerSettings.getSelectedType());
                if (!StringUtil.isNotEmpty((String)typeError)) break;
                throw new RuntimeConfigurationError(typeError);
            }
            case Directory: {
                String path = testRunnerSettings.getDirectoryPath();
                if (StringUtil.isEmpty((String)path)) {
                    if (this.myValidator.isEmptyDirectoryValid()) break;
                    throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Directory"));
                }
                String error = this.myValidator.isDirectoryValid(PhpRunUtil.findDirectory(path), workingDirectory);
                if (!StringUtil.isNotEmpty((String)error)) break;
                throw new RuntimeConfigurationError(error);
            }
            case File: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                String error = this.myValidator.isFileValid(file, workingDirectory);
                if (!StringUtil.isNotEmpty((String)error)) break;
                throw new RuntimeConfigurationError(error);
            }
            case Method: {
                PsiFile file = PhpRunUtil.findPsiFile(project, testRunnerSettings.getFilePath());
                String fileError = this.myValidator.isFileValid(file, workingDirectory);
                if (StringUtil.isNotEmpty((String)fileError)) {
                    throw new RuntimeConfigurationError(fileError);
                }
                String methodError = this.myValidator.isMethodValid(file, testRunnerSettings.getMethodName());
                if (!StringUtil.isNotEmpty((String)methodError)) break;
                throw new RuntimeConfigurationError(methodError);
            }
            case ConfigurationFile: {
                if (testRunnerSettings.isUseAlternativeConfigurationFile() || configuration.isUseConfigurationFile()) break;
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Configuration file"), this.myShowSettingsRunnable);
            }
        }
        if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
            if (!PhpRunUtil.isValidFilePath(testRunnerSettings.getConfigurationFilePath())) {
                throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Configuration file"));
            }
        } else if (configuration.isUseConfigurationFile() && !interpreter.isRemote() && !PhpRunUtil.isValidFilePath(configuration.getConfigurationFilePath())) {
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", "Configuration file"), this.myShowSettingsRunnable);
        }
        if (!interpreter.isRemote() && !PhpRunUtil.isValidFileOrDirectoryPath(configuration.getExecutablePath())) {
            String name = "Path to " + this.getFrameworkName();
            throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid.press.fix.project.configuration", name), this.myShowSettingsRunnable);
        }
    }

    @Nullable
    protected String getWorkingDirectory(@NotNull Project project, @NotNull PhpTestRunConfigurationSettings settings, @Nullable PhpTestFrameworkConfiguration config) {
        VirtualFile root;
        PhpCommandLineSettings cli;
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(12);
        }
        if (StringUtil.isNotEmpty((String)(cli = settings.getCommandLineSettings()).getWorkingDirectory())) {
            return cli.getWorkingDirectory();
        }
        VirtualFile baseFile = PhpTestRunConfiguration.getBaseFile(settings, config);
        if (baseFile != null && (root = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(baseFile)) != null) {
            return root.getPath();
        }
        return project.getBasePath();
    }

    @Nullable
    private static VirtualFile getBaseFile(@NotNull PhpTestRunConfigurationSettings settings, @Nullable PhpTestFrameworkConfiguration config) {
        if (settings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(13);
        }
        PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
        PhpTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Directory: {
                String directory = testRunnerSettings.getDirectoryPath();
                if (StringUtil.isEmptyOrSpaces((String)directory)) break;
                return PhpRunUtil.findDirectory(directory);
            }
            case File: 
            case Method: {
                String filePath = testRunnerSettings.getFilePath();
                if (StringUtil.isEmptyOrSpaces((String)filePath)) break;
                return PhpRunUtil.findFile(filePath);
            }
            case ConfigurationFile: {
                String configurationFilePath = PhpTestRunConfiguration.getConfigurationFile(testRunnerSettings, config);
                if (StringUtil.isEmptyOrSpaces((String)configurationFilePath)) break;
                return PhpRunUtil.findFile(configurationFilePath);
            }
        }
        return null;
    }

    @Nullable
    public static String getConfigurationFile(@NotNull PhpTestRunnerSettings testRunnerSettings, @Nullable PhpTestFrameworkConfiguration configuration) {
        if (testRunnerSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(14);
        }
        if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
            return testRunnerSettings.getConfigurationFilePath();
        }
        if (configuration != null && configuration.isUseConfigurationFile()) {
            return configuration.getConfigurationFilePath();
        }
        return null;
    }

    @NotNull
    public PhpCommandSettings createCommand(@NotNull PhpInterpreter interpreter, @NotNull Map<String, String> env, @NotNull List<String> arguments, boolean withDebugger) throws ExecutionException {
        if (interpreter == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(15);
        }
        if (env == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(16);
        }
        if (arguments == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(17);
        }
        if (this.myHandler == null) {
            throw new ExecutionException("Can not execute tests");
        }
        Project project = this.getProject();
        PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)this.getSettings();
        PhpCommandSettings command = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug(withDebugger).build();
        PhpTestFrameworkConfiguration config = PhpTestFrameworkSettingsManager.getInstance(project).getConfigByInterpreter(this.myFrameworkType, interpreter);
        if (config == null || StringUtil.isEmptyOrSpaces((String)config.getExecutablePath())) {
            String target = command.isRemote() ? "'" + interpreter.getName() + "' interpreter" : "local machine";
            String message = PhpBundle.message("php.interpreter.base.configuration.is.not.provided.or.empty", this.getFrameworkName(), target);
            throw new ExecutionException(message);
        }
        String version = null;
        if (this.myVersionDetector != null && StringUtil.isEmpty((String)(version = PhpTestFrameworkVersionCache.getCache(project, config)))) {
            try {
                version = this.myVersionDetector.getVersion(project, interpreter, config.getExecutablePath()).toString();
                PhpTestFrameworkVersionCache.setCache(project, config, version);
            }
            catch (ExecutionException message) {
                // empty catch block
            }
        }
        this.myHandler.prepareCommand(project, command, config.getExecutablePath(), version);
        String workingDirectory = this.getWorkingDirectory(project, settings, config);
        if (StringUtil.isEmptyOrSpaces((String)workingDirectory)) {
            throw new ExecutionException(PhpBundle.message("php.interpreter.base.configuration.working.directory", new Object[0]));
        }
        command.importCommandLineSettings(settings.getCommandLineSettings(), workingDirectory);
        command.addEnvs(env);
        PhpTestRunConfiguration.fillTestRunnerArguments(project, workingDirectory, settings.getRunnerSettings(), arguments, command, config, this.myHandler);
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(18);
        }
        return phpCommandSettings;
    }

    public static void fillTestRunnerArguments(@NotNull Project project, @NotNull String workingDirectory, @NotNull PhpTestRunnerSettings testRunnerSettings, @NotNull List<String> arguments, @NotNull PhpCommandSettings command, @Nullable PhpTestFrameworkConfiguration configuration, @NotNull PhpTestRunConfigurationHandler handler) throws ExecutionException {
        String testRunnerOptions;
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(19);
        }
        if (workingDirectory == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(20);
        }
        if (testRunnerSettings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(21);
        }
        if (arguments == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(22);
        }
        if (command == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(23);
        }
        if (handler == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(24);
        }
        if (StringUtil.isNotEmpty((String)(testRunnerOptions = testRunnerSettings.getTestRunnerOptions()))) {
            command.addArguments(Arrays.asList(ParametersList.parse((String)testRunnerOptions)));
        }
        command.addArguments(arguments);
        String configurationFilePath = PhpTestRunConfiguration.getConfigurationFile(testRunnerSettings, configuration);
        if (StringUtil.isNotEmpty((String)configurationFilePath)) {
            command.addArgument(handler.getConfigFileOption());
            if (testRunnerSettings.isUseAlternativeConfigurationFile()) {
                command.addPathArgument(configurationFilePath);
            } else {
                command.addArgument(configurationFilePath);
            }
        }
        PhpTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Type: {
                handler.runType(project, command, StringUtil.notNullize((String)testRunnerSettings.getSelectedType()), workingDirectory);
                break;
            }
            case Directory: {
                handler.runDirectory(project, command, StringUtil.notNullize((String)testRunnerSettings.getDirectoryPath()), workingDirectory);
                break;
            }
            case File: {
                handler.runFile(project, command, StringUtil.notNullize((String)testRunnerSettings.getFilePath()), workingDirectory);
                break;
            }
            case Method: {
                String filePath = StringUtil.notNullize((String)testRunnerSettings.getFilePath());
                handler.runMethod(project, command, filePath, testRunnerSettings.getMethodName(), workingDirectory);
                break;
            }
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Project project;
        PhpInterpreter interpreter;
        if (executor == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(25);
        }
        if (env == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(26);
        }
        if ((interpreter = PhpProjectConfigurationFacade.getInstance(project = this.getProject()).getInterpreter()) == null) {
            return null;
        }
        PhpCommandSettings command = this.createCommand(interpreter, Collections.emptyMap(), (List<String>)new SmartList(), false);
        return this.getState(env, command, null);
    }

    @Nullable
    public RunProfileState getState(@NotNull ExecutionEnvironment env, final @NotNull PhpCommandSettings command, final @Nullable ProcessListener listener) throws ExecutionException {
        if (env == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(27);
        }
        if (command == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(28);
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationWarning runtimeConfigurationWarning) {
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
        final Project project = this.getProject();
        final PhpPathMapper pathMapper = command.getPathProcessor().createPathMapper(project);
        CommandLineState commandLineState = new CommandLineState(env){

            @NotNull
            protected ProcessHandler startProcess() throws ExecutionException {
                ProcessHandler processHandler = PhpTestRunConfiguration.this.createProcessHandler(project, command);
                PhpRunUtil.attachProcessOutputDebugDumper(processHandler);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
                if (listener != null) {
                    processHandler.addProcessListener(listener);
                }
                ProcessHandler processHandler2 = processHandler;
                if (processHandler2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processHandler2;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(2);
                }
                ProcessHandler processHandler = this.startProcess();
                SMTRunnerConsoleProperties properties = PhpTestRunConfiguration.this.createTestConsoleProperties(executor);
                BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)PhpTestRunConfiguration.this.myFrameworkType.getID(), (ProcessHandler)processHandler, (TestConsoleProperties)properties);
                PhpTestRunConfiguration.this.addMessageFilters((ConsoleView)consoleView, project, pathMapper);
                DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
                AbstractRerunFailedTestsAction rerun = PhpTestRunConfiguration.this.createRerunAction((ConsoleView)consoleView, properties);
                if (rerun != null) {
                    rerun.setModelProvider(() -> 1.lambda$execute$0((ConsoleView)consoleView));
                    result.setRestartActions(new AnAction[]{rerun});
                }
                DefaultExecutionResult defaultExecutionResult = result;
                if (defaultExecutionResult == null) {
                    1.$$$reportNull$$$0(3);
                }
                return defaultExecutionResult;
            }

            private static /* synthetic */ TestFrameworkRunningModel lambda$execute$0(ConsoleView consoleView) {
                if (consoleView instanceof SMTRunnerConsoleView) {
                    return ((SMTRunnerConsoleView)consoleView).getResultsViewer();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        commandLineState.addConsoleFilters(PhpExecutionUtil.getConsoleMessageFilters(project, pathMapper));
        return commandLineState;
    }

    @Nullable
    protected AbstractRerunFailedTestsAction createRerunAction(@NotNull ConsoleView consoleView, @NotNull SMTRunnerConsoleProperties properties) {
        if (consoleView == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(29);
        }
        if (properties == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(30);
        }
        return null;
    }

    protected void addMessageFilters(@NotNull ConsoleView consoleView, @NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (consoleView == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(31);
        }
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(32);
        }
        if (pathMapper == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(33);
        }
        PhpExecutionUtil.addMessageFilters(project, consoleView, pathMapper);
    }

    public SMTRunnerConsoleProperties createTestConsoleProperties(Executor executor) {
        return new SMTRunnerConsoleProperties((RunConfiguration)this, this.myFrameworkType.getID(), executor);
    }

    public boolean isGeneratedName() {
        return PhpRunUtil.isGeneratedName(this);
    }

    @Nullable
    public String suggestedName() {
        PhpTestRunnerSettings runner = ((PhpTestRunConfigurationSettings)this.getSettings()).getRunnerSettings();
        PhpTestRunnerSettings.Scope scope = runner.getScope();
        switch (scope) {
            case Type: {
                return StringUtil.notNullize((String)runner.getSelectedType());
            }
            case File: {
                return PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getFilePath()));
            }
            case Directory: {
                return PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getDirectoryPath()));
            }
            case Method: {
                StringBuilder builder = new StringBuilder();
                String file = PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getFilePath()));
                builder.append(file);
                builder.append("::");
                builder.append(runner.getMethodName());
                return builder.toString();
            }
            case ConfigurationFile: {
                return PathUtil.getFileName((String)StringUtil.notNullize((String)runner.getConfigurationFilePath()));
            }
        }
        assert (false) : "Unknown scope: " + (Object)((Object)scope);
        return null;
    }

    @Nullable
    public String getActionName() {
        PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)this.getSettings()).getRunnerSettings();
        PhpTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        if (scope == PhpTestRunnerSettings.Scope.Method && StringUtil.isNotEmpty((String)testRunnerSettings.getMethodName())) {
            String methodName = testRunnerSettings.getMethodName();
            return methodName.length() < 20 ? methodName : methodName.substring(0, 20) + "...";
        }
        return super.getActionName();
    }

    @Override
    protected void fixSettingsAfterDeserialization(@NotNull PhpTestRunConfigurationSettings settings) {
        if (settings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(34);
        }
        PhpTestRunnerSettings runnerSettings = settings.getRunnerSettings();
        runnerSettings.setDirectoryPath(PhpConfigurationUtil.deserializePath(runnerSettings.getDirectoryPath()));
        runnerSettings.setFilePath(PhpConfigurationUtil.deserializePath(runnerSettings.getFilePath()));
        runnerSettings.setConfigurationFilePath(PhpConfigurationUtil.deserializePath(runnerSettings.getConfigurationFilePath()));
    }

    @Override
    protected void fixSettingsBeforeSerialization(@NotNull PhpTestRunConfigurationSettings settings) {
        if (settings == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(35);
        }
        PhpTestRunnerSettings runnerSettings = settings.getRunnerSettings();
        runnerSettings.setDirectoryPath(PhpConfigurationUtil.serializePath(runnerSettings.getDirectoryPath()));
        runnerSettings.setFilePath(PhpConfigurationUtil.serializePath(runnerSettings.getFilePath()));
        runnerSettings.setConfigurationFilePath(PhpConfigurationUtil.serializePath(runnerSettings.getConfigurationFilePath()));
    }

    @Override
    @NotNull
    protected List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> getPathsToUpdate() {
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> toUpdate = super.getPathsToUpdate();
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().getDirectoryPath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().setDirectoryPath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().getFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().setFilePath(newValue);
            }
        });
        toUpdate.add(new PhpRefactoringListenerRunConfiguration.PhpRefValue<String>(){

            @Override
            @Nullable
            public String getValue() {
                return ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().getConfigurationFilePath();
            }

            @Override
            public void setValue(@Nullable String newValue) {
                ((PhpTestRunConfigurationSettings)PhpTestRunConfiguration.this.getSettings()).getRunnerSettings().setConfigurationFilePath(newValue);
            }
        });
        List<PhpRefactoringListenerRunConfiguration.PhpRefValue<String>> list = toUpdate;
        if (list == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(36);
        }
        return list;
    }

    protected TextFieldCompletionProvider createMethodFileCompletionProvider(final @NotNull Project project, final PhpTestRunnerConfigurationEditor editor, final Predicate<Method> filter) {
        if (project == null) {
            PhpTestRunConfiguration.$$$reportNull$$$0(37);
        }
        return new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                PhpClass phpClass;
                PsiFile file;
                if (text == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    5.$$$reportNull$$$0(2);
                }
                if ((file = PhpRunUtil.findPsiFile(project, editor.getByScope(PhpTestRunnerSettings.Scope.File).getText())) instanceof PhpFile && (phpClass = (PhpClass)ContainerUtil.getFirstItem(PhpPsiUtil.findAllClasses((PhpFile)file))) != null) {
                    PhpClassHierarchyUtils.processMethods((PhpClass)phpClass, (PhpClass)phpClass, (method, subClass, baseClass) -> {
                        if (result == null) {
                            5.$$$reportNull$$$0(3);
                        }
                        if (filter.test(method)) {
                            result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)method).withIcon(method.getIcon()));
                        }
                        return true;
                    }, (boolean)false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCompletionVariants";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$addCompletionVariants$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected boolean createRemoteProcessHandlerFromRunner() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: 
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 11: 
            case 19: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 13: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 16: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: 
            case 36: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationEditor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBaseFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fillTestRunnerArguments";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createRerunAction";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilters";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsAfterDeserialization";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fixSettingsBeforeSerialization";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFileCompletionProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

