/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlBooleanType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Experimental
public class YamlMetaClass
extends YamlMetaType {
    private final List<Field> myFeatures;
    private final List<Field> myFeaturesRO;

    public YamlMetaClass(@NotNull String typeName) {
        if (typeName == null) {
            YamlMetaClass.$$$reportNull$$$0(0);
        }
        super(typeName);
        this.myFeatures = new LinkedList<Field>();
        this.myFeaturesRO = Collections.unmodifiableList(this.myFeatures);
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(1);
        }
        if (this.getFeatures().isEmpty()) {
            return null;
        }
        Optional<Field> byExactName = this.getFeatures().stream().filter(f -> {
            if (name == null) {
                YamlMetaClass.$$$reportNull$$$0(25);
            }
            return !f.isAnyNameAllowed() && name.equals(f.getName());
        }).findAny();
        return byExactName.orElse(this.getFeatures().stream().filter(Field::isAnyNameAllowed).findAny().orElse(null));
    }

    @NotNull
    public List<Field> getFeatures() {
        List<Field> list = this.myFeaturesRO;
        if (list == null) {
            YamlMetaClass.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected final Field addStringFeature(@NotNull String name) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(3);
        }
        Field field = this.addFeature(new Field(name, YamlStringType.getInstance()));
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(4);
        }
        return field;
    }

    @NotNull
    protected Field addBooleanFeature(@NotNull String name) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(5);
        }
        Field field = this.addScalarFeature(name, YamlBooleanType.getSharedInstance());
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(6);
        }
        return field;
    }

    @NotNull
    protected final Field addScalarFeature(@NotNull YamlScalarType type) {
        if (type == null) {
            YamlMetaClass.$$$reportNull$$$0(7);
        }
        Field field = this.addScalarFeature(type.getTypeName(), type);
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(8);
        }
        return field;
    }

    @NotNull
    protected final Field addScalarFeature(@NotNull String name, @NotNull YamlScalarType type) {
        if (name == null) {
            YamlMetaClass.$$$reportNull$$$0(9);
        }
        if (type == null) {
            YamlMetaClass.$$$reportNull$$$0(10);
        }
        Field field = this.addFeature(new Field(name, type));
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(11);
        }
        return field;
    }

    @NotNull
    protected final Field addObjectFeature(@NotNull YamlMetaClass metaClass) {
        if (metaClass == null) {
            YamlMetaClass.$$$reportNull$$$0(12);
        }
        Field field = this.addFeature(new Field(metaClass.getTypeName(), metaClass));
        if (field == null) {
            YamlMetaClass.$$$reportNull$$$0(13);
        }
        return field;
    }

    protected <T extends Field> T addFeature(@NotNull T child) {
        if (child == null) {
            YamlMetaClass.$$$reportNull$$$0(14);
        }
        this.myFeatures.add(child);
        return child;
    }

    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            YamlMetaClass.$$$reportNull$$$0(15);
        }
        if (relation == null) {
            YamlMetaClass.$$$reportNull$$$0(16);
        }
        if (iteration == null) {
            YamlMetaClass.$$$reportNull$$$0(17);
        }
        switch (relation) {
            case SCALAR_VALUE: {
                throw new IllegalArgumentException("Default relation " + (Object)((Object)relation) + " requested for complex type: " + this);
            }
            case OBJECT_CONTENTS: {
                this.doBuildInsertionSuffixMarkup(markup, false, iteration);
                break;
            }
            case SEQUENCE_ITEM: {
                this.doBuildInsertionSuffixMarkup(markup, true, iteration);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation: " + (Object)((Object)relation));
            }
        }
    }

    @Override
    public void validateKeyValue(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        if (keyValue == null) {
            YamlMetaClass.$$$reportNull$$$0(18);
        }
        if (problemsHolder == null) {
            YamlMetaClass.$$$reportNull$$$0(19);
        }
        super.validateKeyValue(keyValue, problemsHolder);
        if (keyValue.getValue() instanceof YAMLScalar) {
            problemsHolder.registerProblem((PsiElement)keyValue.getValue(), YAMLBundle.message("YamlMetaClass.error.scalar.value", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private void doBuildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, boolean manyNotOne, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            YamlMetaClass.$$$reportNull$$$0(20);
        }
        if (iteration == null) {
            YamlMetaClass.$$$reportNull$$$0(21);
        }
        markup.append(":");
        markup.doTabbedBlock(manyNotOne ? 2 : 1, () -> {
            if (markup == null) {
                YamlMetaClass.$$$reportNull$$$0(22);
            }
            if (iteration == null) {
                YamlMetaClass.$$$reportNull$$$0(23);
            }
            markup.newLineAndTabs(manyNotOne);
            List allRequired = this.myFeatures.stream().filter(field -> {
                if (iteration == null) {
                    YamlMetaClass.$$$reportNull$$$0(24);
                }
                return field.isRequired() || iteration.isNextOnPath((Field)field);
            }).collect(Collectors.toList());
            if (allRequired.isEmpty() && iteration.isEndOfPathReached()) {
                markup.appendCaret();
            } else {
                Iterator iterator = allRequired.iterator();
                while (iterator.hasNext()) {
                    Field field2 = (Field)iterator.next();
                    YamlMetaClass.buildCompleteKeyMarkup(markup, field2, iteration.nextIterationFor(field2));
                    if (!iterator.hasNext()) continue;
                    markup.newLineAndTabs();
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaClass";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 17: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addStringFeature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addBooleanFeature";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addScalarFeature";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addObjectFeature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFeatureByName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStringFeature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBooleanFeature";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addScalarFeature";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addObjectFeature";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFeature";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildInsertionSuffixMarkup";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateKeyValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doBuildInsertionSuffixMarkup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doBuildInsertionSuffixMarkup$2";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFeatureByName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

