/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import org.netbeans.lib.cvsclient.command.IFileInfo;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class DefaultFileInfo
implements IFileInfo {
    private final FileObject fileObject;
    private final File file;

    public DefaultFileInfo(FileObject fileObject, File file) {
        BugLog.getInstance().assertNotNull(fileObject);
        BugLog.getInstance().assertNotNull(file);
        this.fileObject = fileObject;
        this.file = file;
    }

    @Override
    public FileObject getFileObject() {
        return this.fileObject;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.isDirectory()) {
            buffer.append("Directory ");
        }
        buffer.append(this.file != null ? this.file.getAbsolutePath() : "null");
        return buffer.toString();
    }

    public File getFile() {
        return this.file;
    }

    private boolean isDirectory() {
        File file = this.getFile();
        if (file == null) {
            return false;
        }
        return file.isDirectory();
    }
}

