/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception.run;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.codeception.CodeceptionBundle;
import com.jetbrains.php.codeception.CodeceptionFrameworkType;
import com.jetbrains.php.codeception.CodeceptionUtil;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeceptionRunConfigurationHandler
implements PhpTestRunConfigurationHandler {
    private static final String HELPER_ENV_EXE = "IDE_CODECEPTION_EXE";
    private static final String HELPER_ENV_SCRIPT_PREFIX = "IDE_SCRIPT_PREFIX";
    private static final CodeceptionRunConfigurationHandler ourInstance = new CodeceptionRunConfigurationHandler();

    public static CodeceptionRunConfigurationHandler getInstance() {
        return ourInstance;
    }

    @NotNull
    public String getConfigFileOption() {
        if ("-c" == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(0);
        }
        return "-c";
    }

    public void prepareCommand(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String exe, @Nullable String version) throws ExecutionException {
        if (project == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(2);
        }
        if (exe == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)version) && PhpTestFrameworkVersionDetector.versionCompare((String)version, (String)"2.2.0") < 0) {
            throw new ExecutionException(CodeceptionBundle.message("php.codeception.run.version.is.not.supported", new Object[0]));
        }
        for (String scriptName : CodeceptionUtil.PRINTERS_NAMES) {
            PhpExecutionUtil.loadHelperScriptAndGetText((Project)project, (String)scriptName, (PhpCommandSettings)command, CodeceptionRunConfigurationHandler.class);
        }
        String scriptFile = PhpExecutionUtil.loadHelperScriptAndGetText((Project)project, (String)"codeception.php", (PhpCommandSettings)command, CodeceptionRunConfigurationHandler.class);
        if (StringUtil.isEmpty((String)scriptFile)) {
            String toolName = CodeceptionFrameworkType.getInstance().getDisplayName();
            String message = PhpBundle.message((String)"php.interpreter.base.configuration.interpreter.is.invalid", (Object[])new Object[]{toolName + "tests", toolName});
            throw new ExecutionException(message);
        }
        command.setScript(scriptFile, false);
        command.addArgument("run");
        if (StringUtil.isNotEmpty((String)version) && PhpTestFrameworkVersionDetector.versionCompare((String)version, (String)"2.2.6") >= 0) {
            command.addArgument("--report");
            command.addArgument("-o");
            command.addArgument("reporters: report: PhpStorm_Codeception_ReportPrinter");
        }
        command.addArgument("--no-ansi");
        command.addArgument("--no-interaction");
        command.addEnv(HELPER_ENV_EXE, exe);
        command.addEnv(HELPER_ENV_SCRIPT_PREFIX, command.isRemote() ? "" : "ide-");
    }

    public void runType(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String type, @NotNull String workingDirectory) throws ExecutionException {
        if (project == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(5);
        }
        if (type == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(7);
        }
        if (!"All".equals(type)) {
            command.addArgument(type);
        }
    }

    public void runDirectory(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String directory, @NotNull String workingDirectory) {
        if (project == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(8);
        }
        if (command == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(9);
        }
        if (directory == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(10);
        }
        if (workingDirectory == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(11);
        }
        command.addRelativePathArgument(directory, workingDirectory);
    }

    public void runFile(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String file, @NotNull String workingDirectory) {
        if (project == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(12);
        }
        if (command == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(14);
        }
        if (workingDirectory == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(15);
        }
        command.addRelativePathArgument(file, workingDirectory);
    }

    public void runMethod(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String filePath, @NotNull String methodName, @NotNull String workingDirectory) {
        if (project == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(16);
        }
        if (command == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(18);
        }
        if (methodName == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(19);
        }
        if (workingDirectory == null) {
            CodeceptionRunConfigurationHandler.$$$reportNull$$$0(20);
        }
        command.addRelativePathArgument(filePath, workingDirectory, ":" + methodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/run/CodeceptionRunConfigurationHandler";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exe";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFileOption";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/run/CodeceptionRunConfigurationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

