/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfigurable;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerConnector;
import com.intellij.docker.debug.DockerDebugConnector;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerDeploymentConfigurator;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerRuntimeComparator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.util.PlatformUtils;
import icons.DockerIcons;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCloudType
extends ServerType<DockerCloudConfiguration> {
    public static final String EMPTY_IMAGE_NAME = "<none>:<none>";
    private final DockerRuntimeComparator myRuntimesComparator = new DockerRuntimeComparator();

    public static DockerCloudType getInstance() {
        return (DockerCloudType)((Object)EP_NAME.findExtension(DockerCloudType.class));
    }

    public DockerCloudType() {
        super("docker");
    }

    @NotNull
    public String getPresentableName() {
        String string = DockerBundle.getText("DockerCloudType.presentable.name", new Object[0]);
        if (string == null) {
            DockerCloudType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDeploymentConfigurationTypePresentableName() {
        String string = DockerBundle.getText("DockerCloudType.run.configuration.type.presentable.name", new Object[0]);
        if (string == null) {
            DockerCloudType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DockerIcons.Docker;
        if (icon == null) {
            DockerCloudType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public DockerCloudConfiguration createDefaultConfiguration() {
        DockerCloudConfiguration dockerCloudConfiguration = DockerCloudConfiguration.createDefault();
        if (dockerCloudConfiguration == null) {
            DockerCloudType.$$$reportNull$$$0(3);
        }
        return dockerCloudConfiguration;
    }

    @NotNull
    public RemoteServerConfigurable createServerConfigurable(@NotNull DockerCloudConfiguration configuration) {
        if (configuration == null) {
            DockerCloudType.$$$reportNull$$$0(4);
        }
        DockerCloudConfigurable dockerCloudConfigurable = new DockerCloudConfigurable(configuration);
        if (dockerCloudConfigurable == null) {
            DockerCloudType.$$$reportNull$$$0(5);
        }
        return dockerCloudConfigurable;
    }

    @NotNull
    public DockerDeploymentConfigurator createDeploymentConfigurator(Project project) {
        DockerDeploymentConfigurator dockerDeploymentConfigurator = new DockerDeploymentConfigurator(project);
        if (dockerDeploymentConfigurator == null) {
            DockerCloudType.$$$reportNull$$$0(6);
        }
        return dockerDeploymentConfigurator;
    }

    public List<SingletonDeploymentSourceType> getSingletonDeploymentSourceTypes() {
        return Arrays.asList(new SingletonDeploymentSourceType[]{DockerFileDeploymentSourceType.getInstance(), DockerImageDeploymentSourceType.getInstance(), DockerComposeDeploymentSourceType.getInstance()});
    }

    public boolean mayHaveProjectSpecificDeploymentSources() {
        return false;
    }

    @NotNull
    public ServerConnector<?> createConnector(@NotNull DockerCloudConfiguration configuration, @NotNull ServerTaskExecutor asyncTasksExecutor) {
        if (configuration == null) {
            DockerCloudType.$$$reportNull$$$0(7);
        }
        if (asyncTasksExecutor == null) {
            DockerCloudType.$$$reportNull$$$0(8);
        }
        DockerConnector dockerConnector = new DockerConnector(configuration, asyncTasksExecutor);
        if (dockerConnector == null) {
            DockerCloudType.$$$reportNull$$$0(9);
        }
        return dockerConnector;
    }

    @NotNull
    public Comparator<Deployment> getDeploymentComparator() {
        Comparator comparator = (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            return this.myRuntimesComparator.compare((DockerApplicationRuntime)o1.getRuntime(), (DockerApplicationRuntime)o2.getRuntime());
        };
        if (comparator == null) {
            DockerCloudType.$$$reportNull$$$0(10);
        }
        return comparator;
    }

    public boolean isDebugSupported() {
        return PlatformUtils.isIntelliJ() || PlatformUtils.isRider();
    }

    @Nullable
    public DebugConnector<?, ?> createDebugConnector() {
        if (!this.isDebugSupported()) {
            return null;
        }
        return (DebugConnector)ServiceManager.getService(DockerDebugConnector.class);
    }

    @Nullable
    public String getCustomToolWindowId() {
        return "Docker";
    }

    @NotNull
    public static DeployToServerConfigurationType getRunConfigurationType() {
        DeployToServerConfigurationType deployToServerConfigurationType = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType((ServerType)DockerCloudType.getInstance());
        if (deployToServerConfigurationType == null) {
            DockerCloudType.$$$reportNull$$$0(11);
        }
        return deployToServerConfigurationType;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.settings.docker" == null) {
            DockerCloudType.$$$reportNull$$$0(12);
        }
        return "reference.settings.docker";
    }

    public boolean canAutoDetectConfiguration() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerCloudType";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncTasksExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentConfigurationTypePresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultConfiguration";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerCloudType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createServerConfigurable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeploymentConfigurator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnector";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentComparator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createServerConfigurable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConnector";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

