/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.ChangeTracker;
import com.intellij.diagram.DiagramChangesProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.PsiChangeTracker;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiFilter;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class UmlDiffElement {
    private final AbstractVcs myVcs;
    private final VcsFileRevision myRevision;
    private final PsiNamedElement myElement;
    private final ChangeTracker myTracker;
    private final FileStatus myStatus;
    private final FilePath myFilePath = null;
    private final Map<PsiNamedElement, FileStatus> myNodeElements = new HashMap<PsiNamedElement, FileStatus>();
    private NodeElementHolder[] myElements = new NodeElementHolder[0];
    private VirtualFile myInitialVirtualFile = null;

    public UmlDiffElement(AbstractVcs vcs, VcsFileRevision revision, VirtualFile initialFile) {
        this(vcs, revision, null, null, null);
        this.myInitialVirtualFile = initialFile;
    }

    public UmlDiffElement(AbstractVcs vcs, VcsFileRevision revision, PsiNamedElement element, ChangeTracker tracker, FileStatus status) {
        this.myVcs = vcs;
        this.myRevision = revision;
        this.myElement = element;
        this.myTracker = tracker;
        this.myStatus = status;
        if (tracker != null) {
            ArrayList<NodeElementHolder> elements = new ArrayList<NodeElementHolder>();
            if (this.myStatus != FileStatus.DELETED) {
                for (PsiFilter filter : tracker.getNodeContentFilters()) {
                    Map map = PsiChangeTracker.getElementsChanged((PsiElement)tracker.getAfter(), (PsiElement)tracker.getBefore(), (PsiFilter)filter);
                    for (PsiNamedElement e : map.keySet()) {
                        elements.add(new NodeElementHolder(e, (FileStatus)map.get(e), tracker));
                    }
                }
            }
            this.myElements = elements.toArray(new NodeElementHolder[0]);
        }
    }

    public NodeElementHolder[] getChanges() {
        ArrayList<NodeElementHolder> result = new ArrayList<NodeElementHolder>();
        for (NodeElementHolder element : this.myElements) {
            if (this.myTracker == null || !this.myTracker.isContainerFor(this.myElement, element.myElement)) continue;
            result.add(element);
        }
        return result.toArray(new NodeElementHolder[0]);
    }

    public ChangeTracker getTracker() {
        return this.myTracker;
    }

    public FileStatus getNodeStatus() {
        return this.myStatus;
    }

    public PsiNamedElement getElement() {
        return this.myElement;
    }

    public String getPresentationName(PsiNamedElement element) {
        return element.getName();
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public VcsFileRevision getRevision() {
        return this.myRevision;
    }

    @Nullable
    public static DiagramChangesProvider acceptChange(Change change) {
        if (change != null) {
            FilePath path;
            ContentRevision after = change.getAfterRevision();
            ContentRevision before = change.getBeforeRevision();
            Object object = after == null ? (before == null ? null : before.getFile()) : (path = after.getFile());
            if (path != null) {
                return DiagramChangesProvider.acceptChange((FileType)path.getFileType(), (String)path.getName());
            }
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return this.myElement == null ? null : this.myElement.getIcon(0);
    }

    public String getNodeName() {
        String name = this.myElement == null ? null : this.myElement.getName();
        return name == null ? "" : name;
    }

    public VirtualFile getInitialVirtualFile() {
        return this.myInitialVirtualFile;
    }

    public static class NodeElementHolder
    implements Iconable {
        private final PsiNamedElement myElement;
        private final ChangeTracker myTracker;
        private final Color myColor;
        private final SimpleColoredText myName;
        private final SimpleColoredText myType;

        NodeElementHolder(PsiNamedElement element, FileStatus status, ChangeTracker tracker) {
            this.myElement = element;
            this.myTracker = tracker;
            this.myColor = status.getColor();
            this.myName = new SimpleColoredText(this.myTracker.getPresentableName(this.myElement), new SimpleTextAttributes(1, this.myColor));
            String type = this.myTracker.getType(this.myElement);
            this.myType = type != null ? new SimpleColoredText(type, new SimpleTextAttributes(1, this.myColor)) : null;
        }

        public SimpleColoredText getName() {
            return this.myName;
        }

        public Icon getIcon(int flags) {
            return this.myTracker.getIcon(this.myElement);
        }

        public SimpleColoredText getType() {
            return this.myType;
        }
    }
}

