/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.OptionalSqlClause;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.IngresDialect;

public class IngresDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private IngresDialectHelper _dialect = new IngresDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database")) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return false;
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 6) {
            return 53;
        }
        return 31;
    }

    @Override
    public String getDisplayName() {
        return "Ingres";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase().startsWith("ingres");
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String dropClause = "DROP COLUMN";
        String constraintClause = "CASCADE";
        return DialectUtils.getColumnDropSQL(tableName, columnName, dropClause, true, constraintClause, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, false, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        String alterClause = "ALTER COLUMN";
        for (int i = 0; i < columns.length; ++i) {
            TableColumnInfo info = columns[i];
            String notNullSQL = DialectUtils.getColumnNullableAlterSQL(info, false, this, alterClause, true, qualifier, prefs);
            result.add(notNullSQL);
        }
        result.add(DialectUtils.getAddPrimaryKeySQL(ti, pkName, columns, false, qualifier, prefs, this));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        return DialectUtils.getColumnCommentAlterSQL(info, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 4;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsRenameColumn() {
        return false;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 3;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        String alterClause = "ALTER COLUMN";
        String setClause = "";
        return DialectUtils.getColumnTypeAlterSQL(this, alterClause, setClause, false, from, to, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        String defaultClause = "DEFAULT";
        return DialectUtils.getColumnDefaultAlterSQL(this, info, alterClause, true, defaultClause, qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, true, true, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.INGRES;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return null;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String msg = DialectUtils.getUnsupportedMessage(this, 21);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean addDefaultClause = false;
        boolean supportsNullQualifier = false;
        boolean addNullClause = false;
        String sql = DialectUtils.getAddColumSQL(column, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs);
        result.add(sql);
        StringTemplate st = new StringTemplate("MODIFY $tableName$ TO RECONSTRUCT");
        result.add(DialectUtils.bindTemplateAttributes(this, st, DialectUtils.getValuesMap("tableName", column.getTableName()), qualifier, prefs));
        if (column.isNullable().equals("NO")) {
            result.add(this.getColumnDefaultAlterSQL(column, qualifier, prefs));
            result.addAll(Arrays.asList(this.getColumnNullableAlterSQL(column, qualifier, prefs)));
        }
        if (column.getRemarks() != null && !"".equals(column.getRemarks())) {
            result.add(this.getColumnCommentAlterSQL(column, qualifier, prefs));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate fkST = new StringTemplate("ALTER TABLE $childTableName$ ADD $constraint$ $constraintName$ FOREIGN KEY ( $childColumn; separator=\",\"$ ) REFERENCES $parentTableName$ ( $parentColumn; separator=\",\"$ )");
        HashMap<String, String> fkValuesMap = DialectUtils.getValuesMap("childTableName", localTableName);
        fkValuesMap.put("constraint", "CONSTRAINT");
        fkValuesMap.put("constraintName", constraintName);
        fkValuesMap.put("parentTableName", refTableName);
        StringTemplate childIndexST = null;
        HashMap<String, String> ckIndexValuesMap = null;
        if (autoFKIndex) {
            childIndexST = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
            ckIndexValuesMap = new HashMap<String, String>();
            ckIndexValuesMap.put("indexName", "fk_child_idx");
        }
        return DialectUtils.getAddForeignKeyConstraintSQL(fkST, fkValuesMap, childIndexST, ckIndexValuesMap, localRefColumns, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "constraintName", constraintName);
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(st, valuesMap, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER SEQUENCE $sequenceName$ $startWith$ $increment$ $minimum$ $maximum$ $cache$ $cycle$");
        OptionalSqlClause incClause = new OptionalSqlClause("INCREMENT BY", increment);
        OptionalSqlClause minClause = new OptionalSqlClause("MINVALUE", minimum);
        OptionalSqlClause maxClause = new OptionalSqlClause("MAXVALUE", maximum);
        OptionalSqlClause cacheClause = new OptionalSqlClause("CACHE", cache);
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName, "increment", incClause, "minimum", minClause, "maximum", maxClause, "cache", cacheClause);
        if (cycle) {
            valuesMap.put("cycle", "CYCLE");
        }
        return new String[]{DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs)};
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return null;
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE SEQUENCE $sequenceName$ $startWith$ $increment$ $minimum$ $maximum$ $cache$ $cycle$");
        OptionalSqlClause incClause = new OptionalSqlClause("INCREMENT BY", increment);
        OptionalSqlClause minClause = new OptionalSqlClause("MINVALUE", minimum);
        OptionalSqlClause maxClause = new OptionalSqlClause("MAXVALUE", maximum);
        OptionalSqlClause cacheClause = new OptionalSqlClause("CACHE", cache);
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName, "increment", incClause, "minimum", minClause, "maximum", maxClause, "cache", cacheClause);
        if (cycle) {
            valuesMap.put("cycle", "CYCLE");
        }
        return DialectUtils.getCreateSequenceSQL(st, valuesMap, qualifier, prefs, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE VIEW $viewName$ AS $selectStatement$ $with$ $checkOptionType$ $checkOption$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName, "selectStatement", definition);
        if (checkOption != null) {
            valuesMap.put("withcheckOption", "WITH CHECK OPTION");
        }
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return null;
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return null;
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP SEQUENCE $sequenceName$ $cascade$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP VIEW $viewName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String valuesPart, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, valuesPart, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 9;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 11;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String result = "SELECT next_value-1, max_value, min_value, cache_size, increment_value, case     when cycle_flag = 'Y'     then 1     else 0 end FROM iisequences where seq_name = ?";
        return result;
    }

    @Override
    public String[] getUpdateSQL(String tableName, String[] setColumns, String[] setValues, String[] fromTables, String[] whereColumns, String[] whereValues, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("UPDATE $destTableName$ SET $columnName$ = (SELECT $columnName$ FROM $sourceTableName$ where $sourceTableName$.$whereColumnName$ = $destTableName$.$whereValue$)");
        return DialectUtils.getUpdateSQL(st, tableName, setColumns, setValues, fromTables, whereColumns, whereValues, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return false;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT TEXT_SEGMENT FROM IIVIEWS ");
        result.append("WHERE TABLE_NAME = '");
        result.append(viewName);
        result.append("' AND TABLE_OWNER = '");
        result.append(qualifier.getSchema());
        result.append("'");
        return result.toString();
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    private class IngresDialectHelper
    extends IngresDialect {
        public IngresDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 8000, "byte($l)");
            this.registerColumnType(-2, "long byte");
            this.registerColumnType(-7, "tinyint");
            this.registerColumnType(2004, "long byte");
            this.registerColumnType(16, "tinyint");
            this.registerColumnType(1, 2000, "char($l)");
            this.registerColumnType(1, "long varchar");
            this.registerColumnType(2005, "long varchar");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p, $s)");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, "long byte");
            this.registerColumnType(-1, "long varchar");
            this.registerColumnType(2, "numeric($p, $s)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "date");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, "long byte");
            this.registerColumnType(12, 4000, "varchar($l)");
            this.registerColumnType(12, "long varchar");
        }
    }
}

