/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.style.I18n;
import writer2latex.latex.style.StyleMap;
import writer2latex.util.BooleanOption;
import writer2latex.util.IntegerOption;
import writer2latex.util.Misc;
import writer2latex.util.Option;
import writer2latex.xhtml.XhtmlStyleMap;
import writer2latex.xmerge.NewDOMDocument;

public class Config {
    public static final int GENERIC = 0;
    public static final int DVIPS = 1;
    public static final int PDFTEX = 2;
    public static final int IGNORE_ALL = 0;
    public static final int IGNORE_MOST = 1;
    public static final int CONVERT_BASIC = 2;
    public static final int CONVERT_MOST = 3;
    public static final int CONVERT_ALL = 4;
    public static final int CONVERT_HEADER_FOOTER = 5;
    private static final int CREATE_USER_CONFIG = 0;
    private static final int BACKEND = 1;
    private static final int NO_PREAMBLE = 2;
    private static final int DOCUMENTCLASS = 3;
    private static final int GLOBAL_OPTIONS = 4;
    private static final int INPUTENCODING = 5;
    private static final int MULTILINGUAL = 6;
    private static final int GREEK_MATH = 7;
    private static final int USE_OOOMATH = 8;
    private static final int USE_PIFONT = 9;
    private static final int USE_IFSYM = 10;
    private static final int USE_WASYSYM = 11;
    private static final int USE_BBDING = 12;
    private static final int USE_EUROSYM = 13;
    private static final int USE_TIPA = 14;
    private static final int USE_COLOR = 15;
    private static final int USE_HYPERREF = 16;
    private static final int USE_ENDNOTES = 17;
    private static final int USE_ULEM = 18;
    private static final int USE_LASTPAGE = 19;
    private static final int USE_BIBTEX = 20;
    private static final int BIBTEX_STYLE = 21;
    private static final int FORMATTING = 22;
    private static final int PAGE_FORMATTING = 23;
    private static final int IGNORE_HARD_PAGE_BREAKS = 24;
    private static final int IGNORE_HARD_LINE_BREAKS = 25;
    private static final int IGNORE_EMPTY_PARAGRAPHS = 26;
    private static final int IGNORE_DOUBLE_SPACES = 27;
    private static final int XHTML_NO_DOCTYPE = 28;
    private static final int XHTML_CUSTOM_STYLESHEET = 29;
    private static final int XHTML_IGNORE_STYLES = 30;
    private static final int XHTML_USE_DUBLIN_CORE = 31;
    private static final int XHTML_CONVERT_TO_PX = 32;
    private static final int XHTML_SCALING = 33;
    private static final int XHTML_COLUMN_SCALING = 34;
    private static final int XHTML_SPLIT_LEVEL = 35;
    private static final int XHTML_CALC_SPLIT = 36;
    private static final int DEBUG = 37;
    private static final int OPTION_COUNT = 38;
    Option[] options = new Option[38];
    protected boolean bDebug = false;
    protected LinkedList customPreamble = new LinkedList();
    protected StyleMap par = new StyleMap();
    protected StyleMap parBlock = new StyleMap();
    protected StyleMap text = new StyleMap();
    protected StyleMap list = new StyleMap();
    protected StyleMap listItem = new StyleMap();
    protected HeadingMap headingMap = new HeadingMap(5);
    protected XhtmlStyleMap xpar = new XhtmlStyleMap();
    protected XhtmlStyleMap xtext = new XhtmlStyleMap();
    protected XhtmlStyleMap xframe = new XhtmlStyleMap();
    protected XhtmlStyleMap xlist = new XhtmlStyleMap();
    protected XhtmlStyleMap xattr = new XhtmlStyleMap();
    protected Hashtable mathSymbols = new Hashtable();

    public Config() {
        this.options[0] = new BooleanOption("create_user_config", "true");
        this.options[2] = new BooleanOption("no_preamble", "false");
        this.options[3] = new Option("documentclass", "article");
        this.options[4] = new Option("global_options", "");
        this.options[1] = new IntegerOption("backend", "generic"){

            void setString(String sValue) {
                super.setString(sValue);
                if ("generic".equals(sValue)) {
                    this.nValue = 0;
                } else if ("dvips".equals(sValue)) {
                    this.nValue = 1;
                } else if ("pdftex".equals(sValue)) {
                    this.nValue = 2;
                }
            }
        };
        this.options[5] = new IntegerOption("inputencoding", I18n.writeInputenc(0)){

            void setString(String sValue) {
                super.setString(sValue);
                this.nValue = I18n.readInputenc(sValue);
            }
        };
        this.options[6] = new BooleanOption("multilingual", "true");
        this.options[7] = new BooleanOption("greek_math", "true");
        this.options[8] = new BooleanOption("use_ooomath", "false");
        this.options[9] = new BooleanOption("use_pifont", "false");
        this.options[10] = new BooleanOption("use_ifsym", "false");
        this.options[11] = new BooleanOption("use_wasysym", "false");
        this.options[12] = new BooleanOption("use_bbding", "false");
        this.options[13] = new BooleanOption("use_eurosym", "false");
        this.options[14] = new BooleanOption("use_tipa", "false");
        this.options[15] = new BooleanOption("use_color", "true");
        this.options[16] = new BooleanOption("use_hyperref", "true");
        this.options[17] = new BooleanOption("use_endnotes", "false");
        this.options[18] = new BooleanOption("use_ulem", "false");
        this.options[19] = new BooleanOption("use_lastpage", "false");
        this.options[20] = new BooleanOption("use_bibtex", "false");
        this.options[21] = new Option("bibtex_style", "plain");
        this.options[22] = new IntegerOption("formatting", "convert_basic"){

            void setString(String sValue) {
                super.setString(sValue);
                if ("convert_all".equals(sValue)) {
                    this.nValue = 4;
                } else if ("convert_most".equals(sValue)) {
                    this.nValue = 3;
                } else if ("convert_basic".equals(sValue)) {
                    this.nValue = 2;
                } else if ("ignore_most".equals(sValue)) {
                    this.nValue = 1;
                } else if ("ignore_all".equals(sValue)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[23] = new IntegerOption("page_formatting", "convert_all"){

            void setString(String sValue) {
                super.setString(sValue);
                if ("convert_all".equals(sValue)) {
                    this.nValue = 4;
                } else if ("convert_header_footer".equals(sValue)) {
                    this.nValue = 5;
                } else if ("ignore_all".equals(sValue)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[24] = new BooleanOption("ignore_hard_page_breaks", "false");
        this.options[25] = new BooleanOption("ignore_hard_line_breaks", "false");
        this.options[26] = new BooleanOption("ignore_empty_paragraphs", "false");
        this.options[27] = new BooleanOption("ignore_double_spaces", "false");
        this.options[28] = new BooleanOption("xhtml_no_doctype", "false");
        this.options[29] = new Option("xhtml_custom_stylesheet", "");
        this.options[30] = new BooleanOption("xhtml_ignore_styles", "false");
        this.options[31] = new BooleanOption("xhtml_use_dublin_core", "true");
        this.options[32] = new BooleanOption("xhtml_convert_to_px", "true");
        this.options[33] = new Option("xhtml_scaling", "100%");
        this.options[34] = new Option("xhtml_column_scaling", "100%");
        this.options[35] = new IntegerOption("xhtml_split_level", "0"){

            void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[36] = new BooleanOption("xhtml_calc_split", "false");
        this.options[37] = new BooleanOption("debug", "false");
        this.headingMap.setLevelData(1, "section", 1);
        this.headingMap.setLevelData(2, "subsection", 2);
        this.headingMap.setLevelData(3, "subsubsection", 3);
        this.headingMap.setLevelData(4, "paragraph", 4);
        this.headingMap.setLevelData(5, "subparagraph", 5);
        String s = this.getClass().getResource("Config.class").toString();
        String sPath = s.substring(s.indexOf("file:"), s.indexOf("writer2latex.jar!"));
        String sDefaultConfig = sPath + "writer2latex.xml";
        try {
            File f = new File(new URI(sDefaultConfig));
            if (f.exists()) {
                this.read(f.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sUserConfig = System.getProperty("user.home") + System.getProperty("file.separator") + "writer2latex.xml";
        File f = new File(sUserConfig);
        if (f.exists()) {
            this.read(sUserConfig);
        } else if (this.createUserConfig()) {
            this.write(sUserConfig);
        }
    }

    public void read(String sFileName) {
        NewDOMDocument doc = new NewDOMDocument(sFileName, ".xml");
        try {
            doc.read(new FileInputStream(sFileName));
        }
        catch (IOException e) {
            System.out.println("Oops - I cannot read the configuration file " + sFileName);
            e.printStackTrace();
            return;
        }
        Document dom = doc.getContentDOM();
        if (dom == null) {
            System.out.println("Oops - I cannot understand the contents of the configuration file " + sFileName);
            return;
        }
        Element root = dom.getDocumentElement();
        if (!root.hasChildNodes()) {
            return;
        }
        NodeList nl = root.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName;
                String sChildName = child.getNodeName();
                if (sChildName.equals("option")) {
                    sName = Misc.getAttribute(child, "name");
                    String sValue = Misc.getAttribute(child, "value");
                    int j = 0;
                    while (j < 38) {
                        if (this.options[j].getName().equals(sName)) {
                            this.options[j].setString(sValue);
                            break;
                        }
                        ++j;
                    }
                } else if (sChildName.equals("style-map")) {
                    sName = Misc.getAttribute(child, "name");
                    String sClass = Misc.getAttribute(child, "class");
                    String sBefore = Misc.getAttribute(child, "before");
                    String sAfter = Misc.getAttribute(child, "after");
                    boolean bLineBreak = !"false".equals(Misc.getAttribute(child, "line-break"));
                    boolean bVerbatim = "true".equals(Misc.getAttribute(child, "verbatim"));
                    if ("paragraph".equals(sClass)) {
                        this.par.put(sName, sBefore, sAfter, bLineBreak, bVerbatim);
                    }
                    if ("paragraph-block".equals(sClass)) {
                        String sNext = Misc.getAttribute(child, "next");
                        this.parBlock.put(sName, sBefore, sAfter, sNext);
                    } else if ("text".equals(sClass)) {
                        this.text.put(sName, sBefore, sAfter, false, bVerbatim);
                    } else if ("list".equals(sClass)) {
                        this.list.put(sName, sBefore, sAfter);
                    } else if ("listitem".equals(sClass)) {
                        this.listItem.put(sName, sBefore, sAfter);
                    }
                } else if (sChildName.equals("heading-map")) {
                    this.readHeadingMap(child);
                } else if (sChildName.equals("custom-preamble")) {
                    if (child.hasChildNodes()) {
                        NodeList subNl = child.getChildNodes();
                        int nSubLen = subNl.getLength();
                        int j = 0;
                        while (j < nSubLen) {
                            Node subChild = subNl.item(j);
                            if (subChild.getNodeType() == 3) {
                                this.customPreamble.add(subChild.getNodeValue());
                            }
                            ++j;
                        }
                    }
                } else if (sChildName.equals("xhtml-style-map")) {
                    String sCss;
                    String sElement;
                    String sBlockCss;
                    sName = Misc.getAttribute(child, "name");
                    String sClass = Misc.getAttribute(child, "class");
                    String sBlockElement = Misc.getAttribute(child, "block-element");
                    if (sBlockElement == null) {
                        sBlockElement = "";
                    }
                    if ((sBlockCss = Misc.getAttribute(child, "block-css")) == null) {
                        sBlockCss = "(none)";
                    }
                    if ((sElement = Misc.getAttribute(child, "element")) == null) {
                        sElement = "";
                    }
                    if ((sCss = Misc.getAttribute(child, "css")) == null) {
                        sCss = "(none)";
                    }
                    if ("paragraph".equals(sClass)) {
                        this.xpar.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("text".equals(sClass)) {
                        this.xtext.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("frame".equals(sClass)) {
                        this.xframe.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("list".equals(sClass)) {
                        this.xlist.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("attribute".equals(sClass)) {
                        this.xattr.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    }
                } else if (sChildName.equals("math-symbol-map")) {
                    sName = Misc.getAttribute(child, "name");
                    String sLatex = Misc.getAttribute(child, "latex");
                    this.mathSymbols.put(sName, sLatex);
                }
            }
            ++i;
        }
    }

    public void readHeadingMap(Node node) {
        int nMaxLevel = Misc.getPosInteger(Misc.getAttribute(node, "max-level"), 0);
        this.headingMap.reset(nMaxLevel);
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            String sChildName;
            Node child = nl.item(i);
            if (child.getNodeType() == 1 && (sChildName = child.getNodeName()).equals("heading-level-map")) {
                int nWriterLevel = Misc.getPosInteger(Misc.getAttribute(child, "writer-level"), 1);
                String sName = Misc.getAttribute(child, "name");
                int nLevel = Misc.getPosInteger(Misc.getAttribute(child, "level"), 0);
                this.headingMap.setLevelData(nWriterLevel, sName, nLevel);
            }
            ++i;
        }
    }

    public void write(String sFileName) {
        NewDOMDocument doc = new NewDOMDocument(sFileName, ".xml");
        Document dom = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            dom = domImpl.createDocument("", "config", null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Element rootElement = dom.getDocumentElement();
        int i = 0;
        while (i < 38) {
            Element optionNode = dom.createElement("option");
            optionNode.setAttribute("name", this.options[i].getName());
            optionNode.setAttribute("value", this.options[i].getString());
            rootElement.appendChild(optionNode);
            ++i;
        }
        Enumeration msEnum = this.mathSymbols.keys();
        while (msEnum.hasMoreElements()) {
            String sName = (String)msEnum.nextElement();
            String sLatex = (String)this.mathSymbols.get(sName);
            Element msNode = dom.createElement("math-symbol-map");
            msNode.setAttribute("name", sName);
            msNode.setAttribute("latex", sLatex);
            rootElement.appendChild(msNode);
        }
        this.writeStyleMap(dom, this.par, "paragraph");
        this.writeStyleMap(dom, this.parBlock, "paragraph-block");
        this.writeStyleMap(dom, this.text, "text");
        this.writeStyleMap(dom, this.list, "list");
        this.writeStyleMap(dom, this.listItem, "listitem");
        Element hmNode = dom.createElement("heading-map");
        hmNode.setAttribute("max-level", Integer.toString(this.headingMap.getMaxLevel()));
        rootElement.appendChild(hmNode);
        int i2 = 1;
        while (i2 <= this.headingMap.getMaxLevel()) {
            Element hlmNode = dom.createElement("heading-level-map");
            hlmNode.setAttribute("writer-level", Integer.toString(i2));
            hlmNode.setAttribute("name", this.headingMap.getName(i2));
            hlmNode.setAttribute("level", Integer.toString(this.headingMap.getLevel(i2)));
            hmNode.appendChild(hlmNode);
            ++i2;
        }
        this.writeXStyleMap(dom, this.xpar, "paragraph");
        this.writeXStyleMap(dom, this.xtext, "text");
        this.writeXStyleMap(dom, this.xlist, "list");
        this.writeXStyleMap(dom, this.xframe, "frame");
        this.writeXStyleMap(dom, this.xframe, "attribute");
        this.writeContent(dom, this.customPreamble, "custom-preamble");
        doc.setContentDOM(dom);
        try {
            doc.write(new FileOutputStream(sFileName));
        }
        catch (IOException e) {
            System.out.println("Oops - problem writing the configuration");
            e.printStackTrace();
        }
    }

    public boolean createUserConfig() {
        return ((BooleanOption)this.options[0]).getValue();
    }

    public boolean debug() {
        return ((BooleanOption)this.options[37]).getValue();
    }

    public String getDocumentclass() {
        return this.options[3].getString();
    }

    public String getGlobalOptions() {
        return this.options[4].getString();
    }

    public int getBackend() {
        return ((IntegerOption)this.options[1]).getValue();
    }

    public int getInputencoding() {
        return ((IntegerOption)this.options[5]).getValue();
    }

    public boolean multilingual() {
        return ((BooleanOption)this.options[6]).getValue();
    }

    public boolean greekMath() {
        return ((BooleanOption)this.options[7]).getValue();
    }

    public boolean noPreamble() {
        return ((BooleanOption)this.options[2]).getValue();
    }

    public boolean useOoomath() {
        return ((BooleanOption)this.options[8]).getValue();
    }

    public boolean usePifont() {
        return ((BooleanOption)this.options[9]).getValue();
    }

    public boolean useIfsym() {
        return ((BooleanOption)this.options[10]).getValue();
    }

    public boolean useWasysym() {
        return ((BooleanOption)this.options[11]).getValue();
    }

    public boolean useBbding() {
        return ((BooleanOption)this.options[12]).getValue();
    }

    public boolean useEurosym() {
        return ((BooleanOption)this.options[13]).getValue();
    }

    public boolean useTipa() {
        return ((BooleanOption)this.options[14]).getValue();
    }

    public boolean useColor() {
        return ((BooleanOption)this.options[15]).getValue();
    }

    public boolean useHyperref() {
        return ((BooleanOption)this.options[16]).getValue();
    }

    public boolean useEndnotes() {
        return ((BooleanOption)this.options[17]).getValue();
    }

    public boolean useUlem() {
        return ((BooleanOption)this.options[18]).getValue();
    }

    public boolean useLastpage() {
        return ((BooleanOption)this.options[19]).getValue();
    }

    public boolean useBibtex() {
        return ((BooleanOption)this.options[20]).getValue();
    }

    public String bibtexStyle() {
        return this.options[21].getString();
    }

    public int formatting() {
        return ((IntegerOption)this.options[22]).getValue();
    }

    public int pageFormatting() {
        return ((IntegerOption)this.options[23]).getValue();
    }

    public boolean ignoreHardPageBreaks() {
        return ((BooleanOption)this.options[24]).getValue();
    }

    public boolean ignoreHardLineBreaks() {
        return ((BooleanOption)this.options[25]).getValue();
    }

    public boolean ignoreEmptyParagraphs() {
        return ((BooleanOption)this.options[26]).getValue();
    }

    public boolean ignoreDoubleSpaces() {
        return ((BooleanOption)this.options[27]).getValue();
    }

    public boolean xhtmlNoDoctype() {
        return ((BooleanOption)this.options[28]).getValue();
    }

    public String xhtmlCustomStylesheet() {
        return this.options[29].getString();
    }

    public boolean xhtmlIgnoreStyles() {
        return ((BooleanOption)this.options[30]).getValue();
    }

    public boolean xhtmlUseDublinCore() {
        return ((BooleanOption)this.options[31]).getValue();
    }

    public boolean xhtmlConvertToPx() {
        return ((BooleanOption)this.options[32]).getValue();
    }

    public String getXhtmlScaling() {
        return this.options[33].getString();
    }

    public String getXhtmlColumnScaling() {
        return this.options[34].getString();
    }

    public int getXhtmlSplitLevel() {
        return ((IntegerOption)this.options[35]).getValue();
    }

    public boolean xhtmlCalcSplit() {
        return ((BooleanOption)this.options[36]).getValue();
    }

    public Hashtable getMathSymbols() {
        return this.mathSymbols;
    }

    public StyleMap getParStyleMap() {
        return this.par;
    }

    public StyleMap getParBlockStyleMap() {
        return this.parBlock;
    }

    public StyleMap getTextStyleMap() {
        return this.text;
    }

    public StyleMap getListStyleMap() {
        return this.list;
    }

    public StyleMap getListItemStyleMap() {
        return this.listItem;
    }

    public HeadingMap getHeadingMap() {
        return this.headingMap;
    }

    public LinkedList getCustomPreamble() {
        return this.customPreamble;
    }

    public XhtmlStyleMap getXParStyleMap() {
        return this.xpar;
    }

    public XhtmlStyleMap getXTextStyleMap() {
        return this.xtext;
    }

    public XhtmlStyleMap getXFrameStyleMap() {
        return this.xframe;
    }

    public XhtmlStyleMap getXListStyleMap() {
        return this.xlist;
    }

    public XhtmlStyleMap getXAttrStyleMap() {
        return this.xattr;
    }

    private void writeStyleMap(Document dom, StyleMap sm, String sClass) {
        Enumeration smEnum = sm.getNames();
        while (smEnum.hasMoreElements()) {
            String sName = (String)smEnum.nextElement();
            Element smNode = dom.createElement("style-map");
            smNode.setAttribute("name", sName);
            smNode.setAttribute("class", sClass);
            smNode.setAttribute("before", sm.getBefore(sName));
            smNode.setAttribute("after", sm.getAfter(sName));
            if (sm.getNext(sName) != null) {
                smNode.setAttribute("next", sm.getNext(sName));
            }
            if (!sm.getLineBreak(sName)) {
                smNode.setAttribute("line-break", "false");
            }
            if (sm.getVerbatim(sName)) {
                smNode.setAttribute("verbatim", "true");
            }
            dom.getDocumentElement().appendChild(smNode);
        }
    }

    private void writeXStyleMap(Document dom, XhtmlStyleMap sm, String sClass) {
        Enumeration smEnum = sm.getNames();
        while (smEnum.hasMoreElements()) {
            String sBlockCss;
            String sName = (String)smEnum.nextElement();
            Element smNode = dom.createElement("xhtml-style-map");
            smNode.setAttribute("name", sName);
            smNode.setAttribute("class", sClass);
            smNode.setAttribute("element", sm.getElement(sName));
            smNode.setAttribute("css", sm.getCss(sName));
            String sBlockElement = sm.getBlockElement(sName);
            if (sBlockElement != null) {
                smNode.setAttribute("block-element", sm.getCss(sBlockElement));
            }
            if ((sBlockCss = sm.getBlockCss(sName)) != null) {
                smNode.setAttribute("block-css", sm.getCss(sBlockCss));
            }
            dom.getDocumentElement().appendChild(smNode);
        }
    }

    private void writeContent(Document dom, LinkedList list, String sElement) {
        Element node = dom.createElement(sElement);
        int nLen = list.size();
        int i = 0;
        while (i < nLen) {
            node.appendChild(dom.createTextNode((String)list.get(i)));
            ++i;
        }
        dom.getDocumentElement().appendChild(node);
    }

    static {
        GENERIC = 0;
        DVIPS = 1;
        PDFTEX = 2;
        IGNORE_ALL = 0;
        IGNORE_MOST = 1;
        CONVERT_BASIC = 2;
        CONVERT_MOST = 3;
        CONVERT_ALL = 4;
        CONVERT_HEADER_FOOTER = 5;
        CREATE_USER_CONFIG = 0;
        BACKEND = 1;
        NO_PREAMBLE = 2;
        DOCUMENTCLASS = 3;
        GLOBAL_OPTIONS = 4;
        INPUTENCODING = 5;
        MULTILINGUAL = 6;
        GREEK_MATH = 7;
        USE_OOOMATH = 8;
        USE_PIFONT = 9;
        USE_IFSYM = 10;
        USE_WASYSYM = 11;
        USE_BBDING = 12;
        USE_EUROSYM = 13;
        USE_TIPA = 14;
        USE_COLOR = 15;
        USE_HYPERREF = 16;
        USE_ENDNOTES = 17;
        USE_ULEM = 18;
        USE_LASTPAGE = 19;
        USE_BIBTEX = 20;
        BIBTEX_STYLE = 21;
        FORMATTING = 22;
        PAGE_FORMATTING = 23;
        IGNORE_HARD_PAGE_BREAKS = 24;
        IGNORE_HARD_LINE_BREAKS = 25;
        IGNORE_EMPTY_PARAGRAPHS = 26;
        IGNORE_DOUBLE_SPACES = 27;
        XHTML_NO_DOCTYPE = 28;
        XHTML_CUSTOM_STYLESHEET = 29;
        XHTML_IGNORE_STYLES = 30;
        XHTML_USE_DUBLIN_CORE = 31;
        XHTML_CONVERT_TO_PX = 32;
        XHTML_SCALING = 33;
        XHTML_COLUMN_SCALING = 34;
        XHTML_SPLIT_LEVEL = 35;
        XHTML_CALC_SPLIT = 36;
        DEBUG = 37;
        OPTION_COUNT = 38;
    }
}

