/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckFilter;

public class DateCheckFilter
extends AbstractDateCheckFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.forLanguageTag("pl"));
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.startsWith("pon")) {
            return 2;
        }
        if (day.startsWith("wt")) {
            return 3;
        }
        if (day.startsWith("\u015br")) {
            return 4;
        }
        if (day.startsWith("czw")) {
            return 5;
        }
        if (day.equals("pt") || day.startsWith("pi\u0105tk") || day.equals("pi\u0105tek")) {
            return 6;
        }
        if (day.startsWith("sob")) {
            return 7;
        }
        if (day.startsWith("niedz")) {
            return 1;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        return date.getDisplayName(7, 2, Locale.forLanguageTag("pl"));
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.equals("stycznia") || monthStr.equals("I")) {
            return 1;
        }
        if (mon.equals("lutego") || monthStr.equals("II")) {
            return 2;
        }
        if (mon.equals("marca") || monthStr.equals("III")) {
            return 3;
        }
        if (mon.equals("kwietnia") || monthStr.equals("IV")) {
            return 4;
        }
        if (mon.equals("maja") || monthStr.equals("V")) {
            return 5;
        }
        if (mon.equals("czerwca") || monthStr.equals("VI")) {
            return 6;
        }
        if (mon.equals("lipca") || monthStr.equals("VII")) {
            return 7;
        }
        if (mon.equals("sierpnia") || monthStr.equals("VIII")) {
            return 8;
        }
        if (mon.equals("wrze\u015bnia") || monthStr.equals("IX")) {
            return 9;
        }
        if (mon.equals("pa\u017adziernika") || monthStr.equals("X")) {
            return 10;
        }
        if (mon.equals("listopada") || monthStr.equals("XI")) {
            return 11;
        }
        if (mon.equals("grudnia") || monthStr.equals("XII")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

