/*
 * Decompiled with CFR 0.152.
 */
package bmsi.util;

import bmsi.util.Diff;
import bmsi.util.UnaryPredicate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DiffPrint {
    static boolean debug = false;

    static String[] slurp(String file) throws IOException {
        String line;
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        ArrayList<String> s = new ArrayList<String>();
        while ((line = rdr.readLine()) != null) {
            s.add(line);
        }
        return s.toArray(new String[s.size()]);
    }

    public static void main(String[] argv) throws IOException {
        String filea = argv[argv.length - 2];
        String fileb = argv[argv.length - 1];
        Object[] a = DiffPrint.slurp(filea);
        Object[] b = DiffPrint.slurp(fileb);
        Diff d = new Diff(a, b);
        int style = 110;
        d.heuristic = false;
        for (int i = 0; i < argv.length - 2; ++i) {
            String f = argv[i];
            if (!f.startsWith("-")) continue;
            block12: for (int j = 1; j < f.length(); ++j) {
                switch (f.charAt(j)) {
                    case 'H': {
                        d.heuristic = true;
                        continue block12;
                    }
                    case 'e': {
                        style = 101;
                        continue block12;
                    }
                    case 'c': {
                        style = 99;
                        continue block12;
                    }
                    case 'u': {
                        style = 117;
                    }
                }
            }
        }
        boolean reverse = style == 101;
        Diff.change script = d.diff_2(reverse);
        if (script == null) {
            System.err.println("No differences");
        } else {
            Base p;
            switch (style) {
                case 101: {
                    p = new EdPrint(a, b);
                    break;
                }
                case 99: {
                    p = new ContextPrint(a, b);
                    break;
                }
                case 117: {
                    p = new UnifiedPrint(a, b);
                    break;
                }
                default: {
                    p = new NormalPrint(a, b);
                }
            }
            p.print_header(filea, fileb);
            p.print_script(script);
        }
    }

    public static class UnifiedPrint
    extends ContextPrint {
        public UnifiedPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        @Override
        public void print_header(String filea, String fileb) {
            this.print_context_label("---", new File(filea), filea);
            this.print_context_label("+++", new File(fileb), fileb);
        }

        private void print_number_range(int a, int b) {
            if (b < a) {
                this.outfile.print(b + ",0");
            } else {
                super.print_number_range(',', a, b);
            }
        }

        @Override
        protected void print_hunk(Diff.change hunk) {
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            if (debug) {
                System.err.printf("%d-%d %d-%d -%d +%d\n", this.first0, this.last0, this.first1, this.last1, this.deletes, this.inserts);
                System.err.println(hunk);
            }
            int i = 0;
            this.first0 = Math.max(this.first0 - this.context, i);
            this.first1 = Math.max(this.first1 - this.context, i);
            this.last0 = Math.min(this.last0 + this.context, this.file0.length - 1);
            this.last1 = Math.min(this.last1 + this.context, this.file1.length - 1);
            this.outfile.print("@@ -");
            this.print_number_range(this.first0, this.last0);
            this.outfile.print(" +");
            this.print_number_range(this.first1, this.last1);
            this.outfile.print(" @@");
            this.print_function(this.file0, this.first0);
            this.outfile.println();
            Diff.change next = hunk;
            i = this.first0;
            int j = this.first1;
            while (i <= this.last0 || j <= this.last1) {
                if (next == null || i < next.line0) {
                    if (i < this.file0.length) {
                        this.outfile.print(this.tab_align_flag);
                        this.print_1_line("", this.file0[i++]);
                    }
                    ++j;
                    continue;
                }
                if (debug) {
                    System.err.printf("%d-%d %d-%d\n", this.first0, this.last0, this.first1, this.last1);
                }
                int k = next.deleted;
                while (k-- > 0) {
                    this.outfile.print('-');
                    if (this.tab_align_flag == '\t') {
                        this.outfile.print('\t');
                    }
                    this.print_1_line("", this.file0[i++]);
                }
                k = next.inserted;
                while (k-- > 0) {
                    this.outfile.print('+');
                    if (this.tab_align_flag == '\t') {
                        this.outfile.print('\t');
                    }
                    this.print_1_line("", this.file1[j++]);
                }
                next = next.link;
            }
        }
    }

    public static class ContextPrint
    extends Base {
        protected int context = 3;
        protected char tab_align_flag = (char)32;

        public ContextPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        @Override
        protected Diff.change find_hunk(Diff.change start) {
            Diff.change prev;
            int thresh;
            int top0;
            do {
                top0 = start.line0 + start.deleted;
                int top1 = start.line1 + start.inserted;
                prev = start;
                start = start.link;
                int n = thresh = prev.ignore || start != null && start.ignore ? this.context : 2 * this.context + 1;
                assert (start == null || start.line0 - top0 == start.line1 - top1);
            } while (start != null && start.line0 < top0 + thresh);
            return prev;
        }

        protected void print_context_label(String mark, File inf, String label) {
            this.setupOutput();
            if (label != null) {
                this.outfile.println(mark + ' ' + label);
            } else if (inf.lastModified() > 0L) {
                this.outfile.println(mark + ' ' + inf.getPath() + '\t' + new Date(inf.lastModified()));
            } else {
                this.outfile.println(mark + ' ' + inf.getPath());
            }
        }

        @Override
        public void print_header(String filea, String fileb) {
            this.print_context_label("***", new File(filea), filea);
            this.print_context_label("---", new File(fileb), fileb);
        }

        protected String find_function(Object[] lines, int start) {
            return null;
        }

        protected void print_function(Object[] file, int start) {
            String function = this.find_function(this.file0, this.first0);
            if (function != null) {
                this.outfile.print(" ");
                this.outfile.print(function.length() < 40 ? function : function.substring(0, 40));
            }
        }

        @Override
        protected void print_hunk(Diff.change hunk) {
            String prefix;
            int i;
            Diff.change next;
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.first0 = Math.max(this.first0 - this.context, 0);
            this.first1 = Math.max(this.first1 - this.context, 0);
            this.last0 = Math.min(this.last0 + this.context, this.file0.length - 1);
            this.last1 = Math.min(this.last1 + this.context, this.file1.length - 1);
            this.outfile.print("***************");
            this.print_function(this.file0, this.first0);
            this.outfile.println();
            this.outfile.print("*** ");
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.println(" ****");
            if (this.deletes != 0) {
                next = hunk;
                for (i = this.first0; i <= this.last0; ++i) {
                    while (next != null && next.line0 + next.deleted <= i) {
                        next = next.link;
                    }
                    prefix = " ";
                    if (next != null && next.line0 <= i) {
                        prefix = next.inserted > 0 ? "!" : "-";
                    }
                    this.print_1_line(prefix, this.file0[i]);
                }
            }
            this.outfile.print("--- ");
            this.print_number_range(',', this.first1, this.last1);
            this.outfile.println(" ----");
            if (this.inserts != 0) {
                next = hunk;
                for (i = this.first1; i <= this.last1; ++i) {
                    while (next != null && next.line1 + next.inserted <= i) {
                        next = next.link;
                    }
                    prefix = " ";
                    if (next != null && next.line1 <= i) {
                        prefix = next.deleted > 0 ? "!" : "+";
                    }
                    this.print_1_line(prefix, this.file1[i]);
                }
            }
        }
    }

    public static class EdPrint
    extends Base {
        public EdPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        @Override
        protected void print_hunk(Diff.change hunk) {
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.println(EdPrint.change_letter(this.inserts, this.deletes));
            if (this.inserts != 0) {
                boolean inserting = true;
                for (int i = this.first1; i <= this.last1; ++i) {
                    if (!inserting) {
                        this.outfile.println(i - this.first1 + this.first0 + "a");
                    }
                    inserting = true;
                    if (".".equals(this.file1[i])) {
                        this.outfile.println("..");
                        this.outfile.println(".");
                        this.outfile.println(i - this.first1 + this.first0 + 1 + "s/^\\.\\././");
                        inserting = false;
                        continue;
                    }
                    this.print_1_line("", this.file1[i]);
                }
                if (inserting) {
                    this.outfile.println(".");
                }
            }
        }
    }

    public static class NormalPrint
    extends Base {
        public NormalPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        @Override
        protected void print_hunk(Diff.change hunk) {
            int i;
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.outfile.print(NormalPrint.change_letter(this.inserts, this.deletes));
            this.print_number_range(',', this.first1, this.last1);
            this.outfile.println();
            if (this.deletes != 0) {
                for (i = this.first0; i <= this.last0; ++i) {
                    this.print_1_line("< ", this.file0[i]);
                }
            }
            if (this.inserts != 0 && this.deletes != 0) {
                this.outfile.println("---");
            }
            if (this.inserts != 0) {
                for (i = this.first1; i <= this.last1; ++i) {
                    this.print_1_line("> ", this.file1[i]);
                }
            }
        }
    }

    public static abstract class Base {
        protected PrintWriter outfile;
        protected UnaryPredicate ignore = null;
        protected Object[] file0;
        protected Object[] file1;
        protected int first0;
        protected int last0;
        protected int first1;
        protected int last1;
        protected int deletes;
        protected int inserts;
        protected List<String> function_regexp_list = new ArrayList<String>();

        public void setOutput(Writer wtr) {
            this.outfile = new PrintWriter(wtr);
        }

        protected void setupOutput() {
            if (this.outfile == null) {
                this.outfile = new PrintWriter(new OutputStreamWriter(System.out));
            }
        }

        protected Base(Object[] a, Object[] b) {
            this.file0 = a;
            this.file1 = b;
        }

        public void print_script(Diff.change script) {
            this.setupOutput();
            Diff.change next = script;
            while (next != null) {
                Diff.change t = next;
                Diff.change end = this.find_hunk(next);
                next = end.link;
                end.link = null;
                this.print_hunk(t);
                end.link = next;
            }
            this.outfile.flush();
        }

        protected Diff.change find_hunk(Diff.change hunk) {
            return hunk;
        }

        protected void analyze_hunk(Diff.change hunk) {
            int l0 = 0;
            int l1 = 0;
            boolean trivial = this.ignore != null;
            int show_to = 0;
            int show_from = 0;
            this.first0 = hunk.line0;
            this.first1 = hunk.line1;
            Diff.change next = hunk;
            while (next != null) {
                int i;
                l0 = next.line0 + next.deleted - 1;
                l1 = next.line1 + next.inserted - 1;
                show_from += next.deleted;
                show_to += next.inserted;
                for (i = next.line0; i <= l0 && trivial; ++i) {
                    if (this.ignore.execute(this.file0[i])) continue;
                    trivial = false;
                }
                for (i = next.line1; i <= l1 && trivial; ++i) {
                    if (this.ignore.execute(this.file1[i])) continue;
                    trivial = false;
                }
                next = next.link;
            }
            this.last0 = l0;
            this.last1 = l1;
            if (trivial) {
                show_to = 0;
                show_from = 0;
            }
            this.deletes = show_from;
            this.inserts = show_to;
        }

        public void print_header(String filea, String fileb) {
            this.setupOutput();
        }

        protected abstract void print_hunk(Diff.change var1);

        protected void print_1_line(String pre, Object linbuf) {
            this.outfile.println(pre + linbuf.toString());
        }

        protected void print_number_range(char sepchar, int a, int b) {
            if (++b > ++a) {
                this.outfile.print("" + a + sepchar + b);
            } else {
                this.outfile.print(b);
            }
        }

        public static char change_letter(int inserts, int deletes) {
            if (inserts == 0) {
                return 'd';
            }
            if (deletes == 0) {
                return 'a';
            }
            return 'c';
        }
    }
}

