/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;

public class SetSerializer<T>
extends CollectionSerializer<Set<T>> {
    private static final Map<TypeSerializer<?>, SetSerializer> instances = new HashMap();
    public final TypeSerializer<T> elements;
    private final Comparator<ByteBuffer> comparator;

    public static synchronized <T> SetSerializer<T> getInstance(TypeSerializer<T> elements, Comparator<ByteBuffer> elementComparator) {
        SetSerializer<T> t = instances.get(elements);
        if (t == null) {
            t = new SetSerializer<T>(elements, elementComparator);
            instances.put(elements, t);
        }
        return t;
    }

    private SetSerializer(TypeSerializer<T> elements, Comparator<ByteBuffer> comparator) {
        this.elements = elements;
        this.comparator = comparator;
    }

    @Override
    public List<ByteBuffer> serializeValues(Set<T> values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.size());
        for (T value : values) {
            buffers.add(this.elements.serialize(value));
        }
        Collections.sort(buffers, this.comparator);
        return buffers;
    }

    @Override
    public int getElementCount(Set<T> value) {
        return value.size();
    }

    @Override
    public void validateForNativeProtocol(ByteBuffer bytes, ProtocolVersion version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = SetSerializer.readCollectionSize(input, version);
            for (int i = 0; i < n; ++i) {
                this.elements.validate(SetSerializer.readValue(input, version));
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after set value");
            }
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public Set<T> deserializeForNativeProtocol(ByteBuffer bytes, ProtocolVersion version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = SetSerializer.readCollectionSize(input, version);
            if (n < 0) {
                throw new MarshalException("The data cannot be deserialized as a set");
            }
            LinkedHashSet<T> l = new LinkedHashSet<T>(Math.min(n, 256));
            for (int i = 0; i < n; ++i) {
                ByteBuffer databb = SetSerializer.readValue(input, version);
                this.elements.validate(databb);
                l.add(this.elements.deserialize(databb));
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after set value");
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public String toString(Set<T> value) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.elements.toString(element));
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Class<Set<T>> getType() {
        return Set.class;
    }
}

