/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.command.Cli;
import io.airlift.command.Command;
import io.airlift.command.Help;
import io.airlift.command.HelpOption;
import io.airlift.command.Option;
import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.StressCQLSSTableWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.stress.StressProfile;
import org.apache.cassandra.stress.WorkManager;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.userdefined.SchemaInsert;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.tools.nodetool.CompactionStats;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;

public abstract class CompactionStress
implements Runnable {
    @Inject
    public HelpOption helpOption;
    @Option(name={"-p", "--profile"}, description="Path to stress yaml file", required=true)
    String profile;
    @Option(name={"-d", "--datadir"}, description="Data directory (can be used many times to specify multiple data dirs)", required=true)
    List<String> dataDirs;
    @Option(name={"-v", "--vnodes"}, description="number of local tokens to generate (default 256)")
    Integer numTokens = 256;

    List<File> getDataDirectories() {
        ArrayList<File> dataDirectories = new ArrayList<File>(this.dataDirs.size());
        for (String dataDir : this.dataDirs) {
            File outputDir = new File(dataDir);
            if (!outputDir.exists()) {
                System.err.println("Invalid output dir (missing): " + outputDir);
                System.exit(1);
            }
            if (!outputDir.isDirectory()) {
                System.err.println("Invalid output dir (not a directory): " + outputDir);
                System.exit(2);
            }
            if (!outputDir.canWrite()) {
                System.err.println("Invalid output dir (no write permissions): " + outputDir);
                System.exit(3);
            }
            dataDirectories.add(outputDir);
        }
        return dataDirectories;
    }

    ColumnFamilyStore initCf(StressProfile stressProfile, boolean loadSSTables) {
        this.generateTokens(stressProfile.seedStr, StorageService.instance.getTokenMetadata(), this.numTokens);
        CreateTableStatement.RawStatement createStatement = stressProfile.getCreateStatement();
        List<File> dataDirectories = this.getDataDirectories();
        ColumnFamilyStore cfs = StressCQLSSTableWriter.Builder.createOfflineTable(createStatement, Collections.EMPTY_LIST, dataDirectories);
        if (loadSSTables) {
            Directories.SSTableLister lister = cfs.getDirectories().sstableLister(Directories.OnTxnErr.IGNORE).skipTemporary(true);
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
            for (Map.Entry entry : lister.list().entrySet()) {
                Set components = (Set)entry.getValue();
                if (!components.contains(Component.DATA)) continue;
                try {
                    SSTableReader sstable = SSTableReader.openNoValidation((Descriptor)((Descriptor)entry.getKey()), (Set)components, (ColumnFamilyStore)cfs);
                    sstables.add(sstable);
                }
                catch (Exception e) {
                    JVMStabilityInspector.inspectThrowable((Throwable)e);
                    System.err.println(String.format("Error Loading %s: %s", entry.getKey(), e.getMessage()));
                }
            }
            cfs.disableAutoCompaction();
            cfs.addSSTables(sstables);
        }
        return cfs;
    }

    StressProfile getStressProfile() {
        try {
            File yamlFile = new File(this.profile);
            return StressProfile.load(yamlFile.exists() ? yamlFile.toURI() : URI.create(this.profile));
        }
        catch (IOError e) {
            e.printStackTrace();
            System.err.print("Invalid profile URI : " + this.profile);
            System.exit(4);
            return null;
        }
    }

    private void generateTokens(String seed, TokenMetadata tokenMetadata, Integer numTokens) {
        Random random = new Random(seed.hashCode());
        IPartitioner p = tokenMetadata.partitioner;
        tokenMetadata.clearUnsafe();
        for (int i = 1; i <= numTokens; ++i) {
            InetAddress addr = FBUtilities.getBroadcastAddress();
            ArrayList tokens = Lists.newArrayListWithCapacity((int)numTokens);
            for (int j = 0; j < numTokens; ++j) {
                tokens.add(p.getRandomToken(random));
            }
            tokenMetadata.updateNormalTokens((Collection)tokens, addr);
        }
    }

    @Override
    public abstract void run();

    void reportCompactionStats() {
        System.out.println("========");
        System.out.println(String.format("Pending compactions: %d\n", CompactionManager.instance.getPendingTasks()));
        CompactionStats.reportCompactionTable((List)CompactionManager.instance.getCompactions(), (int)0, (boolean)true);
    }

    public static void main(String[] args) {
        Cli.CliBuilder builder = Cli.builder((String)"compaction-stress").withDescription("benchmark for compaction").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{DataWriter.class, Compaction.class});
        Cli stress = builder.build();
        try {
            ((Runnable)stress.parse(args)).run();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(6);
        }
        System.exit(0);
    }

    static {
        DatabaseDescriptor.daemonInitialization();
    }

    @Command(name="write", description="write data directly to disk")
    public static class DataWriter
    extends CompactionStress {
        private static double BYTES_IN_GB = 1.063256064E9;
        @Option(name={"-g", "--gbsize"}, description="Total GB size on disk you wish to write", required=true)
        Integer totalSizeGb;
        @Option(name={"-t", "--threads"}, description="Number of sstable writer threads (default 2)")
        Integer threads = 2;
        @Option(name={"-c", "--partition-count"}, description="Number of partitions to loop over (default 1000000)")
        Integer partitions = 1000000;
        @Option(name={"-b", "--buffer-size-mb"}, description="Buffer in MB writes before writing new sstable (default 128)")
        Integer bufferSize = 128;
        @Option(name={"-r", "--range-aware"}, description="Splits the local ranges in number of data directories and makes sure we never write the same token in two different directories (default true)")
        Boolean makeRangeAware = true;

        @Override
        public void run() {
            double currentSizeGB;
            StressProfile stressProfile = this.getStressProfile();
            ColumnFamilyStore cfs = this.initCf(stressProfile, false);
            Directories directories = cfs.getDirectories();
            StressSettings settings = StressSettings.parse(new String[]{"write", "-pop seq=1.." + this.partitions});
            SeedManager seedManager = new SeedManager(settings);
            PartitionGenerator generator = stressProfile.getOfflineGenerator();
            WorkManager.FixedWorkManager workManager = new WorkManager.FixedWorkManager(Long.MAX_VALUE);
            ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
            CountDownLatch finished = new CountDownLatch(this.threads);
            for (int i = 0; i < this.threads; ++i) {
                SchemaInsert insert = stressProfile.getOfflineInsert(null, generator, seedManager, settings);
                StressCQLSSTableWriter tableWriter = insert.createWriter(cfs, this.bufferSize, this.makeRangeAware);
                executorService.submit(() -> {
                    try {
                        insert.runOffline(tableWriter, workManager);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        FileUtils.closeQuietly((Closeable)tableWriter);
                        finished.countDown();
                    }
                });
            }
            while (true) {
                double d;
                currentSizeGB = (double)directories.getRawDiretoriesSize() / BYTES_IN_GB;
                if (!(d < (double)this.totalSizeGb.intValue()) || finished.getCount() == 0L) break;
                System.out.println(String.format("Written %.2fGB of %dGB", currentSizeGB, this.totalSizeGb));
                Uninterruptibles.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            }
            workManager.stop();
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)finished);
            currentSizeGB = (double)directories.getRawDiretoriesSize() / BYTES_IN_GB;
            System.out.println(String.format("Finished writing %.2fGB", currentSizeGB));
        }
    }

    @Command(name="compact", description="Compact data in directory")
    public static class Compaction
    extends CompactionStress {
        @Option(name={"-m", "--maximal"}, description="Force maximal compaction (default true)")
        Boolean maximal = false;
        @Option(name={"-t", "--threads"}, description="Number of compactor threads to use for bg compactions (default 4)")
        Integer threads = 4;

        @Override
        public void run() {
            long working;
            SystemKeyspace.finishStartup();
            CompactionManager.instance.setMaximumCompactorThreads(this.threads.intValue());
            CompactionManager.instance.setCoreCompactorThreads(this.threads.intValue());
            CompactionManager.instance.setRate(0.0);
            StressProfile stressProfile = this.getStressProfile();
            ColumnFamilyStore cfs = this.initCf(stressProfile, true);
            cfs.getCompactionStrategyManager().compactionLogger.enable();
            List futures = new ArrayList(this.threads);
            if (this.maximal.booleanValue()) {
                futures = CompactionManager.instance.submitMaximal(cfs, FBUtilities.nowInSeconds(), false);
            } else {
                cfs.enableAutoCompaction();
                cfs.getCompactionStrategyManager().enable();
                for (int i = 0; i < this.threads; ++i) {
                    futures.addAll(CompactionManager.instance.submitBackground(cfs));
                }
            }
            while ((working = futures.stream().filter(f -> !f.isDone()).count()) > 0L || CompactionManager.instance.getActiveCompactions() > 0 || !this.maximal.booleanValue() && cfs.getCompactionStrategyManager().getEstimatedRemainingTasks() > 0) {
                if (!this.maximal.booleanValue()) {
                    for (long i = working; i < (long)this.threads.intValue(); ++i) {
                        futures.addAll(CompactionManager.instance.submitBackground(cfs));
                    }
                }
                this.reportCompactionStats();
                Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            }
            System.out.println("Finished! Shutting down...");
            CompactionManager.instance.forceShutdown();
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            LifecycleTransaction.removeUnfinishedLeftovers((ColumnFamilyStore)cfs);
        }
    }
}

