/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.powerassert.diagram;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.SourceRangeInfo;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.powerassert.IrUtilsKt;
import org.jetbrains.kotlin.powerassert.diagram.SourceFileKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/powerassert/diagram/SourceFile;", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "source", "", "getSourceRangeInfo", "Lorg/jetbrains/kotlin/ir/SourceRangeInfo;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "getText", "info", "start", "", "end", "getCompilerMessageLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "kotlin-power-assert-compiler-plugin.backend"})
public final class SourceFile {
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final String source;

    public SourceFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.irFile = irFile;
        this.source = StringsKt.replace$default((String)SourceFileKt.access$readSourceText(this.irFile), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
    }

    @NotNull
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final SourceRangeInfo getSourceRangeInfo(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IntRange range = new IntRange(element.getStartOffset(), element.getEndOffset());
        if (element instanceof IrCall) {
            String substring;
            IrExpression receiver;
            IrExpression irExpression = ((IrCall)element).getExtensionReceiver();
            if (irExpression == null) {
                irExpression = receiver = ((IrCall)element).getDispatchReceiver();
            }
            if (((IrSimpleFunction)((IrCall)element).getSymbol().getOwner()).isInfix() && receiver != null && StringsKt.startsWith$default((CharSequence)(substring = this.getText((range = new IntRange(IrUtilsKt.getEarliestStartOffset(element), element.getEndOffset())).getFirst() - 1, receiver.getEndOffset() + 1)), (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)substring, (char)')', (boolean)false, (int)2, null)) {
                range = new IntRange(range.getFirst() - 1, range.getLast());
            }
        }
        return this.irFile.getFileEntry().getSourceRangeInfo(range.getFirst(), range.getLast());
    }

    @NotNull
    public final String getText(@NotNull SourceRangeInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return this.getText(info.getStartOffset(), info.getEndOffset());
    }

    @NotNull
    public final String getText(int start, int end) {
        String string = this.source.substring(Math.max(start, 0), Math.min(end, this.source.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final CompilerMessageLocation getCompilerMessageLocation(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SourceRangeInfo info = this.getSourceRangeInfo(element);
        String lineContent = this.getText(info);
        CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.Companion.create(IrDeclarationsKt.getPath((IrFile)this.irFile), info.getStartLineNumber(), info.getStartColumnNumber(), lineContent);
        Intrinsics.checkNotNull((Object)compilerMessageLocation);
        return compilerMessageLocation;
    }

    @NotNull
    public final IrFile component1() {
        return this.irFile;
    }

    @NotNull
    public final SourceFile copy(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        return new SourceFile(irFile);
    }

    public static /* synthetic */ SourceFile copy$default(SourceFile sourceFile, IrFile irFile, int n, Object object) {
        if ((n & 1) != 0) {
            irFile = sourceFile.irFile;
        }
        return sourceFile.copy(irFile);
    }

    @NotNull
    public String toString() {
        return "SourceFile(irFile=" + this.irFile + ')';
    }

    public int hashCode() {
        return this.irFile.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SourceFile)) {
            return false;
        }
        SourceFile sourceFile = (SourceFile)other;
        return Intrinsics.areEqual((Object)this.irFile, (Object)sourceFile.irFile);
    }
}

