# _build_config.py.in is converted into _build_config.py during the meson build process.

from __future__ import annotations


def build_config() -> dict[str, str]:
    """
    Return a dictionary containing build configuration settings.

    All dictionary keys and values are strings, for example ``False`` is
    returned as ``"False"``.

        .. versionadded:: 1.1.0
    """
    return dict(
        # Python settings
        python_version="3.11",
        python_install_dir=r"/usr/local/lib/python3.11/site-packages/",
        python_path=r"/usr/pkg/bin/python3.11",

        # Package versions
        contourpy_version="1.3.1",
        meson_version="1.7.0",
        mesonpy_version="0.17.1",
        pybind11_version="2.13.6",

        # Misc meson settings
        meson_backend="ninja",
        build_dir=r"/pbulk/work/graphics/py-contourpy/work/contourpy-1.3.1/.mesonpy-dx0w8qw3/lib/contourpy/util",
        source_dir=r"/pbulk/work/graphics/py-contourpy/work/contourpy-1.3.1/lib/contourpy/util",
        cross_build="False",

        # Build options
        build_options=r"-Dbuildtype=release -Db_ndebug=if-release -Db_vscrt=md -Dvsenv=True --native-file=/pbulk/work/graphics/py-contourpy/work/contourpy-1.3.1/.mesonpy-dx0w8qw3/meson-python-native-file.ini",
        buildtype="release",
        cpp_std="c++17",
        debug="False",
        optimization="3",
        vsenv="True",
        b_ndebug="if-release",
        b_vscrt="from_buildtype",

        # C++ compiler
        compiler_name="gcc",
        compiler_version="10.5.0",
        linker_id="ld.bfd",
        compile_command="c++",

        # Host machine
        host_cpu="arm",
        host_cpu_family="arm",
        host_cpu_endian="little",
        host_cpu_system="netbsd",

        # Build machine, same as host machine if not a cross_build
        build_cpu="arm",
        build_cpu_family="arm",
        build_cpu_endian="little",
        build_cpu_system="netbsd",
    )
