/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.TypeCodeHelper;
import gnu.CORBA.Version;
import gnu.CORBA.gnuAny;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CdrEncapsCodecImpl
extends LocalObject
implements Codec {
    private static final long serialVersionUID = 1L;
    private final boolean noWide;
    private final Version version;
    protected final ORB orb;
    private boolean lengthIndicator;

    public String[] _ids() {
        return new String[]{"IDL:gnu/CORBA/cdrEnapsCodec:1.0"};
    }

    public Any decode(byte[] them) throws FormatMismatch {
        BufferredCdrInput input = this.createInput(them);
        BufferredCdrInput encapsulation = this.createEncapsulation(them, input);
        TypeCode type = encapsulation.read_TypeCode();
        try {
            this.checkTypePossibility("", type);
        }
        catch (InvalidTypeForEncoding ex) {
            throw new FormatMismatch(ex.getMessage());
        }
        return this.readAny(type, encapsulation);
    }

    private final BufferredCdrInput createEncapsulation(byte[] them, BufferredCdrInput input) {
        BufferredCdrInput encapsulation;
        if ((them[0] | them[1] | them[2] | them[3]) == 0) {
            encapsulation = input;
            input.read_short();
        } else {
            encapsulation = input.read_encapsulation();
        }
        return encapsulation;
    }

    public byte[] encode(Any that) throws InvalidTypeForEncoding {
        this.checkTypePossibility("", that.type());
        BufferedCdrOutput output = this.createOutput(that);
        AbstractCdrOutput encapsulation = output.createEncapsulation();
        try {
            TypeCodeHelper.write(encapsulation, that.type());
            that.write_value(encapsulation);
            encapsulation.close();
            output.close();
        }
        catch (Exception ex) {
            MARSHAL m = new MARSHAL();
            m.minor = 1195573256;
            m.initCause(ex);
            throw m;
        }
        return output.buffer.toByteArray();
    }

    public Any decode_value(byte[] them, TypeCode type) throws FormatMismatch, TypeMismatch {
        try {
            this.checkTypePossibility("", type);
        }
        catch (InvalidTypeForEncoding ex) {
            throw new TypeMismatch(ex.getMessage());
        }
        BufferredCdrInput input = this.createInput(them);
        BufferredCdrInput encapsulation = this.createEncapsulation(them, input);
        return this.readAny(type, encapsulation);
    }

    private final Any readAny(TypeCode type, BufferredCdrInput encapsulation) throws MARSHAL {
        gnuAny a = new gnuAny();
        a.setOrb(this.orb);
        a.read_value(encapsulation, type);
        return a;
    }

    public byte[] encode_value(Any that) throws InvalidTypeForEncoding {
        this.checkTypePossibility("", that.type());
        BufferedCdrOutput output = this.createOutput(that);
        AbstractCdrOutput encapsulation = output.createEncapsulation();
        try {
            that.write_value(encapsulation);
            encapsulation.close();
            output.close();
        }
        catch (Exception ex) {
            MARSHAL m = new MARSHAL();
            m.minor = 1195573256;
            m.initCause(ex);
            throw m;
        }
        return output.buffer.toByteArray();
    }

    private final BufferedCdrOutput createOutput(Any that) throws InvalidTypeForEncoding {
        BufferedCdrOutput output = new BufferedCdrOutput();
        output.setOrb(this.orb);
        output.setVersion(this.version);
        return output;
    }

    private final void checkTypePossibility(String name, TypeCode t) throws InvalidTypeForEncoding {
        if (this.noWide) {
            try {
                int kind = t.kind().value();
                if (kind == 26 || kind == 27) {
                    throw new InvalidTypeForEncoding(name + " wide char in " + this.version);
                }
                if (kind == 21 || kind == 20 || kind == 19) {
                    this.checkTypePossibility("Array member", t.content_type());
                } else if (kind == 15 || kind == 16) {
                    int i = 0;
                    while (i < t.member_count()) {
                        this.checkTypePossibility(t.member_name(i), t.member_type(i));
                        ++i;
                    }
                }
            }
            catch (UserException ex) {
                InternalError ierr = new InternalError();
                ierr.initCause(ex);
                throw ierr;
            }
        }
    }

    private final BufferredCdrInput createInput(byte[] them) {
        BufferredCdrInput input = new BufferredCdrInput(them);
        input.setOrb(this.orb);
        input.setVersion(this.version);
        return input;
    }

    public boolean hasLengthIndicator() {
        return this.lengthIndicator;
    }

    public void setUseLengthIndicator(boolean use_lengthIndicator) {
        this.lengthIndicator = use_lengthIndicator;
    }

    private final /* synthetic */ void this() {
        this.lengthIndicator = true;
    }

    public CdrEncapsCodecImpl(ORB _orb, Version _version) {
        this.this();
        this.orb = _orb;
        this.version = _version;
        this.noWide = this.version.until_inclusive(1, 0);
    }
}

