#!/usr/bin/sci -t
#
# template.sci - Sample `sci' template
#
@def SCIPARMS   -l -h -s -d
@center Student Billing Program
@center Press Cntrl C to Exit

	Last Name: ...................
	First Name: ...................
	Home Phone: ............
	Work Phone: ............
 	Home Street Address: .........................
	Apt Number: .................
	City: .....................
	State: ..
	Zip Code: ..........
	Email: ...................................
	Monthly fee: ......
# The end of the screen display information is given by this line
# Any line with a lb-sign at the start is a comment or control line
# Lines after the first comment line starting with lb-sign colon are 
# instructions to 'sci' as to the type of entry field.
#
@ifndef DEFCITY
@def DEFCITY Houston
@endif
@ifndef DEFSTATE
@def DEFSTATE Tx
@endif
@ifndef DEFAREACODE
@def DEFAREACODE 770
@endif
#
#:7d@DEFCITY
#:8d@DEFSTATE
#:9d@DEFAREACODE
#:9n
#:11f###.##
#:0Cc
#:7pHouston,Dallas,Los Angeles,Berkeley,Alameda,Biloxi
#:8pAk,Al,Ar,Az,Ca,Cn,Co,Dw,Fl,Ga,Hw,Id,Il,In,Iw,Ks,Ky,La,Ma,Md,Me,Mi,Mn,Mo,Ms,Mt,NC,Nb,ND,NH,NJ,NM,Nv,NY,Oh,Ok,Or,Pn,RI,SC,SD,Tn,Tx,Ut,Va,Vt,Wa,Wi,Wv,Wy
#
#
# The first command "7dHouston" tells 'sci' to place the Default value Houston
# in the seventh (City) field. The user may wipe out this default or tab 
# past it to accept it. The next two commands do the same thing. The zip
# code field allows the user to complete the zip code without having to
# input the 770 common to most Houston zip codes. Defaults are not necessary 
# but are allowed in any field. The next instructs 'sci' to only accept
# numeric values in this fields. Normally 'sci' defaults to alpha-numeric
# input on all fields. This allows some error checking on what goes into
# critical data fields in the resulting database.
#
# A #:1N command allows only numbers to be entered.
#
# The difference between #:1n and #:1N is that the former
# allows '+' '-' or '.' plus numbers while the latter allows
# numbers only to be entered.
#
# A #:1A command would allow the entry of alpha characters only.
#
# A #:1a command would allow the entry of alpha or punctuation
# in the first data entry field. The c and a flags may be used
# with the same field. However if the n and a flags are both used
# in a field no data may be entered into the field since the 
# alpha and numeric fields are mutually exclusive.
#
# The command #:11f###.## is a formatted input. When using
# formatted input data entry is calculator style: from right
# to left. The formatted input requires that the total number of
# periods in the field is the same as the number of formatting
# characters to the right of the f in the command. The numbers
# 0..9 '+' and '-' are the only characters accepted during a 
# formatted input. The decimal point is fixed by the format.
# Default values are ignored in a formatted input field.
# 
# The command #:0Cc turns on color in the input fields. The
# colors are c - cyan, r - red, y - yellow, m - magenta,
# b - blue, g - green, w - white. The field number 0 selects 
# all of the input fields. Individual fields may be given  
# different colors by issuing multiple color commands. For 
# example to set the first field to red and the third field 
# to green the following commands could be given: 
# #:1Cr and #:3Cg.
#
# A #:0bg command would change the background colors for
# the data entry screen. No number other than 0 is allowed for
# this instruction. The color options are the same as for the
# character color options. Pick contrasting colors for 
# visibility.
#
# An input field may be placed in one of two mandatory 
# states by use of the #:1m or #:1M commands. The 'm' 
# version requires at least one character in the field
# before the tab key will exit the field. The 'M' version
# requires that the field be filled in completely before
# the tab key will exit the field. The use of the #:0M 
# command would require each of the fields to be completely
# filled in before the tab key could exit the fields.
#
# A #:1c command would force sci to capitalize every thing in the
# first data entry field. The command #:0c would capitalize all 
# of the data entry fields.
#
# A #:1y command would force the first field to become
# Yes/No field. Yes/No fields are exactly one character
# in length - if a Yes/No field is more than one
# character long it will be reduced to one character in length.
# Yes/No fields may have the capitalization flag ( #:1c ) 
# and mandatory flags ( #:1m or #:1M ) set. Yes/No fields will
# accept only 'y', 'Y', 'n', 'N' characters. A #:0y command
# would make all the fields one character in length.
# 
# It is permitted to have more than one data entry field on
# a line in a sci template.
#
# Starting with revision 0.4.0 the -f flag may be used to 
# change the character used to indicate a data entry field
# in a template.
#
# Starting with revision 0.4.2 a #:0x<path><parms> command
# will allow the command specified by the path to fill in a 
# field as though the user had typed in the data. This would
# be useful if there was a bar code reader program etc. An
# example line would be: 
#
# #:3x/usr/bin/bcode -a
#
# In that example the imaginary program 'bcode' would be 
# passed the '-a' parameter and would pass back the data
# produced on its standard output. The data passed back will
# truncated to the length of the input field or will be 
# ended by the called program exiting or the end of the first
# line of data it outputs. If the program does not exist an
# error message will be given.
#
#
# Starting with revision 0.4.3 two new commands have been
# added: #:0s<path><parms> and #:0S<path><parms>.
# These commands will pipe the data in a field to an 
# executable file. The 'S' version of the command will also
# send the data to the output file while the 's' version will
# only send the data to the executable - leaving the field in
# output data file blank. An example usage would be:
#
# #:3S/bin/cat >> extraout
#
# This command would append the data from the 3rd field to the
# end of the 'extraout' file as well as sending it to the 
# normal sci output file.
#
# Starting with revision 0.4.7 pick Boxes have been added to the
# templates command structure. An example of a pick box is:
#
# #:7pHouston,Dallas,Los Angeles,Berkely,Alemeda,Biloxi
#
# This command would allow the operator to enter one of the
# listed commands by simply selecting it. When the cursor is
# over a pick box data item and the <screenKey> (default is
# the 'Enter' key) is pressed the data is written to the
# field. Pressing the <fieldKey> (default is 'Tab') will exit
# the pick box.
#
# Starting with revision 0.5.1, a simple, m1-like preprocessor
# has been added.  Think of it somewhat like the C language
# pre-processor, except that directives are introduced by
# a `@' in column 1 instead of a `#'.
#
# The following directives are implemented:
#   @include file
#     Process the text appearing in `file' as if it were copied
#     directly into this file.
#
#   @ifdef var
#     Text after this statement (up until the next @else or
#     @endif) is processed only if `var' exists.
#
#   @ifndef var
#     Text after this statement (up until the next @else or
#     @endif) is processed only if `var' does not exist.
#
#   @else
#     Only valid between an @ifdef/@ifndef and @endif pair,
#     works like `else' in shell lingo.
#
#   @endif
#     Ends an @ifdef or @ifndef block.  This works like `fi'
#     in shell lingo.
#
#   @def var [value ...]
#     Sets the value of `var' to the `value' parameters,
#     concatenated.
#
#   @undef var
#     Removes `var' from the namespace.
#
#   @center [text ...]
#     Calculates and pads text so that it will be centered
#     regardless of the terminal width.
#
# Variable substitution can occur anywhere within the file, and
# is invoked by placing a `@' followed by the variable name.
# For example, @HOME will expand to the value of the HOME
# variable.  A pseudo-variable `@' exists, which may be
# referenced as `@@' in the source, which evaluates to a single
# `@' symbol in the output.
#
# The syntax @{HOME} is also valid, and is useful when you
# need to run the right side of the variable name up against
# some other text.
#
# At startup, sci inherits all of the calling shell's exported
# variables (environment variables).  This means you may
# reference any shell variables from the sci script.  Setting
# a variable, however, does not affect the value of the
# calling shell's variable.
#
# Any programs that are started by sci will see the new values
# of the variables.
#
# As of version 0.5.2 command line parameters may be overridden
# with the SCIPARMS environment variable. It is possible to 
# pass the variable using the @def SCIPARMS macro on a 
# template. EXAMPLE
#
# @def SCIPARMS -h -l -d -t -o output.file
#
