/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleFFT_3D {
    private int n1;
    private int n2;
    private int n3;
    private int sliceStride;
    private int rowStride;
    private int[] ip;
    private double[] w;
    private double[] t;
    private DoubleFFT_1D fftn1;
    private DoubleFFT_1D fftn2;
    private DoubleFFT_1D fftn3;
    private int oldNthreads;
    private int nt;

    public DoubleFFT_3D(int n, int n2, int n3) {
        if (!(ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2) && ConcurrencyUtils.isPowerOf2(n3))) {
            throw new IllegalArgumentException("n1, n2 and n3 must be power of two numbers");
        }
        if (n <= 1 || n2 <= 1 || n3 <= 1) {
            throw new IllegalArgumentException("n1, n2 and n3 must be greater than 1");
        }
        this.n1 = n;
        this.n2 = n2;
        this.n3 = n3;
        this.sliceStride = n2 * n3;
        this.rowStride = n3;
        this.ip = new int[2 + (int)Math.ceil(Math.sqrt(Math.max(Math.max(n, n2), n3)))];
        this.w = new double[(int)Math.ceil(Math.max(Math.max(Math.max(n / 2, n2 / 2), n3 / 2), Math.max(Math.max(n / 2, n2 / 2), n3 / 4) + n3 / 4))];
        this.fftn1 = new DoubleFFT_1D(n, this.ip, this.w);
        this.fftn2 = new DoubleFFT_1D(n2, this.ip, this.w);
        this.fftn3 = new DoubleFFT_1D(n3, this.ip, this.w);
        this.oldNthreads = ConcurrencyUtils.getNumberOfProcessors();
        this.nt = n;
        if (this.nt < n2) {
            this.nt = n2;
        }
        this.nt *= 8;
        if (this.oldNthreads > 1) {
            this.nt *= this.oldNthreads;
        }
        if (2 * n3 == 4) {
            this.nt >>= 1;
        } else if (2 * n3 < 4) {
            this.nt >>= 2;
        }
        this.t = new double[this.nt];
    }

    public void complexForward(double[] dArray) {
        int n;
        int n2 = this.n3;
        this.n3 = 2 * this.n3;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
        int n3 = this.n1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if ((n3 <<= 1) < this.n3) {
            n3 = this.n3;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(0, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
        } else {
            this.xdft3da_sub2(0, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
        }
        this.n3 = n2;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
    }

    public void complexForward(double[][][] dArray) {
        int n;
        int n2 = this.n3;
        this.n3 = 2 * this.n3;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
        int n3 = this.n1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if ((n3 <<= 1) < this.n3) {
            n3 = this.n3;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(0, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
        } else {
            this.xdft3da_sub2(0, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
        }
        this.n3 = n2;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
    }

    public void complexInverse(double[] dArray, boolean bl) {
        int n;
        int n2 = this.n3;
        this.n3 = 2 * this.n3;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
        int n3 = this.n1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if ((n3 <<= 1) < this.n3) {
            n3 = this.n3;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(0, 1, dArray, bl);
            this.cdft3db_subth(1, dArray, bl);
        } else {
            this.xdft3da_sub2(0, 1, dArray, bl);
            this.cdft3db_sub(1, dArray, bl);
        }
        this.n3 = n2;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
    }

    public void complexInverse(double[][][] dArray, boolean bl) {
        int n;
        int n2 = this.n3;
        this.n3 = 2 * this.n3;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
        int n3 = this.n1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if ((n3 <<= 1) < this.n3) {
            n3 = this.n3;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(0, 1, dArray, bl);
            this.cdft3db_subth(1, dArray, bl);
        } else {
            this.xdft3da_sub2(0, 1, dArray, bl);
            this.cdft3db_sub(1, dArray, bl);
        }
        this.n3 = n2;
        this.sliceStride = this.n2 * this.n3;
        this.rowStride = this.n3;
    }

    public void realForward(double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if ((n4 <<= 1) < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n3 > (n2 = this.ip[1]) << 2) {
            n2 = this.n3 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth1(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub1(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
    }

    public void realForward(double[][][] dArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if ((n4 <<= 1) < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n3 > (n2 = this.ip[1]) << 2) {
            n2 = this.n3 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth1(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub1(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
    }

    public void realForwardFull(double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.n1;
        if (n11 < this.n2) {
            n11 = this.n2;
        }
        if ((n11 <<= 1) < this.n3) {
            n11 = this.n3;
        }
        if (n11 > (n10 = this.ip[0]) << 2) {
            n10 = n11 >> 2;
            this.makewt(n10);
        }
        if (this.n3 > (n9 = this.ip[1]) << 2) {
            n9 = this.n3 >> 2;
            this.makect(n9, this.w, n10);
        }
        if ((n8 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n8 > 1) {
                this.nt *= n8;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n8;
        }
        if (n8 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub2(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
        int n12 = 2 * this.n3;
        int n13 = this.n2 / 2;
        int n14 = this.n1 / 2;
        int n15 = this.n2 * n12;
        int n16 = n12;
        for (n7 = this.n1 - 1; n7 >= 1; --n7) {
            for (n6 = 0; n6 < this.n2; ++n6) {
                for (n5 = 0; n5 < this.n3; n5 += 2) {
                    n4 = n7 * this.sliceStride + n6 * this.rowStride + n5;
                    n3 = n7 * n15 + n6 * n16 + n5;
                    dArray[n3] = dArray[n4];
                    dArray[n4] = 0.0;
                    dArray[++n3] = dArray[++n4];
                    dArray[n4] = 0.0;
                }
            }
        }
        for (n6 = 1; n6 < this.n2; ++n6) {
            for (n5 = 0; n5 < this.n3; n5 += 2) {
                n4 = (this.n2 - n6) * this.rowStride + n5;
                n3 = (this.n2 - n6) * n16 + n5;
                dArray[n3] = dArray[n4];
                dArray[n4] = 0.0;
                dArray[++n3] = dArray[++n4];
                dArray[n4] = 0.0;
            }
        }
        if (n8 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.fillSymmetric(dArray);
        } else {
            for (n7 = 0; n7 < this.n1; ++n7) {
                for (n6 = 0; n6 < this.n2; ++n6) {
                    for (n5 = 1; n5 < this.n3; n5 += 2) {
                        n4 = (this.n1 - n7) % this.n1 * n15 + (this.n2 - n6) % this.n2 * n16 + n12 - n5;
                        n3 = n7 * n15 + n6 * n16 + n5;
                        dArray[n4] = -dArray[n3 + 2];
                        dArray[n4 - 1] = dArray[n3 + 1];
                    }
                }
            }
            for (n7 = 0; n7 < this.n1; ++n7) {
                for (n6 = 1; n6 < n13; ++n6) {
                    n4 = (this.n1 - n7) % this.n1 * n15 + n6 * n16 + this.n3;
                    n3 = n7 * n15 + (this.n2 - n6) * n16 + this.n3;
                    n2 = n7 * n15 + (this.n2 - n6) * n16 + 1;
                    n = n7 * n15 + (this.n2 - n6) * n16;
                    dArray[n4] = dArray[n2];
                    dArray[n3] = dArray[n2];
                    dArray[n4 + 1] = -dArray[n];
                    dArray[n3 + 1] = dArray[n];
                }
            }
        }
        for (n7 = 0; n7 < this.n1; ++n7) {
            for (n6 = 1; n6 < n13; ++n6) {
                n4 = (this.n1 - n7) % this.n1 * n15 + (this.n2 - n6) * n16;
                n3 = n7 * n15 + n6 * n16;
                dArray[n4] = dArray[n3];
                dArray[n4 + 1] = -dArray[n3 + 1];
            }
        }
        for (n7 = 1; n7 < n14; ++n7) {
            n4 = n7 * n15;
            n3 = (this.n1 - n7) * n15;
            n = n7 * n15 + n13 * n16;
            int n17 = (this.n1 - n7) * n15 + n13 * n16;
            dArray[n4 + this.n3] = dArray[n3 + 1];
            dArray[n3 + this.n3] = dArray[n3 + 1];
            dArray[n4 + this.n3 + 1] = -dArray[n3];
            dArray[n3 + this.n3 + 1] = dArray[n3];
            dArray[n + this.n3] = dArray[n17 + 1];
            dArray[n17 + this.n3] = dArray[n17 + 1];
            dArray[n + this.n3 + 1] = -dArray[n17];
            dArray[n17 + this.n3 + 1] = dArray[n17];
            dArray[n3] = dArray[n4];
            dArray[n3 + 1] = -dArray[n4 + 1];
            dArray[n17] = dArray[n];
            dArray[n17 + 1] = -dArray[n + 1];
        }
        dArray[this.n3] = dArray[1];
        dArray[1] = 0.0;
        n4 = n13 * n16;
        n3 = n14 * n15;
        n2 = n4 + n3;
        dArray[n4 + this.n3] = dArray[n4 + 1];
        dArray[n4 + 1] = 0.0;
        dArray[n3 + this.n3] = dArray[n3 + 1];
        dArray[n3 + 1] = 0.0;
        dArray[n2 + this.n3] = dArray[n2 + 1];
        dArray[n2 + 1] = 0.0;
        dArray[n3 + this.n3 + 1] = 0.0;
        dArray[n2 + this.n3 + 1] = 0.0;
    }

    public void realForwardFull(double[][][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.n1;
        if (n6 < this.n2) {
            n6 = this.n2;
        }
        if ((n6 <<= 1) < this.n3) {
            n6 = this.n3;
        }
        if (n6 > (n5 = this.ip[0]) << 2) {
            n5 = n6 >> 2;
            this.makewt(n5);
        }
        if (this.n3 > (n4 = this.ip[1]) << 2) {
            n4 = this.n3 >> 2;
            this.makect(n4, this.w, n5);
        }
        if ((n3 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n3 > 1) {
                this.nt *= n3;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n3;
        }
        if (n3 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub2(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
        int n7 = 2 * this.n3;
        int n8 = this.n2 / 2;
        int n9 = this.n1 / 2;
        if (n3 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.fillSymmetric(dArray);
        } else {
            for (n2 = 0; n2 < this.n1; ++n2) {
                for (n = 0; n < this.n2; ++n) {
                    for (int i = 1; i < this.n3; i += 2) {
                        dArray[(this.n1 - n2) % this.n1][(this.n2 - n) % this.n2][n7 - i] = -dArray[n2][n][i + 2];
                        dArray[(this.n1 - n2) % this.n1][(this.n2 - n) % this.n2][n7 - i - 1] = dArray[n2][n][i + 1];
                    }
                }
            }
            for (n2 = 0; n2 < this.n1; ++n2) {
                for (n = 1; n < n8; ++n) {
                    dArray[(this.n1 - n2) % this.n1][n][this.n3] = dArray[n2][this.n2 - n][1];
                    dArray[n2][this.n2 - n][this.n3] = dArray[n2][this.n2 - n][1];
                    dArray[(this.n1 - n2) % this.n1][n][this.n3 + 1] = -dArray[n2][this.n2 - n][0];
                    dArray[n2][this.n2 - n][this.n3 + 1] = dArray[n2][this.n2 - n][0];
                }
            }
        }
        for (n2 = 0; n2 < this.n1; ++n2) {
            for (n = 1; n < n8; ++n) {
                dArray[(this.n1 - n2) % this.n1][this.n2 - n][0] = dArray[n2][n][0];
                dArray[(this.n1 - n2) % this.n1][this.n2 - n][1] = -dArray[n2][n][1];
            }
        }
        for (n2 = 1; n2 < n9; ++n2) {
            dArray[n2][0][this.n3] = dArray[this.n1 - n2][0][1];
            dArray[this.n1 - n2][0][this.n3] = dArray[this.n1 - n2][0][1];
            dArray[n2][0][this.n3 + 1] = -dArray[this.n1 - n2][0][0];
            dArray[this.n1 - n2][0][this.n3 + 1] = dArray[this.n1 - n2][0][0];
            dArray[n2][n8][this.n3] = dArray[this.n1 - n2][n8][1];
            dArray[this.n1 - n2][n8][this.n3] = dArray[this.n1 - n2][n8][1];
            dArray[n2][n8][this.n3 + 1] = -dArray[this.n1 - n2][n8][0];
            dArray[this.n1 - n2][n8][this.n3 + 1] = dArray[this.n1 - n2][n8][0];
            dArray[this.n1 - n2][0][0] = dArray[n2][0][0];
            dArray[this.n1 - n2][0][1] = -dArray[n2][0][1];
            dArray[this.n1 - n2][n8][0] = dArray[n2][n8][0];
            dArray[this.n1 - n2][n8][1] = -dArray[n2][n8][1];
        }
        dArray[0][0][this.n3] = dArray[0][0][1];
        dArray[0][0][1] = 0.0;
        dArray[0][n8][this.n3] = dArray[0][n8][1];
        dArray[0][n8][1] = 0.0;
        dArray[n9][0][this.n3] = dArray[n9][0][1];
        dArray[n9][0][1] = 0.0;
        dArray[n9][n8][this.n3] = dArray[n9][n8][1];
        dArray[n9][n8][1] = 0.0;
        dArray[n9][0][this.n3 + 1] = 0.0;
        dArray[n9][n8][this.n3 + 1] = 0.0;
    }

    public void realInverse(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if ((n4 <<= 1) < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n3 > (n2 = this.ip[1]) << 2) {
            n2 = this.n3 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_subth(1, dArray, bl);
            this.xdft3da_subth1(1, 1, dArray, bl);
        } else {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_sub(1, dArray, bl);
            this.xdft3da_sub1(1, 1, dArray, bl);
        }
    }

    public void realInverse(double[][][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if ((n4 <<= 1) < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n3 > (n2 = this.ip[1]) << 2) {
            n2 = this.n3 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_subth(1, dArray, bl);
            this.xdft3da_subth1(1, 1, dArray, bl);
        } else {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_sub(1, dArray, bl);
            this.xdft3da_sub1(1, 1, dArray, bl);
        }
    }

    public void realInverseFull(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.n1;
        if (n11 < this.n2) {
            n11 = this.n2;
        }
        if ((n11 <<= 1) < this.n3) {
            n11 = this.n3;
        }
        if (n11 > (n10 = this.ip[0]) << 2) {
            n10 = n11 >> 2;
            this.makewt(n10);
        }
        if (this.n3 > (n9 = this.ip[1]) << 2) {
            n9 = this.n3 >> 2;
            this.makect(n9, this.w, n10);
        }
        if ((n8 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n8 > 1) {
                this.nt *= n8;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n8;
        }
        if (n8 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(1, 1, dArray, bl);
            this.cdft3db_subth(1, dArray, bl);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub2(1, 1, dArray, bl);
            this.cdft3db_sub(1, dArray, bl);
            this.rdft3d_sub(1, dArray);
        }
        int n12 = 2 * this.n3;
        int n13 = this.n2 / 2;
        int n14 = this.n1 / 2;
        int n15 = this.n2 * n12;
        int n16 = n12;
        for (n7 = this.n1 - 1; n7 >= 1; --n7) {
            for (n6 = 0; n6 < this.n2; ++n6) {
                for (n5 = 0; n5 < this.n3; n5 += 2) {
                    n4 = n7 * this.sliceStride + n6 * this.rowStride + n5;
                    n3 = n7 * n15 + n6 * n16 + n5;
                    dArray[n3] = dArray[n4];
                    dArray[n4] = 0.0;
                    dArray[++n3] = dArray[++n4];
                    dArray[n4] = 0.0;
                }
            }
        }
        for (n6 = 1; n6 < this.n2; ++n6) {
            for (n5 = 0; n5 < this.n3; n5 += 2) {
                n4 = (this.n2 - n6) * this.rowStride + n5;
                n3 = (this.n2 - n6) * n16 + n5;
                dArray[n3] = dArray[n4];
                dArray[n4] = 0.0;
                dArray[++n3] = dArray[++n4];
                dArray[n4] = 0.0;
            }
        }
        if (n8 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.fillSymmetric(dArray);
        } else {
            for (n7 = 0; n7 < this.n1; ++n7) {
                for (n6 = 0; n6 < this.n2; ++n6) {
                    for (n5 = 1; n5 < this.n3; n5 += 2) {
                        n4 = (this.n1 - n7) % this.n1 * n15 + (this.n2 - n6) % this.n2 * n16 + n12 - n5;
                        n3 = n7 * n15 + n6 * n16 + n5;
                        dArray[n4] = -dArray[n3 + 2];
                        dArray[n4 - 1] = dArray[n3 + 1];
                    }
                }
            }
            for (n7 = 0; n7 < this.n1; ++n7) {
                for (n6 = 1; n6 < n13; ++n6) {
                    n4 = (this.n1 - n7) % this.n1 * n15 + n6 * n16 + this.n3;
                    n3 = n7 * n15 + (this.n2 - n6) * n16 + this.n3;
                    n2 = n7 * n15 + (this.n2 - n6) * n16 + 1;
                    n = n7 * n15 + (this.n2 - n6) * n16;
                    dArray[n4] = dArray[n2];
                    dArray[n3] = dArray[n2];
                    dArray[n4 + 1] = -dArray[n];
                    dArray[n3 + 1] = dArray[n];
                }
            }
        }
        for (n7 = 0; n7 < this.n1; ++n7) {
            for (n6 = 1; n6 < n13; ++n6) {
                n4 = (this.n1 - n7) % this.n1 * n15 + (this.n2 - n6) * n16;
                n3 = n7 * n15 + n6 * n16;
                dArray[n4] = dArray[n3];
                dArray[n4 + 1] = -dArray[n3 + 1];
            }
        }
        for (n7 = 1; n7 < n14; ++n7) {
            n4 = n7 * n15;
            n3 = (this.n1 - n7) * n15;
            n = n7 * n15 + n13 * n16;
            int n17 = (this.n1 - n7) * n15 + n13 * n16;
            dArray[n4 + this.n3] = dArray[n3 + 1];
            dArray[n3 + this.n3] = dArray[n3 + 1];
            dArray[n4 + this.n3 + 1] = -dArray[n3];
            dArray[n3 + this.n3 + 1] = dArray[n3];
            dArray[n + this.n3] = dArray[n17 + 1];
            dArray[n17 + this.n3] = dArray[n17 + 1];
            dArray[n + this.n3 + 1] = -dArray[n17];
            dArray[n17 + this.n3 + 1] = dArray[n17];
            dArray[n3] = dArray[n4];
            dArray[n3 + 1] = -dArray[n4 + 1];
            dArray[n17] = dArray[n];
            dArray[n17 + 1] = -dArray[n + 1];
        }
        dArray[this.n3] = dArray[1];
        dArray[1] = 0.0;
        n4 = n13 * n16;
        n3 = n14 * n15;
        n2 = n4 + n3;
        dArray[n4 + this.n3] = dArray[n4 + 1];
        dArray[n4 + 1] = 0.0;
        dArray[n3 + this.n3] = dArray[n3 + 1];
        dArray[n3 + 1] = 0.0;
        dArray[n2 + this.n3] = dArray[n2 + 1];
        dArray[n2 + 1] = 0.0;
        dArray[n3 + this.n3 + 1] = 0.0;
        dArray[n2 + this.n3 + 1] = 0.0;
    }

    public void realInverseFull(double[][][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.n1;
        if (n6 < this.n2) {
            n6 = this.n2;
        }
        if ((n6 <<= 1) < this.n3) {
            n6 = this.n3;
        }
        if (n6 > (n5 = this.ip[0]) << 2) {
            n5 = n6 >> 2;
            this.makewt(n5);
        }
        if (this.n3 > (n4 = this.ip[1]) << 2) {
            n4 = this.n3 >> 2;
            this.makect(n4, this.w, n5);
        }
        if ((n3 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthreads) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 8;
            if (n3 > 1) {
                this.nt *= n3;
            }
            if (this.n3 == 4) {
                this.nt >>= 1;
            } else if (this.n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n3;
        }
        if (n3 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.xdft3da_subth2(1, 1, dArray, bl);
            this.cdft3db_subth(1, dArray, bl);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub2(1, 1, dArray, bl);
            this.cdft3db_sub(1, dArray, bl);
            this.rdft3d_sub(1, dArray);
        }
        int n7 = 2 * this.n3;
        int n8 = this.n2 / 2;
        int n9 = this.n1 / 2;
        if (n3 > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.fillSymmetric(dArray);
        } else {
            for (n2 = 0; n2 < this.n1; ++n2) {
                for (n = 0; n < this.n2; ++n) {
                    for (int i = 1; i < this.n3; i += 2) {
                        dArray[(this.n1 - n2) % this.n1][(this.n2 - n) % this.n2][n7 - i] = -dArray[n2][n][i + 2];
                        dArray[(this.n1 - n2) % this.n1][(this.n2 - n) % this.n2][n7 - i - 1] = dArray[n2][n][i + 1];
                    }
                }
            }
            for (n2 = 0; n2 < this.n1; ++n2) {
                for (n = 1; n < n8; ++n) {
                    dArray[(this.n1 - n2) % this.n1][n][this.n3] = dArray[n2][this.n2 - n][1];
                    dArray[n2][this.n2 - n][this.n3] = dArray[n2][this.n2 - n][1];
                    dArray[(this.n1 - n2) % this.n1][n][this.n3 + 1] = -dArray[n2][this.n2 - n][0];
                    dArray[n2][this.n2 - n][this.n3 + 1] = dArray[n2][this.n2 - n][0];
                }
            }
        }
        for (n2 = 0; n2 < this.n1; ++n2) {
            for (n = 1; n < n8; ++n) {
                dArray[(this.n1 - n2) % this.n1][this.n2 - n][0] = dArray[n2][n][0];
                dArray[(this.n1 - n2) % this.n1][this.n2 - n][1] = -dArray[n2][n][1];
            }
        }
        for (n2 = 1; n2 < n9; ++n2) {
            dArray[n2][0][this.n3] = dArray[this.n1 - n2][0][1];
            dArray[this.n1 - n2][0][this.n3] = dArray[this.n1 - n2][0][1];
            dArray[n2][0][this.n3 + 1] = -dArray[this.n1 - n2][0][0];
            dArray[this.n1 - n2][0][this.n3 + 1] = dArray[this.n1 - n2][0][0];
            dArray[n2][n8][this.n3] = dArray[this.n1 - n2][n8][1];
            dArray[this.n1 - n2][n8][this.n3] = dArray[this.n1 - n2][n8][1];
            dArray[n2][n8][this.n3 + 1] = -dArray[this.n1 - n2][n8][0];
            dArray[this.n1 - n2][n8][this.n3 + 1] = dArray[this.n1 - n2][n8][0];
            dArray[this.n1 - n2][0][0] = dArray[n2][0][0];
            dArray[this.n1 - n2][0][1] = -dArray[n2][0][1];
            dArray[this.n1 - n2][n8][0] = dArray[n2][n8][0];
            dArray[this.n1 - n2][n8][1] = -dArray[n2][n8][1];
        }
        dArray[0][0][this.n3] = dArray[0][0][1];
        dArray[0][0][1] = 0.0;
        dArray[0][n8][this.n3] = dArray[0][n8][1];
        dArray[0][n8][1] = 0.0;
        dArray[n9][0][this.n3] = dArray[n9][0][1];
        dArray[n9][0][1] = 0.0;
        dArray[n9][n8][this.n3] = dArray[n9][n8][1];
        dArray[n9][n8][1] = 0.0;
        dArray[n9][0][this.n3 + 1] = 0.0;
        dArray[n9][n8][this.n3 + 1] = 0.0;
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            double d2 = Math.cos(d * (double)n3);
            this.w[0] = 1.0;
            this.w[1] = d2;
            if (n3 == 4) {
                this.w[2] = Math.cos(d * 2.0);
                this.w[3] = Math.sin(d * 2.0);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = 0.5 / Math.cos(d * 2.0);
                this.w[3] = 0.5 / Math.cos(d * 6.0);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    this.w[n2] = Math.cos(d * (double)n2);
                    this.w[n2 + 1] = Math.sin(d * (double)n2);
                    this.w[n2 + 2] = Math.cos(3.0 * d * (double)n2);
                    this.w[n2 + 3] = -Math.sin(3.0 * d * (double)n2);
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                double d3;
                double d4;
                int n5 = n4 + n3;
                this.w[n5] = 1.0;
                this.w[n5 + 1] = d2;
                if ((n3 >>= 1) == 4) {
                    d4 = this.w[n4 + 4];
                    d3 = this.w[n4 + 5];
                    this.w[n5 + 2] = d4;
                    this.w[n5 + 3] = d3;
                } else if (n3 > 4) {
                    d4 = this.w[n4 + 4];
                    double d5 = this.w[n4 + 6];
                    this.w[n5 + 2] = 0.5 / d4;
                    this.w[n5 + 3] = 0.5 / d5;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        d4 = this.w[n6];
                        d3 = this.w[n6 + 1];
                        d5 = this.w[n6 + 2];
                        double d6 = this.w[n6 + 3];
                        this.w[n7] = d4;
                        this.w[n7 + 1] = d3;
                        this.w[n7 + 2] = d5;
                        this.w[n7 + 3] = d6;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, double[] dArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            dArray[n2] = Math.cos(d * (double)n3);
            dArray[n2 + n3] = 0.5 * dArray[n2];
            for (int i = 1; i < n3; ++i) {
                dArray[n2 + i] = 0.5 * Math.cos(d * (double)i);
                dArray[n2 + n - i] = 0.5 * Math.sin(d * (double)i);
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, double[] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = i * this.sliceStride;
                if (n == 0) {
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        this.fftn3.complexForward(dArray, n7 + n6 * this.rowStride);
                    }
                } else {
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        this.fftn3.realInverse(dArray, n7 + n6 * this.rowStride, bl);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n8;
                        int n9;
                        for (n6 = 0; n6 < this.n2; ++n6) {
                            n5 = n7 + n6 * this.rowStride + j;
                            n4 = 2 * n6;
                            n3 = 2 * this.n2 + 2 * n6;
                            n9 = n3 + 2 * this.n2;
                            n8 = n9 + 2 * this.n2;
                            this.t[n4] = dArray[n5];
                            this.t[n4 + 1] = dArray[n5 + 1];
                            this.t[n3] = dArray[n5 + 2];
                            this.t[n3 + 1] = dArray[n5 + 3];
                            this.t[n9] = dArray[n5 + 4];
                            this.t[n9 + 1] = dArray[n5 + 5];
                            this.t[n8] = dArray[n5 + 6];
                            this.t[n8 + 1] = dArray[n5 + 7];
                        }
                        this.fftn2.complexForward(this.t, 0);
                        this.fftn2.complexForward(this.t, 2 * this.n2);
                        this.fftn2.complexForward(this.t, 4 * this.n2);
                        this.fftn2.complexForward(this.t, 6 * this.n2);
                        for (n6 = 0; n6 < this.n2; ++n6) {
                            n5 = n7 + n6 * this.rowStride + j;
                            n4 = 2 * n6;
                            n3 = 2 * this.n2 + 2 * n6;
                            n9 = n3 + 2 * this.n2;
                            n8 = n9 + 2 * this.n2;
                            dArray[n5] = this.t[n4];
                            dArray[n5 + 1] = this.t[n4 + 1];
                            dArray[n5 + 2] = this.t[n3];
                            dArray[n5 + 3] = this.t[n3 + 1];
                            dArray[n5 + 4] = this.t[n9];
                            dArray[n5 + 5] = this.t[n9 + 1];
                            dArray[n5 + 6] = this.t[n8];
                            dArray[n5 + 7] = this.t[n8 + 1];
                        }
                    }
                    continue;
                }
                if (this.n3 == 4) {
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.n2 + 2 * n6;
                        this.t[n4] = dArray[n5];
                        this.t[n4 + 1] = dArray[n5 + 1];
                        this.t[n3] = dArray[n5 + 2];
                        this.t[n3 + 1] = dArray[n5 + 3];
                    }
                    this.fftn2.complexForward(this.t, 0);
                    this.fftn2.complexForward(this.t, 2 * this.n2);
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.n2 + 2 * n6;
                        dArray[n5] = this.t[n4];
                        dArray[n5 + 1] = this.t[n4 + 1];
                        dArray[n5 + 2] = this.t[n3];
                        dArray[n5 + 3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n6 = 0; n6 < this.n2; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    this.t[n4] = dArray[n5];
                    this.t[n4 + 1] = dArray[n5 + 1];
                }
                this.fftn2.complexForward(this.t, 0);
                for (n6 = 0; n6 < this.n2; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    dArray[n5] = this.t[n4];
                    dArray[n5 + 1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14 = i * this.sliceStride;
                if (n == 0) {
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        this.fftn3.complexInverse(dArray, n14 + n13 * this.rowStride, bl);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n15;
                        int n16;
                        for (n13 = 0; n13 < this.n2; ++n13) {
                            n12 = n14 + n13 * this.rowStride + j;
                            n11 = 2 * n13;
                            n10 = 2 * this.n2 + 2 * n13;
                            n16 = n10 + 2 * this.n2;
                            n15 = n16 + 2 * this.n2;
                            this.t[n11] = dArray[n12];
                            this.t[n11 + 1] = dArray[n12 + 1];
                            this.t[n10] = dArray[n12 + 2];
                            this.t[n10 + 1] = dArray[n12 + 3];
                            this.t[n16] = dArray[n12 + 4];
                            this.t[n16 + 1] = dArray[n12 + 5];
                            this.t[n15] = dArray[n12 + 6];
                            this.t[n15 + 1] = dArray[n12 + 7];
                        }
                        this.fftn2.complexInverse(this.t, 0, bl);
                        this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 4 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 6 * this.n2, bl);
                        for (n13 = 0; n13 < this.n2; ++n13) {
                            n12 = n14 + n13 * this.rowStride + j;
                            n11 = 2 * n13;
                            n10 = 2 * this.n2 + 2 * n13;
                            n16 = n10 + 2 * this.n2;
                            n15 = n16 + 2 * this.n2;
                            dArray[n12] = this.t[n11];
                            dArray[n12 + 1] = this.t[n11 + 1];
                            dArray[n12 + 2] = this.t[n10];
                            dArray[n12 + 3] = this.t[n10 + 1];
                            dArray[n12 + 4] = this.t[n16];
                            dArray[n12 + 5] = this.t[n16 + 1];
                            dArray[n12 + 6] = this.t[n15];
                            dArray[n12 + 7] = this.t[n15 + 1];
                        }
                    }
                } else if (this.n3 == 4) {
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        n12 = n14 + n13 * this.rowStride;
                        n11 = 2 * n13;
                        n10 = 2 * this.n2 + 2 * n13;
                        this.t[n11] = dArray[n12];
                        this.t[n11 + 1] = dArray[n12 + 1];
                        this.t[n10] = dArray[n12 + 2];
                        this.t[n10 + 1] = dArray[n12 + 3];
                    }
                    this.fftn2.complexInverse(this.t, 0, bl);
                    this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        n12 = n14 + n13 * this.rowStride;
                        n11 = 2 * n13;
                        n10 = 2 * this.n2 + 2 * n13;
                        dArray[n12] = this.t[n11];
                        dArray[n12 + 1] = this.t[n11 + 1];
                        dArray[n12 + 2] = this.t[n10];
                        dArray[n12 + 3] = this.t[n10 + 1];
                    }
                } else if (this.n3 == 2) {
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        n12 = n14 + n13 * this.rowStride;
                        n11 = 2 * n13;
                        this.t[n11] = dArray[n12];
                        this.t[n11 + 1] = dArray[n12 + 1];
                    }
                    this.fftn2.complexInverse(this.t, 0, bl);
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        n12 = n14 + n13 * this.rowStride;
                        n11 = 2 * n13;
                        dArray[n12] = this.t[n11];
                        dArray[n12 + 1] = this.t[n11 + 1];
                    }
                }
                if (n == 0) continue;
                for (n13 = 0; n13 < this.n2; ++n13) {
                    this.fftn3.realForward(dArray, n14 + n13 * this.rowStride);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, double[] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = i * this.sliceStride;
                if (n == 0) {
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        this.fftn3.complexForward(dArray, n7 + n6 * this.rowStride);
                    }
                } else {
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        this.fftn3.realForward(dArray, n7 + n6 * this.rowStride);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n8;
                        int n9;
                        for (n6 = 0; n6 < this.n2; ++n6) {
                            n5 = n7 + n6 * this.rowStride + j;
                            n4 = 2 * n6;
                            n3 = 2 * this.n2 + 2 * n6;
                            n9 = n3 + 2 * this.n2;
                            n8 = n9 + 2 * this.n2;
                            this.t[n4] = dArray[n5];
                            this.t[n4 + 1] = dArray[n5 + 1];
                            this.t[n3] = dArray[n5 + 2];
                            this.t[n3 + 1] = dArray[n5 + 3];
                            this.t[n9] = dArray[n5 + 4];
                            this.t[n9 + 1] = dArray[n5 + 5];
                            this.t[n8] = dArray[n5 + 6];
                            this.t[n8 + 1] = dArray[n5 + 7];
                        }
                        this.fftn2.complexForward(this.t, 0);
                        this.fftn2.complexForward(this.t, 2 * this.n2);
                        this.fftn2.complexForward(this.t, 4 * this.n2);
                        this.fftn2.complexForward(this.t, 6 * this.n2);
                        for (n6 = 0; n6 < this.n2; ++n6) {
                            n5 = n7 + n6 * this.rowStride + j;
                            n4 = 2 * n6;
                            n3 = 2 * this.n2 + 2 * n6;
                            n9 = n3 + 2 * this.n2;
                            n8 = n9 + 2 * this.n2;
                            dArray[n5] = this.t[n4];
                            dArray[n5 + 1] = this.t[n4 + 1];
                            dArray[n5 + 2] = this.t[n3];
                            dArray[n5 + 3] = this.t[n3 + 1];
                            dArray[n5 + 4] = this.t[n9];
                            dArray[n5 + 5] = this.t[n9 + 1];
                            dArray[n5 + 6] = this.t[n8];
                            dArray[n5 + 7] = this.t[n8 + 1];
                        }
                    }
                    continue;
                }
                if (this.n3 == 4) {
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.n2 + 2 * n6;
                        this.t[n4] = dArray[n5];
                        this.t[n4 + 1] = dArray[n5 + 1];
                        this.t[n3] = dArray[n5 + 2];
                        this.t[n3 + 1] = dArray[n5 + 3];
                    }
                    this.fftn2.complexForward(this.t, 0);
                    this.fftn2.complexForward(this.t, 2 * this.n2);
                    for (n6 = 0; n6 < this.n2; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.n2 + 2 * n6;
                        dArray[n5] = this.t[n4];
                        dArray[n5 + 1] = this.t[n4 + 1];
                        dArray[n5 + 2] = this.t[n3];
                        dArray[n5 + 3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n6 = 0; n6 < this.n2; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    this.t[n4] = dArray[n5];
                    this.t[n4 + 1] = dArray[n5 + 1];
                }
                this.fftn2.complexForward(this.t, 0);
                for (n6 = 0; n6 < this.n2; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    dArray[n5] = this.t[n4];
                    dArray[n5 + 1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14 = i * this.sliceStride;
                if (n == 0) {
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        this.fftn3.complexInverse(dArray, n14 + n13 * this.rowStride, bl);
                    }
                } else {
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        this.fftn3.realInverse2(dArray, n14 + n13 * this.rowStride, bl);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n15;
                        int n16;
                        for (n13 = 0; n13 < this.n2; ++n13) {
                            n12 = n14 + n13 * this.rowStride + j;
                            n11 = 2 * n13;
                            n10 = 2 * this.n2 + 2 * n13;
                            n16 = n10 + 2 * this.n2;
                            n15 = n16 + 2 * this.n2;
                            this.t[n11] = dArray[n12];
                            this.t[n11 + 1] = dArray[n12 + 1];
                            this.t[n10] = dArray[n12 + 2];
                            this.t[n10 + 1] = dArray[n12 + 3];
                            this.t[n16] = dArray[n12 + 4];
                            this.t[n16 + 1] = dArray[n12 + 5];
                            this.t[n15] = dArray[n12 + 6];
                            this.t[n15 + 1] = dArray[n12 + 7];
                        }
                        this.fftn2.complexInverse(this.t, 0, bl);
                        this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 4 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 6 * this.n2, bl);
                        for (n13 = 0; n13 < this.n2; ++n13) {
                            n12 = n14 + n13 * this.rowStride + j;
                            n11 = 2 * n13;
                            n10 = 2 * this.n2 + 2 * n13;
                            n16 = n10 + 2 * this.n2;
                            n15 = n16 + 2 * this.n2;
                            dArray[n12] = this.t[n11];
                            dArray[n12 + 1] = this.t[n11 + 1];
                            dArray[n12 + 2] = this.t[n10];
                            dArray[n12 + 3] = this.t[n10 + 1];
                            dArray[n12 + 4] = this.t[n16];
                            dArray[n12 + 5] = this.t[n16 + 1];
                            dArray[n12 + 6] = this.t[n15];
                            dArray[n12 + 7] = this.t[n15 + 1];
                        }
                    }
                    continue;
                }
                if (this.n3 == 4) {
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        n12 = n14 + n13 * this.rowStride;
                        n11 = 2 * n13;
                        n10 = 2 * this.n2 + 2 * n13;
                        this.t[n11] = dArray[n12];
                        this.t[n11 + 1] = dArray[n12 + 1];
                        this.t[n10] = dArray[n12 + 2];
                        this.t[n10 + 1] = dArray[n12 + 3];
                    }
                    this.fftn2.complexInverse(this.t, 0, bl);
                    this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                    for (n13 = 0; n13 < this.n2; ++n13) {
                        n12 = n14 + n13 * this.rowStride;
                        n11 = 2 * n13;
                        n10 = 2 * this.n2 + 2 * n13;
                        dArray[n12] = this.t[n11];
                        dArray[n12 + 1] = this.t[n11 + 1];
                        dArray[n12 + 2] = this.t[n10];
                        dArray[n12 + 3] = this.t[n10 + 1];
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n13 = 0; n13 < this.n2; ++n13) {
                    n12 = n14 + n13 * this.rowStride;
                    n11 = 2 * n13;
                    this.t[n11] = dArray[n12];
                    this.t[n11 + 1] = dArray[n12 + 1];
                }
                this.fftn2.complexInverse(this.t, 0, bl);
                for (n13 = 0; n13 < this.n2; ++n13) {
                    n12 = n14 + n13 * this.rowStride;
                    n11 = 2 * n13;
                    dArray[n12] = this.t[n11];
                    dArray[n12 + 1] = this.t[n11 + 1];
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, double[][][] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n3;
                int n4;
                int n5;
                if (n == 0) {
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        this.fftn3.complexForward(dArray[i][n5]);
                    }
                } else {
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        this.fftn3.realInverse(dArray[i][n5], 0, bl);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n6;
                        int n7;
                        for (n5 = 0; n5 < this.n2; ++n5) {
                            n4 = 2 * n5;
                            n3 = 2 * this.n2 + 2 * n5;
                            n7 = n3 + 2 * this.n2;
                            n6 = n7 + 2 * this.n2;
                            this.t[n4] = dArray[i][n5][j];
                            this.t[n4 + 1] = dArray[i][n5][j + 1];
                            this.t[n3] = dArray[i][n5][j + 2];
                            this.t[n3 + 1] = dArray[i][n5][j + 3];
                            this.t[n7] = dArray[i][n5][j + 4];
                            this.t[n7 + 1] = dArray[i][n5][j + 5];
                            this.t[n6] = dArray[i][n5][j + 6];
                            this.t[n6 + 1] = dArray[i][n5][j + 7];
                        }
                        this.fftn2.complexForward(this.t, 0);
                        this.fftn2.complexForward(this.t, 2 * this.n2);
                        this.fftn2.complexForward(this.t, 4 * this.n2);
                        this.fftn2.complexForward(this.t, 6 * this.n2);
                        for (n5 = 0; n5 < this.n2; ++n5) {
                            n4 = 2 * n5;
                            n3 = 2 * this.n2 + 2 * n5;
                            n7 = n3 + 2 * this.n2;
                            n6 = n7 + 2 * this.n2;
                            dArray[i][n5][j] = this.t[n4];
                            dArray[i][n5][j + 1] = this.t[n4 + 1];
                            dArray[i][n5][j + 2] = this.t[n3];
                            dArray[i][n5][j + 3] = this.t[n3 + 1];
                            dArray[i][n5][j + 4] = this.t[n7];
                            dArray[i][n5][j + 5] = this.t[n7 + 1];
                            dArray[i][n5][j + 6] = this.t[n6];
                            dArray[i][n5][j + 7] = this.t[n6 + 1];
                        }
                    }
                    continue;
                }
                if (this.n3 == 4) {
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.n2 + 2 * n5;
                        this.t[n4] = dArray[i][n5][0];
                        this.t[n4 + 1] = dArray[i][n5][1];
                        this.t[n3] = dArray[i][n5][2];
                        this.t[n3 + 1] = dArray[i][n5][3];
                    }
                    this.fftn2.complexForward(this.t, 0);
                    this.fftn2.complexForward(this.t, 2 * this.n2);
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.n2 + 2 * n5;
                        dArray[i][n5][0] = this.t[n4];
                        dArray[i][n5][1] = this.t[n4 + 1];
                        dArray[i][n5][2] = this.t[n3];
                        dArray[i][n5][3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n5 = 0; n5 < this.n2; ++n5) {
                    n4 = 2 * n5;
                    this.t[n4] = dArray[i][n5][0];
                    this.t[n4 + 1] = dArray[i][n5][1];
                }
                this.fftn2.complexForward(this.t, 0);
                for (n5 = 0; n5 < this.n2; ++n5) {
                    n4 = 2 * n5;
                    dArray[i][n5][0] = this.t[n4];
                    dArray[i][n5][1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n8;
                int n9;
                int n10;
                if (n == 0) {
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        this.fftn3.complexInverse(dArray[i][n10], bl);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n11;
                        int n12;
                        for (n10 = 0; n10 < this.n2; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.n2 + 2 * n10;
                            n12 = n8 + 2 * this.n2;
                            n11 = n12 + 2 * this.n2;
                            this.t[n9] = dArray[i][n10][j];
                            this.t[n9 + 1] = dArray[i][n10][j + 1];
                            this.t[n8] = dArray[i][n10][j + 2];
                            this.t[n8 + 1] = dArray[i][n10][j + 3];
                            this.t[n12] = dArray[i][n10][j + 4];
                            this.t[n12 + 1] = dArray[i][n10][j + 5];
                            this.t[n11] = dArray[i][n10][j + 6];
                            this.t[n11 + 1] = dArray[i][n10][j + 7];
                        }
                        this.fftn2.complexInverse(this.t, 0, bl);
                        this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 4 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 6 * this.n2, bl);
                        for (n10 = 0; n10 < this.n2; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.n2 + 2 * n10;
                            n12 = n8 + 2 * this.n2;
                            n11 = n12 + 2 * this.n2;
                            dArray[i][n10][j] = this.t[n9];
                            dArray[i][n10][j + 1] = this.t[n9 + 1];
                            dArray[i][n10][j + 2] = this.t[n8];
                            dArray[i][n10][j + 3] = this.t[n8 + 1];
                            dArray[i][n10][j + 4] = this.t[n12];
                            dArray[i][n10][j + 5] = this.t[n12 + 1];
                            dArray[i][n10][j + 6] = this.t[n11];
                            dArray[i][n10][j + 7] = this.t[n11 + 1];
                        }
                    }
                } else if (this.n3 == 4) {
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        n9 = 2 * n10;
                        n8 = 2 * this.n2 + 2 * n10;
                        this.t[n9] = dArray[i][n10][0];
                        this.t[n9 + 1] = dArray[i][n10][1];
                        this.t[n8] = dArray[i][n10][2];
                        this.t[n8 + 1] = dArray[i][n10][3];
                    }
                    this.fftn2.complexInverse(this.t, 0, bl);
                    this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        n9 = 2 * n10;
                        n8 = 2 * this.n2 + 2 * n10;
                        dArray[i][n10][0] = this.t[n9];
                        dArray[i][n10][1] = this.t[n9 + 1];
                        dArray[i][n10][2] = this.t[n8];
                        dArray[i][n10][3] = this.t[n8 + 1];
                    }
                } else if (this.n3 == 2) {
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        n9 = 2 * n10;
                        this.t[n9] = dArray[i][n10][0];
                        this.t[n9 + 1] = dArray[i][n10][1];
                    }
                    this.fftn2.complexInverse(this.t, 0, bl);
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        n9 = 2 * n10;
                        dArray[i][n10][0] = this.t[n9];
                        dArray[i][n10][1] = this.t[n9 + 1];
                    }
                }
                if (n == 0) continue;
                for (n10 = 0; n10 < this.n2; ++n10) {
                    this.fftn3.realForward(dArray[i][n10], 0);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, double[][][] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n3;
                int n4;
                int n5;
                if (n == 0) {
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        this.fftn3.complexForward(dArray[i][n5]);
                    }
                } else {
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        this.fftn3.realForward(dArray[i][n5]);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n6;
                        int n7;
                        for (n5 = 0; n5 < this.n2; ++n5) {
                            n4 = 2 * n5;
                            n3 = 2 * this.n2 + 2 * n5;
                            n7 = n3 + 2 * this.n2;
                            n6 = n7 + 2 * this.n2;
                            this.t[n4] = dArray[i][n5][j];
                            this.t[n4 + 1] = dArray[i][n5][j + 1];
                            this.t[n3] = dArray[i][n5][j + 2];
                            this.t[n3 + 1] = dArray[i][n5][j + 3];
                            this.t[n7] = dArray[i][n5][j + 4];
                            this.t[n7 + 1] = dArray[i][n5][j + 5];
                            this.t[n6] = dArray[i][n5][j + 6];
                            this.t[n6 + 1] = dArray[i][n5][j + 7];
                        }
                        this.fftn2.complexForward(this.t, 0);
                        this.fftn2.complexForward(this.t, 2 * this.n2);
                        this.fftn2.complexForward(this.t, 4 * this.n2);
                        this.fftn2.complexForward(this.t, 6 * this.n2);
                        for (n5 = 0; n5 < this.n2; ++n5) {
                            n4 = 2 * n5;
                            n3 = 2 * this.n2 + 2 * n5;
                            n7 = n3 + 2 * this.n2;
                            n6 = n7 + 2 * this.n2;
                            dArray[i][n5][j] = this.t[n4];
                            dArray[i][n5][j + 1] = this.t[n4 + 1];
                            dArray[i][n5][j + 2] = this.t[n3];
                            dArray[i][n5][j + 3] = this.t[n3 + 1];
                            dArray[i][n5][j + 4] = this.t[n7];
                            dArray[i][n5][j + 5] = this.t[n7 + 1];
                            dArray[i][n5][j + 6] = this.t[n6];
                            dArray[i][n5][j + 7] = this.t[n6 + 1];
                        }
                    }
                    continue;
                }
                if (this.n3 == 4) {
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.n2 + 2 * n5;
                        this.t[n4] = dArray[i][n5][0];
                        this.t[n4 + 1] = dArray[i][n5][1];
                        this.t[n3] = dArray[i][n5][2];
                        this.t[n3 + 1] = dArray[i][n5][3];
                    }
                    this.fftn2.complexForward(this.t, 0);
                    this.fftn2.complexForward(this.t, 2 * this.n2);
                    for (n5 = 0; n5 < this.n2; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.n2 + 2 * n5;
                        dArray[i][n5][0] = this.t[n4];
                        dArray[i][n5][1] = this.t[n4 + 1];
                        dArray[i][n5][2] = this.t[n3];
                        dArray[i][n5][3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n5 = 0; n5 < this.n2; ++n5) {
                    n4 = 2 * n5;
                    this.t[n4] = dArray[i][n5][0];
                    this.t[n4 + 1] = dArray[i][n5][1];
                }
                this.fftn2.complexForward(this.t, 0);
                for (n5 = 0; n5 < this.n2; ++n5) {
                    n4 = 2 * n5;
                    dArray[i][n5][0] = this.t[n4];
                    dArray[i][n5][1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n8;
                int n9;
                int n10;
                if (n == 0) {
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        this.fftn3.complexInverse(dArray[i][n10], bl);
                    }
                } else {
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        this.fftn3.realInverse2(dArray[i][n10], 0, bl);
                    }
                }
                if (this.n3 > 4) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n11;
                        int n12;
                        for (n10 = 0; n10 < this.n2; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.n2 + 2 * n10;
                            n12 = n8 + 2 * this.n2;
                            n11 = n12 + 2 * this.n2;
                            this.t[n9] = dArray[i][n10][j];
                            this.t[n9 + 1] = dArray[i][n10][j + 1];
                            this.t[n8] = dArray[i][n10][j + 2];
                            this.t[n8 + 1] = dArray[i][n10][j + 3];
                            this.t[n12] = dArray[i][n10][j + 4];
                            this.t[n12 + 1] = dArray[i][n10][j + 5];
                            this.t[n11] = dArray[i][n10][j + 6];
                            this.t[n11 + 1] = dArray[i][n10][j + 7];
                        }
                        this.fftn2.complexInverse(this.t, 0, bl);
                        this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 4 * this.n2, bl);
                        this.fftn2.complexInverse(this.t, 6 * this.n2, bl);
                        for (n10 = 0; n10 < this.n2; ++n10) {
                            n9 = 2 * n10;
                            n8 = 2 * this.n2 + 2 * n10;
                            n12 = n8 + 2 * this.n2;
                            n11 = n12 + 2 * this.n2;
                            dArray[i][n10][j] = this.t[n9];
                            dArray[i][n10][j + 1] = this.t[n9 + 1];
                            dArray[i][n10][j + 2] = this.t[n8];
                            dArray[i][n10][j + 3] = this.t[n8 + 1];
                            dArray[i][n10][j + 4] = this.t[n12];
                            dArray[i][n10][j + 5] = this.t[n12 + 1];
                            dArray[i][n10][j + 6] = this.t[n11];
                            dArray[i][n10][j + 7] = this.t[n11 + 1];
                        }
                    }
                    continue;
                }
                if (this.n3 == 4) {
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        n9 = 2 * n10;
                        n8 = 2 * this.n2 + 2 * n10;
                        this.t[n9] = dArray[i][n10][0];
                        this.t[n9 + 1] = dArray[i][n10][1];
                        this.t[n8] = dArray[i][n10][2];
                        this.t[n8 + 1] = dArray[i][n10][3];
                    }
                    this.fftn2.complexInverse(this.t, 0, bl);
                    this.fftn2.complexInverse(this.t, 2 * this.n2, bl);
                    for (n10 = 0; n10 < this.n2; ++n10) {
                        n9 = 2 * n10;
                        n8 = 2 * this.n2 + 2 * n10;
                        dArray[i][n10][0] = this.t[n9];
                        dArray[i][n10][1] = this.t[n9 + 1];
                        dArray[i][n10][2] = this.t[n8];
                        dArray[i][n10][3] = this.t[n8 + 1];
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n10 = 0; n10 < this.n2; ++n10) {
                    n9 = 2 * n10;
                    this.t[n9] = dArray[i][n10][0];
                    this.t[n9 + 1] = dArray[i][n10][1];
                }
                this.fftn2.complexInverse(this.t, 0, bl);
                for (n10 = 0; n10 < this.n2; ++n10) {
                    n9 = 2 * n10;
                    dArray[i][n10][0] = this.t[n9];
                    dArray[i][n10][1] = this.t[n9 + 1];
                }
            }
        }
    }

    private void cdft3db_sub(int n, double[] dArray, boolean bl) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (n != -1) break block25;
                        if (this.n3 <= 4) break block26;
                        for (int i = 0; i < this.n2; ++i) {
                            int n2 = i * this.rowStride;
                            for (int j = 0; j < this.n3; j += 8) {
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n8;
                                for (n8 = 0; n8 < this.n1; ++n8) {
                                    n7 = n8 * this.sliceStride + n2 + j;
                                    n6 = 2 * n8;
                                    n5 = 2 * this.n1 + 2 * n8;
                                    n4 = n5 + 2 * this.n1;
                                    n3 = n4 + 2 * this.n1;
                                    this.t[n6] = dArray[n7];
                                    this.t[n6 + 1] = dArray[n7 + 1];
                                    this.t[n5] = dArray[n7 + 2];
                                    this.t[n5 + 1] = dArray[n7 + 3];
                                    this.t[n4] = dArray[n7 + 4];
                                    this.t[n4 + 1] = dArray[n7 + 5];
                                    this.t[n3] = dArray[n7 + 6];
                                    this.t[n3 + 1] = dArray[n7 + 7];
                                }
                                this.fftn1.complexForward(this.t, 0);
                                this.fftn1.complexForward(this.t, 2 * this.n1);
                                this.fftn1.complexForward(this.t, 4 * this.n1);
                                this.fftn1.complexForward(this.t, 6 * this.n1);
                                for (n8 = 0; n8 < this.n1; ++n8) {
                                    n7 = n8 * this.sliceStride + n2 + j;
                                    n6 = 2 * n8;
                                    n5 = 2 * this.n1 + 2 * n8;
                                    n4 = n5 + 2 * this.n1;
                                    n3 = n4 + 2 * this.n1;
                                    dArray[n7] = this.t[n6];
                                    dArray[n7 + 1] = this.t[n6 + 1];
                                    dArray[n7 + 2] = this.t[n5];
                                    dArray[n7 + 3] = this.t[n5 + 1];
                                    dArray[n7 + 4] = this.t[n4];
                                    dArray[n7 + 5] = this.t[n4 + 1];
                                    dArray[n7 + 6] = this.t[n3];
                                    dArray[n7 + 7] = this.t[n3 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.n3 != 4) break block28;
                    for (int i = 0; i < this.n2; ++i) {
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13 = i * this.rowStride;
                        for (n12 = 0; n12 < this.n1; ++n12) {
                            n11 = n12 * this.sliceStride + n13;
                            n10 = 2 * n12;
                            n9 = 2 * this.n1 + 2 * n12;
                            this.t[n10] = dArray[n11];
                            this.t[n10 + 1] = dArray[n11 + 1];
                            this.t[n9] = dArray[n11 + 2];
                            this.t[n9 + 1] = dArray[n11 + 3];
                        }
                        this.fftn1.complexForward(this.t, 0);
                        this.fftn1.complexForward(this.t, 2 * this.n1);
                        for (n12 = 0; n12 < this.n1; ++n12) {
                            n11 = n12 * this.sliceStride + n13;
                            n10 = 2 * n12;
                            n9 = 2 * this.n1 + 2 * n12;
                            dArray[n11] = this.t[n10];
                            dArray[n11 + 1] = this.t[n10 + 1];
                            dArray[n11 + 2] = this.t[n9];
                            dArray[n11 + 3] = this.t[n9 + 1];
                        }
                    }
                    break block27;
                }
                if (this.n3 != 2) break block27;
                for (int i = 0; i < this.n2; ++i) {
                    int n14;
                    int n15;
                    int n16;
                    int n17 = i * this.rowStride;
                    for (n16 = 0; n16 < this.n1; ++n16) {
                        n15 = n16 * this.sliceStride + n17;
                        n14 = 2 * n16;
                        this.t[n14] = dArray[n15];
                        this.t[n14 + 1] = dArray[n15 + 1];
                    }
                    this.fftn1.complexForward(this.t, 0);
                    for (n16 = 0; n16 < this.n1; ++n16) {
                        n15 = n16 * this.sliceStride + n17;
                        n14 = 2 * n16;
                        dArray[n15] = this.t[n14];
                        dArray[n15 + 1] = this.t[n14 + 1];
                    }
                }
                break block27;
            }
            if (this.n3 > 4) {
                for (int i = 0; i < this.n2; ++i) {
                    int n18 = i * this.rowStride;
                    for (int j = 0; j < this.n3; j += 8) {
                        int n19;
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        for (n24 = 0; n24 < this.n1; ++n24) {
                            n23 = n24 * this.sliceStride + n18 + j;
                            n22 = 2 * n24;
                            n21 = 2 * this.n1 + 2 * n24;
                            n20 = n21 + 2 * this.n1;
                            n19 = n20 + 2 * this.n1;
                            this.t[n22] = dArray[n23];
                            this.t[n22 + 1] = dArray[n23 + 1];
                            this.t[n21] = dArray[n23 + 2];
                            this.t[n21 + 1] = dArray[n23 + 3];
                            this.t[n20] = dArray[n23 + 4];
                            this.t[n20 + 1] = dArray[n23 + 5];
                            this.t[n19] = dArray[n23 + 6];
                            this.t[n19 + 1] = dArray[n23 + 7];
                        }
                        this.fftn1.complexInverse(this.t, 0, bl);
                        this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                        this.fftn1.complexInverse(this.t, 4 * this.n1, bl);
                        this.fftn1.complexInverse(this.t, 6 * this.n1, bl);
                        for (n24 = 0; n24 < this.n1; ++n24) {
                            n23 = n24 * this.sliceStride + n18 + j;
                            n22 = 2 * n24;
                            n21 = 2 * this.n1 + 2 * n24;
                            n20 = n21 + 2 * this.n1;
                            n19 = n20 + 2 * this.n1;
                            dArray[n23] = this.t[n22];
                            dArray[n23 + 1] = this.t[n22 + 1];
                            dArray[n23 + 2] = this.t[n21];
                            dArray[n23 + 3] = this.t[n21 + 1];
                            dArray[n23 + 4] = this.t[n20];
                            dArray[n23 + 5] = this.t[n20 + 1];
                            dArray[n23 + 6] = this.t[n19];
                            dArray[n23 + 7] = this.t[n19 + 1];
                        }
                    }
                }
            } else if (this.n3 == 4) {
                for (int i = 0; i < this.n2; ++i) {
                    int n25;
                    int n26;
                    int n27;
                    int n28;
                    int n29 = i * this.rowStride;
                    for (n28 = 0; n28 < this.n1; ++n28) {
                        n27 = n28 * this.sliceStride + n29;
                        n26 = 2 * n28;
                        n25 = 2 * this.n1 + 2 * n28;
                        this.t[n26] = dArray[n27];
                        this.t[n26 + 1] = dArray[n27 + 1];
                        this.t[n25] = dArray[n27 + 2];
                        this.t[n25 + 1] = dArray[n27 + 3];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                    for (n28 = 0; n28 < this.n1; ++n28) {
                        n27 = n28 * this.sliceStride + n29;
                        n26 = 2 * n28;
                        n25 = 2 * this.n1 + 2 * n28;
                        dArray[n27] = this.t[n26];
                        dArray[n27 + 1] = this.t[n26 + 1];
                        dArray[n27 + 2] = this.t[n25];
                        dArray[n27 + 3] = this.t[n25 + 1];
                    }
                }
            } else if (this.n3 == 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n30;
                    int n31;
                    int n32;
                    int n33 = i * this.rowStride;
                    for (n32 = 0; n32 < this.n1; ++n32) {
                        n31 = n32 * this.sliceStride + n33;
                        n30 = 2 * n32;
                        this.t[n30] = dArray[n31];
                        this.t[n30 + 1] = dArray[n31 + 1];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    for (n32 = 0; n32 < this.n1; ++n32) {
                        n31 = n32 * this.sliceStride + n33;
                        n30 = 2 * n32;
                        dArray[n31] = this.t[n30];
                        dArray[n31 + 1] = this.t[n30 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int n, double[][][] dArray, boolean bl) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (n != -1) break block25;
                        if (this.n3 <= 4) break block26;
                        for (int i = 0; i < this.n2; ++i) {
                            for (int j = 0; j < this.n3; j += 8) {
                                int n2;
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                for (n6 = 0; n6 < this.n1; ++n6) {
                                    n5 = 2 * n6;
                                    n4 = 2 * this.n1 + 2 * n6;
                                    n3 = n4 + 2 * this.n1;
                                    n2 = n3 + 2 * this.n1;
                                    this.t[n5] = dArray[n6][i][j];
                                    this.t[n5 + 1] = dArray[n6][i][j + 1];
                                    this.t[n4] = dArray[n6][i][j + 2];
                                    this.t[n4 + 1] = dArray[n6][i][j + 3];
                                    this.t[n3] = dArray[n6][i][j + 4];
                                    this.t[n3 + 1] = dArray[n6][i][j + 5];
                                    this.t[n2] = dArray[n6][i][j + 6];
                                    this.t[n2 + 1] = dArray[n6][i][j + 7];
                                }
                                this.fftn1.complexForward(this.t, 0);
                                this.fftn1.complexForward(this.t, 2 * this.n1);
                                this.fftn1.complexForward(this.t, 4 * this.n1);
                                this.fftn1.complexForward(this.t, 6 * this.n1);
                                for (n6 = 0; n6 < this.n1; ++n6) {
                                    n5 = 2 * n6;
                                    n4 = 2 * this.n1 + 2 * n6;
                                    n3 = n4 + 2 * this.n1;
                                    n2 = n3 + 2 * this.n1;
                                    dArray[n6][i][j] = this.t[n5];
                                    dArray[n6][i][j + 1] = this.t[n5 + 1];
                                    dArray[n6][i][j + 2] = this.t[n4];
                                    dArray[n6][i][j + 3] = this.t[n4 + 1];
                                    dArray[n6][i][j + 4] = this.t[n3];
                                    dArray[n6][i][j + 5] = this.t[n3 + 1];
                                    dArray[n6][i][j + 6] = this.t[n2];
                                    dArray[n6][i][j + 7] = this.t[n2 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.n3 != 4) break block28;
                    for (int i = 0; i < this.n2; ++i) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.n1; ++n9) {
                            n8 = 2 * n9;
                            n7 = 2 * this.n1 + 2 * n9;
                            this.t[n8] = dArray[n9][i][0];
                            this.t[n8 + 1] = dArray[n9][i][1];
                            this.t[n7] = dArray[n9][i][2];
                            this.t[n7 + 1] = dArray[n9][i][3];
                        }
                        this.fftn1.complexForward(this.t, 0);
                        this.fftn1.complexForward(this.t, 2 * this.n1);
                        for (n9 = 0; n9 < this.n1; ++n9) {
                            n8 = 2 * n9;
                            n7 = 2 * this.n1 + 2 * n9;
                            dArray[n9][i][0] = this.t[n8];
                            dArray[n9][i][1] = this.t[n8 + 1];
                            dArray[n9][i][2] = this.t[n7];
                            dArray[n9][i][3] = this.t[n7 + 1];
                        }
                    }
                    break block27;
                }
                if (this.n3 != 2) break block27;
                for (int i = 0; i < this.n2; ++i) {
                    int n10;
                    int n11;
                    for (n11 = 0; n11 < this.n1; ++n11) {
                        n10 = 2 * n11;
                        this.t[n10] = dArray[n11][i][0];
                        this.t[n10 + 1] = dArray[n11][i][1];
                    }
                    this.fftn1.complexForward(this.t, 0);
                    for (n11 = 0; n11 < this.n1; ++n11) {
                        n10 = 2 * n11;
                        dArray[n11][i][0] = this.t[n10];
                        dArray[n11][i][1] = this.t[n10 + 1];
                    }
                }
                break block27;
            }
            if (this.n3 > 4) {
                for (int i = 0; i < this.n2; ++i) {
                    for (int j = 0; j < this.n3; j += 8) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        for (n16 = 0; n16 < this.n1; ++n16) {
                            n15 = 2 * n16;
                            n14 = 2 * this.n1 + 2 * n16;
                            n13 = n14 + 2 * this.n1;
                            n12 = n13 + 2 * this.n1;
                            this.t[n15] = dArray[n16][i][j];
                            this.t[n15 + 1] = dArray[n16][i][j + 1];
                            this.t[n14] = dArray[n16][i][j + 2];
                            this.t[n14 + 1] = dArray[n16][i][j + 3];
                            this.t[n13] = dArray[n16][i][j + 4];
                            this.t[n13 + 1] = dArray[n16][i][j + 5];
                            this.t[n12] = dArray[n16][i][j + 6];
                            this.t[n12 + 1] = dArray[n16][i][j + 7];
                        }
                        this.fftn1.complexInverse(this.t, 0, bl);
                        this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                        this.fftn1.complexInverse(this.t, 4 * this.n1, bl);
                        this.fftn1.complexInverse(this.t, 6 * this.n1, bl);
                        for (n16 = 0; n16 < this.n1; ++n16) {
                            n15 = 2 * n16;
                            n14 = 2 * this.n1 + 2 * n16;
                            n13 = n14 + 2 * this.n1;
                            n12 = n13 + 2 * this.n1;
                            dArray[n16][i][j] = this.t[n15];
                            dArray[n16][i][j + 1] = this.t[n15 + 1];
                            dArray[n16][i][j + 2] = this.t[n14];
                            dArray[n16][i][j + 3] = this.t[n14 + 1];
                            dArray[n16][i][j + 4] = this.t[n13];
                            dArray[n16][i][j + 5] = this.t[n13 + 1];
                            dArray[n16][i][j + 6] = this.t[n12];
                            dArray[n16][i][j + 7] = this.t[n12 + 1];
                        }
                    }
                }
            } else if (this.n3 == 4) {
                for (int i = 0; i < this.n2; ++i) {
                    int n17;
                    int n18;
                    int n19;
                    for (n19 = 0; n19 < this.n1; ++n19) {
                        n18 = 2 * n19;
                        n17 = 2 * this.n1 + 2 * n19;
                        this.t[n18] = dArray[n19][i][0];
                        this.t[n18 + 1] = dArray[n19][i][1];
                        this.t[n17] = dArray[n19][i][2];
                        this.t[n17 + 1] = dArray[n19][i][3];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                    for (n19 = 0; n19 < this.n1; ++n19) {
                        n18 = 2 * n19;
                        n17 = 2 * this.n1 + 2 * n19;
                        dArray[n19][i][0] = this.t[n18];
                        dArray[n19][i][1] = this.t[n18 + 1];
                        dArray[n19][i][2] = this.t[n17];
                        dArray[n19][i][3] = this.t[n17 + 1];
                    }
                }
            } else if (this.n3 == 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n20;
                    int n21;
                    for (n21 = 0; n21 < this.n1; ++n21) {
                        n20 = 2 * n21;
                        this.t[n20] = dArray[n21][i][0];
                        this.t[n20 + 1] = dArray[n21][i][1];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    for (n21 = 0; n21 < this.n1; ++n21) {
                        n20 = 2 * n21;
                        dArray[n21][i][0] = this.t[n20];
                        dArray[n21][i][1] = this.t[n20 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_subth1(final int n, final int n2, final double[] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        if (n4 > this.n1) {
            n4 = this.n1;
        }
        int n5 = 8 * this.n2;
        if (this.n3 == 4) {
            n5 >>= 1;
        } else if (this.n3 < 4) {
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n3 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n14;
                            int n22;
                            int n32;
                            int n4;
                            int n5 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    DoubleFFT_3D.this.fftn3.complexForward(dArray, n5 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    DoubleFFT_3D.this.fftn3.realInverse(dArray, n5 + n4 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n62;
                                    int n72;
                                    for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                        n32 = n5 + n4 * DoubleFFT_3D.this.rowStride + j;
                                        n22 = n7 + 2 * n4;
                                        n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                        n72 = n14 + 2 * DoubleFFT_3D.this.n2;
                                        n62 = n72 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14] = dArray[n32 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14 + 1] = dArray[n32 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n72] = dArray[n32 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n72 + 1] = dArray[n32 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[n32 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2);
                                    for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                        n32 = n5 + n4 * DoubleFFT_3D.this.rowStride + j;
                                        n22 = n7 + 2 * n4;
                                        n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                        n72 = n14 + 2 * DoubleFFT_3D.this.n2;
                                        n62 = n72 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[n32] = DoubleFFT_3D.this.t[n22];
                                        dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[n32 + 2] = DoubleFFT_3D.this.t[n14];
                                        dArray[n32 + 3] = DoubleFFT_3D.this.t[n14 + 1];
                                        dArray[n32 + 4] = DoubleFFT_3D.this.t[n72];
                                        dArray[n32 + 5] = DoubleFFT_3D.this.t[n72 + 1];
                                        dArray[n32 + 6] = DoubleFFT_3D.this.t[n62];
                                        dArray[n32 + 7] = DoubleFFT_3D.this.t[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 == 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n7 + 2 * n4;
                                    n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14] = dArray[n32 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14 + 1] = dArray[n32 + 3];
                                }
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n7 + 2 * n4;
                                    n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                    dArray[n32] = DoubleFFT_3D.this.t[n22];
                                    dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[n32 + 2] = DoubleFFT_3D.this.t[n14];
                                    dArray[n32 + 3] = DoubleFFT_3D.this.t[n14 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) continue;
                            for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n7 + 2 * n4;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                            }
                            DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                            for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n7 + 2 * n4;
                                dArray[n32] = DoubleFFT_3D.this.t[n22];
                                dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n15;
                            int n8;
                            int n9;
                            int n10;
                            int n11 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    DoubleFFT_3D.this.fftn3.complexInverse(dArray, n11 + n10 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n12;
                                    int n13;
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                        n9 = n11 + n10 * DoubleFFT_3D.this.rowStride + j;
                                        n8 = n7 + 2 * n10;
                                        n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                        n13 = n15 + 2 * DoubleFFT_3D.this.n2;
                                        n12 = n13 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15] = dArray[n9 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15 + 1] = dArray[n9 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[n9 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[n9 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12] = dArray[n9 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12 + 1] = dArray[n9 + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2, bl);
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                        n9 = n11 + n10 * DoubleFFT_3D.this.rowStride + j;
                                        n8 = n7 + 2 * n10;
                                        n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                        n13 = n15 + 2 * DoubleFFT_3D.this.n2;
                                        n12 = n13 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[n9] = DoubleFFT_3D.this.t[n8];
                                        dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                                        dArray[n9 + 2] = DoubleFFT_3D.this.t[n15];
                                        dArray[n9 + 3] = DoubleFFT_3D.this.t[n15 + 1];
                                        dArray[n9 + 4] = DoubleFFT_3D.this.t[n13];
                                        dArray[n9 + 5] = DoubleFFT_3D.this.t[n13 + 1];
                                        dArray[n9 + 6] = DoubleFFT_3D.this.t[n12];
                                        dArray[n9 + 7] = DoubleFFT_3D.this.t[n12 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.n3 == 4) {
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                    n8 = n7 + 2 * n10;
                                    n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15] = dArray[n9 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15 + 1] = dArray[n9 + 3];
                                }
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                    n8 = n7 + 2 * n10;
                                    n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                    dArray[n9] = DoubleFFT_3D.this.t[n8];
                                    dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                                    dArray[n9 + 2] = DoubleFFT_3D.this.t[n15];
                                    dArray[n9 + 3] = DoubleFFT_3D.this.t[n15 + 1];
                                }
                            } else if (DoubleFFT_3D.this.n3 == 2) {
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                    n8 = n7 + 2 * n10;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                                }
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                    n8 = n7 + 2 * n10;
                                    dArray[n9] = DoubleFFT_3D.this.t[n8];
                                    dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                DoubleFFT_3D.this.fftn3.realForward(dArray, n11 + n10 * DoubleFFT_3D.this.rowStride);
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n4; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft3da_subth2(final int n, final int n2, final double[] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        if (n4 > this.n1) {
            n4 = this.n1;
        }
        int n5 = 8 * this.n2;
        if (this.n3 == 4) {
            n5 >>= 1;
        } else if (this.n3 < 4) {
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n3 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n14;
                            int n22;
                            int n32;
                            int n4;
                            int n5 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    DoubleFFT_3D.this.fftn3.complexForward(dArray, n5 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    DoubleFFT_3D.this.fftn3.realForward(dArray, n5 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n62;
                                    int n72;
                                    for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                        n32 = n5 + n4 * DoubleFFT_3D.this.rowStride + j;
                                        n22 = n7 + 2 * n4;
                                        n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                        n72 = n14 + 2 * DoubleFFT_3D.this.n2;
                                        n62 = n72 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14] = dArray[n32 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14 + 1] = dArray[n32 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n72] = dArray[n32 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n72 + 1] = dArray[n32 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[n32 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2);
                                    for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                        n32 = n5 + n4 * DoubleFFT_3D.this.rowStride + j;
                                        n22 = n7 + 2 * n4;
                                        n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                        n72 = n14 + 2 * DoubleFFT_3D.this.n2;
                                        n62 = n72 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[n32] = DoubleFFT_3D.this.t[n22];
                                        dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[n32 + 2] = DoubleFFT_3D.this.t[n14];
                                        dArray[n32 + 3] = DoubleFFT_3D.this.t[n14 + 1];
                                        dArray[n32 + 4] = DoubleFFT_3D.this.t[n72];
                                        dArray[n32 + 5] = DoubleFFT_3D.this.t[n72 + 1];
                                        dArray[n32 + 6] = DoubleFFT_3D.this.t[n62];
                                        dArray[n32 + 7] = DoubleFFT_3D.this.t[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 == 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n7 + 2 * n4;
                                    n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14] = dArray[n32 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14 + 1] = dArray[n32 + 3];
                                }
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                    n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n7 + 2 * n4;
                                    n14 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n4;
                                    dArray[n32] = DoubleFFT_3D.this.t[n22];
                                    dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[n32 + 2] = DoubleFFT_3D.this.t[n14];
                                    dArray[n32 + 3] = DoubleFFT_3D.this.t[n14 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) continue;
                            for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n7 + 2 * n4;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                            }
                            DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                            for (n4 = 0; n4 < DoubleFFT_3D.this.n2; ++n4) {
                                n32 = n5 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n7 + 2 * n4;
                                dArray[n32] = DoubleFFT_3D.this.t[n22];
                                dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n15;
                            int n8;
                            int n9;
                            int n10;
                            int n11 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    DoubleFFT_3D.this.fftn3.complexInverse(dArray, n11 + n10 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            } else {
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    DoubleFFT_3D.this.fftn3.realInverse2(dArray, n11 + n10 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n12;
                                    int n13;
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                        n9 = n11 + n10 * DoubleFFT_3D.this.rowStride + j;
                                        n8 = n7 + 2 * n10;
                                        n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                        n13 = n15 + 2 * DoubleFFT_3D.this.n2;
                                        n12 = n13 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15] = dArray[n9 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15 + 1] = dArray[n9 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[n9 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[n9 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12] = dArray[n9 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12 + 1] = dArray[n9 + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2, bl);
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                        n9 = n11 + n10 * DoubleFFT_3D.this.rowStride + j;
                                        n8 = n7 + 2 * n10;
                                        n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                        n13 = n15 + 2 * DoubleFFT_3D.this.n2;
                                        n12 = n13 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[n9] = DoubleFFT_3D.this.t[n8];
                                        dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                                        dArray[n9 + 2] = DoubleFFT_3D.this.t[n15];
                                        dArray[n9 + 3] = DoubleFFT_3D.this.t[n15 + 1];
                                        dArray[n9 + 4] = DoubleFFT_3D.this.t[n13];
                                        dArray[n9 + 5] = DoubleFFT_3D.this.t[n13 + 1];
                                        dArray[n9 + 6] = DoubleFFT_3D.this.t[n12];
                                        dArray[n9 + 7] = DoubleFFT_3D.this.t[n12 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 == 4) {
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                    n8 = n7 + 2 * n10;
                                    n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15] = dArray[n9 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15 + 1] = dArray[n9 + 3];
                                }
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                    n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                    n8 = n7 + 2 * n10;
                                    n15 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n10;
                                    dArray[n9] = DoubleFFT_3D.this.t[n8];
                                    dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                                    dArray[n9 + 2] = DoubleFFT_3D.this.t[n15];
                                    dArray[n9 + 3] = DoubleFFT_3D.this.t[n15 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) continue;
                            for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                n8 = n7 + 2 * n10;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                            }
                            DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                            for (n10 = 0; n10 < DoubleFFT_3D.this.n2; ++n10) {
                                n9 = n11 + n10 * DoubleFFT_3D.this.rowStride;
                                n8 = n7 + 2 * n10;
                                dArray[n9] = DoubleFFT_3D.this.t[n8];
                                dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n4; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft3da_subth1(final int n, final int n2, final double[][][] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        if (n4 > this.n1) {
            n4 = this.n1;
        }
        int n5 = 8 * this.n2;
        if (this.n3 == 4) {
            n5 >>= 1;
        } else if (this.n3 < 4) {
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n3 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n10;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    DoubleFFT_3D.this.fftn3.complexForward(dArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    DoubleFFT_3D.this.fftn3.realInverse(dArray[i][n32], 0, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n4;
                                    int n5;
                                    for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                        n22 = n7 + 2 * n32;
                                        n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                        n5 = n10 + 2 * DoubleFFT_3D.this.n2;
                                        n4 = n5 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][j];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][j + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[i][n32][j + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[i][n32][j + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n5] = dArray[i][n32][j + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n5 + 1] = dArray[i][n32][j + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4] = dArray[i][n32][j + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4 + 1] = dArray[i][n32][j + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2);
                                    for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                        n22 = n7 + 2 * n32;
                                        n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                        n5 = n10 + 2 * DoubleFFT_3D.this.n2;
                                        n4 = n5 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[i][n32][j] = DoubleFFT_3D.this.t[n22];
                                        dArray[i][n32][j + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[i][n32][j + 2] = DoubleFFT_3D.this.t[n10];
                                        dArray[i][n32][j + 3] = DoubleFFT_3D.this.t[n10 + 1];
                                        dArray[i][n32][j + 4] = DoubleFFT_3D.this.t[n5];
                                        dArray[i][n32][j + 5] = DoubleFFT_3D.this.t[n5 + 1];
                                        dArray[i][n32][j + 6] = DoubleFFT_3D.this.t[n4];
                                        dArray[i][n32][j + 7] = DoubleFFT_3D.this.t[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 == 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    n22 = n7 + 2 * n32;
                                    n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[i][n32][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[i][n32][3];
                                }
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    n22 = n7 + 2 * n32;
                                    n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                    dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                    dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[i][n32][2] = DoubleFFT_3D.this.t[n10];
                                    dArray[i][n32][3] = DoubleFFT_3D.this.t[n10 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) continue;
                            for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                n22 = n7 + 2 * n32;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                            }
                            DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                            for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                n22 = n7 + 2 * n32;
                                dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n11;
                            int n62;
                            int n72;
                            if (n == 0) {
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    DoubleFFT_3D.this.fftn3.complexInverse(dArray[i][n72], bl);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n8;
                                    int n9;
                                    for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                        n62 = n7 + 2 * n72;
                                        n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                        n9 = n11 + 2 * DoubleFFT_3D.this.n2;
                                        n8 = n9 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[i][n72][j];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[i][n72][j + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11] = dArray[i][n72][j + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11 + 1] = dArray[i][n72][j + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[i][n72][j + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[i][n72][j + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[i][n72][j + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[i][n72][j + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2, bl);
                                    for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                        n62 = n7 + 2 * n72;
                                        n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                        n9 = n11 + 2 * DoubleFFT_3D.this.n2;
                                        n8 = n9 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[i][n72][j] = DoubleFFT_3D.this.t[n62];
                                        dArray[i][n72][j + 1] = DoubleFFT_3D.this.t[n62 + 1];
                                        dArray[i][n72][j + 2] = DoubleFFT_3D.this.t[n11];
                                        dArray[i][n72][j + 3] = DoubleFFT_3D.this.t[n11 + 1];
                                        dArray[i][n72][j + 4] = DoubleFFT_3D.this.t[n9];
                                        dArray[i][n72][j + 5] = DoubleFFT_3D.this.t[n9 + 1];
                                        dArray[i][n72][j + 6] = DoubleFFT_3D.this.t[n8];
                                        dArray[i][n72][j + 7] = DoubleFFT_3D.this.t[n8 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.n3 == 4) {
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    n62 = n7 + 2 * n72;
                                    n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[i][n72][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[i][n72][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11] = dArray[i][n72][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11 + 1] = dArray[i][n72][3];
                                }
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    n62 = n7 + 2 * n72;
                                    n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                    dArray[i][n72][0] = DoubleFFT_3D.this.t[n62];
                                    dArray[i][n72][1] = DoubleFFT_3D.this.t[n62 + 1];
                                    dArray[i][n72][2] = DoubleFFT_3D.this.t[n11];
                                    dArray[i][n72][3] = DoubleFFT_3D.this.t[n11 + 1];
                                }
                            } else if (DoubleFFT_3D.this.n3 == 2) {
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    n62 = n7 + 2 * n72;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[i][n72][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[i][n72][1];
                                }
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    n62 = n7 + 2 * n72;
                                    dArray[i][n72][0] = DoubleFFT_3D.this.t[n62];
                                    dArray[i][n72][1] = DoubleFFT_3D.this.t[n62 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                DoubleFFT_3D.this.fftn3.realForward(dArray[i][n72]);
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n4; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft3da_subth2(final int n, final int n2, final double[][][] dArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        if (n4 > this.n1) {
            n4 = this.n1;
        }
        int n5 = 8 * this.n2;
        if (this.n3 == 4) {
            n5 >>= 1;
        } else if (this.n3 < 4) {
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n3 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n10;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    DoubleFFT_3D.this.fftn3.complexForward(dArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    DoubleFFT_3D.this.fftn3.realForward(dArray[i][n32]);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n4;
                                    int n5;
                                    for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                        n22 = n7 + 2 * n32;
                                        n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                        n5 = n10 + 2 * DoubleFFT_3D.this.n2;
                                        n4 = n5 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][j];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][j + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[i][n32][j + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[i][n32][j + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n5] = dArray[i][n32][j + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n5 + 1] = dArray[i][n32][j + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4] = dArray[i][n32][j + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4 + 1] = dArray[i][n32][j + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2);
                                    DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2);
                                    for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                        n22 = n7 + 2 * n32;
                                        n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                        n5 = n10 + 2 * DoubleFFT_3D.this.n2;
                                        n4 = n5 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[i][n32][j] = DoubleFFT_3D.this.t[n22];
                                        dArray[i][n32][j + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[i][n32][j + 2] = DoubleFFT_3D.this.t[n10];
                                        dArray[i][n32][j + 3] = DoubleFFT_3D.this.t[n10 + 1];
                                        dArray[i][n32][j + 4] = DoubleFFT_3D.this.t[n5];
                                        dArray[i][n32][j + 5] = DoubleFFT_3D.this.t[n5 + 1];
                                        dArray[i][n32][j + 6] = DoubleFFT_3D.this.t[n4];
                                        dArray[i][n32][j + 7] = DoubleFFT_3D.this.t[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 == 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    n22 = n7 + 2 * n32;
                                    n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[i][n32][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[i][n32][3];
                                }
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                                DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2);
                                for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                    n22 = n7 + 2 * n32;
                                    n10 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n32;
                                    dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                    dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[i][n32][2] = DoubleFFT_3D.this.t[n10];
                                    dArray[i][n32][3] = DoubleFFT_3D.this.t[n10 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) continue;
                            for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                n22 = n7 + 2 * n32;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                            }
                            DoubleFFT_3D.this.fftn2.complexForward(DoubleFFT_3D.this.t, n7);
                            for (n32 = 0; n32 < DoubleFFT_3D.this.n2; ++n32) {
                                n22 = n7 + 2 * n32;
                                dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n3; i < DoubleFFT_3D.this.n1; i += n6) {
                            int n11;
                            int n62;
                            int n72;
                            if (n == 0) {
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    DoubleFFT_3D.this.fftn3.complexInverse(dArray[i][n72], bl);
                                }
                            } else {
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    DoubleFFT_3D.this.fftn3.realInverse2(dArray[i][n72], 0, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.n3 > 4) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n8;
                                    int n9;
                                    for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                        n62 = n7 + 2 * n72;
                                        n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                        n9 = n11 + 2 * DoubleFFT_3D.this.n2;
                                        n8 = n9 + 2 * DoubleFFT_3D.this.n2;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[i][n72][j];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[i][n72][j + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11] = dArray[i][n72][j + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11 + 1] = dArray[i][n72][j + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[i][n72][j + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[i][n72][j + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[i][n72][j + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[i][n72][j + 7];
                                    }
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 4 * DoubleFFT_3D.this.n2, bl);
                                    DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 6 * DoubleFFT_3D.this.n2, bl);
                                    for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                        n62 = n7 + 2 * n72;
                                        n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                        n9 = n11 + 2 * DoubleFFT_3D.this.n2;
                                        n8 = n9 + 2 * DoubleFFT_3D.this.n2;
                                        dArray[i][n72][j] = DoubleFFT_3D.this.t[n62];
                                        dArray[i][n72][j + 1] = DoubleFFT_3D.this.t[n62 + 1];
                                        dArray[i][n72][j + 2] = DoubleFFT_3D.this.t[n11];
                                        dArray[i][n72][j + 3] = DoubleFFT_3D.this.t[n11 + 1];
                                        dArray[i][n72][j + 4] = DoubleFFT_3D.this.t[n9];
                                        dArray[i][n72][j + 5] = DoubleFFT_3D.this.t[n9 + 1];
                                        dArray[i][n72][j + 6] = DoubleFFT_3D.this.t[n8];
                                        dArray[i][n72][j + 7] = DoubleFFT_3D.this.t[n8 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 == 4) {
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    n62 = n7 + 2 * n72;
                                    n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[i][n72][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[i][n72][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11] = dArray[i][n72][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11 + 1] = dArray[i][n72][3];
                                }
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                                DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7 + 2 * DoubleFFT_3D.this.n2, bl);
                                for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                    n62 = n7 + 2 * n72;
                                    n11 = n7 + 2 * DoubleFFT_3D.this.n2 + 2 * n72;
                                    dArray[i][n72][0] = DoubleFFT_3D.this.t[n62];
                                    dArray[i][n72][1] = DoubleFFT_3D.this.t[n62 + 1];
                                    dArray[i][n72][2] = DoubleFFT_3D.this.t[n11];
                                    dArray[i][n72][3] = DoubleFFT_3D.this.t[n11 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) continue;
                            for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                n62 = n7 + 2 * n72;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[i][n72][0];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[i][n72][1];
                            }
                            DoubleFFT_3D.this.fftn2.complexInverse(DoubleFFT_3D.this.t, n7, bl);
                            for (n72 = 0; n72 < DoubleFFT_3D.this.n2; ++n72) {
                                n62 = n7 + 2 * n72;
                                dArray[i][n72][0] = DoubleFFT_3D.this.t[n62];
                                dArray[i][n72][1] = DoubleFFT_3D.this.t[n62 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n4; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void cdft3db_subth(final int n, final double[] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n2) {
            n3 = this.n2;
        }
        int n4 = 8 * this.n1;
        if (this.n3 == 4) {
            n4 >>= 1;
        } else if (this.n3 < 4) {
            n4 >>= 2;
        }
        final int n5 = n3;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (n != -1) break block25;
                                    if (DoubleFFT_3D.this.n3 <= 4) break block26;
                                    for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                        int n28 = i * DoubleFFT_3D.this.rowStride;
                                        for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                            int n29;
                                            int n3;
                                            int n4;
                                            int n52;
                                            int n62;
                                            int n7;
                                            for (n7 = 0; n7 < DoubleFFT_3D.this.n1; ++n7) {
                                                n62 = n7 * DoubleFFT_3D.this.sliceStride + n28 + j;
                                                n52 = n6 + 2 * n7;
                                                n4 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n7;
                                                n3 = n4 + 2 * DoubleFFT_3D.this.n1;
                                                n29 = n3 + 2 * DoubleFFT_3D.this.n1;
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52] = dArray[n62];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52 + 1] = dArray[n62 + 1];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4] = dArray[n62 + 2];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4 + 1] = dArray[n62 + 3];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3] = dArray[n62 + 4];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3 + 1] = dArray[n62 + 5];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n29] = dArray[n62 + 6];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n29 + 1] = dArray[n62 + 7];
                                            }
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6);
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1);
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.n1);
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.n1);
                                            for (n7 = 0; n7 < DoubleFFT_3D.this.n1; ++n7) {
                                                n62 = n7 * DoubleFFT_3D.this.sliceStride + n28 + j;
                                                n52 = n6 + 2 * n7;
                                                n4 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n7;
                                                n3 = n4 + 2 * DoubleFFT_3D.this.n1;
                                                n29 = n3 + 2 * DoubleFFT_3D.this.n1;
                                                dArray[n62] = DoubleFFT_3D.this.t[n52];
                                                dArray[n62 + 1] = DoubleFFT_3D.this.t[n52 + 1];
                                                dArray[n62 + 2] = DoubleFFT_3D.this.t[n4];
                                                dArray[n62 + 3] = DoubleFFT_3D.this.t[n4 + 1];
                                                dArray[n62 + 4] = DoubleFFT_3D.this.t[n3];
                                                dArray[n62 + 5] = DoubleFFT_3D.this.t[n3 + 1];
                                                dArray[n62 + 6] = DoubleFFT_3D.this.t[n29];
                                                dArray[n62 + 7] = DoubleFFT_3D.this.t[n29 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.n3 != 4) break block28;
                                for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                    int n30;
                                    int n8;
                                    int n9;
                                    int n10;
                                    int n11 = i * DoubleFFT_3D.this.rowStride;
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.n1; ++n10) {
                                        n9 = n10 * DoubleFFT_3D.this.sliceStride + n11;
                                        n8 = n6 + 2 * n10;
                                        n30 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n10;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n30] = dArray[n9 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n30 + 1] = dArray[n9 + 3];
                                    }
                                    DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6);
                                    DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1);
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.n1; ++n10) {
                                        n9 = n10 * DoubleFFT_3D.this.sliceStride + n11;
                                        n8 = n6 + 2 * n10;
                                        n30 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n10;
                                        dArray[n9] = DoubleFFT_3D.this.t[n8];
                                        dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                                        dArray[n9 + 2] = DoubleFFT_3D.this.t[n30];
                                        dArray[n9 + 3] = DoubleFFT_3D.this.t[n30 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) break block27;
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                int n31;
                                int n12;
                                int n13;
                                int n14 = i * DoubleFFT_3D.this.rowStride;
                                for (n13 = 0; n13 < DoubleFFT_3D.this.n1; ++n13) {
                                    n12 = n13 * DoubleFFT_3D.this.sliceStride + n14;
                                    n31 = n6 + 2 * n13;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n31] = dArray[n12];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n31 + 1] = dArray[n12 + 1];
                                }
                                DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6);
                                for (n13 = 0; n13 < DoubleFFT_3D.this.n1; ++n13) {
                                    n12 = n13 * DoubleFFT_3D.this.sliceStride + n14;
                                    n31 = n6 + 2 * n13;
                                    dArray[n12] = DoubleFFT_3D.this.t[n31];
                                    dArray[n12 + 1] = DoubleFFT_3D.this.t[n31 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.n3 > 4) {
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                int n32 = i * DoubleFFT_3D.this.rowStride;
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n15;
                                    int n16;
                                    int n17;
                                    int n18;
                                    int n19;
                                    int n20;
                                    for (n20 = 0; n20 < DoubleFFT_3D.this.n1; ++n20) {
                                        n19 = n20 * DoubleFFT_3D.this.sliceStride + n32 + j;
                                        n18 = n6 + 2 * n20;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n20;
                                        n16 = n17 + 2 * DoubleFFT_3D.this.n1;
                                        n15 = n16 + 2 * DoubleFFT_3D.this.n1;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18] = dArray[n19];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18 + 1] = dArray[n19 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n19 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n19 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n19 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n19 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15] = dArray[n19 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15 + 1] = dArray[n19 + 7];
                                    }
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1, bl);
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.n1, bl);
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.n1, bl);
                                    for (n20 = 0; n20 < DoubleFFT_3D.this.n1; ++n20) {
                                        n19 = n20 * DoubleFFT_3D.this.sliceStride + n32 + j;
                                        n18 = n6 + 2 * n20;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n20;
                                        n16 = n17 + 2 * DoubleFFT_3D.this.n1;
                                        n15 = n16 + 2 * DoubleFFT_3D.this.n1;
                                        dArray[n19] = DoubleFFT_3D.this.t[n18];
                                        dArray[n19 + 1] = DoubleFFT_3D.this.t[n18 + 1];
                                        dArray[n19 + 2] = DoubleFFT_3D.this.t[n17];
                                        dArray[n19 + 3] = DoubleFFT_3D.this.t[n17 + 1];
                                        dArray[n19 + 4] = DoubleFFT_3D.this.t[n16];
                                        dArray[n19 + 5] = DoubleFFT_3D.this.t[n16 + 1];
                                        dArray[n19 + 6] = DoubleFFT_3D.this.t[n15];
                                        dArray[n19 + 7] = DoubleFFT_3D.this.t[n15 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.n3 == 4) {
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                int n33;
                                int n21;
                                int n22;
                                int n23;
                                int n24 = i * DoubleFFT_3D.this.rowStride;
                                for (n23 = 0; n23 < DoubleFFT_3D.this.n1; ++n23) {
                                    n22 = n23 * DoubleFFT_3D.this.sliceStride + n24;
                                    n21 = n6 + 2 * n23;
                                    n33 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n23;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21] = dArray[n22];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21 + 1] = dArray[n22 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n33] = dArray[n22 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n33 + 1] = dArray[n22 + 3];
                                }
                                DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1, bl);
                                for (n23 = 0; n23 < DoubleFFT_3D.this.n1; ++n23) {
                                    n22 = n23 * DoubleFFT_3D.this.sliceStride + n24;
                                    n21 = n6 + 2 * n23;
                                    n33 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n23;
                                    dArray[n22] = DoubleFFT_3D.this.t[n21];
                                    dArray[n22 + 1] = DoubleFFT_3D.this.t[n21 + 1];
                                    dArray[n22 + 2] = DoubleFFT_3D.this.t[n33];
                                    dArray[n22 + 3] = DoubleFFT_3D.this.t[n33 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.n3 == 2) {
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                int n34;
                                int n25;
                                int n26;
                                int n27 = i * DoubleFFT_3D.this.rowStride;
                                for (n26 = 0; n26 < DoubleFFT_3D.this.n1; ++n26) {
                                    n25 = n26 * DoubleFFT_3D.this.sliceStride + n27;
                                    n34 = n6 + 2 * n26;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n34] = dArray[n25];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n34 + 1] = dArray[n25 + 1];
                                }
                                DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                for (n26 = 0; n26 < DoubleFFT_3D.this.n1; ++n26) {
                                    n25 = n26 * DoubleFFT_3D.this.sliceStride + n27;
                                    n34 = n6 + 2 * n26;
                                    dArray[n25] = DoubleFFT_3D.this.t[n34];
                                    dArray[n25 + 1] = DoubleFFT_3D.this.t[n34 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void cdft3db_subth(final int n, final double[][][] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n2) {
            n3 = this.n2;
        }
        int n4 = 8 * this.n1;
        if (this.n3 == 4) {
            n4 >>= 1;
        } else if (this.n3 < 4) {
            n4 >>= 2;
        }
        final int n5 = n3;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (n != -1) break block25;
                                    if (DoubleFFT_3D.this.n3 <= 4) break block26;
                                    for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                        for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                            int n16;
                                            int n22;
                                            int n3;
                                            int n4;
                                            int n52;
                                            for (n52 = 0; n52 < DoubleFFT_3D.this.n1; ++n52) {
                                                n4 = n6 + 2 * n52;
                                                n3 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n52;
                                                n22 = n3 + 2 * DoubleFFT_3D.this.n1;
                                                n16 = n22 + 2 * DoubleFFT_3D.this.n1;
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4] = dArray[n52][i][j];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4 + 1] = dArray[n52][i][j + 1];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3] = dArray[n52][i][j + 2];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3 + 1] = dArray[n52][i][j + 3];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n52][i][j + 4];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n52][i][j + 5];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n52][i][j + 6];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n52][i][j + 7];
                                            }
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6);
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1);
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.n1);
                                            DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.n1);
                                            for (n52 = 0; n52 < DoubleFFT_3D.this.n1; ++n52) {
                                                n4 = n6 + 2 * n52;
                                                n3 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n52;
                                                n22 = n3 + 2 * DoubleFFT_3D.this.n1;
                                                n16 = n22 + 2 * DoubleFFT_3D.this.n1;
                                                dArray[n52][i][j] = DoubleFFT_3D.this.t[n4];
                                                dArray[n52][i][j + 1] = DoubleFFT_3D.this.t[n4 + 1];
                                                dArray[n52][i][j + 2] = DoubleFFT_3D.this.t[n3];
                                                dArray[n52][i][j + 3] = DoubleFFT_3D.this.t[n3 + 1];
                                                dArray[n52][i][j + 4] = DoubleFFT_3D.this.t[n22];
                                                dArray[n52][i][j + 5] = DoubleFFT_3D.this.t[n22 + 1];
                                                dArray[n52][i][j + 6] = DoubleFFT_3D.this.t[n16];
                                                dArray[n52][i][j + 7] = DoubleFFT_3D.this.t[n16 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.n3 != 4) break block28;
                                for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                    int n17;
                                    int n62;
                                    int n7;
                                    for (n7 = 0; n7 < DoubleFFT_3D.this.n1; ++n7) {
                                        n62 = n6 + 2 * n7;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n7;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[n7][i][0];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[n7][i][1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n7][i][2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n7][i][3];
                                    }
                                    DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6);
                                    DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1);
                                    for (n7 = 0; n7 < DoubleFFT_3D.this.n1; ++n7) {
                                        n62 = n6 + 2 * n7;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n7;
                                        dArray[n7][i][0] = DoubleFFT_3D.this.t[n62];
                                        dArray[n7][i][1] = DoubleFFT_3D.this.t[n62 + 1];
                                        dArray[n7][i][2] = DoubleFFT_3D.this.t[n17];
                                        dArray[n7][i][3] = DoubleFFT_3D.this.t[n17 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.n3 != 2) break block27;
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                int n18;
                                int n8;
                                for (n8 = 0; n8 < DoubleFFT_3D.this.n1; ++n8) {
                                    n18 = n6 + 2 * n8;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18] = dArray[n8][i][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18 + 1] = dArray[n8][i][1];
                                }
                                DoubleFFT_3D.this.fftn1.complexForward(DoubleFFT_3D.this.t, n6);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.n1; ++n8) {
                                    n18 = n6 + 2 * n8;
                                    dArray[n8][i][0] = DoubleFFT_3D.this.t[n18];
                                    dArray[n8][i][1] = DoubleFFT_3D.this.t[n18 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.n3 > 4) {
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                for (int j = 0; j < DoubleFFT_3D.this.n3; j += 8) {
                                    int n19;
                                    int n9;
                                    int n10;
                                    int n11;
                                    int n12;
                                    for (n12 = 0; n12 < DoubleFFT_3D.this.n1; ++n12) {
                                        n11 = n6 + 2 * n12;
                                        n10 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n12;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.n1;
                                        n19 = n9 + 2 * DoubleFFT_3D.this.n1;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11] = dArray[n12][i][j];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11 + 1] = dArray[n12][i][j + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[n12][i][j + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[n12][i][j + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n12][i][j + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n12][i][j + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n19] = dArray[n12][i][j + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n19 + 1] = dArray[n12][i][j + 7];
                                    }
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1, bl);
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.n1, bl);
                                    DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.n1, bl);
                                    for (n12 = 0; n12 < DoubleFFT_3D.this.n1; ++n12) {
                                        n11 = n6 + 2 * n12;
                                        n10 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n12;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.n1;
                                        n19 = n9 + 2 * DoubleFFT_3D.this.n1;
                                        dArray[n12][i][j] = DoubleFFT_3D.this.t[n11];
                                        dArray[n12][i][j + 1] = DoubleFFT_3D.this.t[n11 + 1];
                                        dArray[n12][i][j + 2] = DoubleFFT_3D.this.t[n10];
                                        dArray[n12][i][j + 3] = DoubleFFT_3D.this.t[n10 + 1];
                                        dArray[n12][i][j + 4] = DoubleFFT_3D.this.t[n9];
                                        dArray[n12][i][j + 5] = DoubleFFT_3D.this.t[n9 + 1];
                                        dArray[n12][i][j + 6] = DoubleFFT_3D.this.t[n19];
                                        dArray[n12][i][j + 7] = DoubleFFT_3D.this.t[n19 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.n3 == 4) {
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                int n20;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < DoubleFFT_3D.this.n1; ++n14) {
                                    n13 = n6 + 2 * n14;
                                    n20 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n14;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[n14][i][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[n14][i][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n20] = dArray[n14][i][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n20 + 1] = dArray[n14][i][3];
                                }
                                DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.n1, bl);
                                for (n14 = 0; n14 < DoubleFFT_3D.this.n1; ++n14) {
                                    n13 = n6 + 2 * n14;
                                    n20 = n6 + 2 * DoubleFFT_3D.this.n1 + 2 * n14;
                                    dArray[n14][i][0] = DoubleFFT_3D.this.t[n13];
                                    dArray[n14][i][1] = DoubleFFT_3D.this.t[n13 + 1];
                                    dArray[n14][i][2] = DoubleFFT_3D.this.t[n20];
                                    dArray[n14][i][3] = DoubleFFT_3D.this.t[n20 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.n3 == 2) {
                            for (int i = n2; i < DoubleFFT_3D.this.n2; i += n5) {
                                int n21;
                                int n15;
                                for (n15 = 0; n15 < DoubleFFT_3D.this.n1; ++n15) {
                                    n21 = n6 + 2 * n15;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21] = dArray[n15][i][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21 + 1] = dArray[n15][i][1];
                                }
                                DoubleFFT_3D.this.fftn1.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                for (n15 = 0; n15 < DoubleFFT_3D.this.n1; ++n15) {
                                    n21 = n6 + 2 * n15;
                                    dArray[n15][i][0] = DoubleFFT_3D.this.t[n21];
                                    dArray[n15][i][1] = DoubleFFT_3D.this.t[n21 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void rdft3d_sub(int n, double[] dArray) {
        int n2 = this.n1 >> 1;
        int n3 = this.n2 >> 1;
        if (n < 0) {
            int n4;
            int n5;
            double d;
            int n6;
            int n7;
            int n8;
            int n9;
            for (int i = 1; i < n2; ++i) {
                int n10 = this.n1 - i;
                n9 = i * this.sliceStride;
                n8 = n10 * this.sliceStride;
                n7 = i * this.sliceStride + n3 * this.rowStride;
                n6 = n10 * this.sliceStride + n3 * this.rowStride;
                d = dArray[n9] - dArray[n8];
                int n11 = n9;
                dArray[n11] = dArray[n11] + dArray[n8];
                dArray[n8] = d;
                d = dArray[n8 + 1] - dArray[n9 + 1];
                int n12 = n9 + 1;
                dArray[n12] = dArray[n12] + dArray[n8 + 1];
                dArray[n8 + 1] = d;
                d = dArray[n7] - dArray[n6];
                int n13 = n7;
                dArray[n13] = dArray[n13] + dArray[n6];
                dArray[n6] = d;
                d = dArray[n6 + 1] - dArray[n7 + 1];
                int n14 = n7 + 1;
                dArray[n14] = dArray[n14] + dArray[n6 + 1];
                dArray[n6 + 1] = d;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.n2 - n5;
                    n9 = i * this.sliceStride + n5 * this.rowStride;
                    n8 = n10 * this.sliceStride + n4 * this.rowStride;
                    d = dArray[n9] - dArray[n8];
                    int n15 = n9;
                    dArray[n15] = dArray[n15] + dArray[n8];
                    dArray[n8] = d;
                    d = dArray[n8 + 1] - dArray[n9 + 1];
                    int n16 = n9 + 1;
                    dArray[n16] = dArray[n16] + dArray[n8 + 1];
                    dArray[n8 + 1] = d;
                    n7 = n10 * this.sliceStride + n5 * this.rowStride;
                    n6 = i * this.sliceStride + n4 * this.rowStride;
                    d = dArray[n7] - dArray[n6];
                    int n17 = n7;
                    dArray[n17] = dArray[n17] + dArray[n6];
                    dArray[n6] = d;
                    d = dArray[n6 + 1] - dArray[n7 + 1];
                    int n18 = n7 + 1;
                    dArray[n18] = dArray[n18] + dArray[n6 + 1];
                    dArray[n6 + 1] = d;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.n2 - n5;
                n9 = n5 * this.rowStride;
                n8 = n4 * this.rowStride;
                d = dArray[n9] - dArray[n8];
                int n19 = n9;
                dArray[n19] = dArray[n19] + dArray[n8];
                dArray[n8] = d;
                d = dArray[n8 + 1] - dArray[n9 + 1];
                int n20 = n9 + 1;
                dArray[n20] = dArray[n20] + dArray[n8 + 1];
                dArray[n8 + 1] = d;
                n7 = n2 * this.sliceStride + n5 * this.rowStride;
                n6 = n2 * this.sliceStride + n4 * this.rowStride;
                d = dArray[n7] - dArray[n6];
                int n21 = n7;
                dArray[n21] = dArray[n21] + dArray[n6];
                dArray[n6] = d;
                d = dArray[n6 + 1] - dArray[n7 + 1];
                int n22 = n7 + 1;
                dArray[n22] = dArray[n22] + dArray[n6 + 1];
                dArray[n6 + 1] = d;
            }
        } else {
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            for (int i = 1; i < n2; ++i) {
                int n29 = this.n1 - i;
                n28 = n29 * this.sliceStride;
                n27 = i * this.sliceStride;
                dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                int n30 = n27;
                dArray[n30] = dArray[n30] - dArray[n28];
                dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                int n31 = n27 + 1;
                dArray[n31] = dArray[n31] - dArray[n28 + 1];
                n26 = n29 * this.sliceStride + n3 * this.rowStride;
                n25 = i * this.sliceStride + n3 * this.rowStride;
                dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                int n32 = n25;
                dArray[n32] = dArray[n32] - dArray[n26];
                dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                int n33 = n25 + 1;
                dArray[n33] = dArray[n33] - dArray[n26 + 1];
                for (n24 = 1; n24 < n3; ++n24) {
                    n23 = this.n2 - n24;
                    n28 = n29 * this.sliceStride + n23 * this.rowStride;
                    n27 = i * this.sliceStride + n24 * this.rowStride;
                    dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                    int n34 = n27;
                    dArray[n34] = dArray[n34] - dArray[n28];
                    dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                    int n35 = n27 + 1;
                    dArray[n35] = dArray[n35] - dArray[n28 + 1];
                    n26 = i * this.sliceStride + n23 * this.rowStride;
                    n25 = n29 * this.sliceStride + n24 * this.rowStride;
                    dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                    int n36 = n25;
                    dArray[n36] = dArray[n36] - dArray[n26];
                    dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                    int n37 = n25 + 1;
                    dArray[n37] = dArray[n37] - dArray[n26 + 1];
                }
            }
            for (n24 = 1; n24 < n3; ++n24) {
                n23 = this.n2 - n24;
                n28 = n23 * this.rowStride;
                n27 = n24 * this.rowStride;
                dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                int n38 = n27;
                dArray[n38] = dArray[n38] - dArray[n28];
                dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                int n39 = n27 + 1;
                dArray[n39] = dArray[n39] - dArray[n28 + 1];
                n26 = n2 * this.sliceStride + n23 * this.rowStride;
                n25 = n2 * this.sliceStride + n24 * this.rowStride;
                dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                int n40 = n25;
                dArray[n40] = dArray[n40] - dArray[n26];
                dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                int n41 = n25 + 1;
                dArray[n41] = dArray[n41] - dArray[n26 + 1];
            }
        }
    }

    private void rdft3d_sub(int n, double[][][] dArray) {
        int n2 = this.n1 >> 1;
        int n3 = this.n2 >> 1;
        if (n < 0) {
            int n4;
            int n5;
            double d;
            for (int i = 1; i < n2; ++i) {
                int n6 = this.n1 - i;
                d = dArray[i][0][0] - dArray[n6][0][0];
                double[] dArray2 = dArray[i][0];
                dArray2[0] = dArray2[0] + dArray[n6][0][0];
                dArray[n6][0][0] = d;
                d = dArray[n6][0][1] - dArray[i][0][1];
                double[] dArray3 = dArray[i][0];
                dArray3[1] = dArray3[1] + dArray[n6][0][1];
                dArray[n6][0][1] = d;
                d = dArray[i][n3][0] - dArray[n6][n3][0];
                double[] dArray4 = dArray[i][n3];
                dArray4[0] = dArray4[0] + dArray[n6][n3][0];
                dArray[n6][n3][0] = d;
                d = dArray[n6][n3][1] - dArray[i][n3][1];
                double[] dArray5 = dArray[i][n3];
                dArray5[1] = dArray5[1] + dArray[n6][n3][1];
                dArray[n6][n3][1] = d;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.n2 - n5;
                    d = dArray[i][n5][0] - dArray[n6][n4][0];
                    double[] dArray6 = dArray[i][n5];
                    dArray6[0] = dArray6[0] + dArray[n6][n4][0];
                    dArray[n6][n4][0] = d;
                    d = dArray[n6][n4][1] - dArray[i][n5][1];
                    double[] dArray7 = dArray[i][n5];
                    dArray7[1] = dArray7[1] + dArray[n6][n4][1];
                    dArray[n6][n4][1] = d;
                    d = dArray[n6][n5][0] - dArray[i][n4][0];
                    double[] dArray8 = dArray[n6][n5];
                    dArray8[0] = dArray8[0] + dArray[i][n4][0];
                    dArray[i][n4][0] = d;
                    d = dArray[i][n4][1] - dArray[n6][n5][1];
                    double[] dArray9 = dArray[n6][n5];
                    dArray9[1] = dArray9[1] + dArray[i][n4][1];
                    dArray[i][n4][1] = d;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.n2 - n5;
                d = dArray[0][n5][0] - dArray[0][n4][0];
                double[] dArray10 = dArray[0][n5];
                dArray10[0] = dArray10[0] + dArray[0][n4][0];
                dArray[0][n4][0] = d;
                d = dArray[0][n4][1] - dArray[0][n5][1];
                double[] dArray11 = dArray[0][n5];
                dArray11[1] = dArray11[1] + dArray[0][n4][1];
                dArray[0][n4][1] = d;
                d = dArray[n2][n5][0] - dArray[n2][n4][0];
                double[] dArray12 = dArray[n2][n5];
                dArray12[0] = dArray12[0] + dArray[n2][n4][0];
                dArray[n2][n4][0] = d;
                d = dArray[n2][n4][1] - dArray[n2][n5][1];
                double[] dArray13 = dArray[n2][n5];
                dArray13[1] = dArray13[1] + dArray[n2][n4][1];
                dArray[n2][n4][1] = d;
            }
        } else {
            int n7;
            int n8;
            for (int i = 1; i < n2; ++i) {
                int n9 = this.n1 - i;
                dArray[n9][0][0] = 0.5 * (dArray[i][0][0] - dArray[n9][0][0]);
                double[] dArray14 = dArray[i][0];
                dArray14[0] = dArray14[0] - dArray[n9][0][0];
                dArray[n9][0][1] = 0.5 * (dArray[i][0][1] + dArray[n9][0][1]);
                double[] dArray15 = dArray[i][0];
                dArray15[1] = dArray15[1] - dArray[n9][0][1];
                dArray[n9][n3][0] = 0.5 * (dArray[i][n3][0] - dArray[n9][n3][0]);
                double[] dArray16 = dArray[i][n3];
                dArray16[0] = dArray16[0] - dArray[n9][n3][0];
                dArray[n9][n3][1] = 0.5 * (dArray[i][n3][1] + dArray[n9][n3][1]);
                double[] dArray17 = dArray[i][n3];
                dArray17[1] = dArray17[1] - dArray[n9][n3][1];
                for (n8 = 1; n8 < n3; ++n8) {
                    n7 = this.n2 - n8;
                    dArray[n9][n7][0] = 0.5 * (dArray[i][n8][0] - dArray[n9][n7][0]);
                    double[] dArray18 = dArray[i][n8];
                    dArray18[0] = dArray18[0] - dArray[n9][n7][0];
                    dArray[n9][n7][1] = 0.5 * (dArray[i][n8][1] + dArray[n9][n7][1]);
                    double[] dArray19 = dArray[i][n8];
                    dArray19[1] = dArray19[1] - dArray[n9][n7][1];
                    dArray[i][n7][0] = 0.5 * (dArray[n9][n8][0] - dArray[i][n7][0]);
                    double[] dArray20 = dArray[n9][n8];
                    dArray20[0] = dArray20[0] - dArray[i][n7][0];
                    dArray[i][n7][1] = 0.5 * (dArray[n9][n8][1] + dArray[i][n7][1]);
                    double[] dArray21 = dArray[n9][n8];
                    dArray21[1] = dArray21[1] - dArray[i][n7][1];
                }
            }
            for (n8 = 1; n8 < n3; ++n8) {
                n7 = this.n2 - n8;
                dArray[0][n7][0] = 0.5 * (dArray[0][n8][0] - dArray[0][n7][0]);
                double[] dArray22 = dArray[0][n8];
                dArray22[0] = dArray22[0] - dArray[0][n7][0];
                dArray[0][n7][1] = 0.5 * (dArray[0][n8][1] + dArray[0][n7][1]);
                double[] dArray23 = dArray[0][n8];
                dArray23[1] = dArray23[1] - dArray[0][n7][1];
                dArray[n2][n7][0] = 0.5 * (dArray[n2][n8][0] - dArray[n2][n7][0]);
                double[] dArray24 = dArray[n2][n8];
                dArray24[0] = dArray24[0] - dArray[n2][n7][0];
                dArray[n2][n7][1] = 0.5 * (dArray[n2][n8][1] + dArray[n2][n7][1]);
                double[] dArray25 = dArray[n2][n8];
                dArray25[1] = dArray25[1] - dArray[n2][n7][1];
            }
        }
    }

    private void fillSymmetric(final double[] dArray) {
        int n;
        int n2 = ConcurrencyUtils.getNumberOfProcessors();
        Future[] futureArray = new Future[n2];
        int n3 = this.n1 / n2;
        final int n4 = this.n3 * 2;
        final int n5 = this.n2 * n4;
        final int n6 = n4;
        final int n7 = this.n2 / 2;
        for (n = 0; n < n2; ++n) {
            final int n8 = n * n3;
            final int n9 = n8 + n3;
            futureArray[n] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    int n;
                    int n2;
                    int n3;
                    int n42;
                    for (n42 = n8; n42 < n9; ++n42) {
                        for (n3 = 0; n3 < DoubleFFT_3D.this.n2; ++n3) {
                            for (int i = 1; i < DoubleFFT_3D.this.n3; i += 2) {
                                n2 = (DoubleFFT_3D.this.n1 - n42) % DoubleFFT_3D.this.n1 * n5 + (DoubleFFT_3D.this.n2 - n3) % DoubleFFT_3D.this.n2 * n6 + n4 - i;
                                n = n42 * n5 + n3 * n6 + i;
                                dArray[n2] = -dArray[n + 2];
                                dArray[n2 - 1] = dArray[n + 1];
                            }
                        }
                    }
                    for (n42 = n8; n42 < n9; ++n42) {
                        for (n3 = 1; n3 < n7; ++n3) {
                            n2 = (DoubleFFT_3D.this.n1 - n42) % DoubleFFT_3D.this.n1 * n5 + n3 * n6 + DoubleFFT_3D.this.n3;
                            n = n42 * n5 + (DoubleFFT_3D.this.n2 - n3) * n6;
                            int n52 = n42 * n5 + (DoubleFFT_3D.this.n2 - n3) * n6 + DoubleFFT_3D.this.n3;
                            dArray[n2] = dArray[n + 1];
                            dArray[n52] = dArray[n + 1];
                            dArray[n2 + 1] = -dArray[n];
                            dArray[n52 + 1] = dArray[n];
                        }
                    }
                }
            });
        }
        try {
            for (n = 0; n < n2; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void fillSymmetric(final double[][][] dArray) {
        int n;
        int n2 = ConcurrencyUtils.getNumberOfProcessors();
        Future[] futureArray = new Future[n2];
        int n3 = this.n1 / n2;
        final int n4 = this.n3 * 2;
        final int n5 = this.n2 / 2;
        for (n = 0; n < n2; ++n) {
            final int n6 = n * n3;
            final int n7 = n6 + n3;
            futureArray[n] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    int n;
                    int n2;
                    for (n2 = n6; n2 < n7; ++n2) {
                        for (n = 0; n < DoubleFFT_3D.this.n2; ++n) {
                            for (int i = 1; i < DoubleFFT_3D.this.n3; i += 2) {
                                dArray[(((DoubleFFT_3D)DoubleFFT_3D.this).n1 - n2) % ((DoubleFFT_3D)DoubleFFT_3D.this).n1][(((DoubleFFT_3D)DoubleFFT_3D.this).n2 - n) % ((DoubleFFT_3D)DoubleFFT_3D.this).n2][n4 - i] = -dArray[n2][n][i + 2];
                                dArray[(((DoubleFFT_3D)DoubleFFT_3D.this).n1 - n2) % ((DoubleFFT_3D)DoubleFFT_3D.this).n1][(((DoubleFFT_3D)DoubleFFT_3D.this).n2 - n) % ((DoubleFFT_3D)DoubleFFT_3D.this).n2][n4 - i - 1] = dArray[n2][n][i + 1];
                            }
                        }
                    }
                    for (n2 = n6; n2 < n7; ++n2) {
                        for (n = 1; n < n5; ++n) {
                            dArray[(((DoubleFFT_3D)DoubleFFT_3D.this).n1 - n2) % ((DoubleFFT_3D)DoubleFFT_3D.this).n1][n][((DoubleFFT_3D)DoubleFFT_3D.this).n3] = dArray[n2][DoubleFFT_3D.this.n2 - n][1];
                            dArray[n2][((DoubleFFT_3D)DoubleFFT_3D.this).n2 - n][((DoubleFFT_3D)DoubleFFT_3D.this).n3] = dArray[n2][DoubleFFT_3D.this.n2 - n][1];
                            dArray[(((DoubleFFT_3D)DoubleFFT_3D.this).n1 - n2) % ((DoubleFFT_3D)DoubleFFT_3D.this).n1][n][((DoubleFFT_3D)DoubleFFT_3D.this).n3 + 1] = -dArray[n2][DoubleFFT_3D.this.n2 - n][0];
                            dArray[n2][((DoubleFFT_3D)DoubleFFT_3D.this).n2 - n][((DoubleFFT_3D)DoubleFFT_3D.this).n3 + 1] = dArray[n2][DoubleFFT_3D.this.n2 - n][0];
                        }
                    }
                }
            });
        }
        try {
            for (n = 0; n < n2; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

