/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.jersey.filters;

import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.zookeeper.server.jersey.cfg.Credentials;

public class HTTPBasicAuth
implements Filter {
    private Credentials credentials;

    public HTTPBasicAuth(Credentials c) {
        this.credentials = c;
    }

    public void doFilter(ServletRequest req0, ServletResponse resp0, FilterChain chain) throws IOException, ServletException {
        String[] c;
        HttpServletRequest request = (HttpServletRequest)req0;
        HttpServletResponse response = (HttpServletResponse)resp0;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && (c = this.parseAuthorization(authorization)) != null && this.credentials.containsKey(c[0]) && ((String)this.credentials.get(c[0])).equals(c[1])) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        response.setHeader("WWW-Authenticate", "Basic realm=\"Restricted\"");
        response.sendError(401);
    }

    private String[] parseAuthorization(String authorization) {
        String userPass;
        int p;
        String[] parts = authorization.split(" ");
        if (parts.length == 2 && parts[0].equalsIgnoreCase("Basic") && (p = (userPass = Base64.base64Decode((String)parts[1])).indexOf(":")) != -1) {
            return new String[]{userPass.substring(0, p), userPass.substring(p + 1)};
        }
        return null;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

