/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import org.testng.DataProviderHolder;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Parameters;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;

class ParameterHandler {
    private final IAnnotationFinder finder;
    private final DataProviderHolder holder;

    ParameterHandler(IAnnotationFinder finder, DataProviderHolder holder) {
        this.finder = finder;
        this.holder = holder;
    }

    ParameterBag createParameters(ITestNGMethod testMethod, Map<String, String> parameters, Map<String, String> allParameterNames, ITestContext testContext) {
        return this.createParameters(testMethod, parameters, allParameterNames, testContext, null);
    }

    ParameterBag createParameters(ITestNGMethod testMethod, Map<String, String> parameters, Map<String, String> allParameterNames, ITestContext testContext, Object fedInstance) {
        return this.handleParameters(testMethod, testMethod.getInstance(), allParameterNames, parameters, testContext, fedInstance);
    }

    private ParameterBag handleParameters(ITestNGMethod testMethod, Object instance, Map<String, String> allParameterNames, Map<String, String> parameters, ITestContext testContext, Object fedInstance) {
        XmlSuite suite = testContext.getCurrentXmlTest().getSuite();
        try {
            Parameters.MethodParameters methodParams = Parameters.MethodParameters.newInstance(parameters, testMethod, testContext);
            ParameterHolder paramHolder = Parameters.handleParameters(testMethod, allParameterNames, instance, methodParams, suite, this.finder, fedInstance, this.holder);
            return new ParameterBag(paramHolder);
        }
        catch (Throwable cause) {
            String msg = Utils.longStackTrace(cause.getCause() != null ? cause.getCause() : cause, true);
            if (Strings.isNotNullAndNotEmpty(msg)) {
                Utils.error(msg);
            }
            TestResult result = TestResult.newTestResultWithCauseAs(testMethod, testContext, cause);
            return new ParameterBag(result);
        }
    }

    static class ParameterBag {
        final ParameterHolder parameterHolder;
        final ITestResult errorResult;

        ParameterBag(ParameterHolder parameterHolder) {
            this.parameterHolder = parameterHolder;
            this.errorResult = null;
        }

        ParameterBag(ITestResult errorResult) {
            this.parameterHolder = null;
            this.errorResult = errorResult;
        }

        boolean hasErrors() {
            return this.errorResult != null;
        }

        boolean runInParallel() {
            return this.parameterHolder != null && this.parameterHolder.origin == ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER && this.parameterHolder.dataProviderHolder.isParallel();
        }
    }
}

