/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds.bvtree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.bv.BitVector01Divider;
import org.trie4j.bv.BytesRank0OnlySuccinctBitVector;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.louds.bvtree.BvTree;
import org.trie4j.util.Range;

public class LOUDSPPBvTree
implements Externalizable,
BvTree {
    private final BitVector01Divider divider;
    private SuccinctBitVector r0;
    private SuccinctBitVector r1;

    public LOUDSPPBvTree() {
        this(0);
    }

    public LOUDSPPBvTree(int initialNodeCapacity) {
        this.r0 = new BytesRank0OnlySuccinctBitVector(initialNodeCapacity);
        this.r1 = new BytesSuccinctBitVector(initialNodeCapacity);
        this.divider = new BitVector01Divider(this.r0, this.r1);
    }

    public LOUDSPPBvTree(BitVector01Divider divider, SuccinctBitVector r0, SuccinctBitVector r1) {
        this.divider = divider;
        this.r0 = r0;
        this.r1 = r1;
        divider.setVectors(r0, r1);
    }

    public LOUDSPPBvTree(SuccinctBitVector r0, SuccinctBitVector r1) {
        this.divider = new BitVector01Divider();
        this.r0 = r0;
        this.r1 = r1;
        this.divider.setVectors(r0, r1);
    }

    public BitVector01Divider getDivider() {
        return this.divider;
    }

    public SuccinctBitVector getR0() {
        return this.r0;
    }

    public SuccinctBitVector getR1() {
        return this.r1;
    }

    public String toString() {
        return "r0: " + this.r0.toString() + "  r1: " + this.r1.toString();
    }

    @Override
    public void appendChild() {
        this.divider.append1();
    }

    @Override
    public void appendSelf() {
        this.divider.append0();
    }

    @Override
    public void getChildNodeIds(int selfNodeId, Range range) {
        if (this.r0.isZero(selfNodeId)) {
            int start = this.r1.select0(this.r0.rank0(selfNodeId)) + 1;
            range.set(start, this.r1.next0(start) + 1);
            return;
        }
        range.set(-1, -1);
    }

    @Override
    public void trimToSize() {
        this.r0.trimToSize();
        this.r1.trimToSize();
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.divider.readExternal(in);
        this.r0 = (SuccinctBitVector)in.readObject();
        this.r1 = (SuccinctBitVector)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.divider.writeExternal(out);
        out.writeObject(this.r0);
        out.writeObject(this.r1);
    }
}

