/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.support.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.activemq.apollo.openwire.command.ActiveMQBlobMessage;
import org.apache.activemq.apollo.openwire.support.OpenwireException;
import org.apache.activemq.apollo.openwire.support.blob.BlobTransferPolicy;
import org.apache.activemq.apollo.openwire.support.blob.BlobUploadStrategy;

public class DefaultBlobUploadStrategy
implements BlobUploadStrategy {
    private BlobTransferPolicy transferPolicy;

    public DefaultBlobUploadStrategy(BlobTransferPolicy transferPolicy) {
        this.transferPolicy = transferPolicy;
    }

    public URL uploadFile(ActiveMQBlobMessage message, File file) throws OpenwireException, IOException {
        return this.uploadStream(message, new FileInputStream(file));
    }

    public URL uploadStream(ActiveMQBlobMessage message, InputStream fis) throws OpenwireException, IOException {
        URL url = this.createUploadURL(message);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        connection.setChunkedStreamingMode(this.transferPolicy.getBufferSize());
        OutputStream os = connection.getOutputStream();
        byte[] buf = new byte[this.transferPolicy.getBufferSize()];
        int c = fis.read(buf);
        while (c != -1) {
            os.write(buf, 0, c);
            os.flush();
            c = fis.read(buf);
        }
        os.close();
        fis.close();
        if (!this.isSuccessfulCode(connection.getResponseCode())) {
            throw new IOException("PUT was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return url;
    }

    public void deleteFile(ActiveMQBlobMessage message) throws IOException, OpenwireException {
        URL url = this.createUploadURL(message);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.connect();
        connection.disconnect();
        if (!this.isSuccessfulCode(connection.getResponseCode())) {
            throw new IOException("DELETE was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    private boolean isSuccessfulCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    protected URL createUploadURL(ActiveMQBlobMessage message) throws OpenwireException, MalformedURLException {
        return new URL(this.transferPolicy.getUploadUrl() + message.getMessageId().toString());
    }
}

