/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.BGZIPOutputStream;
import blbutil.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class FileUtil {
    private FileUtil() {
    }

    public static File tempFile(String string, File file) {
        if (string == null) {
            throw new NullPointerException(String.class.toString());
        }
        if (file == null) {
            throw new NullPointerException(File.class.toString());
        }
        File file2 = null;
        try {
            file2 = File.createTempFile(string, null, file);
            file2.deleteOnExit();
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening file", iOException);
        }
        return file2;
    }

    public static RandomAccessFile randomAccessFile(File file, String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error: file not found [" + file + "]", fileNotFoundException);
        }
        return randomAccessFile;
    }

    public static InputStream bufferedInputStream(File file) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error: file not found [" + file + "]", fileNotFoundException);
        }
        return bufferedInputStream;
    }

    public static OutputStream bufferedOutputStream(File file) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error: file not found [" + file + "]", fileNotFoundException);
        }
        return bufferedOutputStream;
    }

    public static OutputStream bufferedOutputStream(File file, boolean bl) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error: file not found [" + file + "]", fileNotFoundException);
        }
        return bufferedOutputStream;
    }

    public static PrintWriter stdOutPrintWriter() {
        return new PrintWriter(new BufferedOutputStream(System.out));
    }

    public static PrintWriter gzipPrintWriter(File file) {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
            printWriter = new PrintWriter(gZIPOutputStream);
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static PrintWriter gzipPrintWriter(File file, boolean bl) {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
            printWriter = new PrintWriter(gZIPOutputStream);
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static PrintWriter bgzipPrintWriter(File file) {
        boolean bl = true;
        OutputStream outputStream = FileUtil.bufferedOutputStream(file);
        return new PrintWriter(new BGZIPOutputStream(outputStream, bl));
    }

    public static PrintWriter bgzipPrintWriter(File file, boolean bl) {
        boolean bl2 = true;
        OutputStream outputStream = FileUtil.bufferedOutputStream(file, bl);
        return new PrintWriter(new BGZIPOutputStream(outputStream, bl2));
    }

    public static PrintWriter printWriter(File file) {
        return FileUtil.printWriter(file, false);
    }

    public static PrintWriter printWriter(File file, boolean bl) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, bl)));
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static PrintWriter nonBufferedPrintWriter(File file, boolean bl) {
        boolean bl2 = true;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file, bl), bl2);
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static File tempFile(String string) {
        File file = null;
        try {
            file = File.createTempFile(string, null);
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            Utilities.exit("Exception thrown by createTempFile: ", iOException);
        }
        return file;
    }
}

