/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.help;

import java.awt.event.ActionEvent;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.Utils;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.images.IconLoader;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swingframework.AboutDialog;
import org.diylc.swingframework.LinkLabel;

public class HelpMenuPlugin
implements IPlugIn {
    private static final String HELP_TITLE = "Help";
    public static String MANUAL_URL = "http://code.google.com/p/diy-layout-creator/wiki/Manual";
    public static String FAQ_URL = "http://code.google.com/p/diy-layout-creator/wiki/FAQ";
    public static String COMPONENT_URL = "http://code.google.com/p/diy-layout-creator/wiki/ComponentAPI";
    public static String PLUGIN_URL = "http://code.google.com/p/diy-layout-creator/wiki/PluginAPI";
    public static String BUG_URL = "http://code.google.com/p/diy-layout-creator/issues/entry";
    public static String DONATE_URL = "https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=25161";
    private IPlugInPort plugInPort;
    private AboutDialog aboutDialog;

    public HelpMenuPlugin(ISwingUI iSwingUI) {
        iSwingUI.injectMenuAction(new NavigateURLAction("User Manual", IconLoader.Manual.getIcon(), MANUAL_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("FAQ", IconLoader.Faq.getIcon(), FAQ_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Component API", IconLoader.Component.getIcon(), COMPONENT_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Plugin API", IconLoader.Plugin.getIcon(), PLUGIN_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Submit a Bug", IconLoader.Bug.getIcon(), BUG_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(null, HELP_TITLE);
        iSwingUI.injectMenuAction(new NavigateURLAction("Donate", IconLoader.Donate.getIcon(), DONATE_URL), HELP_TITLE);
        iSwingUI.injectMenuAction(new AboutAction(), HELP_TITLE);
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return null;
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
    }

    private AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = DialogFactory.getInstance().createAboutDialog("DIY Layout Creator", IconLoader.IconLarge.getIcon(), this.plugInPort.getCurrentVersionNumber().toString(), "Branislav Stojkovic", "diylc.org", "bancika@gmail.com", "");
        }
        return this.aboutDialog;
    }

    class NavigateURLAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String url;

        public NavigateURLAction(String string, Icon icon, String string2) {
            this.url = string2;
            this.putValue("Name", string);
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Utils.openURL((String)this.url);
            }
            catch (Exception exception) {
                Logger.getLogger(LinkLabel.class).error((Object)"Could not launch default browser", (Throwable)exception);
            }
        }
    }

    class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AboutAction() {
            this.putValue("Name", "About");
            this.putValue("SmallIcon", IconLoader.About.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpMenuPlugin.this.getAboutDialog().setVisible(true);
        }
    }
}

