/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsUtils;
import org.jitsi.nlj.dtls.DtlsUtilsKt;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.rtp.extensions.ByteBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\fH\u0016J\b\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$H\u0016J\u0014\u0010%\u001a\u0004\u0018\u00010\u00132\b\u0010&\u001a\u0004\u0018\u00010\u0015H\u0016J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0014\u00a2\u0006\u0002\u0010*J,\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0018\u00103\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J\u0012\u00104\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00010)H\u0016J\b\u00108\u001a\u00020\u0007H\u0016J\u001a\u00109\u001a\u00020\u00072\u0010\u0010:\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006;"}, d2={"Lorg/jitsi/nlj/dtls/TlsServerImpl;", "Lorg/bouncycastle/tls/DefaultTlsServer;", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "notifyClientCertificateReceived", "Lkotlin/Function1;", "Lorg/bouncycastle/tls/Certificate;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/dtls/CertificateInfo;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;)V", "chosenSrtpProtectionProfile", "", "getChosenSrtpProtectionProfile", "()I", "setChosenSrtpProtectionProfile", "(I)V", "logger", "session", "Lorg/bouncycastle/tls/TlsSession;", "srtpKeyingMaterial", "", "getSrtpKeyingMaterial", "()[B", "setSrtpKeyingMaterial", "([B)V", "getCertificateRequest", "Lorg/bouncycastle/tls/CertificateRequest;", "getCipherSuites", "", "getECDSASignerCredentials", "Lorg/bouncycastle/tls/TlsCredentialedSigner;", "getHandshakeTimeoutMillis", "getRSAEncryptionCredentials", "Lorg/bouncycastle/tls/TlsCredentialedDecryptor;", "getServerExtensions", "Ljava/util/Hashtable;", "getSessionToResume", "sessionID", "getSupportedVersions", "", "Lorg/bouncycastle/tls/ProtocolVersion;", "()[Lorg/bouncycastle/tls/ProtocolVersion;", "notifyAlertRaised", "alertLevel", "", "alertDescription", "message", "", "cause", "", "notifyAlertReceived", "notifyClientCertificate", "clientCertificate", "notifyClientVersion", "clientVersion", "notifyHandshakeComplete", "processClientExtensions", "clientExtensions", "jitsi-media-transform"})
@SuppressFBWarnings(value={"NP_ALWAYS_NULL"}, justification="False positives with 'lateinit'.")
public final class TlsServerImpl
extends DefaultTlsServer {
    @NotNull
    private final CertificateInfo certificateInfo;
    @NotNull
    private final Function1<Certificate, Unit> notifyClientCertificateReceived;
    @NotNull
    private final Logger logger;
    @Nullable
    private TlsSession session;
    public byte[] srtpKeyingMaterial;
    private int chosenSrtpProtectionProfile;

    public TlsServerImpl(@NotNull CertificateInfo certificateInfo2, @NotNull Function1<? super Certificate, Unit> notifyClientCertificateReceived, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(certificateInfo2, "certificateInfo");
        Intrinsics.checkNotNullParameter(notifyClientCertificateReceived, "notifyClientCertificateReceived");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(DtlsUtilsKt.getBC_TLS_CRYPTO());
        this.certificateInfo = certificateInfo2;
        this.notifyClientCertificateReceived = notifyClientCertificateReceived;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @NotNull
    public final byte[] getSrtpKeyingMaterial() {
        if (this.srtpKeyingMaterial != null) {
            return this.srtpKeyingMaterial;
        }
        Intrinsics.throwUninitializedPropertyAccessException("srtpKeyingMaterial");
        return null;
    }

    public final void setSrtpKeyingMaterial(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.srtpKeyingMaterial = byArray;
    }

    public final int getChosenSrtpProtectionProfile() {
        return this.chosenSrtpProtectionProfile;
    }

    public final void setChosenSrtpProtectionProfile(int n) {
        this.chosenSrtpProtectionProfile = n;
    }

    @Override
    @Nullable
    public TlsSession getSessionToResume(@Nullable byte[] sessionID) {
        return this.session;
    }

    @Override
    @NotNull
    public Hashtable<?, ?> getServerExtensions() {
        Hashtable extensions;
        Hashtable hashtable = super.getServerExtensions();
        Hashtable it = hashtable = (extensions = hashtable == null ? new Hashtable() : hashtable);
        boolean bl = false;
        if (TlsSRTPUtils.getUseSRTPExtension(it) == null) {
            int[] nArray = new int[]{this.chosenSrtpProtectionProfile};
            TlsSRTPUtils.addUseSRTPExtension(it, new UseSRTPData(nArray, TlsUtils.EMPTY_BYTES));
        }
        return hashtable;
    }

    public void processClientExtensions(@Nullable Hashtable<?, ?> clientExtensions) {
        super.processClientExtensions(clientExtensions);
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension(clientExtensions);
        int[] protectionProfiles2 = useSRTPData.getProtectionProfiles();
        Iterable iterable = SrtpConfig.Companion.getProtectionProfiles();
        Intrinsics.checkNotNullExpressionValue(protectionProfiles2, "protectionProfiles");
        this.chosenSrtpProtectionProfile = DtlsUtils.Companion.chooseSrtpProtectionProfile(iterable, ArraysKt.asIterable(protectionProfiles2));
    }

    @Override
    @NotNull
    public int[] getCipherSuites() {
        int[] nArray = new int[]{49195, 49161};
        return nArray;
    }

    @Override
    @NotNull
    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() {
        TlsCrypto tlsCrypto = this.context.getCrypto();
        if (tlsCrypto == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
        }
        return new BcDefaultTlsCredentialedDecryptor((BcTlsCrypto)tlsCrypto, this.certificateInfo.getCertificate(), PrivateKeyFactory.createKey(this.certificateInfo.getKeyPair().getPrivate().getEncoded()));
    }

    @Override
    @NotNull
    protected TlsCredentialedSigner getECDSASignerCredentials() {
        TlsCrypto tlsCrypto = this.context.getCrypto();
        if (tlsCrypto == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
        }
        return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (BcTlsCrypto)tlsCrypto, PrivateKeyFactory.createKey(this.certificateInfo.getKeyPair().getPrivate().getEncoded()), this.certificateInfo.getCertificate(), TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion()) ? new SignatureAndHashAlgorithm(4, 3) : null);
    }

    @Override
    @NotNull
    public CertificateRequest getCertificateRequest() {
        CertificateRequest certificateRequest;
        Vector<SignatureAndHashAlgorithm> signatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(1);
        signatureAlgorithms.add(new SignatureAndHashAlgorithm(4, 3));
        signatureAlgorithms.add(new SignatureAndHashAlgorithm(2, 1));
        ProtocolVersion protocolVersion = this.context.getClientVersion();
        if (Intrinsics.areEqual(protocolVersion, ProtocolVersion.DTLSv10)) {
            short[] sArray = new short[]{1};
            CertificateRequest certificateRequest2 = new CertificateRequest(sArray, null, null);
            certificateRequest = certificateRequest2;
        } else if (Intrinsics.areEqual(protocolVersion, ProtocolVersion.DTLSv12)) {
            short[] sArray = new short[]{64};
            CertificateRequest certificateRequest3 = new CertificateRequest(sArray, signatureAlgorithms, null);
            certificateRequest = certificateRequest3;
        } else {
            throw new DtlsUtils.DtlsException("Unsupported version: " + this.context.getClientVersion());
        }
        return certificateRequest;
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return (int)DtlsUtils.Companion.getConfig().getHandshakeTimeout().toMillis();
    }

    @Override
    public void notifyHandshakeComplete() {
        super.notifyHandshakeComplete();
        TlsSession tlsSession = this.context.getResumableSession();
        if (tlsSession != null) {
            Unit unit;
            TlsSession newSession = tlsSession;
            boolean bl = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(newSession.sessionID)");
            String newSessionIdHex = ByteBufferKt.toHex(byteBuffer);
            TlsSession tlsSession2 = this.session;
            if (tlsSession2 != null) {
                TlsSession existingSession = tlsSession2;
                boolean bl2 = false;
                byte[] byArray = existingSession.getSessionID();
                boolean bl3 = byArray != null ? Arrays.equals(byArray, newSession.getSessionID()) : false;
                if (bl3) {
                    Logger $this$cinfo$iv = this.logger;
                    boolean $i$f$cinfo = false;
                    if ($this$cinfo$iv.isInfoEnabled()) {
                        Logger logger = $this$cinfo$iv;
                        boolean bl4 = false;
                        logger.info("Resumed DTLS session " + newSessionIdHex);
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                TlsServerImpl $this$notifyHandshakeComplete_u24lambda_u2d5_u24lambda_u2d4 = this;
                boolean bl5 = false;
                Logger $this$cinfo$iv = $this$notifyHandshakeComplete_u24lambda_u2d5_u24lambda_u2d4.logger;
                boolean $i$f$cinfo = false;
                if ($this$cinfo$iv.isInfoEnabled()) {
                    Logger logger = $this$cinfo$iv;
                    boolean bl6 = false;
                    logger.info("Established DTLS session " + newSessionIdHex);
                }
                $this$notifyHandshakeComplete_u24lambda_u2d5_u24lambda_u2d4.session = newSession;
            }
        }
        SrtpProfileInformation srtpProfileInformation = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(this.chosenSrtpProtectionProfile);
        if (!this.context.getSecurityParameters().isExtendedMasterSecret()) {
            Object object = this.context.getSession();
            if (object != null && (object = object.exportSessionParameters()) != null && (object = ((SessionParameters)object).getMasterSecret()) != null) {
                Object it = object;
                boolean bl = false;
                TlsServerContext tlsServerContext = this.context;
                Intrinsics.checkNotNullExpressionValue(tlsServerContext, "context");
                this.setSrtpKeyingMaterial(DtlsUtils.Companion.exportKeyingMaterial(tlsServerContext, "EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength()), (TlsSecret)it));
            }
        } else {
            byte[] byArray = this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength()));
            Intrinsics.checkNotNullExpressionValue(byArray, "context.exportKeyingMate\u2026SaltLength)\n            )");
            this.setSrtpKeyingMaterial(byArray);
        }
    }

    @Override
    public void notifyClientCertificate(@Nullable Certificate clientCertificate) {
        this.notifyClientCertificateReceived.invoke(clientCertificate);
    }

    @Override
    public void notifyClientVersion(@Nullable ProtocolVersion clientVersion) {
        super.notifyClientVersion(clientVersion);
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info("Negotiated DTLS version " + clientVersion);
        }
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, @Nullable String message, @Nullable Throwable cause) {
        Logger $this$notifyAlertRaised$iv = this.logger;
        boolean $i$f$notifyAlertRaised = false;
        if (alertDescription == 0) {
            Logger $this$cdebug$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv$iv;
                boolean bl = false;
                logger.debug("close_notify raised, connection closing");
            }
        } else {
            StringBuffer $this$notifyAlertRaised_u24lambda_u2d1$iv = new StringBuffer();
            boolean bl = false;
            Exception e$iv = new Exception();
            StackTraceElement[] stackTraceElementArray = e$iv.getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
            for (StackTraceElement el$iv : stackTraceElementArray) {
                Appendable appendable = ((Appendable)$this$notifyAlertRaised_u24lambda_u2d1$iv).append(el$iv.toString());
                Intrinsics.checkNotNullExpressionValue(appendable, "append(value)");
                Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
            }
            String string = $this$notifyAlertRaised_u24lambda_u2d1$iv.toString();
            Intrinsics.checkNotNullExpressionValue(string, "with(StringBuffer()) {\n \u2026 toString()\n            }");
            String stack$iv = string;
            Logger $this$cinfo$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl2 = false;
                logger.info("Alert raised: level=" + alertLevel + ", description=" + alertDescription + ", message=" + message + " cause=" + cause + " " + stack$iv);
            }
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Logger $this$notifyAlertReceived$iv = this.logger;
        boolean $i$f$notifyAlertReceived = false;
        if (alertDescription == 0) {
            Logger $this$cinfo$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl = false;
                logger.info("close_notify received, connection closing");
            }
        } else {
            Logger $this$cerror$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cerror = false;
            Logger logger = $this$cerror$iv$iv;
            boolean bl = false;
            logger.error("Alert received: level=" + alertLevel + ", description=" + alertDescription + " (" + AlertDescription.getName(alertDescription) + ")");
        }
    }

    @Override
    @NotNull
    protected ProtocolVersion[] getSupportedVersions() {
        ProtocolVersion[] protocolVersionArray = ProtocolVersion.DTLSv12.downTo(ProtocolVersion.DTLSv10);
        Intrinsics.checkNotNullExpressionValue(protocolVersionArray, "DTLSv12.downTo(ProtocolVersion.DTLSv10)");
        return protocolVersionArray;
    }
}

